/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.relativity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nuix.automate.utils.api.script.RestSSLException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.operations.RelativityView;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.options.relativity.Folder;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AnalyticIndexRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AssociatedResourcePoolType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DocumentField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleSearchResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleSearchResultDeserializer;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExportMetadataType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GenericRelativityApiCallResponse;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingJobStopResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ImagingSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.IndexBuildProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionInfo;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetStopJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityDtSearchIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValueType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityItemLevelSecurity;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityLoginProfile;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchDetails;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchTermReportProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchTermReportRunType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroup;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroups;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceObjectType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.ArmJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.archive.ArmArchive;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.arm.restore.ArmRestore;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQueryRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.CreateProductionSetRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetDataSource;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RelativityProductionSetStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RunProductionSetActionType;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptDetails;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptExportType;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCollection;
import com.nuix.automate.workflow.core.utils.relativity.Relativity11RestV1Client;
import com.nuix.automate.workflow.core.utils.relativity.Relativity12RestV1Client;
import com.nuix.automate.workflow.core.utils.relativity.RelativityError;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRestException;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRsapiClient;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLHandshakeException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class RelativityClient
implements AutoCloseable {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected String relativityUrl;
    protected Client client;
    protected String clientName;
    private static long BACKOFF_START_MS = 5L;
    private static long BACKOFF_EXPONENT = 4L;
    private static long BACKOFF_MAX_MS = 60000L;
    protected Map<String, Long> folderPathArtifactIds;
    private Map<String, Semaphore> keyLocks;
    protected Gson gson;
    protected RelativityService relativityService;
    protected RelativityUserCredential userCredential;
    private boolean usingCustomFingerprint = false;
    protected final CachedObjectMap<Object> cachedObjects;
    private LogChannel logChannel;
    private transient LogHandler logHandler;
    protected String computedInstanceId;

    public static RelativityClient getInstance(RelativityService relativityService, RelativityUserCredential userCredential, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        return RelativityClient.getInstance(relativityService, userCredential, null, logChannel, whitelistedCertFingerprints);
    }

    public static RelativityClient getInstance(RelativityService relativityService, RelativityUserCredential userCredential, String clientName, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        switch (relativityService.getRelativityRestVersion()) {
            case RSAPI: {
                return new RelativityRsapiClient(relativityService, userCredential, clientName, logChannel, whitelistedCertFingerprints);
            }
            case REST_V1: {
                return new Relativity12RestV1Client(relativityService, userCredential, clientName, logChannel, whitelistedCertFingerprints);
            }
            case REST_SERVER_2021: {
                return new Relativity11RestV1Client(relativityService, userCredential, clientName, logChannel, whitelistedCertFingerprints);
            }
        }
        throw new IllegalArgumentException("Unsupported REST type " + String.valueOf(relativityService.getRelativityRestVersion()));
    }

    public static RelativityClient getInstance(RelativityRestVersion restVersion, EndpointType endpointType, String hostname, String username, String password, Set<String> whitelistedCertFingerprints, LogChannel logChannel, ThirdPartyAuthenticationMethod authenticationMethod) throws GeneralSecurityException {
        RelativityService relativityService = new RelativityService();
        relativityService.setHostname(hostname);
        relativityService.setEndpointType(endpointType);
        relativityService.setRelativityRestVersion(restVersion);
        relativityService.setWhitelistedCertFingerprints(whitelistedCertFingerprints);
        RelativityUserCredential userCredential = new RelativityUserCredential();
        userCredential.setUsername(username);
        if (authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
            relativityService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE);
            userCredential.setToken(password);
        } else {
            relativityService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
            userCredential.setPassword(password);
        }
        RelativityClient.setBackOffProperties();
        return RelativityClient.getInstance(relativityService, userCredential, logChannel, whitelistedCertFingerprints);
    }

    public RelativityClient(RelativityService relativityService, RelativityUserCredential userCredential, String clientName, LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.setRelativityService(relativityService);
        RelativityClient.setBackOffProperties();
        this.userCredential = userCredential;
        this.logHandler = LogHandler.getInstance();
        this.logChannel = logChannel;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (clientName == null || ((String)clientName).isEmpty()) {
            clientName = "relativity-client: ";
            clientName = relativityService.getId() != null && userCredential.getUserId() != null ? (String)clientName + relativityService.getId() + userCredential.getUserId() + relativityService.getAuthenticationScope().name() : (String)clientName + relativityService.getHostname() + userCredential.getUsername();
        }
        this.clientName = clientName;
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.clientName, whitelistedCertFingerprints, (boolean)false, (ClientConfig)clientConfig, (boolean)true);
        if (whitelistedCertFingerprints != null && !whitelistedCertFingerprints.isEmpty()) {
            this.usingCustomFingerprint = true;
        }
        this.keyLocks = new ConcurrentHashMap<String, Semaphore>();
        this.folderPathArtifactIds = new ConcurrentHashMap<String, Long>();
        this.cachedObjects = new CachedObjectMap();
        this.gson = new GsonBuilder().registerTypeAdapter(EligibleSearchResult.class, (Object)new EligibleSearchResultDeserializer()).serializeNulls().create();
    }

    public void setRelativityService(RelativityService relativityService) {
        this.relativityService = relativityService;
        this.relativityUrl = relativityService.getEndpointType() == EndpointType.HTTP ? "http://" : "https://";
        this.relativityUrl = this.relativityUrl + relativityService.getHostname();
    }

    public abstract String getProperty(String var1, String var2) throws IOException;

    public abstract String getFieldId(String var1, String var2) throws IOException;

    public abstract String getFieldName(String var1, String var2, boolean var3) throws IOException;

    public abstract String getVersion() throws IOException;

    public String getInstanceId() throws IOException {
        if (this.computedInstanceId == null) {
            this.computedInstanceId = this.getGenericInstanceId();
        }
        return this.computedInstanceId;
    }

    public String getGenericInstanceId() {
        try {
            return FormattingUtils.getHostnameFromUrl((String)this.relativityUrl);
        }
        catch (URISyntaxException e) {
            return this.relativityUrl;
        }
    }

    @Override
    public void close() {
        block3: {
            this.cachedObjects.clear();
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
    }

    protected String encodeForQuery(String text) {
        String result = text;
        result = StringEscapeUtils.escapeJava((String)result);
        result = result.replace("'", "\\'");
        return result;
    }

    private static void setBackOffProperties() {
        String max;
        String exponent;
        String start = System.getProperty("automate.relativity.back_off.start");
        if (start != null) {
            try {
                BACKOFF_START_MS = Long.parseLong(start);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((exponent = System.getProperty("automate.relativity.back_off.exponent")) != null) {
            try {
                BACKOFF_EXPONENT = Long.parseLong(exponent);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((max = System.getProperty("automate.relativity.back_off.max")) != null) {
            try {
                BACKOFF_MAX_MS = Long.parseLong(max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(location, method, requestData, entityType, false);
    }

    protected <ResponseType, RequestType> ResponseType callApi(String location, String method, RequestType requestData, GenericType<ResponseType> entityType, boolean dataIsSerialized) throws IOException {
        LOGGER.info(method + " " + this.getAbsoluteUrl(location));
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + this.getAbsoluteUrl(location)));
        this.logHandler.addLogEvent(this.logChannel.getLogEvent(this.gson.toJson(requestData) + "\n"));
        Response response = null;
        long backOffMs = BACKOFF_START_MS;
        while (true) {
            try {
                Object responseData;
                String logFileName = System.getProperty("automate.relativity.log");
                File logFile = null;
                if (logFileName != null) {
                    logFile = new File(logFileName);
                }
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)(method + " " + location + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        if (dataIsSerialized) {
                            FileUtils.writeStringToFile((File)logFile, (String)requestData.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        } else {
                            FileUtils.writeStringToFile((File)logFile, (String)SerializationUtils.toJson(requestData, (boolean)false), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                    }
                }
                Invocation.Builder invocationBuilder = this.createInvocationBuilder(location);
                switch (method) {
                    case "POST": {
                        if (dataIsSerialized) {
                            response = invocationBuilder.post(Entity.entity(requestData, (String)"application/json"));
                            break;
                        }
                        response = invocationBuilder.post(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                        break;
                    }
                    case "PUT": {
                        if (dataIsSerialized) {
                            response = invocationBuilder.put(Entity.entity(requestData, (String)"application/json"));
                            break;
                        }
                        response = invocationBuilder.put(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                        break;
                    }
                    case "DELETE": {
                        if (dataIsSerialized) {
                            response = invocationBuilder.method("DELETE", Entity.entity(requestData, (String)"application/json"));
                            break;
                        }
                        response = invocationBuilder.method("DELETE", Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                    }
                }
                this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Realtivity log", (Throwable)e);
                    }
                }
                if ((response.getStatus() == 301 || response.getStatus() == 302) && response.getHeaderString("Location") != null) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new IOException("HTTP/" + response.getStatus() + "\n\n" + this.iu.getFormattedString("RelativityClient.Error.Redirected", (Object)response.getHeaderString("Location")));
                }
                if (response.getStatus() == 401) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new NotAuthorizedException((Object)this.iu.getString("RelativityClient.Error.Unauthorized"), new Object[0]);
                }
                if (response.getStatus() == 403) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new NotAuthorizedException((Object)this.iu.getString("RelativityClient.Error.Forbidden"), new Object[0]);
                }
                if (response.getStatus() == 404) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new IOException(this.iu.getFormattedString("RelativityClient.Error.NotFound", new Object[]{"HTTP/404", this.getAbsoluteUrl(location)}));
                }
                if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                    response.bufferEntity();
                    String stringResponse = (String)response.readEntity(String.class);
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    LOGGER.error(method + ": " + location + "\nBody: " + this.gson.toJson(requestData));
                    LOGGER.error(this.getAbsoluteUrl(location) + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                    if (logFile != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                            FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                        }
                    }
                    RelativityError relativityError = null;
                    try {
                        relativityError = (RelativityError)this.gson.fromJson(stringResponse, RelativityError.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (relativityError != null && relativityError.getMessage() != null && relativityError.getMessage().length() > 0) {
                        throw new RelativityRestException(relativityError);
                    }
                    throw new IOException("HTTP/" + response.getStatus() + "\n\n" + stringResponse);
                }
                if (entityType.getRawType().equals(GenericRelativityApiCallResponse.class)) {
                    GenericRelativityApiCallResponse call = new GenericRelativityApiCallResponse();
                    call.setCode(response.getStatus());
                    call.setHeaders((MultivaluedMap<String, Object>)response.getHeaders());
                    call.setData((String)response.readEntity(String.class));
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent(call.getData() + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    if (logFile != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)call.getData(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                            FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                        }
                    }
                    GenericRelativityApiCallResponse e = call;
                    return (ResponseType)e;
                }
                if (entityType.getType().equals(byte[].class)) {
                    responseData = response.readEntity(byte[].class);
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent("\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                } else {
                    String stringResponse = (String)response.readEntity(String.class);
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
                }
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)responseData.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                    }
                }
                Object e = responseData;
                return (ResponseType)e;
            }
            catch (SocketException e) {
                if (e.getMessage().contains("Connection reset")) {
                    if ((backOffMs *= BACKOFF_EXPONENT) > BACKOFF_MAX_MS) {
                        LOGGER.error("Relativity request aborted due to repeated Connection reset errors", (Throwable)e);
                        throw new IOException("Relativity request aborted due to repeated Connection reset errors", e);
                    }
                    LOGGER.info("Received connection reset, Backing off " + backOffMs);
                    try {
                        Thread.sleep(backOffMs);
                    }
                    catch (InterruptedException logFile) {}
                    continue;
                }
                throw e;
            }
            catch (RelativityRestException e) {
                throw e;
            }
            catch (ProcessingException e) {
                if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                    if (!this.usingCustomFingerprint) {
                        HashSet<String> dummyFingerprints = new HashSet<String>();
                        dummyFingerprints.add("dummy-invalid-fingerprint");
                        try {
                            Client dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.clientName + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                            WebTarget dummyWebTarget = dummyClient.target(this.getAbsoluteUrl(location));
                            String dummyMediaType = "application/json";
                            Invocation.Builder dummyInvocationBuilder = dummyWebTarget.request(new String[]{dummyMediaType});
                            Response dummyResponse = dummyInvocationBuilder.get();
                            LOGGER.info("Got response code " + dummyResponse.getStatus());
                        }
                        catch (Exception ex) {
                            if (ex.getCause() != null && ex.getCause() instanceof SSLHandshakeException) {
                                throw new RestSSLException(ex.getCause().getMessage());
                            }
                            throw e;
                        }
                    } else {
                        throw new RestSSLException(e.getCause().getMessage());
                    }
                }
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Cannot query Relativity API", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    private void logSeparator() {
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("\n---\n"));
    }

    protected <ResponseType> ResponseType callApi(String location, String method, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + this.getAbsoluteUrl(location));
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + this.getAbsoluteUrl(location) + "\n"));
        Response response = null;
        long backOffMs = BACKOFF_START_MS;
        while (true) {
            try {
                String stringResponse;
                String logFileName = System.getProperty("automate.relativity.log");
                File logFile = null;
                if (logFileName != null) {
                    logFile = new File(logFileName);
                }
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)(method + " " + location + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                    }
                }
                Invocation.Builder invocationBuilder = this.createInvocationBuilder(location);
                switch (method) {
                    case "GET": {
                        response = invocationBuilder.get();
                        break;
                    }
                    case "DELETE": {
                        response = invocationBuilder.delete();
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                    }
                }
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Realtivity log", (Throwable)e);
                    }
                }
                this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
                if (response.getStatus() == 401) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new NotAuthorizedException((Object)this.iu.getString("RelativityClient.Error.Unauthorized"), new Object[0]);
                }
                if (response.getStatus() == 403) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new NotAuthorizedException((Object)this.iu.getString("RelativityClient.Error.Forbidden"), new Object[0]);
                }
                if (response.getStatus() == 404) {
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent((String)response.readEntity(String.class) + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    throw new IOException(this.iu.getFormattedString("RelativityClient.Error.NotFound", new Object[]{"HTTP/404", this.getAbsoluteUrl(location)}));
                }
                if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                    RelativityError relativityError;
                    response.bufferEntity();
                    stringResponse = (String)response.readEntity(String.class);
                    LOGGER.error(method + ": " + location);
                    LOGGER.error(this.getAbsoluteUrl(location) + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    if (logFile != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                            FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                        }
                    }
                    if ((relativityError = (RelativityError)this.gson.fromJson(stringResponse, RelativityError.class)) != null && relativityError.getMessage() != null && relativityError.getMessage().length() > 0) {
                        throw new RelativityRestException(relativityError);
                    }
                    throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
                }
                if (entityType.getRawType().equals(GenericRelativityApiCallResponse.class)) {
                    GenericRelativityApiCallResponse call = new GenericRelativityApiCallResponse();
                    call.setCode(response.getStatus());
                    call.setHeaders((MultivaluedMap<String, Object>)response.getHeaders());
                    call.setData((String)response.readEntity(String.class));
                    this.logHandler.addLogEvent(this.logChannel.getLogEvent(call.getData() + "\n"));
                    this.logHandler.addLogEvent(this.logChannel.getSeparator());
                    if (logFile != null) {
                        try {
                            FileUtils.writeStringToFile((File)logFile, (String)call.getData(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                            FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                        }
                    }
                    GenericRelativityApiCallResponse e = call;
                    return (ResponseType)e;
                }
                stringResponse = (String)response.readEntity(String.class);
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                this.logHandler.addLogEvent(this.logChannel.getSeparator());
                Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)responseData.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Relativity log", (Throwable)e);
                    }
                }
                Object e = responseData;
                return (ResponseType)e;
            }
            catch (SocketException e) {
                if (e.getMessage().contains("Connection reset")) {
                    if ((backOffMs *= BACKOFF_EXPONENT) > BACKOFF_MAX_MS) {
                        LOGGER.error("Relativity request aborted due to repeated Connection reset errors", (Throwable)e);
                        throw new IOException("Relativity request aborted due to repeated Connection reset errors", e);
                    }
                    LOGGER.info("Received connection reset, Backing off " + backOffMs);
                    try {
                        Thread.sleep(backOffMs);
                    }
                    catch (InterruptedException logFile) {}
                    continue;
                }
                throw e;
            }
            catch (RelativityRestException e) {
                throw e;
            }
            catch (ProcessingException e) {
                if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException) {
                    if (!this.usingCustomFingerprint) {
                        HashSet<String> dummyFingerprints = new HashSet<String>();
                        dummyFingerprints.add("dummy-invalid-fingerprint");
                        try {
                            Client dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.clientName + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                            WebTarget dummyWebTarget = dummyClient.target(this.getAbsoluteUrl(location));
                            String dummyMediaType = "application/json";
                            Invocation.Builder dummyInvocationBuilder = dummyWebTarget.request(new String[]{dummyMediaType});
                            Response dummyResponse = dummyInvocationBuilder.get();
                            LOGGER.info("Got response code " + dummyResponse.getStatus());
                        }
                        catch (Exception ex) {
                            if (ex.getCause() != null && ex.getCause() instanceof SSLHandshakeException) {
                                throw new RestSSLException(ex.getCause().getMessage());
                            }
                            throw e;
                        }
                    } else {
                        throw new RestSSLException(e.getCause().getMessage());
                    }
                }
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Cannot query Relativity API", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
    }

    private String getAbsoluteUrl(String location) {
        if (this.relativityUrl.endsWith("/") || location.startsWith("/")) {
            return this.relativityUrl + location;
        }
        return this.relativityUrl + "/" + location;
    }

    private Invocation.Builder createInvocationBuilder(String location) {
        Invocation.Builder invocationBuilder = this.client.target(this.getAbsoluteUrl(location)).request(new String[]{"application/json"}).header("x-csrf-header", (Object)"");
        switch (this.relativityService.getAuthenticationMethod()) {
            case OIDC_AUTHORIZATION_CODE: {
                invocationBuilder.header("Authorization", (Object)("Bearer " + this.userCredential.getToken()));
                break;
            }
            default: {
                String basicAuthCredentials = Base64.getEncoder().encodeToString((this.userCredential.getUsername() + ":" + this.userCredential.getPassword()).getBytes(StandardCharsets.UTF_8));
                invocationBuilder.header("Authorization", (Object)("Basic " + basicAuthCredentials));
            }
        }
        return invocationBuilder;
    }

    public abstract long getWorkspaceArtifactId(String var1) throws IOException;

    public abstract String getWorkspaceName(Long var1) throws IOException;

    private String getFolderKey(long workspaceArtifactId, List<String> folderPath) {
        StringBuilder key = new StringBuilder();
        key.append(workspaceArtifactId);
        key.append("/");
        key.append(String.join((CharSequence)"/", folderPath));
        return key.toString();
    }

    public long getFolderArtifactIdId(long workspaceArtifactId, long rootFolderArtifactId, String path, boolean createIfNotExists) throws IOException {
        path = StringUtils.strip((String)path, (String)"\\/");
        String[] splits = StringUtils.split((String)path, (String)"\\/");
        return this.getFolderArtifactIdId(workspaceArtifactId, (Long)rootFolderArtifactId, Arrays.asList(splits), createIfNotExists);
    }

    protected String getProperty(String propertyName, Map<String, Object> responseJson) throws IOException {
        Object propertyJson = responseJson.get(propertyName);
        if (propertyJson instanceof Map) {
            Object value = ((Map)propertyJson).get("Value");
            Object name = null;
            if (value != null) {
                if (value instanceof String) {
                    return value.toString();
                }
                if (value instanceof Map) {
                    name = ((Map)value).get("Name");
                }
            }
            if (name == null) {
                name = ((Map)propertyJson).get("Name");
            }
            if (name != null && name instanceof String) {
                return name.toString();
            }
        } else if (propertyJson instanceof String) {
            return (String)propertyJson;
        }
        throw new IOException("Cannot extract value from " + this.gson.toJson(propertyJson));
    }

    private Long getExistingOrCreateFolder(long workspaceArtifactId, String folderKey, String folderRelativeName, long parentArtifactId, boolean createIfNotExists) throws IOException {
        Semaphore newSemaphore = new Semaphore(1);
        Semaphore folderSemaphore = this.keyLocks.putIfAbsent(folderKey, newSemaphore);
        if (folderSemaphore == null) {
            folderSemaphore = newSemaphore;
        }
        try {
            folderSemaphore.acquire();
            Long artifactId = this.folderPathArtifactIds.get(folderKey);
            if (artifactId == null) {
                HashMap<String, Serializable> payload = new HashMap<String, Serializable>();
                payload.put("workspaceArtifactID", Long.valueOf(workspaceArtifactId));
                payload.put("parentId", Long.valueOf(parentArtifactId));
                String response = this.callApi("/relativity.rest/api/Relativity.Services.Folder.IFolderModule/Folder%20Manager/GetChildrenAsync", "POST", payload, new GenericType<String>(){});
                ArrayList<Folder> folders = new ArrayList<Folder>();
                JsonArray results = (JsonArray)this.gson.fromJson(response, JsonArray.class);
                for (JsonElement element : results) {
                    JsonObject jsonFolder = element.getAsJsonObject();
                    Folder folder = (Folder)SerializationUtils.fromJson((JsonObject)jsonFolder, Folder.class);
                    folders.add(folder);
                }
                for (Folder folder : folders) {
                    if (!folder.getName().equals(folderRelativeName)) continue;
                    artifactId = folder.getArtifactId();
                    this.folderPathArtifactIds.put(folderKey, artifactId);
                    LOGGER.info("Got sub-folder " + folderRelativeName + " (" + artifactId + ") from REST");
                    break;
                }
                if (artifactId == null) {
                    if (createIfNotExists) {
                        payload = new HashMap();
                        payload.put("workspaceArtifactID", Long.valueOf(workspaceArtifactId));
                        HashMap<String, Object> model = new HashMap<String, Object>();
                        payload.put("model", model);
                        LOGGER.info("Creating subfolder " + folderRelativeName);
                        model.put("name", folderRelativeName);
                        HashMap<String, Long> parentFolderFilter = new HashMap<String, Long>();
                        parentFolderFilter.put("artifactId", parentArtifactId);
                        model.put("parentFolder", parentFolderFilter);
                        artifactId = this.callApi("/relativity.rest/api/Relativity.Services.Folder.IFolderModule/Folder%20Manager/CreateSingleAsync", "POST", payload, new GenericType<Long>(){});
                        this.folderPathArtifactIds.put(folderKey, artifactId);
                        LOGGER.info("Created sub-folder " + folderKey + " (" + artifactId + ")");
                    } else {
                        throw new IOException("Folder " + folderRelativeName + " under " + folderKey);
                    }
                }
            }
            folderSemaphore.release();
            return artifactId;
        }
        catch (InterruptedException e) {
            LOGGER.error("Cannot wait for semaphore", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            if (folderSemaphore != null) {
                folderSemaphore.release();
            }
            throw e;
        }
    }

    public long getFolderArtifactIdId(long workspaceArtifactId, List<String> folderPath, boolean createIfNotExists) throws IOException {
        return this.getFolderArtifactIdId(workspaceArtifactId, null, folderPath, createIfNotExists);
    }

    public long getFolderArtifactIdId(long workspaceArtifactId, Long rootFolderArtifactId, List<String> folderPath, boolean createIfNotExists) throws IOException {
        long parentFolderId = 0L;
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        if (rootFolderArtifactId == null || rootFolderArtifactId == 0L) {
            String rootFolderKey = this.getFolderKey(workspaceArtifactId, new ArrayList<String>());
            rootFolderArtifactId = this.folderPathArtifactIds.get(rootFolderKey);
            if (rootFolderArtifactId != null) {
                parentFolderId = rootFolderArtifactId;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Got root folder (" + parentFolderId + ") from cache");
                }
            } else {
                Folder rootFolder = this.callApi("/relativity.rest/api/Relativity.Services.Folder.IFolderModule/Folder%20Manager/GetWorkspaceRootAsync", "POST", payload, new GenericType<Folder>(){});
                parentFolderId = rootFolder.getArtifactId();
                LOGGER.info("Got root folder (" + parentFolderId + ") from REST");
                this.folderPathArtifactIds.put(rootFolderKey, rootFolder.getArtifactId());
            }
        } else {
            parentFolderId = rootFolderArtifactId;
        }
        for (int i = 0; i < folderPath.size(); ++i) {
            String requiredSubfolderName = folderPath.get(i);
            String subFolderKey = this.getFolderKey(workspaceArtifactId, folderPath.subList(0, i + 1));
            parentFolderId = this.getExistingOrCreateFolder(workspaceArtifactId, subFolderKey, requiredSubfolderName, parentFolderId, createIfNotExists);
        }
        return parentFolderId;
    }

    public long getRootFolderArtifactId(Long workspaceArtifactId) throws IOException {
        HashMap<String, Long> payload = new HashMap<String, Long>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        Folder rootFolder = this.callApi("/relativity.rest/api/Relativity.Services.Folder.IFolderModule/Folder%20Manager/GetWorkspaceRootAsync", "POST", payload, new GenericType<Folder>(){});
        return rootFolder.getArtifactId();
    }

    public List<String> getFolderPaths(Long workspaceArtifactId, List<Long> folderArtifactIds) throws IOException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("workspaceArtifactID", workspaceArtifactId);
        payload.put("artifactIDs", folderArtifactIds);
        String response = this.callApi("/relativity.rest/api/Relativity.Services.Folder.IFolderModule/Folder%20Manager/GetFullPathListAsync", "POST", payload, new GenericType<String>(){});
        System.out.println(response);
        ArrayList<String> paths = new ArrayList<String>();
        JsonArray array = (JsonArray)this.gson.fromJson(response, JsonArray.class);
        array.forEach(item -> {
            String fullPath = item.getAsJsonObject().get("FullPath").getAsString();
            String[] pathSplit = fullPath.split("\\\\");
            if (pathSplit.length > 1) {
                CharSequence[] updatedPath = new String[pathSplit.length - 1];
                for (int i = 1; i < pathSplit.length; ++i) {
                    updatedPath[i - 1] = pathSplit[i].trim();
                }
                paths.add(String.join((CharSequence)"\\", updatedPath));
            }
        });
        return paths;
    }

    public abstract List<String> getWorkspaceFields(long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleScripts(long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleScriptsNoWorkspace() throws IOException;

    public abstract List<EligibleObject> queryEligibleApplications(long var1) throws IOException;

    public abstract Long importLibraryScript(Long var1, Long var2, Long var3) throws IOException;

    public abstract List<EligibleObject> queryEligibleClients(RelativityIdentifierType var1, String var2) throws IOException;

    public abstract List<EligibleObject> queryEligibleGroupClients() throws IOException;

    public abstract List<EligibleObject> queryEligibleGroups(Long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleMattersNoWorkspace(RelativityIdentifierType var1, String var2) throws IOException;

    public abstract List<EligibleObject> queryEligibleMatters(RelativityIdentifierType var1, String var2) throws IOException;

    public abstract List<EligibleObject> queryEligibleWorkspaces(RelativityIdentifierType var1, String var2) throws IOException;

    public abstract List<EligibleObject> queryEligibleWorkspaceTemplates(RelativityIdentifierType var1, String var2) throws IOException;

    public abstract List<EligibleObject> queryEligibleResourcePools() throws IOException;

    public abstract List<EligibleObject> queryEligibleSQLServers(long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleFileRepositories(long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleCacheLocations(long var1) throws IOException;

    public abstract List<EligibleObject> queryEligibleStatusesWorkspaces() throws IOException;

    public abstract List<EligibleObject> queryEligibleSqlLanguages() throws IOException;

    public abstract List<EligibleObject> queryEligibleStatusesClients() throws IOException;

    public abstract List<EligibleObject> queryEligibleStatusesMatters() throws IOException;

    public abstract String queryDefaultDownloadHandlerUrl() throws IOException;

    public abstract Map<String, Object> createRelativityWorkspace(String var1, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16) throws IOException;

    public abstract long uploadCustomScript(long var1, String var3) throws IOException;

    public abstract String queueScript(long var1, long var3, Map<String, Object> var5) throws IOException;

    public abstract RelativityScriptDetails readScriptOutput(long var1, String var3) throws IOException;

    public abstract String exportScript(long var1, String var3, RelativityScriptExportType var4, String var5) throws IOException;

    public abstract Long createClient(String var1, String var2, String var3, String var4, Long var5) throws IOException;

    public abstract Long createGroup(String var1, Long var2, String var3, String var4) throws IOException;

    public abstract Long createMatter(String var1, String var2, String var3, String var4, Long var5, Long var6) throws IOException;

    public abstract void deleteScript(Long var1, Long var2) throws IOException;

    public abstract void runDtSearchIndexAction(Long var1, Long var2, RelativityDtSearchIndexAction var3) throws IOException;

    public abstract List<EligibleObject> getDtSearchIndexes(Long var1, boolean var2) throws IOException;

    public abstract void updateDtSearchIndex(Long var1, Long var2, String var3) throws IOException;

    public abstract IndexBuildProgress getIndexBuildProgress(Long var1, Long var2) throws IOException;

    public abstract String getScriptStatus(Long var1, String var2) throws IOException;

    public abstract WorkspaceGroups getWorkspaceGroups(Long var1) throws IOException;

    public abstract void setWorkspaceGroups(Long var1, WorkspaceGroups var2) throws IOException;

    public abstract List<RelativityBasicUser> queryUsers() throws IOException;

    public abstract RelativityUser getRelativityUserProperties(Long var1) throws IOException;

    public abstract RelativityUser createUser(RelativityUser var1) throws IOException;

    public abstract void deleteUser(Long var1) throws IOException;

    public abstract void enableUser(RelativityUser var1) throws IOException;

    public abstract void disableUser(RelativityUser var1) throws IOException;

    public abstract void addUsersToGroup(Long var1, List<RelativityBasicUser> var2) throws IOException;

    public abstract void removeUsersFromGroup(Long var1, List<RelativityBasicUser> var2) throws IOException;

    public abstract List<EligibleObject> queryGroupMembers(Long var1) throws IOException;

    public abstract WorkspaceGroupPermissions getWorkspaceGroupPermissions(Long var1, Long var2) throws IOException;

    public abstract void setWorkspaceGroupPermissions(Long var1, WorkspaceGroupPermissions var2) throws IOException;

    public abstract Map<String, RelativityFieldValueType> getFieldValueTypeIdentifiers(Long var1, Long var2) throws IOException;

    public abstract Map<String, RelativityFieldObject> getFieldIdentifiers(Long var1, Long var2) throws IOException;

    public abstract Map<String, EligibleObject> queryChoiceValues(Long var1, String var2) throws IOException;

    public abstract Long retrieveFieldArtifactTypeId(Long var1, Long var2) throws IOException;

    public abstract Map<String, EligibleObject> queryObjectValues(Long var1, Long var2) throws IOException;

    public abstract boolean massCreateDynamicObjects(Long var1, Long var2, String[] var3, List<Object[]> var4) throws IOException;

    public abstract List<EligibleObject> queryObjectTypes(String var1, RelativityIdentifierType var2, Long var3) throws IOException;

    public abstract Long queryObjectTypeArtifactIdFromArtifactId(Long var1, Long var2) throws IOException;

    public abstract boolean instanceContainsArmApplication() throws IOException;

    public abstract Long createArmArchive(Long var1, ArmArchive var2) throws IOException;

    public abstract ArmJobStatus getArmJobStatus(Long var1) throws IOException;

    public abstract void runArmJob(Long var1) throws IOException;

    public abstract String getArmArchivePath(Long var1) throws IOException;

    public abstract List<EligibleObject> queryAssociatedResourcePoolObject(Long var1, AssociatedResourcePoolType var2) throws IOException;

    public abstract List<EligibleObject> queryResourcePools() throws IOException;

    public abstract Long createArmRestore(ArmRestore var1) throws IOException;

    public abstract void deleteWorkspace(Long var1) throws IOException;

    public abstract RelativityLoginProfile getUserLoginProfile(Long var1) throws IOException;

    public abstract void setUserLoginProfile(RelativityLoginProfile var1, Long var2) throws IOException;

    public abstract Map<Long, String> sendEmailInvitationLink(Set<Long> var1) throws IOException;

    public abstract List<AllowedValueItem> filterRelativityObjects(RelativityCondition var1, ParameterType var2, String var3) throws IOException;

    public abstract List<EligibleObject> querySearchTermReports(String var1, RelativityIdentifierType var2, Long var3) throws IOException;

    public abstract void runSearchTermsReport(Long var1, Long var2, SearchTermReportRunType var3) throws IOException;

    public abstract SearchTermReportProgress getSearchTermReportProgress(Long var1, Long var2) throws IOException;

    public abstract String getSearchTermResults(Long var1, Long var2) throws IOException;

    public abstract List<String> getSearchTermViewFields(Long var1, Long var2) throws IOException;

    public abstract Set<String> getWorkspaceDocumentIds(Long var1) throws IOException;

    public abstract List<EligibleObject> querySearchesForWorkspace(Long var1) throws IOException;

    public abstract SavedSearchDetails readSavedSearch(Long var1, Long var2, Map<Long, String> var3, boolean var4) throws IOException;

    public abstract SavedSearchDetails readSavedSearch(Long var1, Long var2, Map<Long, String> var3) throws IOException;

    public abstract Map<String, DocumentField> getDocumentSavedSearchFields(Long var1) throws IOException;

    public abstract Long createSavedSearch(Long var1, CriteriaCollection var2, SavedSearchRequest var3) throws IOException;

    public abstract List<EligibleObject> querySearchContainersForWorkspace(Long var1) throws IOException;

    public abstract void moveSavedSearch(Long var1, Long var2, Long var3) throws IOException;

    public abstract List<WorkspaceObjectType> queryObjectTypes(Long var1) throws IOException;

    public abstract Map<Long, ItemLevelPermissionObject> getItemLevelObjectsForObjectType(Long var1, Long var2) throws IOException;

    public abstract Map<Long, Boolean> getItemLevelSecurity(Long var1, Set<Long> var2) throws IOException;

    public abstract RelativityItemLevelSecurity getItemLevelSecurity(Long var1, Long var2) throws IOException;

    public abstract void setItemLevelSecurity(Long var1, Long var2, boolean var3) throws IOException;

    public abstract WorkspaceGroupPermissions getItemPermissions(Long var1, Long var2, Long var3) throws IOException;

    public abstract void setItemPermissions(Long var1, Long var2, WorkspaceGroupPermissions var3) throws IOException;

    public abstract Map<Long, ItemLevelPermissionObject> getObjectsForTypeWithPermissions(String var1, Long var2, Long var3) throws IOException;

    public abstract Map<Long, ItemLevelPermissionObject> getObjectsForTypeWithPermissions(Long var1, Long var2, Long var3) throws IOException;

    public abstract Long getWorkspaceGroupId(Long var1, Long var2) throws IOException;

    public abstract void setItemGroups(Long var1, Long var2, WorkspaceGroups var3) throws IOException;

    public abstract WorkspaceGroups getItemGroups(Long var1, Long var2, boolean var3) throws IOException;

    public abstract boolean workspaceContainsGroup(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract GenericRelativityApiCallResponse callGenericApi(String var1, Verb var2, Object var3) throws IOException;

    public abstract GenericRelativityApiCallResponse callGenericApiEncoded(String var1, Verb var2, String var3) throws IOException;

    public abstract void deleteSavedSearch(Long var1, Long var2) throws IOException;

    public abstract List<EligibleObject> queryImagingSets(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract ImagingSetStatus getImagingSetStatus(Long var1, Long var2) throws IOException;

    public abstract Long runImagingSet(Long var1, Long var2, boolean var3) throws IOException;

    public abstract Map<RelativityIndexType, List<EligibleObject>> queryAnalyticIndexes(Long var1) throws IOException;

    public abstract void deleteRelativityIndex(Long var1, Long var2, RelativityIndexType var3) throws IOException;

    public abstract EligibleObject getWorkspaceResourcePoolArtifactId(Long var1) throws IOException;

    public abstract long createAnalyticIndex(Long var1, AnalyticIndexRequest var2, RelativityIndexType var3) throws IOException;

    public abstract List<EligibleObject> queryRepeatedFilters(Long var1) throws IOException;

    public abstract Map<Long, ItemLevelPermissionInfo> getItemLevelPermissionInfo(Long var1, Long var2, String var3) throws IOException;

    public abstract Set<Long> queryWorkspacesAssociatedWithGroup(Long var1) throws IOException;

    public abstract Map<Long, WorkspaceGroup> getWorkspaceGroupsWithArtifactIds(Long var1) throws IOException;

    public abstract ImagingJobStopResult stopImagingJob(Long var1, Long var2) throws IOException;

    public abstract Map<Long, String> resolveSearchContainerPaths(Long var1) throws IOException;

    public abstract long createFolderPath(Long var1, Long var2, List<String> var3) throws IOException;

    public abstract Map<String, Long> getChildSearchContainers(Long var1, Long var2) throws IOException;

    public abstract long getOrCreateSearchContainer(Long var1, Long var2, List<String> var3) throws IOException;

    public abstract long getOrCreateSearchContainer(Long var1, Long var2, List<String> var3, int var4) throws IOException;

    public abstract long getSearchContainerRoot(Long var1) throws IOException;

    public abstract Set<String> getSearchContainerItemNames(Long var1, Long var2) throws IOException;

    public abstract long runSavedSearch(Long var1, Long var2) throws IOException;

    public abstract List<EligibleObject> getSearchContainerSavedSearches(Long var1, Long var2) throws IOException;

    public abstract Set<Long> getSearchContainerChildren(Long var1, Long var2, Set<Long> var3) throws IOException;

    public abstract List<EligibleObject> getAllSearchContainerSavedSearches(Long var1, Set<Long> var2) throws IOException;

    public abstract void submitAnalyticIndexJob(Long var1, Long var2, RelativityAnalyticIndexAction var3, RelativityIndexType var4) throws IOException;

    public abstract RelativityAnalyticIndexStatus getAnalyticIndexJobStatus(Long var1, Long var2, RelativityIndexType var3) throws IOException;

    public abstract void cancelAnalyticJob(Long var1, Long var2, RelativityIndexType var3) throws IOException;

    public abstract List<EligibleObject> getOcrSets(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract OcrSetJobStatus getOcrSetJobStatus(Long var1, Long var2) throws IOException;

    public abstract OcrSetJobResult runOcrSet(Long var1, Long var2) throws IOException;

    public abstract OcrSetStopJobResult stopOcrSetJob(Long var1, Long var2) throws IOException;

    public abstract List<EligibleObject> getViews(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract List<EligibleObject> queryMarkupSets(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract List<EligibleObject> queryProductionPlaceholders(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract List<EligibleObject> querySavedSearches(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract List<EligibleObject> queryProductionSets(Long var1, RelativityIdentifierType var2, String var3) throws IOException;

    public abstract JsonObject readProductionSetJson(Long var1, Long var2) throws IOException;

    public abstract Long createProductionSetJsonObject(Long var1, JsonObject var2) throws IOException;

    public abstract Long createProductionSet(Long var1, CreateProductionSetRequest var2) throws IOException;

    public abstract Long createProductionDataSource(Long var1, Long var2, ProductionSetDataSource var3) throws IOException;

    public abstract RelativityProductionSetProgress getProductionSetProgress(Long var1, Long var2) throws IOException;

    public abstract boolean runProductionJobAction(Long var1, Long var2, RunProductionSetActionType var3) throws IOException;

    public abstract RelativityProductionSetStatus getProductionSetStatus(Long var1, Long var2) throws IOException;

    public abstract String queryObjectManagerSlim(ObjectManagerQueryRequest var1) throws IOException;

    public abstract RelativityView getRelativityView(Long var1, Long var2) throws IOException;

    public abstract int queryTotalMetadataTypeObjects(Long var1, Long var2, Long var3, ExportMetadataType var4, String var5) throws IOException;

    public abstract List<Object[]> queryMetadataTypeObjectsPaged(ObjectManagerQueryRequest var1) throws IOException;

    public abstract List<EligibleObject> getMetadataTypes(Long var1, RelativityIdentifierType var2, String var3, ExportMetadataType var4) throws IOException;

    public abstract SavedSearchDetails readSavedSearchNoCondition(Long var1, Long var2) throws IOException;
}

