/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.semantic;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SemanticClient
implements Closeable {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SemanticClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private String apiUrl;
    private boolean usingCustomFingerprint;
    private String clientName;
    private Client client;

    public SemanticClient(String url) throws GeneralSecurityException {
        this(null, url, null);
    }

    public SemanticClient(String clientName, String url, Set<String> fingerprints) throws GeneralSecurityException {
        this.apiUrl = url;
        if (clientName == null || clientName.trim().isEmpty()) {
            clientName = "SemanticClient";
        }
        this.clientName = clientName;
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)this.clientName, fingerprints, (boolean)false);
        if (fingerprints != null && fingerprints.size() >= 1) {
            this.usingCustomFingerprint = true;
        }
    }

    public Set<String> getModels() throws IOException {
        TreeSet<String> models = new TreeSet<String>();
        String modelsResponse = this.callApi(this.apiUrl + "/ping", "GET", new GenericType<String>(){});
        try {
            LOGGER.info("Test Semantic service response body: " + modelsResponse);
            Map modelsStatus = (Map)SerializationUtils.fromJson((String)modelsResponse, Map.class);
            for (String modelName : modelsStatus.keySet()) {
                models.add(modelName);
                Map modelDetails = (Map)modelsStatus.get(modelName);
                Object v = modelDetails.get("status");
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get Semantic service models", (Throwable)e);
            if (modelsResponse == null) {
                throw new IOException(this.iu.getString("SemanticSearch.Error.CannotReadResponse"));
            }
            throw new IOException(this.iu.getFormattedString("SemanticSearch.Error.InvalidResponse", (Object)modelsResponse.trim()));
        }
        return models;
    }

    public String test() throws IOException {
        Set<String> models = this.getModels();
        if (models.isEmpty()) {
            throw new IOException(this.iu.getString("SemanticSearch.Error.NoModels"));
        }
        return this.iu.getFormattedString("SemanticSearch.Models", (Object)String.join((CharSequence)", ", models));
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String method, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + url);
        try (Response response = null;){
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            String logFileName = System.getProperty("automate.semantic.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Semantic log", (Throwable)e);
                }
            }
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            String stringResponse = (String)response.readEntity(String.class);
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Semantic log", (Throwable)e);
                }
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                LOGGER.error(method + ": " + this.apiUrl);
                LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                        FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Semantic log", (Throwable)e);
                    }
                }
                throw new IOException(("HTTP/" + response.getStatus() + "\n" + stringResponse).trim());
            }
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)stringResponse, (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Semantic log", (Throwable)e);
                }
            }
            Object e = responseData;
            return (ResponseType)e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

