/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.thirdparty;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ThirdPartyUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyUtils.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static ThirdPartyUtils instance;

    public static ThirdPartyUtils getInstance() {
        if (instance == null) {
            instance = new ThirdPartyUtils();
        }
        return instance;
    }

    public void verifyThirdPartyServiceSettings(Operation o, Collection<ThirdPartyService> services, String thirdPartyType, ParameterType type) {
        List<Parameter> parameters = this.getUserDefinedThirdPartyServiceParameterByType(o, type);
        List<ThirdPartyService> filteredServices = this.getUsableThirdPartyServices(services, thirdPartyType);
        ArrayList<String> warnings = new ArrayList<String>();
        if (filteredServices.size() >= 2) {
            String typeName = filteredServices.get(0).getPrintableServiceType();
            warnings.add(this.iu.getFormattedString("ThirdPartyService.Warning.MultipleDefaultServices", (Object)typeName));
        }
        if (parameters != null && filteredServices.size() >= 1) {
            HashSet<String> parameterNames = new HashSet<String>();
            if (filteredServices.size() >= 2) {
                for (Parameter parameter : parameters) {
                    parameterNames.add(parameter.getFriendlyNameAndName());
                }
            } else {
                String thirdPartyServiceId = filteredServices.get(0).getId();
                for (Parameter parameter : parameters) {
                    try {
                        String parameterValue = parameter.getMaskedValue();
                        if (parameterValue == null || parameterValue.equals(thirdPartyServiceId)) continue;
                        parameterNames.add(parameter.getFriendlyNameAndName());
                    }
                    catch (ParameterException parameterException) {}
                }
            }
            if (parameterNames.size() > 0) {
                String typeName = filteredServices.get(0).getPrintableServiceType();
                String parameterString = String.join((CharSequence)", ", parameterNames);
                warnings.add(this.iu.getNumeralFormattedString("ThirdPartyService.Warning.ServiceParameter", (long)parameterNames.size(), new Object[]{parameterString, typeName}));
            }
        }
        if (warnings.size() > 0) {
            for (String warning : warnings) {
                o.addWarning(warning);
            }
        }
    }

    private List<Parameter> getUserDefinedThirdPartyServiceParameterByType(Operation o, ParameterType type) {
        if (type == null) {
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : o.getExecutionContext().getSessionConfigParameters().getParameters()) {
            if (parameter.getParameterType() != type) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private List<ThirdPartyService> getUsableThirdPartyServices(Collection<ThirdPartyService> services, String thirdPartyClassName) {
        ArrayList<ThirdPartyService> filtered = new ArrayList<ThirdPartyService>();
        for (ThirdPartyService service : services) {
            ThirdPartyUserCredential serviceCredential;
            if (service == null || !Boolean.TRUE.equals(service.getAvailableByDefault()) || !service.getClass().getSimpleName().equals(thirdPartyClassName) || (serviceCredential = service.getUserCredential()) == null || !serviceCredential.getSignedIn()) continue;
            filtered.add(service);
        }
        return filtered;
    }
}

