/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.vault;

import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.internal.googleapi.ChatSpaceMembership;
import com.nuix.automate.utils.models.internal.googleapi.OrgUnit;
import com.nuix.automate.utils.models.internal.vault.MatterState;
import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.VaultHold;
import com.nuix.automate.utils.models.internal.vault.VaultMatter;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.models.internal.vault.VaultSavedQuery;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import com.nuix.automate.workflow.core.utils.vault.VaultObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.vault.VaultRestException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.GenericType;

public class VaultRestClient
extends ThirdPartyProxyRestClient {
    private static final String ADMIN_DIRECTORY_API_URL = "https://admin.googleapis.com/admin/directory/v1";
    private static final String CHAT_API_URL = "https://chat.googleapis.com/v1";

    public VaultRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.setMaxAttempts(SystemUtils.getIntegerProperty((String)"automate.vault.maxAttempts", (Integer)3));
        this.setDelayFactorSeconds(SystemUtils.getIntegerProperty((String)"automate.vault.delayFactorSeconds", (Integer)30));
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.vault.log");
    }

    @Override
    public String getServiceName() {
        return "Google Vault";
    }

    @Override
    protected boolean isResponseReattemptable(TranslationResponseStatus errorResponse) {
        return errorResponse.getCode() == 429 || super.isResponseReattemptable(errorResponse);
    }

    public String getDomain() throws IOException {
        String endpoint = "/domain";
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public Set<String> getAllUserIds() throws IOException {
        String endpoint = "/allUserIds";
        return this.proxyApiGetRequest(endpoint, new GenericType<Set<String>>(){});
    }

    public Set<String> getUserIdsFromEmails(Set<String> userEmails) throws IOException {
        String endpoint = "/userIdsFromEmails";
        return this.proxyApiRequest(endpoint, "POST", userEmails, new GenericType<Set<String>>(){});
    }

    public Set<String> getUserIdsFromGroups(Set<String> groupEmails) throws IOException {
        String endpoint = "/userIdsFromGroups";
        return this.proxyApiRequest(endpoint, "POST", groupEmails, new GenericType<Set<String>>(){});
    }

    public Set<String> getUserIdsForOrgUnits(Set<String> orgUnitIds) throws IOException {
        String endpoint = "/userIdsFromOrgUnits";
        return this.proxyApiRequest(endpoint, "POST", orgUnitIds, new GenericType<Set<String>>(){});
    }

    public Set<String> getUserIdsForChatSpace(String chatSpaceId) throws IOException {
        String endpoint = "https://chat.googleapis.com/v1/spaces/" + chatSpaceId + "/members";
        List<ChatSpaceMembership> memberships = this.proxyApiPagedGetRequest(endpoint, "memberships", new GenericType<List<ChatSpaceMembership>>(){});
        HashSet<String> userIds = new HashSet<String>();
        for (ChatSpaceMembership membership : memberships) {
            String name;
            if (membership.getMember() == null || (name = membership.getMember().getName()) == null) continue;
            userIds.add(name.replace("users/", ""));
        }
        return userIds;
    }

    public List<OrgUnit> getOrgUnits() throws IOException {
        String endpoint = "https://admin.googleapis.com/admin/directory/v1/customer/my_customer/orgunits?type=" + URLEncoder.encode("ALL_INCLUDING_PARENT", "UTF-8");
        return this.proxyApiPagedGetRequest(endpoint, "organizationUnits", new GenericType<List<OrgUnit>>(){});
    }

    public List<VaultMatter> getMatters(MatterState state) throws IOException {
        Object endpoint = "/matters";
        if (state != null) {
            endpoint = (String)endpoint + "?&state=" + URLEncoder.encode(state.name(), "UTF-8");
        }
        return this.proxyApiPagedGetRequest((String)endpoint, "matters", new GenericType<List<VaultMatter>>(){});
    }

    public VaultMatter getMatterForId(String matterId, MatterState state) throws IOException {
        String endpoint = "/matters/" + matterId;
        VaultMatter vaultMatter = this.proxyApiGetRequest(endpoint, new GenericType<VaultMatter>(){});
        if (vaultMatter == null) {
            throw new VaultObjectDoesNotExistException();
        }
        if (vaultMatter.getState() != state) {
            throw new VaultRestException(iu.getFormattedString("VaultRestClient.Error.MatterDoesNotMatchState", new Object[]{vaultMatter.getName(), state, vaultMatter.getState().toLocalizedString()}));
        }
        return vaultMatter;
    }

    public VaultMatter getMatterForName(String matterName, MatterState state) throws IOException {
        List<VaultMatter> vaultMatters = this.getMatters(state);
        vaultMatters.removeIf(matter -> !matter.getName().equals(matterName));
        if (vaultMatters.isEmpty()) {
            throw new VaultObjectDoesNotExistException(iu.getFormattedString("VaultRestClient.Error.MatterNameWithStateNotFound", new Object[]{matterName, state.toLocalizedString()}));
        }
        if (vaultMatters.size() > 1) {
            String errorMessage = iu.getFormattedString("VaultRestClient.Error.MultipleMattersWithName", new Object[]{vaultMatters.size(), matterName});
            throw new VaultRestException(errorMessage);
        }
        return vaultMatters.get(0);
    }

    public VaultMatter getMatterForNameRegex(String nameRegex, MatterState state, Function<VaultMatter, String> idGenerator, Function<VaultMatter, String> nameGenerator) throws IOException {
        RegexMatchingResult<VaultMatter> matchingMattersResult = VaultRestClient.getObjectsForNameRegex(nameRegex, this.getMatters(state), idGenerator, nameGenerator);
        List matchingMatters = ((RegexMatchingResult)matchingMattersResult).results;
        Set namesWithIds = ((RegexMatchingResult)matchingMattersResult).namesWithIds;
        if (matchingMatters.isEmpty()) {
            throw new VaultObjectDoesNotExistException(iu.getFormattedString("VaultRestClient.Error.MatterNameRegexWithStateNotFound", new Object[]{nameRegex, state.toLocalizedString()}));
        }
        if (matchingMatters.size() > 1) {
            String errorMessage = iu.getFormattedString("VaultRestClient.Error.MultipleMattersMatchingRegex", new Object[]{namesWithIds.size(), String.join((CharSequence)", ", namesWithIds)});
            throw new VaultRestException(errorMessage);
        }
        return (VaultMatter)matchingMatters.get(0);
    }

    public VaultMatter createMatter(VaultMatter vaultMatter) throws IOException {
        String endpoint = "/matters";
        return this.proxyApiRequest(endpoint, "POST", vaultMatter, new GenericType<VaultMatter>(){});
    }

    public VaultMatter closeMatter(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + ":close";
        return this.postMatterAction(endpoint, "POST");
    }

    public VaultMatter deleteMatter(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId;
        return this.postMatterAction(endpoint, "DELETE");
    }

    public VaultMatter reopenMatter(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + ":reopen";
        return this.postMatterAction(endpoint, "POST");
    }

    public VaultMatter undeleteMatter(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + ":undelete";
        return this.postMatterAction(endpoint, "POST");
    }

    public VaultSavedQuery createSavedQuery(String matterId, VaultSavedQuery savedQuery) throws IOException {
        String endpoint = "/matters/" + matterId + "/savedQueries";
        return this.proxyApiRequest(endpoint, "POST", savedQuery, new GenericType<VaultSavedQuery>(){});
    }

    public List<VaultSavedQuery> getSavedQueries(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + "/savedQueries";
        return this.proxyApiPagedGetRequest(endpoint, "savedQueries", new GenericType<List<VaultSavedQuery>>(){});
    }

    public VaultExport createExport(String matterId, VaultExport export) throws IOException {
        String endpoint = "/matters/" + matterId + "/exports";
        return this.proxyApiRequest(endpoint, "POST", export, new GenericType<VaultExport>(){});
    }

    public List<VaultExport> getExports(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + "/exports";
        return this.proxyApiPagedGetRequest(endpoint, "exports", new GenericType<List<VaultExport>>(){});
    }

    public String getCloudDownloadToken() throws IOException {
        String endpoint = "/cloudDownloadToken";
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public VaultHold createHold(String matterId, VaultHold hold) throws IOException {
        String endpoint = "/matters/" + matterId + "/holds";
        return this.proxyApiRequest(endpoint, "POST", hold, new GenericType<VaultHold>(){});
    }

    public List<VaultHold> getHolds(String matterId) throws IOException {
        String endpoint = "/matters/" + matterId + "/holds";
        return this.proxyApiPagedGetRequest(endpoint, "holds", new GenericType<List<VaultHold>>(){});
    }

    public Map<String, Object> removeHeldAccountsFromHold(String matterId, String holdId, Collection<String> accountIds) throws IOException {
        String endpoint = "/matters/" + matterId + "/holds/" + holdId + ":removeHeldAccounts";
        HashMap<String, Collection<String>> body = new HashMap<String, Collection<String>>();
        if (accountIds != null && !accountIds.isEmpty()) {
            body.put("accountIds", accountIds);
        }
        return this.proxyApiRequest(endpoint, "POST", body, new GenericType<Map<String, Object>>(){});
    }

    public void deleteHold(String matterId, String holdId) throws IOException {
        String endpoint = "/matters/" + matterId + "/holds/" + holdId;
        this.proxyApiRequest(endpoint, "DELETE", 0);
    }

    protected VaultMatter postMatterAction(String endpoint, String method) throws IOException {
        Map<String, Object> response = this.proxyApiRequest(endpoint, method, null, new GenericType<Map<String, Object>>(){});
        Map<String, Object> matter = response.getOrDefault("matter", response);
        return (VaultMatter)this.objectMapper.convertValue(matter, VaultMatter.class);
    }

    protected <ResponseType> ResponseType proxyApiPagedGetRequest(String endpoint, String pagedValueKey, GenericType<ResponseType> entityType) throws IOException {
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "GET", 200);
        apiProxyRequest.setPageRequests(true);
        apiProxyRequest.setPagedValueKey(pagedValueKey);
        return this.proxyApiRequest(apiProxyRequest, entityType);
    }

    public static <T extends VaultObject> List<T> getObjectsForNameRegex(String nameRegex, List<T> vaultObjects, Function<T, String> nameGenerator) {
        return ((RegexMatchingResult)VaultRestClient.getObjectsForNameRegex(nameRegex, vaultObjects, null, nameGenerator)).results;
    }

    private static <T extends VaultObject> RegexMatchingResult<T> getObjectsForNameRegex(String nameRegex, List<T> vaultObjects, Function<T, String> idGenerator, Function<T, String> nameGenerator) {
        Pattern namePattern = Pattern.compile(nameRegex);
        ArrayList<VaultObject> matchingObjects = new ArrayList<VaultObject>();
        HashSet<CallSite> objectNamesWithIds = new HashSet<CallSite>();
        for (VaultObject vaultObject : vaultObjects) {
            String objectName = nameGenerator.apply(vaultObject);
            Matcher matcher = namePattern.matcher(objectName);
            if (!matcher.find()) continue;
            matchingObjects.add(vaultObject);
            if (idGenerator == null) continue;
            objectNamesWithIds.add((CallSite)((Object)(objectName + " (ID " + idGenerator.apply(vaultObject) + ")")));
        }
        return new RegexMatchingResult(matchingObjects, objectNamesWithIds);
    }

    private static class RegexMatchingResult<T> {
        private final List<T> results;
        private final Set<String> namesWithIds;

        private RegexMatchingResult(List<T> results, Set<String> namesWithIds) {
            this.results = results;
            this.namesWithIds = namesWithIds;
        }
    }
}

