/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.veritone;

import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.job.JobFilePayload;
import com.nuix.automate.utils.models.internal.veritone.EngineDetail;
import com.nuix.automate.utils.models.internal.veritone.JobDetail;
import com.nuix.automate.utils.models.internal.veritone.JobStatus;
import com.nuix.automate.utils.models.internal.veritone.OrganizationDetail;
import com.nuix.automate.utils.models.internal.veritone.output.JobOutput;
import com.nuix.automate.utils.models.internal.veritone.request.CancelJobsRequest;
import com.nuix.automate.utils.models.internal.veritone.request.CreateJobRequest;
import com.nuix.automate.utils.models.internal.veritone.response.BaseVeritoneResponse;
import com.nuix.automate.utils.models.internal.veritone.response.CreateJobResponse;
import com.nuix.automate.utils.models.internal.veritone.response.JobOutputResponse;
import com.nuix.automate.utils.models.internal.veritone.response.JobOutputsResponse;
import com.nuix.automate.utils.models.internal.veritone.response.JobStatusResponse;
import com.nuix.automate.workflow.core.execution.options.veritone.ItemVeritoneJob;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneOperationException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.GenericType;

public class VeritoneRestClient
extends ThirdPartyProxyRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VeritoneRestClient.class);

    public VeritoneRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.setMaxAttempts(SystemUtils.getIntegerProperty((String)"automate.veritone.maxAttempts", (Integer)3));
        this.setDelayFactorSeconds(SystemUtils.getIntegerProperty((String)"automate.veritone.delayFactorSeconds", (Integer)30));
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.veritone.log");
    }

    @Override
    public String getServiceName() {
        return "Veritone";
    }

    public List<EngineDetail> getEngines() throws IOException {
        String endpoint = "/admin/engines";
        return (List)this.proxyApiGetRequest(endpoint, new GenericType<BaseVeritoneResponse.BaseVeritoneListResponse<EngineDetail>>(){}).getResult();
    }

    public List<OrganizationDetail> getOrganizations() throws IOException {
        String endpoint = "/admin/organizations";
        return (List)this.proxyApiGetRequest(endpoint, new GenericType<BaseVeritoneResponse.BaseVeritoneListResponse<OrganizationDetail>>(){}).getResult();
    }

    public String createFileDownloadUrl(String jobId, String fileName) throws IOException {
        JobFilePayload filePayload = new JobFilePayload(jobId, fileName);
        String fileDownloadEndpoint = this.proxyApiRequest("/fileDownloadEndpoint", "POST", filePayload, new GenericType<String>(){});
        return this.schedulerUrl + fileDownloadEndpoint;
    }

    public CreateJobRequest.CreateJobDetail buildTranscriptionJobDetail() {
        return (CreateJobRequest.CreateJobDetail)SerializationUtils.fromJson((String)"    {\n        \"jobStatus\": \"queued\",\n        \"tasks\": [\n            {\n                \"correlationTaskId\": \"wsa\",\n                \"engineId\": \"9e611ad7-2d3b-48f6-a51b-0a1ba40fe255\",\n                \"taskPayloadJSON\": \"{}\",\n                \"taskStatus\": \"pending\",\n                \"ioFolders\": [\n                    {\n                        \"correlationID\": \"wsaOutput\",\n                        \"mode\": \"stream\",\n                        \"type\": \"output\"\n                    }\n                ]\n            },\n            {\n                \"correlationTaskId\": \"chunkAudio\",\n                \"engineId\": \"8bdb0e3b-ff28-4f6e-a3ba-887bd06e6440\",\n                \"taskPayloadJSON\": \"{\\\"customFFMPEGProperties\\\":{\\\"chunkSizeInSeconds\\\":\\\"300\\\"},\\\"ffmpegTemplate\\\":\\\"audio\\\"}\",\n                \"taskStatus\": \"pending\",\n                \"ioFolders\": [\n                    {\n                        \"correlationID\": \"chunkAudioInput\",\n                        \"mode\": \"stream\",\n                        \"type\": \"input\"\n                    },\n                    {\n                        \"correlationID\": \"chunkAudioOutput\",\n                        \"mode\": \"chunk\",\n                        \"type\": \"output\"\n                    }\n                ],\n                \"parentMustBeCompleteBeforeStarting\": true\n            },\n            {\n                \"correlationTaskId\": \"transcription\",\n                \"engineId\": \"e97d1564-39ff-4016-a034-e1f32aa9eb7d\",\n                \"taskStatus\": \"pending\",\n                \"ioFolders\": [\n                    {\n                        \"correlationID\": \"transcriptionInput\",\n                        \"mode\": \"chunk\",\n                        \"type\": \"input\"\n                    },\n                    {\n                        \"correlationID\": \"transcriptionOutput\",\n                        \"mode\": \"chunk\",\n                        \"type\": \"output\"\n                    }\n                ],\n                \"parentMustBeCompleteBeforeStarting\": true,\n                \"maxEngines\": 1,\n                \"maxRetries\": 10,\n                \"numChunksPerWorkItem\": 5\n            },\n            {\n                \"correlationTaskId\": \"ow\",\n                \"engineId\": \"8eccf9cc-6b6d-4d7d-8cb3-7ebf4950c5f3\",\n                \"taskStatus\": \"pending\",\n                \"ioFolders\": [\n                    {\n                        \"correlationID\": \"owInput\",\n                        \"mode\": \"chunk\",\n                        \"type\": \"input\"\n                    }\n                ],\n                \"parentMustBeCompleteBeforeStarting\": true,\n                \"maxEngines\": 1,\n                \"maxRetries\": 10\n            }\n        ],\n        \"taskRoutes\": [\n            {\n                \"taskChildId\": \"wsa\"\n            },\n            {\n                \"taskParentId\": \"wsa\",\n                \"taskParentOutputId\": \"wsaOutput\",\n                \"taskChildId\": \"chunkAudio\",\n                \"taskChildInputId\": \"chunkAudioInput\"\n            },\n            {\n                \"taskParentId\": \"chunkAudio\",\n                \"taskParentOutputId\": \"chunkAudioOutput\",\n                \"taskChildId\": \"transcription\",\n                \"taskChildInputId\": \"transcriptionInput\"\n            },\n            {\n                \"taskParentId\": \"transcription\",\n                \"taskParentOutputId\": \"transcriptionOutput\",\n                \"taskChildId\": \"ow\",\n                \"taskChildInputId\": \"owInput\"\n            }\n        ]\n    }", CreateJobRequest.CreateJobDetail.class);
    }

    public CreateJobRequest.CreateJobDetail buildTranslationJobDetail() {
        return (CreateJobRequest.CreateJobDetail)SerializationUtils.fromJson((String)"{\n    \"jobStatus\": \"queued\",\n    \"tasks\": [\n        {\n            \"correlationTaskId\": \"translation\",\n            \"engineId\": \"\",\n            \"taskPayloadJSON\": \"{}\",\n            \"taskStatus\": \"pending\",\n            \"ioFolders\": [\n                {\n                    \"correlationID\": \"translationOutput\",\n                    \"mode\": \"chunk\",\n                    \"type\": \"output\"\n                }\n            ],\n            \"maxEngines\": 1,\n            \"maxRetries\": 10,\n            \"parallelProcessing\": \"true\"\n        },\n        {\n            \"correlationTaskId\": \"ow\",\n            \"engineId\": \"\",\n            \"taskStatus\": \"pending\",\n            \"ioFolders\": [\n                {\n                    \"correlationID\": \"owInput\",\n                    \"mode\": \"chunk\",\n                    \"type\": \"input\"\n                }\n            ],\n            \"parentMustBeCompleteBeforeStarting\": true,\n            \"maxEngines\": 1,\n            \"maxRetries\": 10\n        }\n    ],\n    \"taskRoutes\": [\n        {\n            \"taskChildId\": \"translation\"\n        },\n        {\n            \"taskParentId\": \"translation\",\n            \"taskParentOutputId\": \"translationOutput\",\n            \"taskChildId\": \"ow\",\n            \"taskChildInputId\": \"owInput\"\n        }\n    ]\n}", CreateJobRequest.CreateJobDetail.class);
    }

    public CreateJobResponse createJobs(CreateJobRequest jobRequest) throws IOException {
        String endpoint = "/proc/job/create";
        return this.proxyApiRequest(endpoint, "POST", jobRequest, new GenericType<CreateJobResponse>(){});
    }

    public JobStatus getJobStatus(String jobId) throws IOException {
        String endpoint = "/proc/job/" + jobId + "/status";
        JobStatusResponse response = this.proxyApiGetRequest(endpoint, new GenericType<JobStatusResponse>(){});
        return response.getJob().getJobStatus();
    }

    public List<JobOutput> getJobOutputs(String jobId) throws IOException {
        String endpoint = "/proc/job/" + jobId + "/outputs";
        JobOutputsResponse response = this.proxyApiGetRequest(endpoint, new GenericType<JobOutputsResponse>(){});
        ArrayList<JobOutput> outputs = new ArrayList<JobOutput>();
        for (JobOutput jobOutput : response.getOutputs().getOutputs()) {
            outputs.add(this.getJobOutput(jobId, jobOutput.getName()));
        }
        return outputs;
    }

    public JobOutput getJobOutput(String jobId, String outputName) throws IOException {
        String endpoint = "/proc/job/" + jobId + "/output/" + outputName;
        JobOutputResponse response = this.proxyApiGetRequest(endpoint, new GenericType<JobOutputResponse>(){});
        return response.getOutput();
    }

    public List<JobDetail> cancelJob(String jobId) throws IOException {
        String endpoint = "/proc/jobs/cancel";
        CancelJobsRequest cancelJobsRequest = new CancelJobsRequest(jobId);
        return (List)this.proxyApiRequest(endpoint, "POST", cancelJobsRequest, new GenericType<BaseVeritoneResponse.BaseVeritoneListResponse<JobDetail>>(){}).getResult();
    }

    public void cancelJobIfRunning(ItemVeritoneJob veritoneJob) {
        if (veritoneJob.getJobId() != null && (veritoneJob.getJobStatus() == null || veritoneJob.getJobStatus().isRunning())) {
            try {
                LOGGER.info("Cancelling veritone job " + veritoneJob.getJobId());
                this.cancelJob(veritoneJob.getJobId());
            }
            catch (IOException e) {
                LOGGER.error("Error cancelling veritone job " + veritoneJob.getJobId());
            }
        }
    }

    public void waitForJob(ItemVeritoneJob veritoneJob, int pollingDelay) throws IOException, InterruptedException {
        JobStatus jobStatus = null;
        int attempt = 0;
        do {
            block4: {
                Thread.sleep((long)pollingDelay * 1000L);
                try {
                    jobStatus = this.getJobStatus(veritoneJob.getJobId());
                }
                catch (Exception e) {
                    LOGGER.error("Error getting Veritone job status, attempt (" + attempt + ")", (Throwable)e);
                    if (attempt++ <= 2) break block4;
                    LOGGER.error("Reached max attempts, throwing exception");
                    throw e;
                }
            }
            veritoneJob.setJobStatus(jobStatus);
        } while (jobStatus == null || jobStatus.isRunning());
        LOGGER.info("Veritone job " + veritoneJob.getJobId() + " for item " + veritoneJob.getItem().getGuid() + " finished with status " + String.valueOf(jobStatus));
        if (jobStatus != JobStatus.COMPLETE) {
            throw new VeritoneOperationException(iu.getFormattedString("VeritoneTranslateItemsOperation.Error.VeritoneJobFinishedWithIncompleteState", new Object[]{veritoneJob.getJobId(), jobStatus}));
        }
    }

    @Override
    protected boolean isResponseReattemptable(TranslationResponseStatus errorResponse) {
        return false;
    }
}

