/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.nuix.graph.playbook.nodes.EnginePlaybookNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Playbook {
    private static final Logger log = LoggerFactory.getLogger(Playbook.class);
    private final File playbookFile;
    private final JsonNode playbookJsonNode;

    public static Playbook loadFrom(File playbookFile) throws IOException {
        ObjectMapper ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = ymlMapper.readTree(playbookFile);
        Playbook.validateSchema(jsonNode);
        return new Playbook(playbookFile, jsonNode);
    }

    private static void validateSchema(JsonNode jsonNode) throws IOException {
        ObjectMapper jsonMapper = new ObjectMapper();
        JsonNode schemaNode = jsonMapper.readTree(Playbook.class.getResourceAsStream("/schema/playbook.schema.json"));
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V7);
        JsonSchema jsonSchema = jsonSchemaFactory.getSchema(schemaNode);
        jsonSchema.initializeValidators();
        Set<ValidationMessage> validationErrors = jsonSchema.validate(jsonNode);
        if (!validationErrors.isEmpty()) {
            log.error("Playbook is not valid. Errors: {}", (Object)validationErrors);
            throw new PlaybookValidationException("Playbook is not valid. See logs for details.");
        }
    }

    public EnginePlaybookNode loadEnginePlaybook() {
        return EnginePlaybookNode.loadFromNode(this.playbookJsonNode.findValue("playbook").findValue("engine"));
    }

    public Playbook(File playbookFile, JsonNode playbookJsonNode) {
        this.playbookFile = playbookFile;
        this.playbookJsonNode = playbookJsonNode;
    }

    public File getPlaybookFile() {
        return this.playbookFile;
    }
}

