/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook;

import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdWarning {
    private static final Logger log = LoggerFactory.getLogger(ThresholdWarning.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T warnIfExceedsThreshold(Callable<T> callable, long threshold, Supplier<String> message) {
        T t;
        if (!log.isWarnEnabled()) {
            return callable.call();
        }
        long start = System.currentTimeMillis();
        try {
            t = callable.call();
        }
        catch (Throwable throwable) {
            long total2 = System.currentTimeMillis() - start;
            if (total2 > threshold) {
                log.warn("{} took {}ms to evaluate, which exceeds the threshold of {}", message.get(), total2, threshold);
            }
            throw throwable;
        }
        long total = System.currentTimeMillis() - start;
        if (total > threshold) {
            log.warn("{} took {}ms to evaluate, which exceeds the threshold of {}", message.get(), total, threshold);
        }
        return t;
    }
}

