/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine;

public class EngineStats {
    private final long itemQueueSize;
    private final long memgraphQueueSize;
    private final boolean isLoading;
    private final long committedOperationsCacheSize;
    private final int itemsProcessed;
    private final int itemsFailed;
    private final int totalItems;
    private final int totalNodes;
    private final int totalEdges;
    private final int pendingEdgesCount;
    private final int pendingNodesCount;

    public EngineStats(long itemQueueSize, long memgraphQueueSize, boolean isLoading, long committedOperationsCacheSize, int itemsProcessed, int itemsFailed, int totalItems, int totalNodes, int totalEdges, int pendingEdgesCount, int pendingNodesCount) {
        this.itemQueueSize = itemQueueSize;
        this.memgraphQueueSize = memgraphQueueSize;
        this.isLoading = isLoading;
        this.committedOperationsCacheSize = committedOperationsCacheSize;
        this.itemsProcessed = itemsProcessed;
        this.itemsFailed = itemsFailed;
        this.totalItems = totalItems;
        this.totalNodes = totalNodes;
        this.totalEdges = totalEdges;
        this.pendingEdgesCount = pendingEdgesCount;
        this.pendingNodesCount = pendingNodesCount;
    }

    public long getItemQueueSize() {
        return this.itemQueueSize;
    }

    public long getMemgraphQueueSize() {
        return this.memgraphQueueSize;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public long getCommittedOperationsCacheSize() {
        return this.committedOperationsCacheSize;
    }

    public int getItemsProcessed() {
        return this.itemsProcessed;
    }

    public int getItemsFailed() {
        return this.itemsFailed;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public int getTotalEdges() {
        return this.totalEdges;
    }

    public int getPendingEdgesCount() {
        return this.pendingEdgesCount;
    }

    public int getPendingNodesCount() {
        return this.pendingNodesCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineStats)) {
            return false;
        }
        EngineStats other = (EngineStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemQueueSize() != other.getItemQueueSize()) {
            return false;
        }
        if (this.getMemgraphQueueSize() != other.getMemgraphQueueSize()) {
            return false;
        }
        if (this.isLoading() != other.isLoading()) {
            return false;
        }
        if (this.getCommittedOperationsCacheSize() != other.getCommittedOperationsCacheSize()) {
            return false;
        }
        if (this.getItemsProcessed() != other.getItemsProcessed()) {
            return false;
        }
        if (this.getItemsFailed() != other.getItemsFailed()) {
            return false;
        }
        if (this.getTotalItems() != other.getTotalItems()) {
            return false;
        }
        if (this.getTotalNodes() != other.getTotalNodes()) {
            return false;
        }
        if (this.getTotalEdges() != other.getTotalEdges()) {
            return false;
        }
        if (this.getPendingEdgesCount() != other.getPendingEdgesCount()) {
            return false;
        }
        return this.getPendingNodesCount() == other.getPendingNodesCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $itemQueueSize = this.getItemQueueSize();
        result = result * 59 + (int)($itemQueueSize >>> 32 ^ $itemQueueSize);
        long $memgraphQueueSize = this.getMemgraphQueueSize();
        result = result * 59 + (int)($memgraphQueueSize >>> 32 ^ $memgraphQueueSize);
        result = result * 59 + (this.isLoading() ? 79 : 97);
        long $committedOperationsCacheSize = this.getCommittedOperationsCacheSize();
        result = result * 59 + (int)($committedOperationsCacheSize >>> 32 ^ $committedOperationsCacheSize);
        result = result * 59 + this.getItemsProcessed();
        result = result * 59 + this.getItemsFailed();
        result = result * 59 + this.getTotalItems();
        result = result * 59 + this.getTotalNodes();
        result = result * 59 + this.getTotalEdges();
        result = result * 59 + this.getPendingEdgesCount();
        result = result * 59 + this.getPendingNodesCount();
        return result;
    }

    public String toString() {
        return "EngineStats(itemQueueSize=" + this.getItemQueueSize() + ", memgraphQueueSize=" + this.getMemgraphQueueSize() + ", isLoading=" + this.isLoading() + ", committedOperationsCacheSize=" + this.getCommittedOperationsCacheSize() + ", itemsProcessed=" + this.getItemsProcessed() + ", itemsFailed=" + this.getItemsFailed() + ", totalItems=" + this.getTotalItems() + ", totalNodes=" + this.getTotalNodes() + ", totalEdges=" + this.getTotalEdges() + ", pendingEdgesCount=" + this.getPendingEdgesCount() + ", pendingNodesCount=" + this.getPendingNodesCount() + ")";
    }
}

