/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine;

import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.engine.entities.SourceNode;
import java.util.List;
import nuix.Item;
import org.slf4j.LoggerFactory;

public interface ProcessingCallback {
    default public void beforeItemProcessed(Item item, ExecutionContext context) {
    }

    default public void afterItemProcessed(Item item, ExecutionContext context, List<SourceNode> sourceNodes) {
    }

    default public void itemException(Item item, ExecutionContext context, Exception exception) {
        LoggerFactory.getLogger(ProcessingCallback.class).error("Unable to process item {}", (Object)item, (Object)exception);
    }

    public static class NoOp
    implements ProcessingCallback {
        public static final NoOp INSTANCE = new NoOp();
    }
}

