/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.engine.virtualfields;

import com.google.common.collect.ImmutableMap;
import com.nuix.graph.playbook.engine.virtualfields.DefaultCommunicationWithVirtualFields;
import com.nuix.graph.playbook.engine.virtualfields.ItemWithVirtualFields;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nuix.BatchLoadDetails;
import nuix.Binary;
import nuix.Case;
import nuix.Communication;
import nuix.DetectedFace;
import nuix.DigestCollection;
import nuix.Highlight;
import nuix.HistoryEvent;
import nuix.Image;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ItemKind;
import nuix.ItemModifierCallback;
import nuix.ItemSet;
import nuix.ItemType;
import nuix.MarkupSet;
import nuix.MutablePrintedImage;
import nuix.ProductionSetItem;
import nuix.SourceItem;
import nuix.SourceItemNotFoundException;
import nuix.Text;
import nuix.TokenInfo;
import nuix.TreePosition;
import nuix.image.ImageAnalysis;
import org.joda.time.DateTime;

public class DefaultItemWithVirtualFields
implements ItemWithVirtualFields {
    private final Item item;
    private final Case caze;

    @Override
    public String getSubject() {
        Map<String, Object> properties = this.getNormalisedProperties();
        return Stream.of(properties.get("subject"), properties.get("title"), this.item.getName()).map(Objects::toString).filter(Objects::nonNull).findFirst().orElse("");
    }

    @Override
    public String getAuthor() {
        Map<String, Object> properties = this.getNormalisedProperties();
        return Stream.of(properties.get("author"), this.item.getName()).map(Objects::toString).filter(Objects::nonNull).findFirst().orElse("");
    }

    @Override
    public String getMd5() {
        return this.item.getDigests().getMd5();
    }

    @Override
    public List<Map<String, String>> getEntities() {
        Set allEntityTypes = this.caze.getAllEntityTypes();
        return allEntityTypes.stream().flatMap(type -> {
            try {
                return this.item.getEntities(type).stream().map(value -> ImmutableMap.of((Object)"type", (Object)type, (Object)"value", (Object)value));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Map<String, Object> getNormalisedProperties() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry entry : this.item.getProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            Object key = ((String)entry.getKey()).toLowerCase().replaceAll("\\s+", "_");
            if (result.containsKey(key)) {
                String keyWithCounter;
                int counter = 1;
                while (result.containsKey(keyWithCounter = (String)key + "_" + counter++)) {
                }
                key = keyWithCounter;
            }
            result.put((String)key, entry.getValue());
        }
        return result;
    }

    @Override
    public DateTime getFileCreated() {
        return (DateTime)this.item.getProperties().get("File Created");
    }

    @Override
    public DateTime getFileAccessed() {
        return (DateTime)this.item.getProperties().get("File Accessed");
    }

    @Override
    public DateTime getFileModified() {
        return (DateTime)this.item.getProperties().get("File Modified");
    }

    public Communication getCommunication() {
        return new DefaultCommunicationWithVirtualFields(this.item.getCommunication());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemWithVirtualFields)) {
            return false;
        }
        ItemWithVirtualFields that = (ItemWithVirtualFields)o;
        return this.item.equals(that.getItem());
    }

    public String toString() {
        try {
            return "Case [" + this.caze.getName() + "] Item [" + this.item.getGuid() + "]";
        }
        catch (Exception e) {
            return "Error evaluating name: " + e.getMessage();
        }
    }

    public DefaultItemWithVirtualFields(Item item, Case caze) {
        this.item = item;
        this.caze = caze;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public List<Item> getChildren() {
        return this.getItem().getChildren();
    }

    public List<Item> getDescendants() {
        return this.getItem().getDescendants();
    }

    public String getGuid() {
        return this.getItem().getGuid();
    }

    public List<String> getPathGuids() {
        return this.getItem().getPathGuids();
    }

    public Item getTopLevelItem() {
        return this.getItem().getTopLevelItem();
    }

    public DateTime getTopLevelItemDate() {
        return this.getItem().getTopLevelItemDate();
    }

    public boolean isTopLevel() {
        return this.getItem().isTopLevel();
    }

    public boolean isLooseFile() {
        return this.getItem().isLooseFile();
    }

    public boolean isPhysicalFile() {
        return this.getItem().isPhysicalFile();
    }

    public boolean isPoisoned() {
        return this.getItem().isPoisoned();
    }

    public List<Item> getFamily() {
        return this.getItem().getFamily();
    }

    public TreePosition getPosition() {
        return this.getItem().getPosition();
    }

    public List<Item> getDuplicates() {
        return this.getItem().getDuplicates();
    }

    public Collection<Item> getNearDuplicates(float arg0) {
        return this.getItem().getNearDuplicates(arg0);
    }

    public Collection<Item> getChainedNearDuplicates(float arg0) {
        return this.getItem().getChainedNearDuplicates(arg0);
    }

    public float resemblanceTo(Item arg0) {
        return this.getItem().resemblanceTo(arg0);
    }

    public Set<String> getShingles() throws IOException {
        return this.getItem().getShingles();
    }

    public Map<String, Boolean> getClusterPivots() {
        return this.getItem().getClusterPivots();
    }

    public Map<String, Float> getClusterPivotResemblances() {
        return this.getItem().getClusterPivotResemblances();
    }

    public Map<String, String> getClusterEndpointStatus(Locale arg0) {
        return this.getItem().getClusterEndpointStatus(arg0);
    }

    public Map<String, String> getClusterEndpointStatus() {
        return this.getItem().getClusterEndpointStatus();
    }

    public Map<String, String> getClusterBranchIDs() {
        return this.getItem().getClusterBranchIDs();
    }

    public Map<String, String> getClusterThreadIndexes() {
        return this.getItem().getClusterThreadIndexes();
    }

    public List<Item> getThreadItems() {
        return this.getItem().getThreadItems();
    }

    public DateTime getDate() {
        return this.getItem().getDate();
    }

    public ItemCustomMetadataMap getCustomMetadata() {
        return this.getItem().getCustomMetadata();
    }

    public Map<String, Object> getEvidenceMetadata() {
        return this.getItem().getEvidenceMetadata();
    }

    public DigestCollection getDigests() {
        return this.getItem().getDigests();
    }

    public Double getShannonEntropy() {
        return this.getItem().getShannonEntropy();
    }

    public String getSSDeepFuzzyHash() {
        return this.getItem().getSSDeepFuzzyHash();
    }

    public String getPhotoDNARobustHash() {
        return this.getItem().getPhotoDNARobustHash();
    }

    public Collection<Item> getFuzzyHashMatches(int arg0) {
        return this.getItem().getFuzzyHashMatches(arg0);
    }

    public Collection<Item> getFuzzyHashMatches(int arg0, int arg1) {
        return this.getItem().getFuzzyHashMatches(arg0, arg1);
    }

    public int getFuzzyHashScore(Item arg0) {
        return this.getItem().getFuzzyHashScore(arg0);
    }

    public Text getTextObject() {
        return this.getItem().getTextObject();
    }

    @Deprecated
    public boolean isThumbnailStored() {
        return this.getItem().isThumbnailStored();
    }

    public Image getThumbnail() {
        return this.getItem().getThumbnail();
    }

    public void generateThumbnail(int arg0) throws Exception {
        this.getItem().generateThumbnail(arg0);
    }

    public ImageAnalysis getImageAnalysis() {
        return this.getItem().getImageAnalysis();
    }

    public List<Highlight> getHighlights(String arg0, Set<String> arg1) throws IOException {
        return this.getItem().getHighlights(arg0, arg1);
    }

    public List<TokenInfo> tokenise(String arg0) {
        return this.getItem().tokenise(arg0);
    }

    public Binary getBinary() {
        return this.getItem().getBinary();
    }

    public SourceItem getSourceItem() throws IOException {
        return this.getItem().getSourceItem();
    }

    public <R> R withSourceItem(Function<SourceItem, R> arg0) throws IOException {
        return (R)this.getItem().withSourceItem(arg0);
    }

    public Set<String> getTags() {
        return this.getItem().getTags();
    }

    public boolean addTag(String arg0) {
        return this.getItem().addTag(arg0);
    }

    public boolean removeTag(String arg0) {
        return this.getItem().removeTag(arg0);
    }

    public String getComment() {
        return this.getItem().getComment();
    }

    public void setComment(String arg0) {
        this.getItem().setComment(arg0);
    }

    public void appendComment(String arg0) {
        this.getItem().appendComment(arg0);
    }

    public String getExclusion() {
        return this.getItem().getExclusion();
    }

    public boolean isExcluded() {
        return this.getItem().isExcluded();
    }

    public boolean isIncluded() {
        return this.getItem().isIncluded();
    }

    public void exclude(String arg0) {
        this.getItem().exclude(arg0);
    }

    public void include() {
        this.getItem().include();
    }

    public String getCustodian() {
        return this.getItem().getCustodian();
    }

    public void assignCustodian(String arg0) {
        this.getItem().assignCustodian(arg0);
    }

    public void unassignCustodian() {
        this.getItem().unassignCustodian();
    }

    public Set<String> getDuplicateCustodianSet() {
        return this.getItem().getDuplicateCustodianSet();
    }

    public Set<String> getNearDuplicateCustodianSet(float arg0) {
        return this.getItem().getNearDuplicateCustodianSet(arg0);
    }

    public Set<String> getChainedNearDuplicateCustodianSet(float arg0) {
        return this.getItem().getChainedNearDuplicateCustodianSet(arg0);
    }

    public long getAuditedSize() {
        return this.getItem().getAuditedSize();
    }

    public boolean isAudited() {
        return this.getItem().isAudited();
    }

    public String getItemCategory() {
        return this.getItem().getItemCategory();
    }

    public Set<String> getEntities(String arg0) throws IOException {
        return this.getItem().getEntities(arg0);
    }

    public String getOriginalExtension() {
        return this.getItem().getOriginalExtension();
    }

    public String getCorrectedExtension() {
        return this.getItem().getCorrectedExtension();
    }

    public MutablePrintedImage getPrintedImage() {
        return this.getItem().getPrintedImage();
    }

    public Iterable<HistoryEvent> getHistory() {
        return this.getItem().getHistory();
    }

    public void modify(ItemModifierCallback arg0) throws IOException {
        this.getItem().modify(arg0);
    }

    public void removeItemAndDescendants() throws IOException {
        this.getItem().removeItemAndDescendants();
    }

    public String getLanguage() {
        return this.getItem().getLanguage();
    }

    public Set<ItemSet> getItemSets() {
        return this.getItem().getItemSets();
    }

    public Set<ItemSet> getItemSetsAsOriginal() {
        return this.getItem().getItemSetsAsOriginal();
    }

    public Set<ItemSet> getItemSetsAsDuplicate() {
        return this.getItem().getItemSetsAsDuplicate();
    }

    public String getUri() {
        return this.getItem().getUri();
    }

    public Item getRoot() {
        return this.getItem().getRoot();
    }

    public String getRootUri() {
        return this.getItem().getRootUri();
    }

    public BatchLoadDetails getBatchLoadDetails() {
        return this.getItem().getBatchLoadDetails();
    }

    public Map<String, Object> getFamilyStats() {
        return this.getItem().getFamilyStats();
    }

    public Collection<Item> getNearbyItems(double arg0) {
        return this.getItem().getNearbyItems(arg0);
    }

    public <T> T revealDecryptionPassword(Function<char[], T> arg0) {
        return (T)this.getItem().revealDecryptionPassword(arg0);
    }

    public boolean equals(Item arg0) {
        return this.getItem().equals(arg0);
    }

    public String getCaseId() {
        return this.getItem().getCaseId();
    }

    public String getCaseName() {
        return this.getItem().getCaseName();
    }

    public Set<ProductionSetItem> getProductionSetItems() {
        return this.getItem().getProductionSetItems();
    }

    public Set<MarkupSet> getMarkupSets() {
        return this.getItem().getMarkupSets();
    }

    public Set<DetectedFace> getDetectedFaces() {
        return this.getItem().getDetectedFaces();
    }

    public Item getLinkedItem() {
        return this.getItem().getLinkedItem();
    }

    public void validateSourceItemExistence() throws SourceItemNotFoundException {
        this.getItem().validateSourceItemExistence();
    }

    public String getName() {
        return this.getItem().getName();
    }

    public String getLocalisedName() {
        return this.getItem().getLocalisedName();
    }

    public String getLocalisedName(Locale arg0) {
        return this.getItem().getLocalisedName(arg0);
    }

    public List<String> getPathNames() {
        return this.getItem().getPathNames();
    }

    public List<String> getLocalisedPathNames() {
        return this.getItem().getLocalisedPathNames();
    }

    public List<String> getLocalisedPathNames(Locale arg0) {
        return this.getItem().getLocalisedPathNames(arg0);
    }

    public ItemType getType() {
        return this.getItem().getType();
    }

    public Long getFileSize() {
        return this.getItem().getFileSize();
    }

    public boolean isFileData() {
        return this.getItem().isFileData();
    }

    public boolean isDeleted() {
        return this.getItem().isDeleted();
    }

    public boolean isEncrypted() {
        return this.getItem().isEncrypted();
    }

    public boolean isKind(String arg0) {
        return this.getItem().isKind(arg0);
    }

    public ItemKind getKind() {
        return this.getItem().getKind();
    }

    public Map<String, Object> getProperties() {
        return this.getItem().getProperties();
    }

    public String getId() {
        return this.getItem().getId();
    }

    public List<String> getPathIds() {
        return this.getItem().getPathIds();
    }

    public Item getParent() {
        return (Item)this.getItem().getParent();
    }

    public Iterable<String> getChildIds() {
        return this.getItem().getChildIds();
    }

    public Item findChildById(String arg0) {
        return (Item)this.getItem().findChildById(arg0);
    }

    public List<Item> getPath() {
        return this.getItem().getPath();
    }

    public boolean matchesSearch(String arg0) {
        return this.getItem().matchesSearch(arg0);
    }

    static interface ExcludedMethods {
        public Communication getCommunication();
    }
}

