/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.expressions;

import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.expressions.FieldExpression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexCaptureExpression
extends FieldExpression {
    private final Pattern regex;

    public RegexCaptureExpression(String field, String regex) {
        super(field);
        this.regex = Pattern.compile(regex);
    }

    @Override
    public Object evaluate(ExecutionContext executionContext) {
        Object fieldValue = super.evaluate(executionContext);
        if (fieldValue == null) {
            return null;
        }
        Matcher matcher = this.regex.matcher(String.valueOf(fieldValue));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String toString() {
        return "RegexCaptureExpression(regex=" + this.regex + ")";
    }
}

