/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.expressions;

import com.google.common.base.Splitter;
import com.nuix.graph.playbook.engine.ExecutionContext;
import com.nuix.graph.playbook.expressions.FieldExpression;
import com.nuix.graph.playbook.expressions.FilterExpression;
import java.util.List;
import org.neo4j.driver.internal.util.Iterables;

public class ValueMatchExpression
extends FieldExpression
implements FilterExpression {
    private final List<String> values;
    private final boolean negate;

    public ValueMatchExpression(String field, String values, boolean negate) {
        super(field);
        this.values = Iterables.asList((Iterable)Splitter.on((String)",").split((CharSequence)values));
        this.negate = negate;
    }

    @Override
    public Boolean evaluate(ExecutionContext executionContext) {
        Object fieldValue = super.evaluate(executionContext);
        if (fieldValue == null) {
            return this.negate;
        }
        boolean matches = this.values.contains(String.valueOf(fieldValue));
        return this.negate != matches;
    }

    @Override
    public String toString() {
        return "ValueMatchExpression(values=" + this.values + ", negate=" + this.isNegate() + ")";
    }

    public boolean isNegate() {
        return this.negate;
    }
}

