/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.loader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.nuix.graph.playbook.Settings;
import com.nuix.graph.playbook.loader.entities.GraphObject;
import com.nuix.graph.playbook.loader.entities.StoredEdge;
import com.nuix.graph.playbook.loader.entities.StoredNode;
import java.io.Closeable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemGraphStore
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MemGraphStore.class);
    private final Cache<String, String> committedOperationsCache;
    private final Session session;
    private final AtomicInteger totalNodes = new AtomicInteger();
    private final AtomicInteger totalEdges = new AtomicInteger();
    protected InMemoryIndex<StoredNode> nodes = new InMemoryIndex<StoredNode>(e -> e.getLabel() + ":" + e.getId());
    protected InMemoryIndex<StoredEdge> edges = new InMemoryIndex<StoredEdge>(e -> e.getSourceLabel() + ":" + e.getSourceId() + "->" + e.getTargetLabel() + ":" + e.getTargetId() + "[" + e.getLabel() + "]");

    public MemGraphStore(Session session, Settings settings) {
        this.session = session;
        this.committedOperationsCache = CacheBuilder.newBuilder().maximumSize((long)settings.getCommittedOperationsCacheSize()).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(List<GraphObject> objects) {
        MemGraphStore memGraphStore = this;
        synchronized (memGraphStore) {
            for (GraphObject object : objects) {
                if (object instanceof StoredNode) {
                    this.nodes.push((StoredNode)object);
                    continue;
                }
                if (object instanceof StoredEdge) {
                    this.edges.push((StoredEdge)object);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognised object: " + object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Set<StoredEdge> edgesToFlush;
        Set<StoredNode> nodesToFlush;
        if (this.nodes.size() == 0 && this.edges.size() == 0) {
            log.debug("Nothing to flush");
            return;
        }
        MemGraphStore memGraphStore = this;
        synchronized (memGraphStore) {
            nodesToFlush = this.nodes.getAllAndReset();
            edgesToFlush = this.edges.getAllAndReset();
        }
        this.pushInTransaction(nodesToFlush, edgesToFlush);
    }

    private <T extends GraphObject> Map<String, List<T>> filterNotCommittedAndGroupByLabel(Collection<T> nodes) {
        return nodes.stream().filter(e -> this.committedOperationsCache.getIfPresent((Object)e.getMD5()) == null).distinct().collect(Collectors.groupingBy(GraphObject::getLabel));
    }

    private Set<String> extractAllFields(Collection<? extends GraphObject> objects) {
        return objects.stream().flatMap(e -> e.getProperties().keySet().stream()).collect(Collectors.toSet());
    }

    private void maybeCreateIdIndices(Set<String> labels) {
        for (String label : labels) {
            String instruction = "CREATE INDEX ON :" + label + "(id)";
            if (this.committedOperationsCache.getIfPresent((Object)instruction) != null) continue;
            this.session.run(instruction);
            this.committedOperationsCache.put((Object)instruction, (Object)instruction);
        }
    }

    private void pushInTransaction(Collection<StoredNode> nodes, Collection<StoredEdge> edges) {
        Map<String, List<StoredNode>> groupedNodes = this.filterNotCommittedAndGroupByLabel(nodes);
        Map<String, List<StoredEdge>> groupedEdges = this.filterNotCommittedAndGroupByLabel(edges);
        this.maybeCreateIdIndices(groupedNodes.keySet());
        ImmutableList.Builder statementPayload = ImmutableList.builder();
        for (Map.Entry<String, List<StoredNode>> entry : groupedNodes.entrySet()) {
            String groupStatement = this.mergeNodesStatement(entry.getKey(), (Collection<StoredNode>)entry.getValue());
            List<Map> payload = this.toMemGraphPayload((Collection<? extends GraphObject>)entry.getValue());
            statementPayload.add(new AbstractMap.SimpleEntry<String, List<Map>>(groupStatement, payload));
            this.totalNodes.addAndGet(payload.size());
        }
        for (Map.Entry<String, List<GraphObject>> entry : groupedEdges.entrySet()) {
            Map<Map.Entry, List<StoredEdge>> sourceTargetGroup = entry.getValue().stream().collect(Collectors.groupingBy(e -> new AbstractMap.SimpleEntry<String, String>(e.getSourceLabel(), e.getTargetLabel())));
            for (Map.Entry<Map.Entry, List<StoredEdge>> entry2 : sourceTargetGroup.entrySet()) {
                String edgesStatement = this.createEdgesStatement(entry.getKey(), (String)entry2.getKey().getKey(), (String)entry2.getKey().getValue(), (Collection<StoredEdge>)entry2.getValue());
                List<Map> payload = this.toMemGraphPayload((Collection<? extends GraphObject>)entry2.getValue());
                statementPayload.add(new AbstractMap.SimpleEntry<String, List<Map>>(edgesStatement, payload));
                this.totalEdges.addAndGet(payload.size());
            }
        }
        this.executeInTransaction((List<Map.Entry<String, List<Map>>>)statementPayload.build());
        nodes.forEach(e -> this.committedOperationsCache.put((Object)e.getMD5(), (Object)e.getMD5()));
        edges.forEach(e -> this.committedOperationsCache.put((Object)e.getMD5(), (Object)e.getMD5()));
    }

    private List<Map> toMemGraphPayload(Collection<? extends GraphObject> graphObjects) {
        return graphObjects.stream().map(GraphObject::asMap).collect(Collectors.toList());
    }

    private String mergeNodesStatement(String label, Collection<StoredNode> nodes) {
        Set<String> allFields = this.extractAllFields(nodes);
        String createFields = allFields.stream().map(e -> "n." + e + "=i.properties." + e).collect(Collectors.joining(","));
        String updateFields = allFields.stream().map(e -> "n." + e + "=COALESCE(i.properties." + e + ",n." + e + ")").collect(Collectors.joining(","));
        if (createFields.isEmpty()) {
            return "UNWIND $list AS i\nMERGE (n:" + label + " {id: i.id})";
        }
        return "UNWIND $list AS i\nMERGE (n:" + label + " {id: i.id})\nON CREATE SET " + createFields + "\nON MATCH SET " + updateFields;
    }

    private String createEdgesStatement(String label, String sLabel, String tLabel, Collection<StoredEdge> edges) {
        Set<String> allFields = this.extractAllFields(edges);
        String createFields = allFields.stream().map(e -> "r." + e + "=i.properties." + e).collect(Collectors.joining(","));
        String updateFields = allFields.stream().map(e -> "r." + e + "=COALESCE(i.properties." + e + ",r." + e + ")").collect(Collectors.joining(","));
        if (createFields.isEmpty()) {
            return "UNWIND $list AS i\nMATCH (a:" + sLabel + " {id:i.sourceId}),(b:" + tLabel + " {id:i.targetId}) MERGE (a)-[r:" + label + " {}]->(b)";
        }
        return "UNWIND $list AS i\nMATCH (a:" + sLabel + " {id:i.sourceId}),(b:" + tLabel + " {id:i.targetId})\nMERGE (a)-[r:" + label + "]->(b)\nON CREATE SET " + createFields + "\nON MATCH SET " + updateFields;
    }

    private void executeInTransaction(List<Map.Entry<String, List<Map>>> statements) {
        for (int i = 5; i > 0; --i) {
            try (Transaction transaction = this.session.beginTransaction();){
                for (Map.Entry<String, List<Map>> statementPayload : statements) {
                    if (log.isDebugEnabled()) {
                        log.debug("Executing {} with {} objects.", (Object)statementPayload.getKey(), (Object)statementPayload.getValue().size());
                    }
                    transaction.run(statementPayload.getKey(), (Map)ImmutableMap.of((Object)"list", statementPayload.getValue()));
                }
                transaction.commit();
                break;
            }
            catch (ClientException | TransientException e) {
                if (e instanceof TransientException || e.getCause() instanceof TransientException) {
                    log.error("Unable to commit transaction. Will retry " + i + " times", e);
                    try {
                        TimeUnit.MILLISECONDS.sleep(50L * (long)i);
                    }
                    catch (InterruptedException ex) {
                        log.error("Interrupted while waiting for pending operations", ex);
                    }
                    continue;
                }
                log.error("Non-transient error while executing transaction. Will not retry.\nROLLED BACK OPERATIONS:\n{}", (Object)statements, (Object)e);
                break;
            }
        }
    }

    public long getCacheSize() {
        return this.committedOperationsCache.size();
    }

    public int getPendingEdgesCount() {
        return this.edges.size();
    }

    public int getPendingNodesCount() {
        return this.nodes.size();
    }

    @Override
    public void close() {
        this.flush();
    }

    public int getTotalNodesCommitted() {
        return this.totalNodes.get();
    }

    public int getTotalEdgesCommitted() {
        return this.totalEdges.get();
    }

    private static class InMemoryIndex<T extends GraphObject> {
        private final Function<T, String> indexEvaluator;
        private Multimap<String, T> index = LinkedHashMultimap.create();

        public void push(T object) {
            boolean exists = false;
            String id = this.indexEvaluator.apply(object);
            if (log.isDebugEnabled()) {
                exists = this.index.containsKey((Object)id);
            }
            if (this.index.put((Object)id, object) && exists && log.isDebugEnabled()) {
                log.debug("Object with the same id already exists with different properties:\n{}", (Object)this.index.get((Object)id));
            }
        }

        public Set<T> getAllAndReset() {
            Multimap<String, T> currentValues = this.index;
            this.index = LinkedHashMultimap.create();
            return currentValues.values().stream().collect(Collectors.toSet());
        }

        public int size() {
            return this.index.keys().size();
        }

        public InMemoryIndex(Function<T, String> indexEvaluator) {
            this.indexEvaluator = indexEvaluator;
        }
    }
}

