/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.loader.entities;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class GraphObject {
    private static final Gson GSON = new Gson();
    private final transient Supplier<String> json = Suppliers.memoize(this::buildJSON);
    private final transient Supplier<String> md5 = Suppliers.memoize(this::buildMD5);
    private final transient Supplier<Map> map = Suppliers.memoize(this::buildMap);

    public abstract String getLabel();

    public abstract Map<String, Object> getProperties();

    public String asJson() {
        return (String)this.json.get();
    }

    public Map asMap() {
        return (Map)this.map.get();
    }

    public String getMD5() {
        return (String)this.md5.get();
    }

    private String buildJSON() {
        return GSON.toJson((Object)this);
    }

    private Map buildMap() {
        return (Map)GSON.fromJson(this.asJson(), Map.class);
    }

    private String buildMD5() {
        return DigestUtils.md5Hex((String)this.asJson());
    }

    public String toString() {
        return this.asJson();
    }

    public int hashCode() {
        return this.getMD5().hashCode();
    }
}

