/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.loader.entities;

import com.nuix.graph.playbook.engine.entities.Edge;
import com.nuix.graph.playbook.engine.entities.Node;
import com.nuix.graph.playbook.loader.entities.GraphObject;
import java.util.Map;
import java.util.TreeMap;

public class StoredEdge
extends GraphObject {
    private final String label;
    private final Object sourceId;
    private final String sourceLabel;
    private final Object targetId;
    private final String targetLabel;
    private final Map<String, Object> properties;

    public static StoredEdge from(Node source, Edge edge) {
        Node s = edge.isReverse() ? edge.getTarget() : source;
        Node t = edge.isReverse() ? source : edge.getTarget();
        return new StoredEdge(edge.getLabel(), s.getId(), s.getLabel(), t.getId(), t.getLabel(), new TreeMap<String, Object>(edge.getFields()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoredEdge)) {
            return false;
        }
        StoredEdge other = (StoredEdge)obj;
        return this.getMD5().equals(other.getMD5());
    }

    public StoredEdge(String label, Object sourceId, String sourceLabel, Object targetId, String targetLabel, Map<String, Object> properties) {
        this.label = label;
        this.sourceId = sourceId;
        this.sourceLabel = sourceLabel;
        this.targetId = targetId;
        this.targetLabel = targetLabel;
        this.properties = properties;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public Object getSourceId() {
        return this.sourceId;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public Object getTargetId() {
        return this.targetId;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

