/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.nuix.graph.playbook.expressions.Expression;
import com.nuix.graph.playbook.expressions.FieldExpression;
import com.nuix.graph.playbook.expressions.RegexCaptureExpression;
import com.nuix.graph.playbook.expressions.ValueExpression;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;

public class FieldNode
extends AbstractNode {
    private String key;
    private Expression value;

    @Override
    protected FieldNode load(JsonNode jsonNode) throws PlaybookValidationException {
        this.key = jsonNode.path("key").asText();
        String value = jsonNode.path("value").asText(null);
        String valueField = jsonNode.path("value-field").asText(null);
        String regexCapture = jsonNode.path("regex-capture").asText(null);
        if (value != null) {
            if (valueField != null || regexCapture != null) {
                throw new PlaybookValidationException("If 'value' is used, 'value-field' and 'regex-capture' can't be present:\n " + jsonNode);
            }
        } else if (valueField == null && regexCapture == null) {
            throw new PlaybookValidationException("'value-field' is required if 'regex-capture; is used:\n" + jsonNode);
        }
        if (value != null) {
            this.value = new ValueExpression(value);
        } else if (valueField != null) {
            this.value = regexCapture != null ? new RegexCaptureExpression(valueField, regexCapture) : new FieldExpression(valueField);
        } else {
            throw new PlaybookValidationException("No value provided for field:\n" + jsonNode);
        }
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Expression getValue() {
        return this.value;
    }

    public String toString() {
        return "FieldNode(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

