/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.nuix.graph.playbook.expressions.FilterExpression;
import com.nuix.graph.playbook.expressions.RegexMatchExpression;
import com.nuix.graph.playbook.expressions.TruthyExpression;
import com.nuix.graph.playbook.expressions.ValueMatchExpression;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;

public class FilterNode
extends AbstractNode {
    private FilterExpression expression;

    @Override
    protected FilterNode load(JsonNode jsonNode) throws PlaybookValidationException {
        String valueField = jsonNode.path("value-field").asText(null);
        String include = jsonNode.path("include").asText(null);
        String exclude = jsonNode.path("exclude").asText(null);
        String regexInclude = jsonNode.path("regex-include").asText(null);
        String regexExclude = jsonNode.path("regex-exclude").asText(null);
        this.expression = regexInclude != null ? new RegexMatchExpression(valueField, regexInclude, false) : (regexExclude != null ? new RegexMatchExpression(valueField, regexExclude, true) : (include != null ? new ValueMatchExpression(valueField, include, false) : (exclude != null ? new ValueMatchExpression(valueField, exclude, true) : new TruthyExpression(valueField))));
        return this;
    }

    public FilterExpression getExpression() {
        return this.expression;
    }

    public String toString() {
        return "FilterNode(expression=" + this.getExpression() + ")";
    }
}

