/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.nuix.graph.playbook.expressions.FieldExpression;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.FilterNode;
import com.nuix.graph.playbook.nodes.NodeNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import java.util.Iterator;
import java.util.List;

public class LoadableNode
extends AbstractNode {
    private FieldExpression context;
    private NodeNode node;
    private List<FilterNode> filters;

    @Override
    protected LoadableNode load(JsonNode jsonNode) throws PlaybookValidationException {
        JsonNode context = jsonNode.findValue("context");
        this.context = context != null ? new FieldExpression(context.asText()) : new FieldExpression("item");
        this.node = new NodeNode().load(jsonNode.path("node"));
        ImmutableList.Builder filtersBuilder = ImmutableList.builder();
        JsonNode filters = jsonNode.findValue("filters");
        if (filters != null) {
            Iterator it = filters.elements();
            while (it.hasNext()) {
                JsonNode filterNode = (JsonNode)it.next();
                filtersBuilder.add((Object)new FilterNode().load(filterNode));
            }
        }
        this.filters = filtersBuilder.build();
        return this;
    }

    public FieldExpression getContext() {
        return this.context;
    }

    public NodeNode getNode() {
        return this.node;
    }

    public List<FilterNode> getFilters() {
        return this.filters;
    }

    public String toString() {
        return "LoadableNode(context=" + this.getContext() + ", node=" + this.getNode() + ", filters=" + this.getFilters() + ")";
    }
}

