/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.graph.playbook.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.nuix.graph.playbook.nodes.AbstractNode;
import com.nuix.graph.playbook.nodes.FieldNode;
import com.nuix.graph.playbook.nodes.PlaybookValidationException;
import com.nuix.graph.playbook.nodes.TemplateNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NodeNode
extends AbstractNode {
    private String template;
    private List<FieldNode> fields;

    @Override
    protected NodeNode load(JsonNode jsonNode) throws PlaybookValidationException {
        this.template = jsonNode.path("template").asText(null);
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        JsonNode fields = jsonNode.findValue("fields");
        if (fields != null) {
            Iterator it = fields.elements();
            while (it.hasNext()) {
                JsonNode fieldNode = (JsonNode)it.next();
                fieldsBuilder.add((Object)new FieldNode().load(fieldNode));
            }
            this.fields = fieldsBuilder.build();
        }
        return this;
    }

    public void applyTemplate(Map<String, TemplateNode> templates) {
        Object existingFields;
        if (this.template == null) {
            return;
        }
        TemplateNode templateNode = templates.get(this.template);
        if (templateNode == null) {
            throw new PlaybookValidationException("Template [" + this.template + "] not found.");
        }
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        if (this.fields != null) {
            existingFields = this.fields.stream().map(FieldNode::getKey).collect(Collectors.toUnmodifiableSet());
            fieldsBuilder.addAll(this.fields);
        } else {
            existingFields = ImmutableSet.of();
        }
        for (FieldNode field : templateNode.getNode().getFields()) {
            if (existingFields.contains(field.getKey())) {
                throw new PlaybookValidationException("Field [" + field + "] is defined in the node and in the template.");
            }
            fieldsBuilder.add((Object)field);
        }
        this.fields = fieldsBuilder.build();
    }

    public String getTemplate() {
        return this.template;
    }

    public List<FieldNode> getFields() {
        return this.fields;
    }

    public String toString() {
        return "NodeNode(template=" + this.getTemplate() + ", fields=" + this.getFields() + ")";
    }
}

