/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.benchmark.CallAwareSqlLogger;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.sql.DriverSqlLocator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class SqlUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlUtils.class);
    private static SqlUtils instance;

    public static SqlUtils getInstance() {
        if (instance == null) {
            instance = new SqlUtils();
        }
        return instance;
    }

    public void buildSqlLocator(Jdbi jdbi) {
        try (Connection connection = jdbi.open().getConnection();){
            DatabaseMetaData metadata = connection.getMetaData();
            DriverSqlLocator driverSqlLocator = new DriverSqlLocator(metadata.getDatabaseProductName());
            ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)driverSqlLocator);
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate Driver SQL locator");
        }
    }

    public void buildCallTracing(Jdbi jdbi) {
        if (SchedulerApplication.getInstance().getConfiguration().isEnableDatabaseCallTracing()) {
            jdbi.setSqlLogger((SqlLogger)new CallAwareSqlLogger("com.nuix"));
        }
    }
}

