/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ApiKeyMapper
implements RowMapper<ApiKeyWithSecret> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ApiKeyMapper.class);

    public ApiKeyWithSecret map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        ApiKeyWithSecret apiKey = (ApiKeyWithSecret)SerializationUtils.fromJson((String)resultSet.getString("data"), ApiKeyWithSecret.class);
        String encryptedSecret = apiKey.getSecret();
        String secret = "";
        try {
            secret = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedSecret);
        }
        catch (IOException e) {
            LOGGER.error("Cannot decrypt API key secret", (Throwable)e);
        }
        apiKey.setSecret(secret);
        apiKey.setId(resultSet.getString("id"));
        return apiKey;
    }
}

