/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=ApiKeyBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindApiKey {

    public static class ApiKeyBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlStatementCustomizerFactory.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                ApiKeyWithSecret arg = (ApiKeyWithSecret)obj;
                q.bind("id", arg.getId());
                ApiKeyWithSecret copyApiKey = arg.clone();
                copyApiKey.setId(null);
                copyApiKey.setStatus(null);
                String secret = copyApiKey.getSecret();
                String encryptedSecret = "";
                try {
                    encryptedSecret = SchedulerApplication.getInstance().getEncryptor().encrypt(secret);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt API key secret", (Throwable)e);
                }
                copyApiKey.setSecret(encryptedSecret);
                q.bind("data", SerializationUtils.toDbJson((Object)copyApiKey));
            };
        }
    }
}

