/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=DataRepositoryBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindDataRepository {

    public static class DataRepositoryBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DataRepositoryBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                DataRepository arg = (DataRepository)obj;
                q.bind("id", arg.getId());
                DataRepository copyRepository = arg.clone();
                copyRepository.setId(null);
                copyRepository.setUsableSpace(null);
                copyRepository.setStatus(null);
                AzureStorageAccount azureStorageAccount = copyRepository.getAzureStorageAccount();
                if (azureStorageAccount != null) {
                    String accountKey = azureStorageAccount.getAccountKey();
                    String encryptedAccountKey = null;
                    if (accountKey != null && !accountKey.trim().equals("")) {
                        try {
                            encryptedAccountKey = SchedulerApplication.getInstance().getEncryptor().encrypt(accountKey);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Azure storage account accountKey for: " + copyRepository.getName(), (Throwable)e);
                        }
                    }
                    azureStorageAccount.setAccountKey(encryptedAccountKey);
                }
                q.bind("repository", SerializationUtils.toDbJson((Object)copyRepository));
            };
        }
    }
}

