/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.ecc.EccProfileModel;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=EccProfileBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindEccProfile {

    public static class EccProfileBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EccProfileBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                EccProfileModel arg = (EccProfileModel)obj;
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("serverUrl", arg.getServerUrl());
                q.bind("username", arg.getUsername());
                try {
                    q.bind("password", SchedulerApplication.getInstance().getEncryptor().encrypt(arg.getPassword()));
                }
                catch (IOException e) {
                    q.bind("password", "");
                    LOGGER.error("Cannot ECC Profile password", (Throwable)e);
                }
                q.bind("whitelistedCertFingerprints", SerializationUtils.toDbJson((Object)arg.getWhitelistedCertFingerprints()));
                EccProfileModel adSettingsModel = arg.clone();
                adSettingsModel.setId(null);
                adSettingsModel.setName(null);
                adSettingsModel.setDescription(null);
                adSettingsModel.setServerUrl(null);
                adSettingsModel.setUsername(null);
                adSettingsModel.setPassword(null);
                adSettingsModel.setWhitelistedCertFingerprints(null);
                adSettingsModel.setStatus(null);
                adSettingsModel.setVersion(null);
                try {
                    adSettingsModel.setRemoteAgentPassword(SchedulerApplication.getInstance().getEncryptor().encrypt(arg.getRemoteAgentPassword()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot ECC Profile password", (Throwable)e);
                }
                q.bind("adSettings", SerializationUtils.toDbJson((Object)adSettingsModel));
            };
        }
    }
}

