/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=LibraryWorkflowBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindLibraryWorkflow {

    public static class LibraryWorkflowBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LibraryWorkflowBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                Workflow arg = (Workflow)obj;
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("libraryId", arg.getLibraryId());
                q.bind("enabled", arg.getEnabled());
                q.bind("xml", arg.getOperationsXml());
                q.bind("allowedParameterValues", SerializationUtils.toDbJson((Object)arg.getAllowedParameterValues()));
                Workflow clone = arg.clone();
                clone.setOperationsXml(null);
                clone.setDescription(null);
                clone.setLibraryId(null);
                clone.setEnabled(null);
                clone.setAllowedParameterValues(null);
                clone.setExecutionMode(null);
                clone.setId(null);
                clone.setName(null);
                clone.setUserPermissions(null);
                q.bind("data", SerializationUtils.toDbJson((Object)clone));
            };
        }
    }
}

