/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AzureResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolAdditionalSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=ResourcePoolBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindResourcePool {

    public static class ResourcePoolBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                ResourcePoolModel arg = (ResourcePoolModel)obj;
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("active", arg.getActive());
                q.bind("type", arg.getType().name());
                q.bind("referenceId", arg.getReferenceId());
                CloudResourcePoolSettings cloudSettings = arg.getCloudSettings();
                if (cloudSettings != null) {
                    AwsResourcePoolSettings awsResourceSettingsModel;
                    AzureResourcePoolSettings azureSettingsModel = (cloudSettings = new CloudResourcePoolSettings(cloudSettings)).getAzureSettings();
                    if (azureSettingsModel != null) {
                        try {
                            azureSettingsModel.setKey(SchedulerApplication.getInstance().getEncryptor().encrypt(azureSettingsModel.getKey()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Azure Resource Pool Key", (Throwable)e);
                        }
                        try {
                            azureSettingsModel.setCustomVmPassword(SchedulerApplication.getInstance().getEncryptor().encrypt(azureSettingsModel.getCustomVmPassword()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Azure Resource Pool Custom VM Password", (Throwable)e);
                        }
                    }
                    if ((azureSettingsModel = cloudSettings.getRemoteAzureSettings()) != null) {
                        try {
                            azureSettingsModel.setCustomVmPassword(SchedulerApplication.getInstance().getEncryptor().encrypt(azureSettingsModel.getCustomVmPassword()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt Azure Resource Pool Custom VM Password", (Throwable)e);
                        }
                    }
                    if ((awsResourceSettingsModel = cloudSettings.getAwsSettings()) != null) {
                        try {
                            awsResourceSettingsModel.setSecretKey(SchedulerApplication.getInstance().getEncryptor().encrypt(awsResourceSettingsModel.getSecretKey()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt AWS Resource Pool Secret Key", (Throwable)e);
                        }
                    }
                }
                q.bind("cloudSettings", SerializationUtils.toDbJson((Object)cloudSettings));
                ResourcePoolAdditionalSettings additionalSettings = new ResourcePoolAdditionalSettings();
                additionalSettings.setAutoRegistrationEnabled(arg.getAutoRegistrationEnabled());
                AutoRegistrationSettings autoRegistrationSettings = arg.getAutoRegistrationSettings();
                if (autoRegistrationSettings != null) {
                    AutoRegistrationSettings updatedAutoRegistrationSettings = new AutoRegistrationSettings(autoRegistrationSettings);
                    additionalSettings.setSelfRegistrationSettings(updatedAutoRegistrationSettings);
                    if (updatedAutoRegistrationSettings.getAccessKey() != null) {
                        try {
                            updatedAutoRegistrationSettings.setAccessKey(SchedulerApplication.getInstance().getEncryptor().encrypt(updatedAutoRegistrationSettings.getAccessKey()));
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot encrypt self-registration access key", (Throwable)e);
                        }
                    }
                }
                q.bind("additionalSettings", SerializationUtils.toDbJson((Object)additionalSettings));
            };
        }
    }
}

