/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.server.Server;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=ServerBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindServer {

    public static class ServerBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                Server arg = (Server)obj;
                q.bind("id", arg.getId());
                q.bind("name", arg.getName());
                q.bind("description", arg.getDescription());
                q.bind("url", arg.getUrl());
                q.bind("whitelistedCertFingerprints", SerializationUtils.toDbJson((Object)arg.getWhitelistedCertFingerprints()));
                q.bind("tags", SerializationUtils.toDbJson((Object)arg.getTags()));
            };
        }
    }
}

