/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=SmtpEmailBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindSmtpEmail {

    public static class SmtpEmailBinder
    implements SqlStatementCustomizerFactory {
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                SmtpEmail arg = (SmtpEmail)obj;
                q.bind("id", arg.getId());
                q.bind("initiatorId", arg.getInitiatorId());
                q.bind("smtpServerId", arg.getSmtpServerId());
                q.bind("type", arg.getType().name());
                q.bind("state", (Object)arg.getState());
                q.bind("to", arg.getTo());
                q.bind("createdDate", arg.getCreatedDate());
                q.bind("sentDate", arg.getSentDate());
                SmtpEmail copyEmail = arg.clone();
                copyEmail.setId(null);
                copyEmail.setInitiatorId(null);
                copyEmail.setSmtpServerId(null);
                copyEmail.setType(null);
                copyEmail.setState(null);
                copyEmail.setTo(null);
                copyEmail.setCreatedDate(null);
                copyEmail.setSentDate(null);
                copyEmail.setUserPermissions(null);
                if (copyEmail.getState() != EmailState.PENDING && copyEmail.getState() != EmailState.ERROR) {
                    copyEmail.setMessage(null);
                    copyEmail.setWorkflowLog(null);
                    copyEmail.setReportFilePath(null);
                    copyEmail.setAdditionalAttachments(null);
                }
                q.bind("email", SerializationUtils.toDbJson((Object)copyEmail));
            };
        }
    }
}

