/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.PurviewDownloadUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=UserCredentialBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindThirdPartyUserCredential {

    public static class UserCredentialBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserCredentialBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                PurviewUserCredential purviewUserCredential;
                PurviewDownloadUserCredential downloadUserCredential;
                ThirdPartyUserCredential arg = (ThirdPartyUserCredential)obj;
                ThirdPartyUserCredential copyCredential = arg.clone();
                copyCredential.setThirdPartyServiceId(null);
                copyCredential.setAuthenticationScope(null);
                copyCredential.setUserId(null);
                copyCredential.setToken(this.encrypt(copyCredential.getToken()));
                copyCredential.setRefreshToken(this.encrypt(copyCredential.getRefreshToken()));
                copyCredential.setPassword(this.encrypt(copyCredential.getPassword()));
                copyCredential.setProperties(this.encrypt(copyCredential.getProperties()));
                if (copyCredential instanceof PurviewUserCredential && (downloadUserCredential = (purviewUserCredential = (PurviewUserCredential)copyCredential).getDownloadUserCredential()) != null) {
                    downloadUserCredential.setToken(this.encrypt(downloadUserCredential.getToken()));
                    downloadUserCredential.setRefreshToken(this.encrypt(downloadUserCredential.getRefreshToken()));
                }
                q.bind("id", arg.getId());
                q.bind("thirdPartyServiceId", arg.getThirdPartyServiceId());
                q.bind("scope", (Object)arg.getAuthenticationScope());
                q.bind("userId", arg.getUserId());
                q.bind("stale", arg.getStale());
                q.bind("credential", SerializationUtils.toDbJson((Object)copyCredential));
            };
        }

        private String encrypt(String value) {
            if (value != null && !value.trim().isEmpty()) {
                try {
                    return SchedulerApplication.getInstance().getEncryptor().encrypt(value);
                }
                catch (IOException e) {
                    LOGGER.error("Error during encryption", (Throwable)e);
                }
            }
            return null;
        }

        private Map<String, String> encrypt(Map<String, String> map) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (map != null) {
                for (String key : map.keySet()) {
                    String value = map.get(key);
                    try {
                        result.put(key, SchedulerApplication.getInstance().getEncryptor().encrypt(value));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error during encryption", (Throwable)e);
                    }
                }
                return result;
            }
            return null;
        }
    }
}

