/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class DataRepositoryMapper
implements RowMapper<DataRepository> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DataRepositoryMapper.class);

    public DataRepository map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        AzureStorageAccount azureStorageAccount;
        DataRepository dataRepository = (DataRepository)SerializationUtils.fromJson((String)resultSet.getString("repository"), DataRepository.class);
        dataRepository.setId(resultSet.getString("id"));
        if (dataRepository.getType() == null) {
            dataRepository.setType(DatasetType.MANAGED);
        }
        if ((azureStorageAccount = dataRepository.getAzureStorageAccount()) != null) {
            String encryptedAccountKey = azureStorageAccount.getAccountKey();
            String accountKey = null;
            if (encryptedAccountKey != null && !encryptedAccountKey.trim().equals("")) {
                try {
                    accountKey = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedAccountKey);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt Azure storage account accountKey for: " + dataRepository.getName(), (Throwable)e);
                }
            }
            azureStorageAccount.setAccountKey(accountKey);
        }
        return dataRepository;
    }
}

