/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.ecc.EccProfileModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class EccProfileMapper
implements RowMapper<EccProfileModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EccProfileMapper.class);

    public EccProfileModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        EccProfileModel eccProfile = new EccProfileModel();
        eccProfile.setId(resultSet.getString("id"));
        eccProfile.setName(resultSet.getString("name"));
        eccProfile.setDescription(resultSet.getString("description"));
        eccProfile.setServerUrl(resultSet.getString("serverUrl"));
        eccProfile.setUsername(resultSet.getString("username"));
        try {
            eccProfile.setPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(resultSet.getString("password")));
        }
        catch (IOException e) {
            LOGGER.error("Cannot decrypt ECC Profile password", (Throwable)e);
        }
        eccProfile.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)((Set)SerializationUtils.fromJson((String)resultSet.getString("whitelistedCertFingerprints"), Set.class))));
        EccProfileModel adSettingsModel = (EccProfileModel)SerializationUtils.fromJson((String)resultSet.getString("adSettings"), EccProfileModel.class);
        eccProfile.setSyncWithAd(adSettingsModel.getSyncWithAd());
        eccProfile.setDeployBeforeCollection(adSettingsModel.getDeployBeforeCollection());
        eccProfile.setEccInstallCommand(adSettingsModel.getEccInstallCommand());
        eccProfile.setRemoveAfterCollection(adSettingsModel.getRemoveAfterCollection());
        eccProfile.setEccUninstallCommand(adSettingsModel.getEccUninstallCommand());
        try {
            eccProfile.setRemoteAgentPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(adSettingsModel.getRemoteAgentPassword()));
        }
        catch (IOException e) {
            LOGGER.error("Cannot decrypt ECC Profile remote agent password", (Throwable)e);
        }
        eccProfile.setRetryCommand(adSettingsModel.getRetryCommand());
        eccProfile.setTimeout(adSettingsModel.getTimeout());
        return eccProfile;
    }
}

