/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.JobExecutionLog;
import com.nuix.automate.utils.workflow.LogLevel;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ExecutionLogMapper
implements RowMapper<JobExecutionLog> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionLogMapper.class);

    public JobExecutionLog map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        JobExecutionLog executionLogLine = new JobExecutionLog();
        String level = resultSet.getString("level");
        executionLogLine.setLevel(LogLevel.valueOf((String)level));
        long date = resultSet.getLong("date");
        executionLogLine.setDate(date);
        byte[] messageBlob = resultSet.getBytes("message");
        if (messageBlob == null) {
            executionLogLine.setMessage("");
        } else {
            executionLogLine.setMessage(new String(messageBlob, StandardCharsets.UTF_8));
        }
        return executionLogLine;
    }
}

