/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.executionprofile.JobProgressSettings;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ExecutionProfileMapper
implements RowMapper<ExecutionProfileModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionProfileMapper.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public ExecutionProfileModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        Object staticParameter;
        ExecutionProfileModel executionProfileModel = new ExecutionProfileModel();
        String encryptedPassword = resultSet.getString("engineAccountPassword");
        String decryptedPassword = "";
        try {
            decryptedPassword = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedPassword);
        }
        catch (IOException e) {
            executionProfileModel.setEngineAccountPassword(null);
            decryptedPassword = null;
            LOGGER.error("Cannot decrypt Execution Profile password", (Throwable)e);
        }
        LinkedHashMap workflowParameters = (LinkedHashMap)SerializationUtils.fromJson((String)resultSet.getString("workflowParameters"), LinkedHashMap.class);
        for (String parameterName : workflowParameters.keySet()) {
            staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            String decryptedParameterValue = "";
            try {
                decryptedParameterValue = SchedulerApplication.getInstance().getEncryptor().decrypt((String)workflowParameters.get(parameterName));
            }
            catch (IOException e) {
                executionProfileModel.getStatus().setOrAppendError(this.iu.getFormattedString("ExecutionProfile.ReenterParameter", (Object)parameterName));
                LOGGER.error("Cannot decrypt parameter " + parameterName, (Throwable)e);
            }
            workflowParameters.put(parameterName, decryptedParameterValue);
        }
        executionProfileModel.setId(resultSet.getString("id"));
        executionProfileModel.setName(resultSet.getString("name"));
        executionProfileModel.setDescription(resultSet.getString("description"));
        executionProfileModel.setEngineCommandLineParameters(resultSet.getString("engineCommandLineParameters"));
        executionProfileModel.setEngineAccountPassword(decryptedPassword);
        executionProfileModel.setEngineAccountUsername(resultSet.getString("engineAccountUsername"));
        executionProfileModel.setWorkflowParameters(workflowParameters);
        executionProfileModel.setEngineLogFolder(resultSet.getString("engineLogFolder"));
        executionProfileModel.setJavaFolder(resultSet.getString("javaFolder"));
        executionProfileModel.setNotificationRuleIds((List)SerializationUtils.fromJson((String)resultSet.getString("notificationRules"), List.class));
        executionProfileModel.setNuixEngineFolder(resultSet.getString("nuixEngineFolder"));
        executionProfileModel.setJobTimeoutSettings((JobTimeoutSettings)SerializationUtils.fromJson((String)resultSet.getString("jobTimeoutSettings"), JobTimeoutSettings.class));
        executionProfileModel.setJobProgressSettings((JobProgressSettings)SerializationUtils.fromJson((String)resultSet.getString("jobProgressSettings"), JobProgressSettings.class));
        executionProfileModel.setWorkerTempFolder(resultSet.getString("workerTempFolder"));
        try {
            executionProfileModel.setSchedulerUrl(resultSet.getString("schedulerUrl"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Map nuixProfiles = new HashMap<String, String>();
        String nuixProfilesJson = resultSet.getString("nuixProfiles");
        if (nuixProfilesJson != null) {
            try {
                nuixProfiles = (Map)SerializationUtils.fromJson((String)nuixProfilesJson, Map.class);
                if (nuixProfiles != null) {
                    staticParameter = (String)nuixProfiles.get("metadataProfiles");
                }
            }
            catch (ClassCastException e) {
                nuixProfiles.put("UPDATE_V1", nuixProfilesJson);
            }
        }
        Map additionalFiles = new HashMap<String, String>();
        String additionalFilesJson = resultSet.getString("additionalFiles");
        if (additionalFilesJson != null) {
            try {
                additionalFiles = (Map)SerializationUtils.fromJson((String)additionalFilesJson, Map.class);
                if (additionalFiles != null) {
                    String value = (String)additionalFiles.get("files");
                    value = (String)additionalFiles.get("fileParameters");
                }
            }
            catch (ClassCastException e) {
                additionalFiles.put("UPDATE_V1", additionalFilesJson);
            }
        }
        executionProfileModel.setNuixProfiles(nuixProfiles);
        executionProfileModel.setAdditionalFiles(additionalFiles);
        executionProfileModel.setReference(resultSet.getString("reference"));
        executionProfileModel.setReferenceVersion(resultSet.getString("referenceVersion"));
        return executionProfileModel;
    }
}

