/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class JobDetailsSerializer {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobDetailsSerializer.class);
    private XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());

    JobDetailsSerializer() {
        LOGGER.info("Initializing XStream (JobDetailsSerializer)");
        this.xstream.ignoreUnknownElements();
        this.xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
    }

    public static String formatXml(String xml) {
        try {
            TransformerFactory factory = SAXTransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return xml;
        }
    }

    public void serialize(Object o, File file) throws IOException {
        String xmlText = this.xstream.toXML(o);
        xmlText = JobDetailsSerializer.formatXml(xmlText);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            bufferedWriter.write(xmlText);
        }
    }

    public String serialize(Object o) throws IOException {
        String xmlText = this.xstream.toXML(o);
        xmlText = JobDetailsSerializer.formatXml(xmlText);
        return xmlText;
    }

    public Object deserialize(File file) throws IOException {
        String xml = FileUtils.readFileWithAutodetectEncoding((File)file);
        return this.deserialize(xml);
    }

    public Object deserialize(String s) throws IOException {
        return this.xstream.fromXML(s);
    }

    public Object deserialize(URL u) throws IOException {
        return this.xstream.fromXML(u);
    }
}

