/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.workflow.StaticParameter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class MatterMapper
implements RowMapper<Matter> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MatterMapper.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public Matter map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        Matter model = new Matter();
        model.setId(resultSet.getString("id"));
        model.setClientId(resultSet.getString("clientId"));
        model.setName(resultSet.getString("name"));
        model.setDescription(resultSet.getString("description"));
        model.setEnabled(Boolean.valueOf(resultSet.getBoolean("enabled")));
        model.setDefaultResourcePoolId(resultSet.getString("defaultResourcePoolId"));
        model.setDefaultExecutionProfileId(resultSet.getString("defaultExecutionProfileId"));
        model.setReference(resultSet.getString("reference"));
        model.setSynchronizeJobs(Boolean.valueOf(resultSet.getBoolean("synchronizeJobs")));
        TreeMap allowedParameters = new TreeMap();
        Map parsedAllowedParameterValues = (Map)SerializationUtils.fromJson((String)resultSet.getString("allowedParameterValues"), Map.class);
        if (parsedAllowedParameterValues != null) {
            for (String parameterName : parsedAllowedParameterValues.keySet()) {
                ArrayList allowedValues = new ArrayList();
                allowedValues.addAll((Collection)parsedAllowedParameterValues.get(parameterName));
                allowedParameters.put(parameterName, allowedValues);
            }
        }
        model.setAllowedParameterValues(allowedParameters);
        LinkedHashMap<String, String> workflowParameters = (LinkedHashMap<String, String>)SerializationUtils.fromJson((String)resultSet.getString("workflowParameters"), LinkedHashMap.class);
        if (workflowParameters == null) {
            workflowParameters = new LinkedHashMap<String, String>();
        }
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            if (!staticParameter.isEffectiveTypeMaskedOrProtected()) continue;
            String decryptedParameterValue = "";
            try {
                decryptedParameterValue = SchedulerApplication.getInstance().getEncryptor().decrypt((String)workflowParameters.get(parameterName));
            }
            catch (IOException e) {
                model.getStatus().setOrAppendError(this.iu.getFormattedString("Parameter.ReenterParameter", (Object)parameterName));
                LOGGER.error("Cannot decrypt parameter " + parameterName, (Throwable)e);
            }
            workflowParameters.put(parameterName, decryptedParameterValue);
        }
        model.setWorkflowParameters(workflowParameters);
        model.setDatasetCounter(resultSet.getInt("datasetCounter"));
        model.setRequiredMetadataHeaders((Map)SerializationUtils.fromJson((String)resultSet.getString("requiredMetadataHeaders"), Map.class));
        return model;
    }
}

