/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.RuleType;
import com.nuix.automate.utils.models.api.notificationrule.WebhookNotificationRule;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class NotificationRuleMapper
implements RowMapper<NotificationRule> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NotificationRuleMapper.class);

    public NotificationRule map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        try {
            Class<EmailNotificationRule> clazz;
            RuleType ruleType = RuleType.valueOf((String)resultSet.getString("ruleType"));
            switch (ruleType) {
                case EMAIL_SMTP: {
                    clazz = EmailNotificationRule.class;
                    break;
                }
                case WEBHOOK: {
                    clazz = WebhookNotificationRule.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rule type " + String.valueOf(ruleType));
                }
            }
            NotificationRule notificationRule = (NotificationRule)SerializationUtils.fromJson((String)resultSet.getString("rule"), clazz);
            notificationRule.setId(resultSet.getString("id"));
            notificationRule.setRuleType(ruleType);
            return notificationRule;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse notification rule " + resultSet.getString("id"), (Throwable)e);
            return null;
        }
    }
}

