/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class NuixLicenceSourceMapper
implements RowMapper<NuixLicenseSourceModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceSourceMapper.class);

    public NuixLicenseSourceModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        NuixLicenseSourceModel nuixLicenseSource = new NuixLicenseSourceModel();
        nuixLicenseSource.setId(resultSet.getString("id"));
        nuixLicenseSource.setName(resultSet.getString("name"));
        nuixLicenseSource.setDescription(resultSet.getString("description"));
        nuixLicenseSource.setSourceType(SourceType.valueOf((String)resultSet.getString("sourceType")));
        String relayType = resultSet.getString("relayType");
        if (relayType != null) {
            nuixLicenseSource.setRelayType(RelayType.valueOf((String)relayType));
        }
        nuixLicenseSource.setServerName(resultSet.getString("serverName"));
        nuixLicenseSource.setServerPort(Integer.valueOf(resultSet.getInt("serverPort")));
        nuixLicenseSource.setUsername(resultSet.getString("username"));
        String encryptedPassword = resultSet.getString("password");
        try {
            nuixLicenseSource.setPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedPassword));
        }
        catch (IOException e) {
            LOGGER.error("Cannot encrypt Engine Licence Location password", (Throwable)e);
        }
        nuixLicenseSource.setFilter(resultSet.getString("filter"));
        nuixLicenseSource.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)((Set)SerializationUtils.fromJson((String)resultSet.getString("whitelistedCertFingerprints"), Set.class))));
        return nuixLicenseSource;
    }
}

