/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.persistance.application.OfflineUtilizationModel;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FrequentLogUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.utilization.ImportResults;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.NuixCaseStats;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class OfflineUtilizationPersistance {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OfflineUtilizationPersistance.class);
    private SchedulerApplication schedulerApplication;

    public OfflineUtilizationPersistance(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public void handleUtilizationExclusions() {
        this.schedulerApplication.getConfiguration();
        File baseDirectory = SchedulerConfiguration.getOsWindows() ? new File(System.getenv("PROGRAMDATA") + "\\Nuix\\Automate\\Scheduler\\utilizationExclusion") : new File("/etc/nuix/automate/scheduler/utilizationExclusion");
        if (baseDirectory.exists()) {
            LOGGER.info("Scanning for utilization exclusion records in " + String.valueOf(baseDirectory));
            Collection files = org.apache.commons.io.FileUtils.listFiles((File)baseDirectory, (String[])new String[]{"csv"}, (boolean)true);
            boolean mimeTypeVolumesComputed = false;
            HashMap<String, MimeTypeVolume> operationsMimeTypeVolume = new HashMap<String, MimeTypeVolume>();
            HashMap<String, Operation> operationsMap = new HashMap<String, Operation>();
            for (File file : files) {
                int operationsProcessed = 0;
                if (!mimeTypeVolumesComputed) {
                    mimeTypeVolumesComputed = true;
                    List<MimeTypeVolume> originalMimeTypeVolumes = this.schedulerApplication.getUtilizationDaoV2().getMimeTypeVolumes();
                    List<Operation> operations = this.schedulerApplication.getUtilizationDaoV2().getOperations();
                    for (Operation operation : operations) {
                        operationsMap.put(operation.getOperationId(), operation);
                    }
                    for (MimeTypeVolume mimeTypeVolume : originalMimeTypeVolumes) {
                        String operationId = mimeTypeVolume.getOperationId();
                        MimeTypeVolume operationMimeTypeVolume = (MimeTypeVolume)operationsMimeTypeVolume.get(operationId);
                        if (operationMimeTypeVolume == null) {
                            operationMimeTypeVolume = new MimeTypeVolume();
                            operationsMimeTypeVolume.put(operationId, operationMimeTypeVolume);
                        }
                        operationMimeTypeVolume.addAuditedSize(mimeTypeVolume.getAuditedSize());
                        operationMimeTypeVolume.addDigestSize(mimeTypeVolume.getDigestSize());
                        operationMimeTypeVolume.addAuditedCount(mimeTypeVolume.getAuditedCount());
                        operationMimeTypeVolume.addItemsCount(mimeTypeVolume.getItemsCount());
                        operationMimeTypeVolume.addPagesCount(mimeTypeVolume.getPagesCount());
                        operationMimeTypeVolume.addPhysicalCount(mimeTypeVolume.getPhysicalCount());
                        operationMimeTypeVolume.addPhysicalSize(mimeTypeVolume.getPhysicalSize());
                    }
                }
                LOGGER.info("Processing utilization exclusion from " + file.getAbsolutePath());
                try {
                    int i;
                    List utilizationExclusions = FileUtils.loadVariableColumnDetectFormatFile((File)file);
                    Object[] header = (Object[])utilizationExclusions.get(0);
                    int operationIdIndex = -1;
                    for (i = 0; i < header.length; ++i) {
                        Object headerValue = header[i];
                        if (!headerValue.toString().equals("operationId")) continue;
                        operationIdIndex = i;
                        LOGGER.info("Detected operationId column " + i);
                        break;
                    }
                    if (operationIdIndex >= 0) {
                        for (i = 1; i < utilizationExclusions.size(); ++i) {
                            Object[] utilizationExclusion = (Object[])utilizationExclusions.get(i);
                            String operationId = utilizationExclusion[operationIdIndex].toString();
                            LOGGER.info("Removing operation " + operationId);
                            MimeTypeVolume operationMimeTypeVolume = (MimeTypeVolume)operationsMimeTypeVolume.get(operationId);
                            Operation operation = (Operation)operationsMap.get(operationId);
                            if (operationMimeTypeVolume != null && operation != null) {
                                ++operationsProcessed;
                                Session session = this.schedulerApplication.getUtilizationDaoV2().getSession(operation.getSessionId());
                                switch (operation.getOperationType()) {
                                    case OCR: {
                                        LOGGER.info("Decreasing session " + session.getSessionId() + " " + String.valueOf(operation.getOperationType()) + " volume by " + operationMimeTypeVolume.getAuditedSize());
                                        session.setVolumeOcred(session.getVolumeOcred() - operationMimeTypeVolume.getAuditedSize());
                                        break;
                                    }
                                    case LOAD: {
                                        LOGGER.info("Decreasing session " + session.getSessionId() + " " + String.valueOf(operation.getOperationType()) + " volume by " + operationMimeTypeVolume.getAuditedSize());
                                        session.setVolumeLoaded(session.getVolumeLoaded() - operationMimeTypeVolume.getAuditedSize());
                                        break;
                                    }
                                    case LEGAL_EXPORT: 
                                    case OTHER_EXPORT: 
                                    case NATIVE_EXPORT: {
                                        LOGGER.info("Decreasing session " + session.getSessionId() + " EXPORT volume by " + operationMimeTypeVolume.getAuditedSize());
                                        session.setVolumeExported(session.getVolumeExported() - operationMimeTypeVolume.getAuditedSize());
                                        break;
                                    }
                                }
                                this.schedulerApplication.getUtilizationDaoV2().replaceSession(session);
                                this.schedulerApplication.getUtilizationDaoV2().deleteOperation(operationId);
                                this.schedulerApplication.getUtilizationDaoV2().deleteMimeTypeVolumes(operationId);
                                operationsMap.remove(operationId);
                                continue;
                            }
                            LOGGER.warn("Operation does not exist in stats");
                        }
                    } else {
                        LOGGER.warn("Cannot find column operationId");
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Cannot process file", (Throwable)e);
                }
                LOGGER.info("Excluded " + operationsProcessed + " operations");
                file.renameTo(new File(file.getAbsolutePath() + "." + DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + ".disabled"));
            }
        }
    }

    public void loadUtilizationRecords() throws IOException {
        this.schedulerApplication.getConfiguration();
        File baseDirectory = SchedulerConfiguration.getOsWindows() ? new File(System.getenv("PROGRAMDATA") + "\\Nuix\\Automate\\Scheduler\\utilizationRecords") : new File("/etc/nuix/automate/scheduler/utilizationRecords");
        LOGGER.info("Scanning for utilization records in " + String.valueOf(baseDirectory));
        boolean previousWorkers = true;
        if (baseDirectory.exists()) {
            Collection files = org.apache.commons.io.FileUtils.listFiles((File)baseDirectory, (String[])new String[]{"json"}, (boolean)true);
            for (File file : files) {
                LOGGER.info("Processing offline utilization from " + file.getAbsolutePath());
                ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                try {
                    String fileContents = FileUtils.readFileWithAutodetectEncoding((File)file);
                    UtilizationRecords utilizationRecords = (UtilizationRecords)mapper.readValue(fileContents, UtilizationRecords.class);
                    ImportResults result = SchedulerApplication.getInstance().getUtilizationResource().handleUtilizationRecords(utilizationRecords, BuiltInPrincipalIdentifiers.SYSTEM_USER.toString());
                    LOGGER.info("Processed " + result.newRecords + " new records, " + result.getExistingRecords() + " existing records");
                    file.renameTo(new File(file.getAbsolutePath() + "." + DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + ".disabled"));
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot parse file " + String.valueOf(file), (Throwable)e);
                }
            }
        }
    }

    public void loadOfflineUtilization() throws IOException {
        this.schedulerApplication.getConfiguration();
        File baseDirectory = SchedulerConfiguration.getOsWindows() ? new File(System.getenv("PROGRAMDATA") + "\\Nuix\\Automate\\Scheduler\\offlineUtilization") : new File("/etc/nuix/automate/scheduler/offlineUtilization");
        LOGGER.info("Scanning for offline utilization stats in " + String.valueOf(baseDirectory));
        boolean previousWorkers = true;
        if (baseDirectory.exists()) {
            Collection files = org.apache.commons.io.FileUtils.listFiles((File)baseDirectory, (String[])new String[]{"json"}, (boolean)true);
            for (File file : files) {
                LOGGER.info("Processing offline utilization from " + file.getAbsolutePath());
                ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                try {
                    Map sessionOperations;
                    UtilizationDao utilization = this.schedulerApplication.forceGetUtilizationDaoV2();
                    String fileContents = FileUtils.readFileWithAutodetectEncoding((File)file);
                    OfflineUtilizationModel utilizationModel = (OfflineUtilizationModel)mapper.readValue(fileContents, OfflineUtilizationModel.class);
                    HashSet<String> automatedJobIds = new HashSet<String>();
                    LOGGER.info("Importing Jobs");
                    int processCount = 0;
                    Set<String> existingJobIds = utilization.getJobIds();
                    ArrayList<Job> newJobs = new ArrayList<Job>();
                    ArrayList<Job> existingJobs = new ArrayList<Job>();
                    HashSet<Activity> existingActivities = new HashSet<Activity>();
                    existingActivities.addAll(utilization.getActivites());
                    ArrayList<Activity> newActivities = new ArrayList<Activity>();
                    for (Job job : utilizationModel.getJobs()) {
                        FrequentLogUtils.info((String)("Importing job " + processCount + " of " + utilizationModel.getJobs().size()));
                        if (this.schedulerApplication.getConfiguration().getExcludeAutomatedOfflineUtilizationData() && job.getJobName().equals("Automated (Nuix)")) {
                            automatedJobIds.add(job.getJobId());
                        } else if (existingJobIds.contains(job.getJobId())) {
                            existingJobs.add(job);
                        } else {
                            newJobs.add(job);
                            existingJobIds.add(job.getJobId());
                        }
                        if (job.getJobSubmissionEpoch() != null) {
                            ActivityDetails jobSetupActivity = new ActivityDetails();
                            jobSetupActivity.setStartEpoch(job.getJobSubmissionEpoch().longValue());
                            jobSetupActivity.setLastEpoch(job.getJobSubmissionEpoch() + 1L);
                            jobSetupActivity.setMatterId(job.getMatterId());
                            jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
                            jobSetupActivity.setUserId(job.getJobSubmittedByUserId());
                            jobSetupActivity.setActivityKey(job.getJobId());
                            List<Activity> activities = this.schedulerApplication.getUserResource().getActivitiesFromActivityDetails(jobSetupActivity);
                            for (Activity activity : activities) {
                                boolean activityIsNew = existingActivities.add(activity);
                                if (!activityIsNew) continue;
                                newActivities.add(activity);
                            }
                        }
                        ++processCount;
                    }
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Importing " + newJobs.size() + " new Jobs"));
                    utilization.replaceJobs(newJobs);
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Importing " + newActivities.size() + " new Activities"));
                    utilization.replaceActivities(newActivities);
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Updating " + existingJobs.size() + " existing Jobs"));
                    utilization.replaceJobs(existingJobs);
                    if (automatedJobIds.size() > 0) {
                        LOGGER.info("Skipped " + automatedJobIds.size() + " Automate Jobs");
                    }
                    HashMap sessionsOperations = new HashMap();
                    HashMap<String, AtomicLong> sessionOcrVolumes = new HashMap<String, AtomicLong>();
                    processCount = 0;
                    for (Operation operation : utilizationModel.getOperations()) {
                        FrequentLogUtils.info((String)("Processing operation " + processCount + " of " + utilizationModel.getOperations().size()));
                        String sessionId = operation.getSessionId();
                        if (operation.getOperationType().equals((Object)OperationType.OCR) || operation.getOperationName().toLowerCase().contains("ocr")) {
                            AtomicLong previousOcrVolume = (AtomicLong)sessionOcrVolumes.get(sessionId);
                            if (previousOcrVolume == null) {
                                previousOcrVolume = new AtomicLong(0L);
                            }
                            sessionOcrVolumes.put(sessionId, previousOcrVolume);
                            if (operation.getMimeTypeVolumes() != null) {
                                for (MimeTypeVolume mimeTypeVolume : operation.getMimeTypeVolumes()) {
                                    previousOcrVolume.addAndGet(mimeTypeVolume.getAuditedSize());
                                }
                            } else {
                                previousOcrVolume.addAndGet(operation.getAuditedSize());
                            }
                        }
                        if ((sessionOperations = (SortedMap)sessionsOperations.get(sessionId)) == null) {
                            sessionOperations = new TreeMap();
                            sessionsOperations.put(sessionId, sessionOperations);
                        }
                        sessionOperations.put(operation.getOperationExecutionPosition(), operation);
                        ++processCount;
                    }
                    processCount = 0;
                    for (Session session : utilizationModel.getSessions()) {
                        FrequentLogUtils.info((String)("Processing session " + processCount + " of " + utilizationModel.getOperations().size()));
                        if (session.getVolumeOcred() == 0L && sessionOcrVolumes.containsKey(session.getSessionId())) {
                            session.setVolumeOcred(((AtomicLong)sessionOcrVolumes.get(session.getSessionId())).get());
                        }
                        Operation lastOperation = null;
                        sessionOperations = (Map)sessionsOperations.get(session.getSessionId());
                        if (sessionOperations == null) continue;
                        for (Map.Entry entry : sessionOperations.entrySet()) {
                            Operation operation = (Operation)entry.getValue();
                            if (lastOperation != null) {
                                lastOperation.setOperationNextEventEpoch(operation.getOperationStartEpoch());
                            }
                            lastOperation = operation;
                        }
                        if (lastOperation != null) {
                            long operationNextEventEpoch = Math.max(lastOperation.getOperationEndEpoch(), lastOperation.getOperationNextEventEpoch());
                            operationNextEventEpoch = Math.max(operationNextEventEpoch, session.getSessionEndEpoch());
                            lastOperation.setOperationNextEventEpoch(operationNextEventEpoch);
                            session.setSessionEndEpoch(operationNextEventEpoch);
                        }
                        ++processCount;
                    }
                    Set<String> existingSessionIds = utilization.getSessionIds();
                    ArrayList<Session> newSessions = new ArrayList<Session>();
                    ArrayList<Session> existingSessions = new ArrayList<Session>();
                    processCount = 0;
                    HashSet<String> automatedSessionIds = new HashSet<String>();
                    LOGGER.info("Importing Sessions");
                    for (Session session : utilizationModel.getSessions()) {
                        FrequentLogUtils.info((String)("Importing session " + processCount + " of " + utilizationModel.getSessions().size()));
                        if (automatedJobIds.contains(session.getJobId())) {
                            automatedSessionIds.add(session.getSessionId());
                        } else if (existingSessionIds.contains(session.getSessionId())) {
                            existingSessions.add(session);
                        } else {
                            newSessions.add(session);
                            existingSessionIds.add(session.getSessionId());
                        }
                        ++processCount;
                    }
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Importing " + newSessions.size() + " new Sessions"));
                    utilization.replaceSessions(newSessions);
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Updating " + existingSessions.size() + " existing Sessions"));
                    utilization.replaceSessions(existingSessions);
                    if (automatedSessionIds.size() > 0) {
                        LOGGER.info("Skipped " + automatedSessionIds.size() + " Automate Sessions");
                    }
                    Set<String> existingOperationIds = utilization.getOperationIds();
                    HashMap<String, Operation> newOperations = new HashMap<String, Operation>();
                    int existingOperationsCount = 0;
                    Set<String> existingMimeTypesOperations = utilization.getMimeTypeOperationIds();
                    HashMap<CallSite, MimeTypeVolume> newMimeTypeVolumes = new HashMap<CallSite, MimeTypeVolume>();
                    boolean existingMimeTypeVolumes = false;
                    HashSet<String> automatedOperations = new HashSet<String>();
                    for (Operation operation : utilizationModel.getOperations()) {
                        if (automatedSessionIds.contains(operation.getSessionId())) {
                            automatedOperations.add(operation.getOperationId());
                            continue;
                        }
                        if (!existingOperationIds.contains(operation.getOperationId())) {
                            newOperations.put(operation.getOperationId(), operation);
                            if (existingMimeTypesOperations.contains(operation.getOperationId()) || operation.getMimeTypeVolumes() == null) continue;
                            for (MimeTypeVolume mimeTypeVolume : operation.getMimeTypeVolumes()) {
                                newMimeTypeVolumes.put((CallSite)((Object)(operation.getOperationId() + mimeTypeVolume.getMimeTypeId())), mimeTypeVolume);
                            }
                            continue;
                        }
                        ++existingOperationsCount;
                    }
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Importing " + newOperations.size() + " new Operations"));
                    utilization.replaceOperations(newOperations.values());
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Skipped " + existingOperationsCount + " existing Operations"));
                    if (automatedOperations.size() > 0) {
                        LOGGER.info("Skipped " + automatedOperations.size() + " Automate Operations");
                    }
                    FrequentLogUtils.resetLastTimestamp();
                    FrequentLogUtils.info((String)("Importing " + newMimeTypeVolumes.size() + " new MimeType Volumes"));
                    utilization.addMimeTypeVolumes(newMimeTypeVolumes.values());
                    for (NuixCase nuixCase : utilizationModel.getNuixCases()) {
                        utilization.replaceNuixCase(nuixCase);
                    }
                    LOGGER.info("Importing Nuix Case Stats");
                    for (NuixCaseStats nuixCaseStats : utilizationModel.getNuixCasesStats()) {
                        if (nuixCaseStats.getNuixCaseStats() == null) continue;
                        for (NuixCaseStat nuixCaseStat : nuixCaseStats.getNuixCaseStats()) {
                            utilization.replaceNuixCaseStat(nuixCaseStat);
                        }
                    }
                    LOGGER.info("Importing " + utilizationModel.getClients().size() + " Clients");
                    for (Client client : utilizationModel.getClients()) {
                        utilization.replaceClient(client);
                    }
                    LOGGER.info("Importing " + utilizationModel.getUsers().size() + " Users");
                    for (User user : utilizationModel.getUsers()) {
                        utilization.replaceUser(user);
                    }
                    LOGGER.info("Importing " + utilizationModel.getMatters().size() + " Matters");
                    for (Matter matter : utilizationModel.getMatters()) {
                        utilization.replaceMatter(matter);
                    }
                    LOGGER.info("Importing " + utilizationModel.getServers().size() + " Servers");
                    for (Server server : utilizationModel.getServers()) {
                        utilization.replaceServer(server);
                    }
                    LOGGER.info("Importing " + utilizationModel.getEngines().size() + " Engines");
                    for (Engine engine : utilizationModel.getEngines()) {
                        utilization.replaceEngine(engine);
                    }
                    LOGGER.info("Importing " + utilizationModel.getResourcePools().size() + " ResourcePools");
                    for (ResourcePool resourcePool : utilizationModel.getResourcePools()) {
                        utilization.replaceResourcePool(resourcePool);
                    }
                    LOGGER.info("Importing Licenses");
                    if (utilizationModel.getLicense() != null) {
                        utilization.replaceLicense(utilizationModel.getLicense());
                    }
                    LOGGER.info("Importing Organizations");
                    if (utilizationModel.getOrganization() != null) {
                        utilization.replaceOrganization(utilizationModel.getOrganization());
                    }
                    LOGGER.info("Processed " + utilizationModel.getSessions().size() + " sessions");
                    file.renameTo(new File(file.getAbsolutePath() + "." + DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + ".disabled"));
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot parse file " + String.valueOf(file), (Throwable)e);
                }
            }
        }
    }
}

