/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.resourcepool.InstanceIdleAction;
import com.nuix.automate.utils.models.api.resourcepool.Type;
import com.nuix.automate.utils.models.internal.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AzureResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ResourcePoolLegacyMapper
implements RowMapper<ResourcePoolModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolLegacyMapper.class);

    public ResourcePoolModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        ResourcePoolModel resourcePool = new ResourcePoolModel();
        resourcePool.setId(resultSet.getString("id"));
        resourcePool.setName(resultSet.getString("name"));
        resourcePool.setDescription(resultSet.getString("description"));
        resourcePool.setType(Type.valueOf((String)resultSet.getString("type")));
        resourcePool.setActive(Boolean.valueOf(resultSet.getBoolean("active")));
        resourcePool.setReferenceId(resultSet.getString("referenceId"));
        if (resourcePool.getType().equals((Object)Type.AWS) || resourcePool.getType().equals((Object)Type.AZURE)) {
            CloudResourcePoolSettings cloudSettingsModel = new CloudResourcePoolSettings();
            cloudSettingsModel.setNuixLicenceSourceId(resultSet.getString("nuixLicenceSourceId"));
            cloudSettingsModel.setTargetNuixWorkers(Integer.valueOf(resultSet.getInt("targetNuixWorkers")));
            cloudSettingsModel.setUseRemoteEngines(Boolean.valueOf(resultSet.getBoolean("useRemoteEngines")));
            cloudSettingsModel.setRemoteNoIdleDuringJob(Boolean.valueOf(resultSet.getBoolean("remoteNoIdleDuringJob")));
            cloudSettingsModel.setRemoteNoIdleBeforeFirstJob(Boolean.valueOf(resultSet.getBoolean("remoteNoIdleBeforeFirstJob")));
            cloudSettingsModel.setRemoteNuixLicenceSourceId(resultSet.getString("remoteNuixLicenceSourceId"));
            cloudSettingsModel.setRemoteTargetNuixWorkers(Integer.valueOf(resultSet.getInt("remoteTargetNuixWorkers")));
            String minNuixWorkersName = resultSet.getString("minNuixWorkers");
            if (minNuixWorkersName == null || minNuixWorkersName.length() == 0) {
                cloudSettingsModel.setMinNuixWorkers(cloudSettingsModel.getTargetNuixWorkers());
            } else {
                cloudSettingsModel.setMinNuixWorkers(Integer.valueOf(resultSet.getInt("minNuixWorkers")));
            }
            String remoteMinNuixWorkersName = resultSet.getString("remoteMinNuixWorkers");
            if (remoteMinNuixWorkersName == null || remoteMinNuixWorkersName.length() == 0) {
                cloudSettingsModel.setRemoteMinNuixWorkers(cloudSettingsModel.getRemoteTargetNuixWorkers());
            } else {
                cloudSettingsModel.setRemoteMinNuixWorkers(Integer.valueOf(resultSet.getInt("remoteMinNuixWorkers")));
            }
            cloudSettingsModel.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)((Set)SerializationUtils.fromJson((String)resultSet.getString("whitelistedCertFingerprints"), Set.class))));
            resourcePool.setCloudSettings(cloudSettingsModel);
            cloudSettingsModel.setForceIdleActionBetweenJobs(Boolean.valueOf(resultSet.getBoolean("forceIdleActionBetweenJobs")));
            if (resultSet.getString("instanceIdleAction") != null) {
                cloudSettingsModel.setInstanceIdleAction(InstanceIdleAction.valueOf((String)resultSet.getString("instanceIdleAction")));
            }
            if (resourcePool.getType().equals((Object)Type.AWS)) {
                AwsResourcePoolSettings awsSettingsModel = new AwsResourcePoolSettings();
                cloudSettingsModel.setAwsSettings(awsSettingsModel);
                awsSettingsModel.setAccessKey(resultSet.getString("awsAccessKey"));
                try {
                    awsSettingsModel.setSecretKey(SchedulerApplication.getInstance().getEncryptor().decrypt(resultSet.getString("awsSecretKey")));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt AWS Resource Pool Secret", (Throwable)e);
                }
                if (resultSet.getString("awsRegion") != null) {
                    awsSettingsModel.setRegion(resultSet.getString("awsRegion"));
                }
                awsSettingsModel.setInstanceIds((Set)SerializationUtils.fromJson((String)resultSet.getString("awsInstanceIds"), Set.class));
                awsSettingsModel.setTagName(resultSet.getString("awsTagName"));
                awsSettingsModel.setTagValue(resultSet.getString("awsTagValue"));
                awsSettingsModel.setLaunchTemplateId(resultSet.getString("awsLaunchTemplateId"));
                awsSettingsModel.setMaxConcurrentInstances(Integer.valueOf(resultSet.getInt("awsMaxConcurrentInstances")));
                AwsResourcePoolSettings remoteAwsSettingsModel = new AwsResourcePoolSettings();
                cloudSettingsModel.setRemoteAwsSettings(remoteAwsSettingsModel);
                remoteAwsSettingsModel.setInstanceIds((Set)SerializationUtils.fromJson((String)resultSet.getString("remoteAwsInstanceIds"), Set.class));
                remoteAwsSettingsModel.setTagName(resultSet.getString("remoteAwsTagName"));
                remoteAwsSettingsModel.setTagValue(resultSet.getString("remoteAwsTagValue"));
                remoteAwsSettingsModel.setLaunchTemplateId(resultSet.getString("remoteAwsLaunchTemplateId"));
                remoteAwsSettingsModel.setMaxConcurrentInstances(Integer.valueOf(resultSet.getInt("remoteAwsMaxConcurrentInstances")));
                if (resultSet.getString("remoteInstanceIdleAction") != null) {
                    cloudSettingsModel.setRemoteInstanceIdleAction(InstanceIdleAction.valueOf((String)resultSet.getString("remoteInstanceIdleAction")));
                }
            }
            if (resourcePool.getType().equals((Object)Type.AZURE)) {
                AzureResourcePoolSettings azureSettingsModel = new AzureResourcePoolSettings();
                cloudSettingsModel.setAzureSettings(azureSettingsModel);
                azureSettingsModel.setAppId(resultSet.getString("azureAppId"));
                azureSettingsModel.setTenant(resultSet.getString("azureTenant"));
                try {
                    azureSettingsModel.setKey(SchedulerApplication.getInstance().getEncryptor().decrypt(resultSet.getString("azureKey")));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt Azure Resource Pool Key", (Throwable)e);
                }
                azureSettingsModel.setSubscriptionId(resultSet.getString("azureSubscriptionId"));
                azureSettingsModel.setVmNames((Set)SerializationUtils.fromJson((String)resultSet.getString("azureVmNames"), Set.class));
            }
        }
        return resourcePool;
    }
}

