/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.resourcepool.Type;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AzureResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolAdditionalSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ResourcePoolMapper
implements RowMapper<ResourcePoolModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolMapper.class);

    public ResourcePoolModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        ResourcePoolAdditionalSettings additionalSettings;
        ResourcePoolModel resourcePool = new ResourcePoolModel();
        resourcePool.setId(resultSet.getString("id"));
        resourcePool.setName(resultSet.getString("name"));
        resourcePool.setDescription(resultSet.getString("description"));
        resourcePool.setType(Type.valueOf((String)resultSet.getString("type")));
        resourcePool.setActive(Boolean.valueOf(resultSet.getBoolean("active")));
        resourcePool.setReferenceId(resultSet.getString("referenceId"));
        CloudResourcePoolSettings cloudSettingsModel = (CloudResourcePoolSettings)SerializationUtils.fromJson((String)resultSet.getString("cloudSettings"), CloudResourcePoolSettings.class);
        if (cloudSettingsModel != null) {
            AwsResourcePoolSettings awsResourceSettingsModel;
            AzureResourcePoolSettings azureSettingsModel = cloudSettingsModel.getAzureSettings();
            if (azureSettingsModel != null) {
                try {
                    azureSettingsModel.setKey(SchedulerApplication.getInstance().getEncryptor().decrypt(azureSettingsModel.getKey()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt Azure Resource Pool Key", (Throwable)e);
                }
                try {
                    azureSettingsModel.setCustomVmPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(azureSettingsModel.getCustomVmPassword()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt Azure Resource Pool Custom VM Password", (Throwable)e);
                }
            }
            if ((azureSettingsModel = cloudSettingsModel.getRemoteAzureSettings()) != null) {
                try {
                    azureSettingsModel.setCustomVmPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(azureSettingsModel.getCustomVmPassword()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt Azure Resource Pool Custom VM Password", (Throwable)e);
                }
            }
            if ((awsResourceSettingsModel = cloudSettingsModel.getAwsSettings()) != null) {
                try {
                    awsResourceSettingsModel.setSecretKey(SchedulerApplication.getInstance().getEncryptor().decrypt(awsResourceSettingsModel.getSecretKey()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt AWS Resource Pool Secret Key", (Throwable)e);
                }
            }
            resourcePool.setCloudSettings(cloudSettingsModel);
        }
        if ((additionalSettings = (ResourcePoolAdditionalSettings)SerializationUtils.fromJson((String)resultSet.getString("additionalSettings"), ResourcePoolAdditionalSettings.class)) != null) {
            resourcePool.setAutoRegistrationSettings(additionalSettings.getSelfRegistrationSettings());
            resourcePool.setAutoRegistrationEnabled(additionalSettings.getAutoRegistrationEnabled());
            AutoRegistrationSettings autoRegistrationSettings = resourcePool.getAutoRegistrationSettings();
            if (autoRegistrationSettings != null) {
                resourcePool.setAutoRegistrationSettings(autoRegistrationSettings);
                try {
                    autoRegistrationSettings.setAccessKey(SchedulerApplication.getInstance().getEncryptor().decrypt(autoRegistrationSettings.getAccessKey()));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot decrypt Resource Pool self-registration access key", (Throwable)e);
                }
            }
        }
        return resourcePool;
    }
}

