/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.smtp.SmtpServerModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class SmtpServerMapper
implements RowMapper<SmtpServerModel> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SmtpServerMapper.class);

    public SmtpServerModel map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        SmtpServerModel smtpServerModel = (SmtpServerModel)SerializationUtils.fromJson((String)resultSet.getString("smtp"), SmtpServerModel.class);
        smtpServerModel.setId(resultSet.getString("id"));
        if (smtpServerModel.getAuthentication() == Boolean.TRUE) {
            try {
                smtpServerModel.setPassword(SchedulerApplication.getInstance().getEncryptor().decrypt(smtpServerModel.getPassword()));
            }
            catch (IOException e) {
                LOGGER.error("Cannot decrypt LDAP Authentication Service password", (Throwable)e);
                smtpServerModel.setPassword(null);
            }
        }
        return smtpServerModel;
    }
}

