/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.PurviewDownloadUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class ThirdPartyUserCredentialMapper
implements RowMapper<ThirdPartyUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyUserCredentialMapper.class);

    public ThirdPartyUserCredential map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        PurviewUserCredential purviewUserCredential;
        PurviewDownloadUserCredential downloadUserCredential;
        ThirdPartyUserCredential userCredential = (ThirdPartyUserCredential)SerializationUtils.fromJson((String)resultSet.getString("credential"), ThirdPartyUserCredential.class);
        userCredential.setThirdPartyServiceId(resultSet.getString("thirdPartyServiceId"));
        userCredential.setAuthenticationScope(ThirdPartyAuthenticationScope.valueOf((String)resultSet.getString("scope")));
        userCredential.setUserId(resultSet.getString("userId"));
        userCredential.setStale(resultSet.getBoolean("stale"));
        userCredential.setToken(this.decrypt(userCredential.getToken()));
        userCredential.setRefreshToken(this.decrypt(userCredential.getRefreshToken()));
        userCredential.setPassword(this.decrypt(userCredential.getPassword()));
        userCredential.setProperties(this.decrypt(userCredential.getProperties()));
        if (userCredential instanceof PurviewUserCredential && (downloadUserCredential = (purviewUserCredential = (PurviewUserCredential)userCredential).getDownloadUserCredential()) != null) {
            downloadUserCredential.setToken(this.decrypt(downloadUserCredential.getToken()));
            downloadUserCredential.setRefreshToken(this.decrypt(downloadUserCredential.getRefreshToken()));
        }
        return userCredential;
    }

    private String decrypt(String encryptedValue) {
        try {
            if (encryptedValue != null && !encryptedValue.trim().isEmpty()) {
                return SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedValue);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error during decryption", (Throwable)e);
        }
        return null;
    }

    private Map<String, String> decrypt(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (map != null) {
            for (String key : map.keySet()) {
                String value = map.get(key);
                try {
                    result.put(key, SchedulerApplication.getInstance().getEncryptor().decrypt(value));
                }
                catch (IOException e) {
                    LOGGER.error("Error during decryption", (Throwable)e);
                }
            }
            return result;
        }
        return null;
    }
}

