/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.google.gson.JsonObject;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.ManagedUserService;
import com.nuix.automate.utils.models.internal.user.MicrosoftOAuthVersion;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.OidcUserServiceType;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class UserServiceMapper
implements RowMapper<UserService> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserServiceMapper.class);

    public UserService map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        String serviceAccountPassword;
        String encryptedServiceAccountPassword;
        String clientSecret;
        OidcUserServiceType oidcUserServiceType;
        String oidcType;
        UserServiceType type;
        String copyConfig = resultSet.getString("config");
        JsonObject userServiceObject = (JsonObject)SerializationUtils.fromJson((String)copyConfig, JsonObject.class);
        boolean migrated = false;
        if (userServiceObject.has("synchronizeObjects")) {
            boolean synchronizeValue = userServiceObject.get("synchronizeObjects").getAsBoolean();
            userServiceObject.remove("synchronizeObjects");
            userServiceObject.addProperty("synchronizeComputers", Boolean.valueOf(synchronizeValue));
            userServiceObject.addProperty("synchronizeUsers", Boolean.valueOf(synchronizeValue));
            migrated = true;
        }
        String id = resultSet.getString("id");
        String userServiceType = resultSet.getString("userServiceType");
        if (userServiceType.equalsIgnoreCase("PURVIEW")) {
            userServiceType = UserServiceType.MICROSOFT.toString();
            migrated = true;
        }
        if (!((type = UserServiceType.valueOf((String)userServiceType)) != UserServiceType.OIDC && type != UserServiceType.MICROSOFT || !userServiceObject.has("oidcUserServiceType") || (oidcType = userServiceObject.get("oidcUserServiceType").getAsString()) == null || (oidcUserServiceType = OidcUserServiceType.valueOf((String)oidcType)) != OidcUserServiceType.MICROSOFT && oidcUserServiceType != OidcUserServiceType.MICROSOFT_V2)) {
            if (oidcUserServiceType == OidcUserServiceType.MICROSOFT) {
                userServiceObject.addProperty("oAuthVersion", MicrosoftOAuthVersion.V1.toString());
            } else {
                userServiceObject.addProperty("oAuthVersion", MicrosoftOAuthVersion.V2.toString());
            }
            type = UserServiceType.MICROSOFT;
            migrated = true;
        }
        if (migrated) {
            copyConfig = userServiceObject.toString();
        }
        Class userServiceClass = null;
        switch (type) {
            case LDAP: {
                userServiceClass = LdapUserService.class;
                break;
            }
            case UMS: {
                userServiceClass = UmsUserService.class;
                break;
            }
            case OIDC: {
                userServiceClass = OidcUserService.class;
                break;
            }
            case MANAGED: {
                userServiceClass = ManagedUserService.class;
                break;
            }
            case MICROSOFT: {
                userServiceClass = MicrosoftUserService.class;
                break;
            }
            case RELATIVITY_IMPERSONATION: {
                userServiceClass = RelativityUserImpersonationService.class;
            }
        }
        UserService userService = (UserService)SerializationUtils.fromJson((String)copyConfig, userServiceClass);
        userService.setId(id);
        userService.setUserServiceType(type);
        userService.setDefaults();
        if (userService instanceof OidcUserService) {
            OidcUserService oidcUserService = (OidcUserService)userService;
            String encryptedClientSecret = oidcUserService.getClientSecret();
            clientSecret = null;
            if (encryptedClientSecret != null && !encryptedClientSecret.trim().equals("")) {
                try {
                    clientSecret = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedClientSecret);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt OIDC Authentication Service client secret for: " + userService.getName(), (Throwable)e);
                }
            }
            oidcUserService.setClientSecret(clientSecret);
        }
        if (userService instanceof RelativityUserImpersonationService) {
            RelativityUserImpersonationService relativityUserImpersonationService = (RelativityUserImpersonationService)userService;
            String encryptedSecret = relativityUserImpersonationService.getSecret();
            clientSecret = null;
            if (encryptedSecret != null && !encryptedSecret.trim().equals("")) {
                try {
                    clientSecret = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedSecret);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt secret for: " + userService.getName(), (Throwable)e);
                }
            }
            relativityUserImpersonationService.setSecret(clientSecret);
        }
        if (userService instanceof MicrosoftUserService) {
            MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
            String encryptedRefreshToken = microsoftUserService.getRefreshToken();
            String refreshToken = null;
            if (encryptedRefreshToken != null && !encryptedRefreshToken.trim().equals("")) {
                try {
                    refreshToken = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedRefreshToken);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt Microsoft Authentication Service client secret for: " + userService.getName(), (Throwable)e);
                }
            }
            microsoftUserService.setRefreshToken(refreshToken);
        }
        if (userService instanceof UmsUserService) {
            UmsUserService umsUserService = (UmsUserService)userService;
            encryptedServiceAccountPassword = umsUserService.getServiceAccountPassword();
            serviceAccountPassword = null;
            if (encryptedServiceAccountPassword != null && !encryptedServiceAccountPassword.trim().equals("")) {
                try {
                    serviceAccountPassword = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedServiceAccountPassword);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt Authentication Service serviceAccountPassword for: " + userService.getName(), (Throwable)e);
                }
            }
            umsUserService.setServiceAccountPassword(serviceAccountPassword);
        }
        if (userService instanceof LdapUserService) {
            LdapUserService ldapUserService = (LdapUserService)userService;
            encryptedServiceAccountPassword = ldapUserService.getServiceAccountPassword();
            serviceAccountPassword = null;
            if (encryptedServiceAccountPassword != null && !encryptedServiceAccountPassword.trim().equals("")) {
                try {
                    serviceAccountPassword = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedServiceAccountPassword);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to decrypt Authentication Service serviceAccountPassword for: " + userService.getName(), (Throwable)e);
                }
            }
            ldapUserService.setServiceAccountPassword(serviceAccountPassword);
        }
        return userService;
    }
}

