/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.userservice.GoogleChatSpace;
import com.nuix.automate.utils.models.api.userservice.GoogleDrive;
import com.nuix.automate.utils.models.api.userservice.GoogleGroup;
import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.api.userservice.LdapComputer;
import com.nuix.automate.utils.models.api.userservice.MicrosoftSharePointSite;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUnifiedGroup;
import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class UserServiceObjectMapper
implements RowMapper<UserServiceObject> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserServiceObjectMapper.class);

    public UserServiceObject map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        UserServiceObject userServiceObject;
        UserServiceObjectType objectType = UserServiceObjectType.valueOf((String)resultSet.getString("serviceType"));
        String objectJson = resultSet.getString("object");
        switch (objectType) {
            case SHARE_POINT_SITE: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, MicrosoftSharePointSite.class);
                break;
            }
            case UNIFIED_GROUP: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, MicrosoftUnifiedGroup.class);
                break;
            }
            case COMPUTER: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, LdapComputer.class);
                break;
            }
            case GOOGLE_GROUP: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, GoogleGroup.class);
                break;
            }
            case GOOGLE_ORG_UNIT: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, GoogleOrgUnit.class);
                break;
            }
            case GOOGLE_SHARED_DRIVE: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, GoogleDrive.class);
                break;
            }
            case GOOGLE_CHAT_SPACE: {
                userServiceObject = (UserServiceObject)SerializationUtils.fromJson((String)objectJson, GoogleChatSpace.class);
                break;
            }
            default: {
                LOGGER.error("Invalid userServiceObject type: " + String.valueOf(objectType));
                return null;
            }
        }
        userServiceObject.setId(resultSet.getString("id"));
        userServiceObject.setUserServiceId(resultSet.getString("userServiceId"));
        return userServiceObject;
    }
}

