/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.application;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class WebhookRegistrationMapper
implements RowMapper<Webhook> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WebhookRegistrationMapper.class);

    public Webhook map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        Webhook webhook = new Webhook();
        try {
            String webhookJson = resultSet.getString("data");
            webhookJson = webhookJson.replace("\"PROCESSING_JOB", "\"JOB");
            webhookJson = webhookJson.replace("\"PROCESSING_SCHEDULE", "\"SCHEDULE");
            webhookJson = webhookJson.replace("\"COLLECTION_JOB", "\"COLLECTION");
            webhookJson = webhookJson.replace("\"JOB_ADDED\"", "\"JOB_SUBMITTED\"");
            webhook = (Webhook)SerializationUtils.fromJson((String)webhookJson, Webhook.class);
        }
        catch (Exception e) {
            webhook.setName("ERROR");
            webhook.setActive(Boolean.valueOf(false));
            webhook.setCallbackAddress("");
            webhook.setHistoryEnabled(Boolean.valueOf(false));
            webhook.setTriggers(new TreeSet());
            webhook.setWhitelistedCertFingerprints(new TreeSet());
            LOGGER.error("Cannot deserialize webhook " + resultSet.getString("id"), (Throwable)e);
        }
        webhook.setId(resultSet.getString("id"));
        String encryptedSecret = webhook.getSignatureKey();
        String secret = "";
        try {
            secret = SchedulerApplication.getInstance().getEncryptor().decrypt(encryptedSecret);
        }
        catch (IOException e) {
            LOGGER.error("Cannot decrypt WebHook signature key", (Throwable)e);
        }
        webhook.setSignatureKey(secret);
        return webhook;
    }
}

