/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.persistance.logging;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.persistance.logging.LoggingDataSourceDetails;
import com.nuix.automate.scheduler.resources.LogsResource;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedPooledDataSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class RolloverLoggingHelper {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RolloverLoggingHelper.class);
    private LogsResource logsResource;
    private LoggingDao activeLoggingDao;
    private List<LoggingDataSourceDetails> managedDataSources;
    private ManagedPooledDataSource managedLoggingStore;
    private SchedulerApplication schedulerApplication;
    private final int maxActiveDatabases;

    public RolloverLoggingHelper(SchedulerApplication schedulerApplication, LogsResource logsResource, LoggingDataSourceDetails details) {
        this.schedulerApplication = schedulerApplication;
        this.managedLoggingStore = details.getDataSource();
        this.activeLoggingDao = details.getLoggingDao();
        this.logsResource = logsResource;
        this.managedDataSources = new ArrayList<LoggingDataSourceDetails>();
        this.maxActiveDatabases = schedulerApplication.getConfiguration().getMaxRollingLoggingDatabases();
        this.managedDataSources.add(details);
    }

    public LoggingDao getActiveLoggingDao() {
        return this.activeLoggingDao;
    }

    public void setActiveLoggingDao(LoggingDao activeLoggingDao) {
        this.activeLoggingDao = activeLoggingDao;
    }

    public List<LoggingDao> getLoggingDaos() {
        ArrayList<LoggingDao> loggingDaos = new ArrayList<LoggingDao>();
        for (LoggingDataSourceDetails loggingDataSource : this.managedDataSources) {
            loggingDaos.add(loggingDataSource.getLoggingDao());
        }
        return loggingDaos;
    }

    public boolean isDatabaseRollable() {
        DataSourceFactory loggingDsf = this.schedulerApplication.getConfiguration().getEffectiveLoggingStore();
        if (loggingDsf != null && loggingDsf.getDriverClass() != null && loggingDsf.getDriverClass().toLowerCase().contains("sqlite")) {
            return this.schedulerApplication.getConfiguration().isEnableRollingLoggingDatabases() && this.schedulerApplication.getConfiguration().getMaxRollingLoggingDatabases() > 1;
        }
        return false;
    }

    private Set<String> getExistingDatabaseNames() throws IOException {
        HashSet<String> existingNames = new HashSet<String>();
        DataSourceFactory loggingDsf = this.schedulerApplication.getConfiguration().getEffectiveLoggingStore();
        String driverUrl = loggingDsf.getUrl();
        if (driverUrl != null) {
            driverUrl = driverUrl.replace("jdbc:sqlite:", "");
            Path loggingDatabasePath = Paths.get(driverUrl, new String[0]);
            Path loggingDatabaseParentPath = loggingDatabasePath.getParent();
            String originalFileName = FileUtils.getFileNameWithoutExtension((String)loggingDatabasePath.getFileName().toString());
            existingNames.add(originalFileName);
            try (Stream<Path> databases = Files.list(loggingDatabaseParentPath);){
                for (Path path : databases.collect(Collectors.toList())) {
                    String databaseName = FileUtils.getFileNameWithoutExtension((String)path.getFileName().toString());
                    if (!databaseName.startsWith(originalFileName)) continue;
                    existingNames.add(databaseName);
                }
            }
        }
        return existingNames;
    }

    private LoggingDataSourceDetails getOldestDatabase() {
        LoggingDataSourceDetails oldestDatabase = null;
        Long earliestLog = Long.MAX_VALUE;
        for (LoggingDataSourceDetails loggingDataSource : this.managedDataSources) {
            try {
                Long earliestLogTemp = loggingDataSource.getLoggingDao().getEarliestLogs();
                if (earliestLogTemp == null || earliestLogTemp >= earliestLog) continue;
                earliestLog = earliestLogTemp;
                oldestDatabase = loggingDataSource;
            }
            catch (Exception exception) {}
        }
        return oldestDatabase;
    }

    public void loadExistingDatabases() {
        block16: {
            try {
                DataSourceFactory loggingDsf = this.schedulerApplication.getConfiguration().getEffectiveLoggingStore();
                String driverUrl = loggingDsf.getUrl();
                if (driverUrl == null) break block16;
                driverUrl = driverUrl.replace("jdbc:sqlite:", "");
                Path loggingDatabasePath = Paths.get(driverUrl, new String[0]);
                Path loggingDatabaseParentPath = loggingDatabasePath.getParent();
                try (Stream<Path> databases = Files.list(loggingDatabaseParentPath);){
                    for (Path path : databases.collect(Collectors.toList())) {
                        String connectionString = "jdbc:sqlite:" + path.toFile().getAbsolutePath();
                        try {
                            Handle handle = Jdbi.open((String)connectionString);
                            try {
                                Long tableExists = (Long)handle.createQuery("SELECT count(*) FROM sqlite_master WHERE type='table' AND name='logs'").mapTo(Long.class).one();
                                if (tableExists == null || tableExists == 0L || Files.isSameFile(loggingDatabasePath, path)) continue;
                                DataSourceFactory rolloverDsf = new DataSourceFactory();
                                rolloverDsf.setDriverClass("org.sqlite.JDBC");
                                rolloverDsf.setUrl(connectionString);
                                rolloverDsf.setUser("automate-scheduler");
                                rolloverDsf.asSingleConnectionPool();
                                LoggingDataSourceDetails details = this.schedulerApplication.getDaoManager().initializeLoggingDao(rolloverDsf, "logging_" + this.getUniqueId(), false);
                                this.managedDataSources.add(details);
                                LOGGER.info("Initialized rollover logging database " + path.toFile().getAbsolutePath());
                            }
                            finally {
                                if (handle == null) continue;
                                handle.close();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot query database, " + path.toFile().getAbsolutePath());
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("Unable to load rollover logging databases", e);
            }
        }
    }

    private String getUniqueId() {
        return UUID.randomUUID().toString().split("-")[0];
    }

    private String getUniqueName(String loggingDatabaseName, Set<String> existingNames) {
        Object result = loggingDatabaseName;
        if (existingNames.contains(loggingDatabaseName)) {
            int i = 2;
            if (((String)result).matches(".*\\([0-9]+\\)$")) {
                int leftParenthesisIndex = ((String)result).lastIndexOf("_");
                i = Integer.parseInt(((String)result).substring(leftParenthesisIndex + 2, ((String)result).length() - 1)) + 1;
                result = ((String)result).substring(0, leftParenthesisIndex);
            }
            while (existingNames.contains((String)result + "_" + i)) {
                ++i;
            }
            result = (String)result + "_" + i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollActiveLoggingDao() throws IOException {
        Set<String> existingNames = this.getExistingDatabaseNames();
        if (existingNames.isEmpty()) {
            return;
        }
        if (existingNames.size() >= this.maxActiveDatabases) {
            try {
                LoggingDataSourceDetails details = this.getOldestDatabase();
                String databasePath = details.getDataSource().getUrl().replace("jdbc:sqlite:", "");
                details.getDataSource().stop();
                LOGGER.info("Deleting oldest database " + databasePath);
                Files.deleteIfExists(Paths.get(databasePath, new String[0]));
                this.managedDataSources.remove(details);
            }
            catch (Exception e) {
                LOGGER.error("Unable to delete old database", (Throwable)e);
                return;
            }
        }
        try {
            this.logsResource.stopWriter();
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LoggingDao loggingDao = this.activeLoggingDao;
        synchronized (loggingDao) {
            DataSourceFactory loggingStore = this.schedulerApplication.getConfiguration().getEffectiveLoggingStore();
            String driverUrl = loggingStore.getUrl();
            if (driverUrl != null) {
                driverUrl = driverUrl.replace("jdbc:sqlite:", "");
                Path loggingDatabasePath = Paths.get(driverUrl, new String[0]);
                Path loggingDatabaseParentPath = loggingDatabasePath.getParent();
                String originalFileName = FileUtils.getFileNameWithoutExtension((String)loggingDatabasePath.getFileName().toString());
                String updatedFileName = this.getUniqueName(originalFileName, existingNames) + ".db";
                Path rolloverDatabase = loggingDatabaseParentPath.resolve(updatedFileName);
                try {
                    this.activeLoggingDao.checkLogsTable();
                    this.managedLoggingStore.stop();
                    Files.move(loggingDatabasePath, rolloverDatabase, StandardCopyOption.REPLACE_EXISTING);
                    this.managedLoggingStore.setUrl("jdbc:sqlite:" + rolloverDatabase.toAbsolutePath().toString());
                    this.managedLoggingStore.start();
                    LoggingDataSourceDetails details = this.schedulerApplication.getDaoManager().initializeLoggingDao(loggingStore, "loggingStore_" + this.getUniqueId(), true);
                    this.managedLoggingStore = details.getDataSource();
                    this.activeLoggingDao = details.getLoggingDao();
                    this.managedDataSources.add(details);
                }
                catch (Throwable e) {
                    LOGGER.error("Unable to stop managed data source", e);
                }
                this.logsResource.resetWriter();
            }
        }
    }
}

