/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.oidc.generic.OidcJwtUser;
import com.nuix.automate.utils.api.configuration.SystemConfiguration;
import com.nuix.automate.utils.general.JavaUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.executionprofile.WorkerTempFolder;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.annotation.security.PermitAll;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@PermitAll
@Path(value="v1/configuration")
@Produces(value={"application/json"})
public class ConfigurationResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigurationResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public ConfigurationResource(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
    }

    @SecurityRequirement(name="Bearer_Token")
    @Operation(summary="Get System Configuration", tags={"Settings"}, operationId="GetSystemConfiguration", description="Returns the system configuration", responses={@ApiResponse(description="The configuration", content={@Content(schema=@Schema(implementation=SystemConfiguration.class))})})
    @GET
    @Consumes(value={"application/json"})
    public Response getConfiguration(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        if (user instanceof OidcJwtUser) {
            systemConfiguration.setUserSessionTimeout(31536000L);
            systemConfiguration.setAuthTokenTtl(31536000L);
            systemConfiguration.setDisableAuthTokenExpiration(true);
        } else {
            systemConfiguration.setUserSessionTimeout(this.schedulerConfiguration.getUserSessionTimeout());
            systemConfiguration.setAuthTokenTtl(this.schedulerConfiguration.getAuthTokenTtl());
            systemConfiguration.setDisableAuthTokenExpiration(this.schedulerConfiguration.getDisableAuthTokenExpiration());
        }
        systemConfiguration.setLibraryFileMaxSize(this.schedulerConfiguration.getLibraryFileMaxSize());
        systemConfiguration.setEnableUserInterfaceDebugMode(this.schedulerConfiguration.getEnableUserInterfaceDebugMode());
        if (this.schedulerConfiguration.getEnableCentralizedLogging()) {
            systemConfiguration.setLogRetentionPeriod(this.schedulerConfiguration.getCentralizedLoggingRetention());
            systemConfiguration.setEarliestLogDate(this.schedulerApplication.getLoggingResource().getEarliestLog().longValue());
        }
        systemConfiguration.setJavaVersion(JavaUtils.getVersion());
        systemConfiguration.setJavaVendor(System.getProperty("java.vendor"));
        systemConfiguration.setJavaVersionBelowRecommended(JavaUtils.isVersionBelowRecommended());
        systemConfiguration.setUsername(user.getName());
        systemConfiguration.setIdentifiers(user.getIdentifiers());
        if (SchedulerConfiguration.getOsWindows()) {
            systemConfiguration.setDefaultWorkerTempFolder(WorkerTempFolder.WINDOWS.getPath());
        } else {
            systemConfiguration.setDefaultWorkerTempFolder(WorkerTempFolder.OTHER.getPath());
        }
        String lastHash = ResponseCache.getInstance().hashObject((Object)systemConfiguration);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)systemConfiguration).build();
        }
    }
}

