/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.engine.Command;
import com.nuix.automate.utils.models.api.engine.Engine;
import com.nuix.automate.utils.models.api.engine.EngineCommand;
import com.nuix.automate.utils.models.api.engine.EngineSubmission;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.server.ServerStatus;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/scheduler/resources/engines")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EnginesResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EnginesResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;
    private static InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public EnginesResource(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
    }

    public EngineModel getEngineFromId(String engineId) {
        Map<String, ServerWorker> serverWorkers;
        if (engineId == null) {
            return null;
        }
        if (this.schedulerApplication.getServerResource() != null && (serverWorkers = this.schedulerApplication.getServerResource().getServerWorkers()) != null) {
            for (ServerWorker serverWorker : serverWorkers.values()) {
                Collection<EngineModel> engineModels = serverWorker.getEngineModels();
                if (engineModels == null) continue;
                for (EngineModel engineModel : engineModels) {
                    if (!engineId.equals(engineModel.getId())) continue;
                    return engineModel;
                }
            }
        }
        return null;
    }

    public Collection<EngineModel> getEnginesFromServerId(String serverId) {
        ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(serverId);
        Collection<EngineModel> engineModels = serverWorker.getEngineModels();
        return engineModels;
    }

    public Set<EngineModel> getEngines() {
        HashSet<EngineModel> engines = new HashSet<EngineModel>();
        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
            engines.addAll(serverWorker.getEngineModels());
        }
        return engines;
    }

    @Operation(tags={"Resources"}, operationId="GetEngines", summary="Get Engines", description="Get full information of all registered engines", responses={@ApiResponse(description="The list of engines", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Engine.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response listEngines(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list engines");
        }
        Map<String, ServerWorker> serverWorkers = this.schedulerApplication.getServerResource().getServerWorkers();
        ArrayList<Engine> allowedEngines = new ArrayList<Engine>();
        for (ServerWorker serverWorker : serverWorkers.values()) {
            Collection<EngineModel> engineModels = serverWorker.getEngineModels();
            if (engineModels == null) continue;
            for (EngineModel engineModel : engineModels) {
                Engine result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, engineModel);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedEngines.add(result);
            }
        }
        try {
            SortingUtils.sortList(allowedEngines, Engine::getName);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot sort engines", (Throwable)e);
        }
        String lastHash = ResponseCache.getInstance().hashObject(allowedEngines);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedEngines).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddEngine", summary="Add Engine", description="Add a new engine", responses={@ApiResponse(description="The engine that was added", content={@Content(schema=@Schema(implementation=Engine.class))}), @ApiResponse(responseCode="400", description="Invalid engine name, or invalid server name")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response schedulerAddEngine(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The engine to add", schema=@Schema(implementation=EngineSubmission.class)) EngineModel engine) {
        ServerWorker serverWorker;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to add a new engine with name " + engine.getName());
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)engine);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)engine);
        if (!(user instanceof SystemBearerUser)) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put(TagsUtil.ELIGIBLE_FOR_LOCAL_POOL, "true");
            if (engine.getTags() == null) {
                engine.setTags(new HashMap());
            }
            engine.getTags().putAll(tags);
        }
        if (engine.getName() == null || engine.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidEngineName", (Map)null);
        }
        if (engine.getSupportedExecutionMode().equals((Object)ExecutionMode.AUTOMATE_NATIVE)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.AUTOMATE_NATIVE_WORKFLOWS);
            engine.setNuixLicenceSourceId(null);
            engine.setTargetNuixWorkers(null);
            engine.setMinNuixWorkers(null);
        }
        if ((serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(engine.getServerId())) != null) {
            Server server = serverWorker.getModel();
            if (!(user instanceof SystemBearerUser) && server != null && server.getTags() != null && server.getTags().get(TagsUtil.CLOUD_INSTANCE_ID) != null) {
                return ExceptionUtils.toResponse((String)"cannotAddEngineToCloudServer", (Map)null);
            }
            if (!serverWorker.getModel().getStatus().equals((Object)ServerStatus.INITIALIZED)) {
                return ExceptionUtils.toResponse((String)"cannotAddEngineToServer", (Map)new HashMap<String, String>(){
                    {
                        this.put("serverWorker", String.valueOf(serverWorker.getModel().getStatus()));
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            EngineModel addedEngine = null;
            try {
                engine.setId(null);
                addedEngine = serverWorker.addEngine(engine);
                Engine eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, addedEngine);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_ADDED, eventResult, user.getName());
                Engine result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, addedEngine);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
            }
            catch (ServerException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)e.getMessage()).build();
            }
        }
        return ExceptionUtils.toResponse((String)"cannotFindServer", (Map)new HashMap<String, String>(){
            {
                this.put("engine", engine.getServerId());
            }
        }, (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Resources"}, operationId="DeleteEngine", summary="Delete Engine", description="Removes the engine with the specified ID", responses={@ApiResponse(description="The removal status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Invalid engine name, or invalid server name, or engine is running a job")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{engineId}")
    @DELETE
    public Response schedulerRemoveEngine(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the engine to remove") @PathParam(value="engineId") String engineId) {
        ServerWorker serverWorker;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to delete engine " + engineId);
        EngineModel engineModel = this.getEngineFromId(engineId);
        if (engineModel == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("engineIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            })).build();
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)engineId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (engineModel != null && (serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(engineModel.getServerId())) != null) {
            try {
                String response = serverWorker.deleteEngine(engineId);
                Engine eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, engineModel);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_DELETED, eventResult, user.getName());
                this.schedulerApplication.getResourcePoolResource().removeEnginePoolIds(engineId);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
            }
            catch (ServerException e) {
                return e.getResponse();
            }
        }
        return ExceptionUtils.toResponse((String)"invalidEngineId", (Map)new HashMap<String, String>(){
            {
                this.put("engineId", engineId);
            }
        }, (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Resources"}, operationId="UpdateEngine", summary="Update Engine", description="Update the engine with the specified ID", responses={@ApiResponse(description="The updated engine", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="Engine name is missing, or an engine with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{engineId}")
    @PUT
    public Response updateEngine(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the engine to update") @PathParam(value="engineId") String engineId, @Parameter(description="The information to update the engine with", schema=@Schema(implementation=EngineSubmission.class)) EngineModel engineModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        final EngineModel originalEngineModel = this.getEngineFromId(engineId);
        if (originalEngineModel == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("engineIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("engineId", engineId);
                }
            })).build();
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)engineModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)engineModel);
        ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(originalEngineModel.getServerId());
        if (serverWorker != null) {
            EngineModel updatedEngineModel = null;
            try {
                updatedEngineModel = serverWorker.updateEngine(originalEngineModel.getId(), engineModel);
                Engine eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedEngineModel);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_MODIFIED, eventResult, user.getName());
                serverWorker.reloadEnginesFromServer();
                Engine result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedEngineModel);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
            }
            catch (ServerException e) {
                return Response.status((int)e.getResponse().getStatus()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)e.getMessage()).build();
            }
        }
        return ExceptionUtils.toResponse((String)"cannotFindServerModel", (Map)new HashMap<String, String>(){
            {
                this.put("originalEngineModel", originalEngineModel.getServerId());
            }
        }, (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Resources"}, operationId="SendEngineCommand", summary="Send Engine Command", description="Send a command to the engine, for example to stop the execution of the current job", responses={@ApiResponse(description="The engine to which the command was sent", content={@Content(schema=@Schema(implementation=Engine.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{engineId}/command")
    @Consumes(value={"application/json"})
    @PUT
    public Response schedulerSendEngineCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the engine which should execute the command") @PathParam(value="engineId") String engineId, final @Parameter(description="The command to execute") EngineCommand engineCommand) {
        boolean askedToAbortDisconnectedJob;
        block8: {
            ServerWorker serverWorker;
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
            EngineModel engineModel = this.getEngineFromId(engineId);
            JobDetailsModel jobDetailsModel = this.schedulerApplication.getJobResource().getJobDetailsModel(engineCommand.getJobId());
            if (jobDetailsModel == null) {
                return ExceptionUtils.toResponse((String)"cannotFindJobSpecifiedId", (Map)null);
            }
            JobModel jobModel = jobDetailsModel.getSettings();
            JobModel result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobModel);
            if (!result.getUserPermissions().contains(Permission.MODIFY)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)engineId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            askedToAbortDisconnectedJob = false;
            if (jobModel != null && jobModel.getExecutionState() == ExecutionState.DISCONNECTED && engineCommand.getCommand() == Command.ABORT) {
                this.schedulerApplication.getJobResource().removeUnrespossiveJob(engineCommand.getJobId());
                askedToAbortDisconnectedJob = true;
            }
            if (engineModel != null && (serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(engineModel.getServerId())) != null) {
                try {
                    EngineModel responseEngineModel = serverWorker.sendEngineCommand(engineId, engineCommand);
                    Engine response = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, responseEngineModel);
                    if (!askedToAbortDisconnectedJob) {
                        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
                    }
                }
                catch (ServerException e) {
                    if (askedToAbortDisconnectedJob) break block8;
                    return e.getResponse();
                }
            }
        }
        if (askedToAbortDisconnectedJob) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return ExceptionUtils.toResponse((String)"cannotSendCommandEngineJob", (Map)new HashMap<String, String>(){
            {
                this.put("engineCommandModel", String.valueOf(engineCommand.getCommand()));
            }
        });
    }
}

