/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.application.ApplicationDao;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.utils.DatasetUtils;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.scheduler.utils.WorkflowSerializationUtils;
import com.nuix.automate.scheduler.utils.allowedvalues.AllowedValueUtils;
import com.nuix.automate.scheduler.workers.ArchivedJobWorker;
import com.nuix.automate.scheduler.workers.JobWorker;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.CollectionUtils;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.general.MimeTypeStat;
import com.nuix.automate.utils.general.OperationMimeTypeStats;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.comment.UserComment;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.api.engine.Command;
import com.nuix.automate.utils.models.api.engine.EngineCommand;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.JobArchiveFilter;
import com.nuix.automate.utils.models.api.job.JobCommand;
import com.nuix.automate.utils.models.api.job.JobDetails;
import com.nuix.automate.utils.models.api.job.JobErrors;
import com.nuix.automate.utils.models.api.job.JobExecutionLog;
import com.nuix.automate.utils.models.api.job.JobExecutionLogUpdate;
import com.nuix.automate.utils.models.api.job.JobFilter;
import com.nuix.automate.utils.models.api.job.JobId;
import com.nuix.automate.utils.models.api.job.JobInfos;
import com.nuix.automate.utils.models.api.job.JobOperationId;
import com.nuix.automate.utils.models.api.job.JobOperationMimeTypeStats;
import com.nuix.automate.utils.models.api.job.JobRequiredProfile;
import com.nuix.automate.utils.models.api.job.JobSoftErrors;
import com.nuix.automate.utils.models.api.job.JobSubmission;
import com.nuix.automate.utils.models.api.job.JobUpdate;
import com.nuix.automate.utils.models.api.job.JobWarnings;
import com.nuix.automate.utils.models.api.job.JobsCommand;
import com.nuix.automate.utils.models.api.job.MimeTypeStatsTable;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.job.ParameterUpdate;
import com.nuix.automate.utils.models.api.job.ParameterUpdateSubmission;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.securitypolicy.SymmetricKey;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyDetails;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobDetailsCacheModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobEvent;
import com.nuix.automate.utils.models.internal.job.JobFilePayload;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.job.JobQueueSortSettings;
import com.nuix.automate.utils.models.internal.job.JobQueueState;
import com.nuix.automate.utils.models.internal.job.JobState;
import com.nuix.automate.utils.models.internal.job.JobWorkflowModel;
import com.nuix.automate.utils.models.internal.logging.RunningLogEventsModel;
import com.nuix.automate.utils.models.internal.logging.history.HistoryComponentType;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.JobStart;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.Priority;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.DisplayCondition;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.MetadataAssignMode;
import com.nuix.automate.utils.workflow.ParameterSource;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.SourceParameter;
import com.nuix.automate.utils.workflow.SourceParameterSourceType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowRenderer;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.DisplayConditionUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@javax.ws.rs.Path(value="/v1/scheduler/jobs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JobResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    public static final String JOB_QUEUE_SORT_SETTINGS_CATEGORY_NAME = "JOB_QUEUE_SORT";
    private final SchedulerApplication schedulerApplication;
    private final Map<String, JobDetailsModel> backlogJobsDetails;
    private final Map<String, JobDetailsModel> finishedJobsDetails;
    private final Map<String, JobDetailsCacheModel> runningJobsCachedDetails;
    private final Map<String, Long> lastJobDaoUpdatesMs;
    private final Map<String, JobFilter> sessionsFilter;
    private final Map<String, RunningLogEventsModel> jobRunningLogs;

    public long getBacklogJobsForResourcePoolCount(String resourcePoolId) {
        long count = 0L;
        for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
            String jobResourcePoolId = jobDetailsModel.getSettings().getResourcePoolId();
            if (!jobResourcePoolId.equals(resourcePoolId)) continue;
            ++count;
        }
        return count;
    }

    public long getRunningJobsForResourcePoolCount(String resourcePoolId) {
        long count = 0L;
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            String jobResourcePoolId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getResourcePoolId();
            if (!resourcePoolId.equals(jobResourcePoolId)) continue;
            ++count;
        }
        return count;
    }

    public long getBacklogJobsFromSchedule(String scheduleId) {
        long count = 0L;
        for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
            if (jobDetailsModel.getSettings().getScheduleId() == null || !jobDetailsModel.getSettings().getScheduleId().equals(scheduleId)) continue;
            ++count;
        }
        return count;
    }

    public long getStagingJobsFromSchedule(String scheduleId) {
        long count = 0L;
        for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
            if (jobDetailsModel.getSettings().getScheduleId() == null || !jobDetailsModel.getSettings().getScheduleId().equals(scheduleId) || !jobDetailsModel.getSettings().getInStaging()) continue;
            ++count;
        }
        return count;
    }

    public long getRunningJobsFromSchedule(String scheduleId) {
        long count = 0L;
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getScheduleId() == null || !jobDetailsCacheModel.getJobDetailsModel().getSettings().getScheduleId().equals(scheduleId)) continue;
            ++count;
        }
        return count;
    }

    public void removeUnrespossiveJob(String jobId) {
        JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(jobId);
        if (jobDetailsCacheModel != null && jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState() == ExecutionState.DISCONNECTED) {
            this.handleJobEngineStoppedResponding(jobDetailsCacheModel.getJobDetailsModel());
        }
    }

    public void removeExpiredEntriesForServers(String serverId) {
        HashSet<JobDetailsModel> expiredJobsDetailsModels = new HashSet<JobDetailsModel>();
        for (String id : this.runningJobsCachedDetails.keySet()) {
            String jobServerId;
            JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(id);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing previously running " + String.valueOf(jobDetailsCacheModel.getJobDetailsModel().getSettings()));
            }
            if (!serverId.equals(jobServerId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getServerId())) continue;
            long remainingMs = jobDetailsCacheModel.getCreationDate() + this.schedulerApplication.getConfiguration().getEngineTimeout() - new DateTime(DateTimeZone.UTC).getMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Entry matches server and has " + remainingMs + " remaining ms");
            }
            if (remainingMs > 0L) continue;
            LOGGER.info("Flagging " + String.valueOf(jobDetailsCacheModel.getJobDetailsModel().getSettings()) + " for removal from cache with remaining " + remainingMs + " ms");
            expiredJobsDetailsModels.add(jobDetailsCacheModel.getJobDetailsModel());
        }
        for (JobDetailsModel jobDetailsModel : expiredJobsDetailsModels) {
            this.handleJobEngineStoppedResponding(jobDetailsModel);
        }
    }

    private JobStart getProcessingJobDetails(JobDetailsModel jobDetailsModel, boolean isJobStarting) {
        ExecutionProfileModel executionProfileModel;
        ResourcePoolModel resourcePoolModel;
        EngineModel engineModel;
        Server serverModel;
        com.nuix.automate.utils.utilization.Client client = new com.nuix.automate.utils.utilization.Client();
        Matter matter = new Matter();
        com.nuix.automate.utils.utilization.Workflow workflow = new com.nuix.automate.utils.utilization.Workflow();
        Library library = new Library();
        com.nuix.automate.utils.utilization.Job job = new com.nuix.automate.utils.utilization.Job();
        job.setJobId(jobDetailsModel.getSettings().getId());
        job.setJobName(jobDetailsModel.getSettings().getName());
        if (jobDetailsModel.getSettings().getStagedBy() != null) {
            job.setJobSubmittedByUserId(User.getIdFromName((String)jobDetailsModel.getSettings().getStagedBy(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        } else {
            job.setJobSubmittedByUserId(User.getIdFromName((String)jobDetailsModel.getSettings().getSubmittedBy(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        }
        job.setJobModifiedByUserId(User.getIdFromName((String)jobDetailsModel.getSettings().getModifiedBy(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        if (jobDetailsModel.getSettings().getStagedDate() != null) {
            job.setJobSubmissionEpoch(jobDetailsModel.getSettings().getStagedDate());
        } else {
            job.setJobSubmissionEpoch(jobDetailsModel.getSettings().getSubmittedDate());
        }
        job.setJobStartEpoch(jobDetailsModel.getSettings().getStartedDate());
        job.setJobEndEpoch(jobDetailsModel.getSettings().getFinishedDate());
        job.setJobExecutionState(jobDetailsModel.getSettings().getExecutionState());
        job.setExcludeMetrics(jobDetailsModel.getSettings().getExcludeUtilization());
        job.setJobPercentageComplete(jobDetailsModel.getSettings().getPercentageComplete());
        job.setMatterId(jobDetailsModel.getSettings().getMatterId());
        job.setJobHasWarnings(jobDetailsModel.getSettings().getHasWarnings());
        job.setJobHasSoftErrors(jobDetailsModel.getSettings().getHasSoftErrors());
        job.setJobHasErrors(Boolean.valueOf(jobDetailsModel.getSettings().getError() != null && jobDetailsModel.getSettings().getError().length() > 0));
        String matterId = jobDetailsModel.getSettings().getMatterId();
        com.nuix.automate.utils.models.api.client.Matter matterModel = null;
        Client clientModel = null;
        if (matterId != null && (matterModel = this.schedulerApplication.getClientResource().getMatter(matterId)) != null) {
            clientModel = this.schedulerApplication.getClientResource().getClient(matterModel.getClientId());
        }
        if (matterModel != null && clientModel != null) {
            matter.setMatterId(matterId);
            matter.setMatterIsActive(matterModel.getEnabled().booleanValue());
            matter.setMatterName(matterModel.getName());
            matter.setClientId(clientModel.getId());
            client.setClientId(clientModel.getId());
            client.setClientIsActive(clientModel.getEnabled().booleanValue());
            client.setClientName(clientModel.getName());
        } else {
            client.setClientName("_Undefined");
            client.setClientId(UidUtils.fromString((String)"_Undefined", (String)"client"));
            client.setClientIsActive(true);
            matter.setMatterName("_Undefined");
            matter.setMatterId(UidUtils.fromString((String)"_Undefined", (String)"matter"));
            matter.setMatterIsActive(true);
            matter.setClientId(client.getClientId());
        }
        ActivityDetails jobSetupActivity = new ActivityDetails();
        jobSetupActivity.setStartEpoch(job.getJobSubmissionEpoch().longValue());
        jobSetupActivity.setLastEpoch(job.getJobSubmissionEpoch() + 1L);
        jobSetupActivity.setMatterId(matter.getMatterId());
        jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
        jobSetupActivity.setUserId(job.getJobSubmittedByUserId());
        jobSetupActivity.setActivityKey(job.getJobId());
        this.schedulerApplication.getUserResource().trackFinishedActivity(jobSetupActivity);
        String libraryWorkflowId = jobDetailsModel.getSettings().getLibraryWorkflowId();
        Workflow libraryWorkflowModel = null;
        WorkflowLibrary workflowLibrary = null;
        if (libraryWorkflowId != null && (libraryWorkflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(libraryWorkflowId)) != null) {
            workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(libraryWorkflowModel.getLibraryId());
        }
        if (libraryWorkflowModel != null && workflowLibrary != null) {
            job.setWorkflowId(libraryWorkflowId);
            workflow.setWorkflowId(libraryWorkflowId);
            workflow.setWorkflowName(libraryWorkflowModel.getName());
            workflow.setLibraryId(libraryWorkflowModel.getLibraryId());
            library.setLibraryId(workflowLibrary.getId());
            library.setLibraryName(workflowLibrary.getName());
        }
        com.nuix.automate.utils.utilization.Server server = null;
        if (jobDetailsModel.getSettings().getServerId() != null && (serverModel = this.schedulerApplication.getServerResource().getServerWithId(jobDetailsModel.getSettings().getServerId())) != null) {
            server = new com.nuix.automate.utils.utilization.Server();
            server.setServerId(serverModel.getId());
            server.setServerName(serverModel.getName());
        }
        job.setEngineId(jobDetailsModel.getSettings().getEngineId());
        Engine engine = null;
        if (jobDetailsModel.getSettings().getEngineId() != null && (engineModel = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(jobDetailsModel.getSettings().getEngineId())) != null) {
            engine = new Engine();
            engine.setEngineId(engineModel.getId());
            engine.setEngineName(engineModel.getName());
            engine.setServerId(engineModel.getServerId());
        }
        job.setResourcePoolId(jobDetailsModel.getSettings().getResourcePoolId());
        ResourcePool resourcePool = null;
        if (jobDetailsModel.getSettings().getResourcePoolId() != null && (resourcePoolModel = this.schedulerApplication.getResourcePoolResource().getResourcePool(jobDetailsModel.getSettings().getResourcePoolId())) != null) {
            resourcePool = new ResourcePool();
            resourcePool.setResourcePoolName(resourcePoolModel.getName());
            resourcePool.setResourcePoolId(resourcePoolModel.getId());
        }
        job.setExecutionProfileId(jobDetailsModel.getSettings().getExecutionProfileId());
        ExecutionProfile executionProfile = null;
        if (jobDetailsModel.getSettings().getExecutionProfileId() != null && (executionProfileModel = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobDetailsModel.getSettings().getExecutionProfileId())) != null) {
            executionProfile = new ExecutionProfile();
            executionProfile.setExecutionProfileName(executionProfileModel.getName());
            executionProfile.setExecutionProfileId(executionProfileModel.getId());
        }
        HashMap<String, String> jobParameters = new HashMap<String, String>();
        for (Parameter parameterModel : jobDetailsModel.getSettings().getSessionParameters()) {
            if (parameterModel.getParameterType().equals((Object)ParameterType.TEXT_PROTECTED) || parameterModel.getParameterType().equals((Object)ParameterType.TEXT_MASKED) || new StaticParameter(parameterModel.getName(), "").isEffectiveTypeMaskedOrProtected()) {
                jobParameters.put(parameterModel.getName(), com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE);
                continue;
            }
            jobParameters.put(parameterModel.getName(), parameterModel.getValue());
        }
        job.setJobParameters(jobParameters);
        job.setJobPriority(Priority.fromInteger((Integer)jobDetailsModel.getSettings().getPriority().getInt()));
        JobStart jobStart = new JobStart();
        jobStart.setJob(job);
        if (isJobStarting) {
            jobStart.setClient(client);
            jobStart.setEngine(engine);
            jobStart.setExecutionProfile(executionProfile);
            jobStart.setLibrary(library);
            jobStart.setMatter(matter);
            jobStart.setResourcePool(resourcePool);
            jobStart.setServer(server);
            jobStart.setWorkflow(workflow);
        }
        return jobStart;
    }

    private void localUtilizationUpdateJob(JobStart jobStart) {
        block12: {
            try {
                com.nuix.automate.utils.utilization.Job job;
                ExecutionProfile executionProfile;
                ResourcePool resourcePool;
                Engine engine;
                com.nuix.automate.utils.utilization.Server server;
                com.nuix.automate.utils.utilization.Workflow workflow;
                Library library;
                Matter matter;
                com.nuix.automate.utils.utilization.Client client = jobStart.getClient();
                if (client != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceClient(client);
                }
                if ((matter = jobStart.getMatter()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceMatter(matter);
                }
                if ((library = jobStart.getLibrary()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceLibrary(library);
                }
                if ((workflow = jobStart.getWorkflow()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceWorkflow(workflow);
                }
                if ((server = jobStart.getServer()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceServer(server);
                }
                if ((engine = jobStart.getEngine()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceEngine(engine);
                }
                if ((resourcePool = jobStart.getResourcePool()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceResourcePool(resourcePool);
                }
                if ((executionProfile = jobStart.getExecutionProfile()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceExecutionProfile(executionProfile);
                }
                if ((job = jobStart.getJob()) != null) {
                    this.schedulerApplication.getUtilizationDaoV2().replaceJob(job);
                    List parameters = jobStart.getJob().getParameters();
                    if (parameters != null) {
                        this.schedulerApplication.getUtilizationDaoV2().replaceParameters(parameters);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot update utilization data", (Throwable)e);
                if (this.schedulerApplication.getConfiguration().getUtilizationErrorsSoftFail()) break block12;
                throw e;
            }
        }
    }

    private void licenseServerUtilizationUpdateJob(JobStart jobStart) {
        com.nuix.automate.utils.utilization.Job job;
        ExecutionProfile executionProfile;
        ResourcePool resourcePool;
        Engine engine;
        com.nuix.automate.utils.utilization.Server server;
        com.nuix.automate.utils.utilization.Workflow workflow;
        Library library;
        Matter matter;
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        boolean hasUtilizationData = false;
        com.nuix.automate.utils.utilization.Client client = jobStart.getClient();
        if (client != null) {
            HashSet<com.nuix.automate.utils.utilization.Client> clients = new HashSet<com.nuix.automate.utils.utilization.Client>();
            utilizationRecords.setClients(clients);
            clients.add(client);
            hasUtilizationData = true;
        }
        if ((matter = jobStart.getMatter()) != null) {
            HashSet<Matter> matters = new HashSet<Matter>();
            utilizationRecords.setMatters(matters);
            matters.add(matter);
            hasUtilizationData = true;
        }
        if ((library = jobStart.getLibrary()) != null) {
            HashSet<Library> libraries = new HashSet<Library>();
            utilizationRecords.setLibraries(libraries);
            libraries.add(library);
            hasUtilizationData = true;
        }
        if ((workflow = jobStart.getWorkflow()) != null) {
            HashSet<com.nuix.automate.utils.utilization.Workflow> workflows = new HashSet<com.nuix.automate.utils.utilization.Workflow>();
            utilizationRecords.setWorkflows(workflows);
            workflows.add(workflow);
            hasUtilizationData = true;
        }
        if ((server = jobStart.getServer()) != null) {
            HashSet<com.nuix.automate.utils.utilization.Server> servers = new HashSet<com.nuix.automate.utils.utilization.Server>();
            utilizationRecords.setServers(servers);
            servers.add(server);
            hasUtilizationData = true;
        }
        if ((engine = jobStart.getEngine()) != null) {
            HashSet<Engine> engines = new HashSet<Engine>();
            utilizationRecords.setEngines(engines);
            engines.add(engine);
            hasUtilizationData = true;
        }
        if ((resourcePool = jobStart.getResourcePool()) != null) {
            HashSet<ResourcePool> resourcePools = new HashSet<ResourcePool>();
            utilizationRecords.setResourcePools(resourcePools);
            resourcePools.add(resourcePool);
            hasUtilizationData = true;
        }
        if ((executionProfile = jobStart.getExecutionProfile()) != null) {
            HashSet<ExecutionProfile> executionProfiles = new HashSet<ExecutionProfile>();
            utilizationRecords.setExecutionProfiles(executionProfiles);
            executionProfiles.add(executionProfile);
            hasUtilizationData = true;
        }
        if (hasUtilizationData) {
            this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
        if ((job = jobStart.getJob()) != null) {
            utilizationRecords = new UtilizationRecords();
            utilizationRecords.setId(UidUtils.getRandom());
            utilizationRecords.setId(job.getJobId());
            HashSet<com.nuix.automate.utils.utilization.Job> jobs = new HashSet<com.nuix.automate.utils.utilization.Job>();
            utilizationRecords.setJobs(jobs);
            jobs.add(job);
            this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
    }

    private void utilizationUpdateJob(JobDetailsModel jobDetailsModel, boolean isJobStarting, boolean firstOccurence) {
        JobStart jobStart = this.getProcessingJobDetails(jobDetailsModel, isJobStarting);
        if (!firstOccurence && jobStart.getJob() != null) {
            jobStart.getJob().setJobParameters(new HashMap());
        }
        this.localUtilizationUpdateJob(jobStart);
        this.licenseServerUtilizationUpdateJob(jobStart);
    }

    private void handleJobEngineStoppedResponding(JobDetailsModel jobDetailsModel) {
        jobDetailsModel.getSettings().setExecutionState(ExecutionState.ERROR);
        String error = this.iu.getString("JobResource.EngineStoppedResponding");
        Object jobError = jobDetailsModel.getSettings().getError();
        if (jobError == null) {
            jobError = "";
        }
        if (((String)jobError).length() > 0) {
            jobError = (String)jobError + ", ";
        }
        jobError = (String)jobError + error;
        jobDetailsModel.getSettings().setError((String)jobError);
        this.schedulerApplication.getJobsDao().addExecutionLog(jobDetailsModel.getSettings().getId(), LogLevel.EXECUTION.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), "\n".getBytes(StandardCharsets.UTF_8));
        this.schedulerApplication.getJobsDao().addExecutionLog(jobDetailsModel.getSettings().getId(), LogLevel.ERROR.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), error.getBytes(StandardCharsets.UTF_8));
        this.putFinishedJob(jobDetailsModel, "N/A");
    }

    public void removeJobFilterForSession(String sessionId) {
        if (sessionId != null) {
            this.sessionsFilter.remove(sessionId);
        }
    }

    public JobResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.backlogJobsDetails = new ConcurrentHashMap<String, JobDetailsModel>();
        this.finishedJobsDetails = new ConcurrentHashMap<String, JobDetailsModel>();
        this.runningJobsCachedDetails = new ConcurrentHashMap<String, JobDetailsCacheModel>();
        this.lastJobDaoUpdatesMs = new ConcurrentHashMap<String, Long>();
        this.jobRunningLogs = new ConcurrentHashMap<String, RunningLogEventsModel>();
        this.sessionsFilter = new HashMap<String, JobFilter>();
        List<JobDetailsModel> storedJobsDetails = schedulerApplication.getJobsDao().getJobDetails(JobState.FINISHED);
        for (JobDetailsModel jobDetailsModel : storedJobsDetails) {
            boolean jobModified;
            try {
                Workflow workflow = schedulerApplication.getLibraryResource().getLibraryWorkflow(jobDetailsModel.getSettings().getLibraryWorkflowId());
                jobModified = jobDetailsModel.getSettings().clearSensitiveValues();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot handle previous job " + String.valueOf(jobDetailsModel), (Throwable)e);
                continue;
            }
            if (jobModified) {
                schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.FINISHED);
                LOGGER.info("Removed " + String.valueOf(jobDetailsModel.getSettings()) + " saved state");
            }
            try {
                this.finishedJobsDetails.put(jobDetailsModel.getSettings().getId(), jobDetailsModel);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot handle previous jobs " + String.valueOf(jobDetailsModel), (Throwable)e);
            }
        }
        storedJobsDetails = schedulerApplication.getJobsDao().getJobDetails(JobState.RUNNING);
        for (JobDetailsModel jobDetailsModel : storedJobsDetails) {
            try {
                if (this.finishedJobsDetails.containsKey(jobDetailsModel.getSettings().getId())) {
                    schedulerApplication.getJobsDao().removeJobDetails(jobDetailsModel.getSettings().getId(), JobState.RUNNING);
                    continue;
                }
                this.runningJobsCachedDetails.put(jobDetailsModel.getSettings().getId(), new JobDetailsCacheModel(new DateTime(DateTimeZone.UTC).getMillis(), jobDetailsModel));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot handle previous jobs " + String.valueOf(jobDetailsModel), (Throwable)e);
            }
        }
        storedJobsDetails = schedulerApplication.getJobsDao().getJobDetails(JobState.BACKLOG);
        for (JobDetailsModel jobDetailsModel : storedJobsDetails) {
            try {
                if (this.finishedJobsDetails.containsKey(jobDetailsModel.getSettings().getId()) || this.runningJobsCachedDetails.containsKey(jobDetailsModel.getSettings().getId())) {
                    schedulerApplication.getJobsDao().removeJobDetails(jobDetailsModel.getSettings().getId(), JobState.BACKLOG);
                    continue;
                }
                if (jobDetailsModel.getSettings() != null && jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.CANCELLED)) {
                    this.finishedJobsDetails.put(jobDetailsModel.getSettings().getId(), jobDetailsModel);
                    continue;
                }
                this.backlogJobsDetails.put(jobDetailsModel.getSettings().getId(), jobDetailsModel);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot handle previous jobs " + String.valueOf(jobDetailsModel), (Throwable)e);
            }
        }
        this.migrateJobComponentsToArchive();
        JobWorker jobWorker = new JobWorker(schedulerApplication, this);
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)jobWorker, 0L, schedulerApplication.getConfiguration().getJobWorkerInterval());
        if (schedulerApplication.getConfiguration().isArchivedJobCleanupEnabled()) {
            LOGGER.info("Starting Archived Job Worker");
            ArchivedJobWorker archivedJobWorker = new ArchivedJobWorker(schedulerApplication);
            Timer archivedJobTime = new Timer(true);
            archivedJobTime.schedule((TimerTask)archivedJobWorker, 0L, (long)schedulerApplication.getConfiguration().getArchivedJobCleanupInterval());
        }
    }

    private void migrateJobComponentsToArchive() {
        if (this.schedulerApplication.getJobsDao() != this.schedulerApplication.getJobsArchiveDao()) {
            boolean jobIsActive;
            List<String> jobIds = this.schedulerApplication.getJobsDao().getJobExecutionLogJobIds();
            LOGGER.info("Detected " + jobIds.size() + " non-archived job(s) with Execution Logs");
            for (String jobId : jobIds) {
                jobIsActive = this.backlogJobsDetails.containsKey(jobId);
                if (this.finishedJobsDetails.containsKey(jobId)) {
                    jobIsActive = true;
                }
                if (this.runningJobsCachedDetails.containsKey(jobId)) {
                    jobIsActive = true;
                }
                if (jobIsActive) continue;
                this.migrateJobExecutionLogToArchive(jobId);
            }
            jobIds = this.schedulerApplication.getJobsDao().getOperationMimeTypeStatsJobId();
            LOGGER.info("Detected " + jobIds.size() + " job(s) with Execution Logs");
            for (String jobId : jobIds) {
                jobIsActive = this.backlogJobsDetails.containsKey(jobId);
                if (this.finishedJobsDetails.containsKey(jobId)) {
                    jobIsActive = true;
                }
                if (this.runningJobsCachedDetails.containsKey(jobId)) {
                    jobIsActive = true;
                }
                if (jobIsActive) continue;
                this.migrateJobOperationMimeStats(jobId);
            }
        }
    }

    private void migrateJobExecutionLogToArchive(String jobId) {
        if (this.schedulerApplication.getJobsDao() != this.schedulerApplication.getJobsArchiveDao()) {
            try {
                LOGGER.info("Moving Execution Logs for job " + jobId + " to archive");
                List<JobExecutionLog> executionLog = this.schedulerApplication.getJobsDao().getJobExecutionLog(jobId);
                int[] results = this.schedulerApplication.getJobsArchiveDao().addJobExecutionLogs(executionLog, jobId);
                this.schedulerApplication.getJobsDao().deleteJobLogsForJobId(jobId);
                long movedLogsCount = this.schedulerApplication.getJobsArchiveDao().getJobExecutionLogCount(jobId);
                if (movedLogsCount == 0L) {
                    LOGGER.warn("Execution Logs not found in archive after moving, re-inserting");
                    this.schedulerApplication.getJobsArchiveDao().addJobExecutionLogs(executionLog, jobId);
                }
                LOGGER.info("Moved " + results.length + " log lines");
            }
            catch (Exception e) {
                LOGGER.error("Cannot move execution logs", (Throwable)e);
            }
        }
    }

    private void migrateJobOperationMimeStats(String jobId) {
        if (this.schedulerApplication.getJobsDao() != this.schedulerApplication.getJobsArchiveDao()) {
            try {
                LOGGER.info("Moving Operation Mime Stats job " + jobId + " to archive");
                JobOperationMimeTypeStats operationMimeStats = this.schedulerApplication.getJobsDao().getJobOperationMimeTypeStats(jobId);
                if (operationMimeStats != null) {
                    this.schedulerApplication.getJobsArchiveDao().addJobOperationsMimeTypeStats(operationMimeStats);
                    this.schedulerApplication.getJobsDao().deleteJobOperationsMimeTypeStats(jobId);
                    LOGGER.info("Moved " + operationMimeStats.getMimeTypeStats().size() + " operation Mime Stats");
                    JobOperationMimeTypeStats movedOperationMimeStats = this.schedulerApplication.getJobsArchiveDao().getJobOperationMimeTypeStats(jobId);
                    if (movedOperationMimeStats == null) {
                        LOGGER.warn("Mime Stats not found in archive after moving, re-inserting");
                        this.schedulerApplication.getJobsArchiveDao().addJobOperationsMimeTypeStats(operationMimeStats);
                    }
                } else {
                    LOGGER.info("Job does not Mime Stats");
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot move Mime Stats", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJobBootstrapState(String jobId) {
        JobResource jobResource = this;
        synchronized (jobResource) {
            JobDetailsModel candidate = this.backlogJobsDetails.get(jobId);
            if (candidate == null) {
                LOGGER.error("Cannot clear job " + jobId + " bootstrap state because job does not exist anymore");
            } else if (!candidate.getSettings().getBootstrap()) {
                LOGGER.error("Cannot clear job " + jobId + " bootstrap state because job is not in bootstraping state");
            } else {
                candidate.getSettings().setBootstrap(false);
                candidate.getSettings().setEngineId(null);
                candidate.getSettings().setEngineName(null);
                candidate.getSettings().setServerId(null);
                candidate.getSettings().setServerName(null);
                candidate.getSettings().setParameterLock(false);
                candidate.getSettings().setMatterLock(false);
                this.schedulerApplication.getJobsDao().updateJobDetails(candidate, JobState.BACKLOG);
            }
        }
    }

    private List<JobModel> getRunningOrInitializingJobs() {
        ArrayList<JobModel> runningOrInitializingJobs = new ArrayList<JobModel>();
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            runningOrInitializingJobs.add(jobDetailsCacheModel.getJobDetailsModel().getSettings());
        }
        for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
            if (jobDetailsModel.getSettings().getEngineId() == null || jobDetailsModel.getSettings().getEngineId().length() <= 0) continue;
            runningOrInitializingJobs.add(jobDetailsModel.getSettings());
        }
        return runningOrInitializingJobs;
    }

    private Set<String> getActiveParameterLocks(List<JobModel> runningOrInitializingJobs) {
        HashSet<String> activeLocks = new HashSet<String>();
        for (JobModel runningOrInitializingJob : runningOrInitializingJobs) {
            for (Parameter parameterModel : runningOrInitializingJob.getSessionParameters()) {
                if (!parameterModel.isLock() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
                activeLocks.add(parameterModel.getName() + ":" + parameterModel.getValue());
            }
        }
        return activeLocks;
    }

    public void setJobRunningLog(String jobId, RunningLogEventsModel runningLog) {
        this.jobRunningLogs.put(jobId, runningLog);
    }

    private Set<String> getSynchronizedMatterIds(List<JobModel> runningOrInitializingJobs) {
        HashSet<String> activeSynchronizedMatterIds = new HashSet<String>();
        for (JobModel runningOrInitializingJob : runningOrInitializingJobs) {
            String runningMatterId = runningOrInitializingJob.getMatterId();
            com.nuix.automate.utils.models.api.client.Matter runningMatter = this.schedulerApplication.getClientResource().getMatter(runningMatterId);
            if (runningMatter == null || (runningMatter.getSynchronizeJobs() == null || !runningMatter.getSynchronizeJobs().booleanValue()) && !this.schedulerApplication.getConfiguration().getSynchronizeJobsOnAllMatters()) continue;
            activeSynchronizedMatterIds.add(runningMatterId);
        }
        return activeSynchronizedMatterIds;
    }

    public BootstrappableJob getNotStartedJobForResourcePool(String resourcePoolId, boolean markAsBootstrapped) {
        HashSet<ExecutionMode> executionModes = new HashSet<ExecutionMode>();
        executionModes.addAll(Arrays.asList(ExecutionMode.values()));
        return this.getNotStartedJobForResourcePool(resourcePoolId, markAsBootstrapped, executionModes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrappableJob getNotStartedJobForResourcePool(String resourcePoolId, boolean markAsBootstrapped, Set<ExecutionMode> executionModes) {
        JobModel candidate = null;
        JobResource jobResource = this;
        synchronized (jobResource) {
            List<JobModel> runningOrInitializedJobs = this.getRunningOrInitializingJobs();
            Set<String> activeLocks = this.getActiveParameterLocks(runningOrInitializedJobs);
            Set<String> activeSynchronizedMatterIds = this.getSynchronizedMatterIds(runningOrInitializedJobs);
            ArrayList<JobDetailsModel> backLogList = new ArrayList<JobDetailsModel>();
            backLogList.addAll(this.backlogJobsDetails.values());
            backLogList.sort(Comparator.comparing(o -> o.getSettings().getResubmittedDate()));
            for (JobDetailsModel jobDetailsModel : backLogList) {
                try {
                    if (jobDetailsModel.getSettings().getInStaging()) continue;
                    String jobResourcePoolId = jobDetailsModel.getSettings().getResourcePoolId();
                    if (jobDetailsModel.getSettings() == null || jobDetailsModel.getSettings().getExecutionState() != ExecutionState.NOT_STARTED && jobDetailsModel.getSettings().getExecutionState() != ExecutionState.PAUSED || !resourcePoolId.equals(jobResourcePoolId)) continue;
                    if (jobDetailsModel.getSettings().getBootstrap()) {
                        EngineModel engine = null;
                        String engineId = jobDetailsModel.getSettings().getEngineId();
                        if (engineId != null) {
                            engine = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(engineId);
                        }
                        if (engine != null && jobDetailsModel.getSettings().getId().equals(engine.getBootstrappingJobId())) continue;
                        LOGGER.warn(String.valueOf(jobDetailsModel) + " was bootstrapped to " + (String)engineId + " and this engine does not exist anymore");
                        this.clearJobBootstrapState(jobDetailsModel.getSettings().getId());
                        continue;
                    }
                    String conflictingLock = null;
                    for (Parameter parameterModel : jobDetailsModel.getSettings().getSessionParameters()) {
                        String lockName;
                        if (!parameterModel.isLock() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0 || !activeLocks.contains(lockName = parameterModel.getName() + ":" + parameterModel.getValue())) continue;
                        conflictingLock = lockName;
                        break;
                    }
                    ExecutionProfileModel executionProfileModel = null;
                    String executionProfileId = jobDetailsModel.getSettings().getExecutionProfileId();
                    String executionProfileMissingRequiredProfile = null;
                    if (executionProfileId != null) {
                        executionProfileModel = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
                        if (executionProfileModel == null) {
                            executionProfileId = null;
                        } else {
                            List requiredProfiles = jobDetailsModel.getSettings().getRequiredProfiles();
                            this.updateRequiredProfiles(requiredProfiles, executionProfileId);
                            if (requiredProfiles != null) {
                                for (JobRequiredProfile requiredProfile : requiredProfiles) {
                                    if (!requiredProfile.getMissing()) continue;
                                    executionProfileMissingRequiredProfile = requiredProfile.getProfileType().name() + ":" + requiredProfile.getName();
                                }
                            }
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot run job because it does not have an executionProfile");
                    }
                    String conflictingSynchronizedMatterName = null;
                    String matterId = jobDetailsModel.getSettings().getMatterId();
                    com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
                    if (matter != null && (matter.getSynchronizeJobs() != null && matter.getSynchronizeJobs().booleanValue() || this.schedulerApplication.getConfiguration().getSynchronizeJobsOnAllMatters()) && activeSynchronizedMatterIds.contains(matter.getId())) {
                        conflictingSynchronizedMatterName = matter.getName();
                    }
                    if (conflictingSynchronizedMatterName != null || executionProfileMissingRequiredProfile != null || conflictingLock != null || executionProfileModel == null || candidate != null && candidate.getPriority().compareTo((Enum)jobDetailsModel.getSettings().getPriority()) >= 0) continue;
                    ExecutionMode jobExecutionMode = null;
                    String workflowId = jobDetailsModel.getSettings().getLibraryWorkflowId();
                    Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
                    jobExecutionMode = workflow.getExecutionMode();
                    if (jobExecutionMode == null) {
                        jobExecutionMode = ExecutionMode.AUTOMATE_NUIX;
                        LOGGER.info("Cannot determine job " + String.valueOf(jobDetailsModel) + " execution mode, defaulting to " + String.valueOf(jobExecutionMode));
                    }
                    if (jobExecutionMode.equals((Object)ExecutionMode.AUTOMATE_NUIX) && !executionModes.contains(ExecutionMode.AUTOMATE_NUIX)) continue;
                    candidate = jobDetailsModel.getSettings();
                }
                catch (Exception e) {
                    JobModel jobSettings = jobDetailsModel.getSettings();
                    String id = "[unknown]";
                    if (jobSettings != null) {
                        id = jobSettings.getId();
                    }
                    LOGGER.warn("Cannot handle job " + id, (Throwable)e);
                }
            }
            if (candidate != null && markAsBootstrapped) {
                candidate.setBootstrap(true);
            }
        }
        return this.getBootstrappableJob(candidate);
    }

    public BootstrappableJob getBootstrappableJob(JobModel jobModel) {
        ThirdPartyService thirdPartyService;
        if (jobModel == null) {
            return null;
        }
        ExecutionProfileModel executionProfileModel = null;
        String executionProfileId = jobModel.getExecutionProfileId();
        if (executionProfileId != null) {
            executionProfileModel = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
        }
        ExecutionMode jobExecutionMode = null;
        String workflowId = jobModel.getLibraryWorkflowId();
        Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
        jobExecutionMode = workflow.getExecutionMode();
        if (jobExecutionMode == null) {
            jobExecutionMode = ExecutionMode.AUTOMATE_NUIX;
            LOGGER.info("Cannot determine job " + String.valueOf(jobModel) + " execution mode, defaulting to " + String.valueOf(jobExecutionMode));
        }
        BootstrappableJob bootstrappableJob = new BootstrappableJob(jobModel, workflow.getOperationsXml(), executionProfileModel);
        jobModel.setExecutionMode(jobExecutionMode);
        long currentTimeMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        try {
            try {
                this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addComponentHistory(workflowId, workflow.getLastModified(), HistoryComponentType.WORKFLOW, workflow.getOperationsXml(), currentTimeMillis);
            }
            catch (Exception e) {
                this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateComponentHistory(workflowId, workflow.getLastModified(), HistoryComponentType.WORKFLOW, currentTimeMillis);
            }
            try {
                this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addJobHistory(jobModel.getId(), workflowId, workflow.getLastModified(), currentTimeMillis);
            }
            catch (Exception e) {
                this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateJobHistory(jobModel.getId(), currentTimeMillis);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle history log", (Throwable)e);
        }
        bootstrappableJob.setDataSetsMetadata(new HashMap());
        bootstrappableJob.setDataRepositories(new HashMap());
        HashMap<String, ThirdPartyService> thirdPartyServices = new HashMap<String, ThirdPartyService>();
        for (Object sessionParameter : jobModel.getSessionParameters()) {
            if (!sessionParameter.getDisplayCondition().getDisplayable()) continue;
            String string = sessionParameter.getValue();
            if (sessionParameter.isDataSet()) {
                Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(string);
                if (dataset == null || !dataset.getMatterId().equals(jobModel.getMatterId()) || !dataset.isFinalized() && !dataset.isHidden()) {
                    LOGGER.info("Skipping invalid dataset, null or mismatching matter or not finalized or hidden, " + string);
                    continue;
                }
                DatasetMetadata datasetMetadata = this.buildDatasetMetadata(dataset);
                bootstrappableJob.getDataSetsMetadata().put(dataset.getId(), datasetMetadata);
                continue;
            }
            if (sessionParameter.isAzureStorageAccount()) {
                DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(string);
                if (dataRepository == null || dataRepository.getType() != DatasetType.AZURE_STORAGE_ACCOUNT) {
                    LOGGER.info("Skipping invalid dataRepository, null or not AzureStorageAccount type, " + string);
                    continue;
                }
                bootstrappableJob.getDataRepositories().put(dataRepository.getId(), dataRepository);
                continue;
            }
            if (!sessionParameter.isThirdPartyServiceParameter()) continue;
            try {
                ThirdPartyServiceSession<?, ?> thirdPartyServiceSession2 = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(string, jobModel.getSubmitterUserId());
                thirdPartyService = thirdPartyServiceSession2.getService().clone();
                thirdPartyService.setUserCredential(thirdPartyServiceSession2.getUserCredential());
                thirdPartyService.setWhitelistedCertFingerprints(thirdPartyServiceSession2.getWhitelistedCertFingerprints());
                thirdPartyServices.put(thirdPartyService.getId(), thirdPartyService);
            }
            catch (IOException thirdPartyServiceSession2) {}
        }
        List defaultParameters = bootstrappableJob.getJobModel().getDefaultParameters();
        for (String string : this.schedulerApplication.getThirdPartyServiceResource().getAvailableByDefaultThirdPartyServiceIds()) {
            try {
                ThirdPartyServiceSession<?, ?> thirdPartyServiceSession3 = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(string, jobModel.getSubmitterUserId());
                thirdPartyService = thirdPartyServiceSession3.getService().clone();
                if (thirdPartyService.getDefaultParameterName() == null) continue;
                thirdPartyService.setUserCredential(thirdPartyServiceSession3.getUserCredential());
                thirdPartyServices.put(thirdPartyService.getId(), thirdPartyService);
                Parameter parameter = new Parameter(thirdPartyService.getDefaultParameterName(), thirdPartyService.getId());
                parameter.setSource(ParameterSource.DEFAULT_THIRD_PARTY_SERVICE);
                parameter.setUserDisplayableValue(thirdPartyService.getName());
                parameter.setFriendlyName(thirdPartyService.getPrintableServiceType());
                defaultParameters.add(parameter);
            }
            catch (IOException thirdPartyServiceSession3) {}
        }
        bootstrappableJob.setThirdPartyServicesJson(SerializationUtils.toJson(thirdPartyServices));
        HashMap<String, FileLibraryFile> fileLibraryFiles = new HashMap<String, FileLibraryFile>();
        for (String id : this.getJobFileLibraryFiles(jobModel, bootstrappableJob.getWorkflowXml())) {
            FileLibraryFile file = this.schedulerApplication.getFileLibraryResource().resolveFileId(id);
            if (file == null) {
                LOGGER.error("File library file with ID: " + id + " does not exist, skipped adding to job");
                continue;
            }
            try {
                try {
                    this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addComponentHistory(file.getId(), file.getLastStateChangedDate(), HistoryComponentType.FILE, SerializationUtils.toJson((Object)file), currentTimeMillis);
                }
                catch (Exception exception) {
                    this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateComponentHistory(file.getId(), file.getLastStateChangedDate(), HistoryComponentType.FILE, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                }
                try {
                    this.schedulerApplication.getLoggingResource().getActiveLoggingDao().addJobHistory(jobModel.getId(), file.getId(), file.getLastStateChangedDate(), currentTimeMillis);
                }
                catch (Exception exception) {
                    this.schedulerApplication.getLoggingResource().getActiveLoggingDao().updateJobHistory(jobModel.getId(), currentTimeMillis);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Cannot handle history log", (Throwable)exception);
            }
            fileLibraryFiles.put(id, file);
        }
        ArrayList<SourceParameter> arrayList = new ArrayList<SourceParameter>();
        if (jobModel.getClientId() != null) {
            List<ClientPool> list;
            Client client;
            com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId());
            if (matter != null && matter.getWorkflowParameters() != null) {
                for (Map.Entry entry : matter.getWorkflowParameters().entrySet()) {
                    arrayList.add(new SourceParameter((String)entry.getKey(), (String)entry.getValue(), SourceParameterSourceType.MATTER));
                }
            }
            if ((client = this.schedulerApplication.getClientResource().getClient(jobModel.getClientId())) != null && client.getWorkflowParameters() != null) {
                for (Map.Entry entry : client.getWorkflowParameters().entrySet()) {
                    arrayList.add(new SourceParameter((String)entry.getKey(), (String)entry.getValue(), SourceParameterSourceType.CLIENT));
                }
            }
            if ((list = this.schedulerApplication.getClientPoolResource().getClientPoolsContainingClientId(jobModel.getClientId())) != null) {
                for (ClientPool clientPool : list) {
                    if (clientPool.getWorkflowParameters() == null) continue;
                    for (Map.Entry entry : clientPool.getWorkflowParameters().entrySet()) {
                        arrayList.add(new SourceParameter((String)entry.getKey(), (String)entry.getValue(), SourceParameterSourceType.CLIENT_POOL));
                    }
                }
            }
        }
        bootstrappableJob.setSourceParameters(arrayList);
        bootstrappableJob.setFileLibraryFiles(fileLibraryFiles);
        return bootstrappableJob;
    }

    private DatasetMetadata buildDatasetMetadata(Dataset dataset) {
        DatasetMetadata dataSetMetadata = new DatasetMetadata();
        dataSetMetadata.setName(dataset.getName());
        try {
            Path datasetFinalPath = DatasetUtils.getDatasetUtils(this.schedulerApplication).getDatasetFinalPath(dataset);
            dataSetMetadata.setBasePath(datasetFinalPath.toString());
        }
        catch (FileTraversalException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
        ArrayList headers = dataset.getFileMetadataHeaders();
        if (headers == null) {
            headers = new ArrayList();
        }
        dataSetMetadata.setMetadataFieldNames((List)headers);
        String datasetCustodian = dataset.getDatasetCustodian();
        dataSetMetadata.setDatasetCustodian(datasetCustodian);
        List<FileInfo> datasetFileInfos = FileInfoCache.getInstance().getDatasetFileInfos(dataset.getId());
        if (dataset.getType() == DatasetType.ECC) {
            dataSetMetadata.setMetadataAssignMode(MetadataAssignMode.SELF);
        } else {
            dataSetMetadata.setMetadataAssignMode(MetadataAssignMode.SELF_AND_DESCENDANTS);
        }
        HashMap<String, List> filesMetadata = new HashMap<String, List>();
        HashMap<String, Map> filesHashes = new HashMap<String, Map>();
        for (FileInfo fileInfo : datasetFileInfos) {
            String relativePath = fileInfo.getRelativePath();
            if (!(dataset.getType() != DatasetType.ECC && fileInfo.getRootFileId() != null || fileInfo.getMetadata() == null || fileInfo.getMetadata().isEmpty())) {
                filesMetadata.put(relativePath, fileInfo.getMetadata());
            }
            if (fileInfo.getDirectory().booleanValue()) continue;
            filesHashes.put(relativePath, fileInfo.getHashes());
        }
        dataSetMetadata.setFilesMetadata(filesMetadata);
        dataSetMetadata.setFilesHashes(filesHashes);
        return dataSetMetadata;
    }

    private Set<String> getJobDataSetIds(JobModel candidate) {
        TreeSet<String> dataSetIds = new TreeSet<String>();
        List sessionParameters = candidate.getSessionParameters();
        for (Parameter sessionParameter : sessionParameters) {
            if (!sessionParameter.getDisplayCondition().getDisplayable() || !sessionParameter.isDataSet()) continue;
            String datasetId = sessionParameter.getValue();
            dataSetIds.add(datasetId);
        }
        return dataSetIds;
    }

    private Set<String> getJobLegalHoldIds(JobModel candidate) {
        TreeSet<String> legalHoldIds = new TreeSet<String>();
        for (Parameter sessionParameter : candidate.getSessionParameters()) {
            if (!sessionParameter.isLegalHold()) continue;
            String legalHoldId = sessionParameter.getValue();
            legalHoldIds.add(legalHoldId);
        }
        return legalHoldIds;
    }

    private Set<String> getJobFileLibraryFiles(JobModel candidate, String workflowXml) {
        ExecutionProfileModel executionProfile;
        TreeSet<String> fileLibraryIds = new TreeSet<String>();
        if (candidate.getExecutionProfileId() != null && (executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(candidate.getExecutionProfileId())) != null) {
            if (executionProfile.getNuixProfiles() != null && executionProfile.getNuixProfiles().size() > 0) {
                fileLibraryIds.addAll(executionProfile.getNuixProfiles().keySet());
            }
            if (executionProfile.getAdditionalFiles() != null && executionProfile.getAdditionalFiles().size() > 0) {
                fileLibraryIds.addAll(executionProfile.getAdditionalFiles().values());
            }
        }
        try {
            WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflowXml).useReadOnlyOperations(operations -> {
                for (com.nuix.automate.workflow.core.execution.operations.Operation operation : operations) {
                    if (!(operation instanceof ConfigureParametersOperation)) continue;
                    for (StaticParameter parameter : ((ConfigureParametersOperation)operation).staticParameters) {
                        if (!ParameterType.LIBRARY_FILE.equals((Object)parameter.getParameterType())) continue;
                        fileLibraryIds.add(parameter.getValue());
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while parsing static parameters", (Throwable)e);
        }
        List sessionParameters = candidate.getSessionParameters();
        for (Parameter sessionParameter : sessionParameters) {
            if (!sessionParameter.isFile()) continue;
            String libraryFileId = sessionParameter.getValue();
            fileLibraryIds.add(libraryFileId);
        }
        return fileLibraryIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveJobFromPendingToExecution(JobDetailsModel jobDetailsModel, String remoteAddress) {
        JobResource jobResource = this;
        synchronized (jobResource) {
            String id = jobDetailsModel.getSettings().getId();
            JobDetailsModel backlogJobDetails = this.backlogJobsDetails.get(id);
            if (backlogJobDetails != null) {
                if (backlogJobDetails.getSettings().getSavedState() != null) {
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_RESUMED, "", remoteAddress));
                    Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_RESUMED, eventResult);
                } else {
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_STARTED, "", remoteAddress));
                    Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_STARTED, eventResult);
                }
            }
            this.runningJobsCachedDetails.put(jobDetailsModel.getSettings().getId(), new JobDetailsCacheModel(new DateTime(DateTimeZone.UTC).getMillis(), jobDetailsModel));
            if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.RUNNING) == 0) {
                this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.RUNNING);
            }
            this.utilizationUpdateJob(jobDetailsModel, true, false);
            this.backlogJobsDetails.remove(id);
        }
        this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_STARTED);
        this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePausedJobToStaging(JobDetailsModel jobDetailsModel, String remoteAddress) {
        JobResource jobResource = this;
        synchronized (jobResource) {
            String id = jobDetailsModel.getSettings().getId();
            jobDetailsModel.getSettings().setResubmittedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), id, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_PAUSED, "", remoteAddress));
            jobDetailsModel.getSettings().setEngineId(null);
            jobDetailsModel.getSettings().setEngineName(null);
            jobDetailsModel.getSettings().setInStaging(true);
            jobDetailsModel.getSettings().setAutoSubmitOnDate(null);
            this.runningJobsCachedDetails.remove(jobDetailsModel.getSettings().getId());
            this.schedulerApplication.getJobsDao().removeJobDetails(id, JobState.RUNNING);
            this.backlogJobsDetails.put(id, jobDetailsModel);
            if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.BACKLOG) == 0) {
                this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.BACKLOG);
            }
            this.utilizationUpdateJob(jobDetailsModel, false, false);
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_PAUSED, null, null);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_PAUSED);
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_PAUSED, eventResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetailsModel takeJobForStopping(String id) {
        JobResource jobResource = this;
        synchronized (jobResource) {
            JobDetailsModel jobDetailsModel = this.backlogJobsDetails.remove(id);
            this.schedulerApplication.getJobsDao().removeJobDetails(id, JobState.BACKLOG);
            return jobDetailsModel;
        }
    }

    public void putRunningJob(JobDetailsModel jobDetailsModel) {
        this.runningJobsCachedDetails.put(jobDetailsModel.getSettings().getId(), new JobDetailsCacheModel(new DateTime(DateTimeZone.UTC).getMillis(), jobDetailsModel));
        Long lastJobDaoUpdateMs = this.lastJobDaoUpdatesMs.get(jobDetailsModel.getSettings().getId());
        if (lastJobDaoUpdateMs == null || DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lastJobDaoUpdateMs > this.schedulerApplication.getConfiguration().getUpdateDatabaseInterval()) {
            this.lastJobDaoUpdatesMs.put(jobDetailsModel.getSettings().getId(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.RUNNING) == 0) {
                this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.RUNNING);
            }
            this.utilizationUpdateJob(jobDetailsModel, false, false);
        }
    }

    public void putFinishedJob(JobDetailsModel jobDetailsModel, String remoteAddress) {
        LOGGER.info("Tracking finished " + String.valueOf(jobDetailsModel.getSettings()));
        JobEvent notificationTrigger = null;
        jobDetailsModel.getSettings().setFinishedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
        JobDetailsCacheModel runningJobDetailsCache = this.runningJobsCachedDetails.get(jobDetailsModel.getSettings().getId());
        if (runningJobDetailsCache != null) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_ENDED, this.iu.getFormattedString("JobResource.Status", (Object)new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString()), remoteAddress));
            Job processingJob = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), jobDetailsModel.getSettings());
            if (processingJob.getError() != null && processingJob.getError().length() > 0) {
                ArrayList<Object> errors = new ArrayList<Object>();
                if (processingJob.getError() != null && processingJob.getError().length() > 0) {
                    errors.add(processingJob.getError());
                }
                if (jobDetailsModel.getOperations() != null) {
                    for (Iterator<Object> operationStatus : jobDetailsModel.getOperations()) {
                        String error = operationStatus.getError();
                        if (error == null || error.length() <= 0) continue;
                        errors.add(operationStatus.getName() + " - " + error);
                    }
                }
                JobErrors processingJobErrors = new JobErrors();
                processingJobErrors.setJob(processingJob);
                processingJobErrors.setErrors(errors);
                SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_ERROR, processingJobErrors);
            }
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.JOB_ENDED, processingJob);
        }
        Set<EngineModel> engines = this.schedulerApplication.getSchedulerEnginesResource().getEngines();
        ArrayList<EngineModel> workerAgents = new ArrayList<EngineModel>();
        ArrayList<String> workerAgentIds = new ArrayList<String>();
        for (EngineModel engineModel : engines) {
            if (!engineModel.getWorkerAgentOnly() || engineModel.getRunningJobId() == null || !engineModel.getRunningJobId().equals(jobDetailsModel.getSettings().getId())) continue;
            workerAgents.add(engineModel);
        }
        workerAgents.sort(Comparator.comparing(EngineModel::getName));
        for (EngineModel workerAgent : workerAgents) {
            workerAgentIds.add(workerAgent.getId());
        }
        jobDetailsModel.getSettings().setWorkerAgentIds(workerAgentIds);
        Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobDetailsModel.getSettings().getLibraryWorkflowId());
        this.finishedJobsDetails.put(jobDetailsModel.getSettings().getId(), jobDetailsModel);
        this.schedulerApplication.getJobsDao().removeJobDetails(jobDetailsModel.getSettings().getId(), JobState.RUNNING);
        this.runningJobsCachedDetails.remove(jobDetailsModel.getSettings().getId());
        if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.DISCONNECTED)) {
            jobDetailsModel.getSettings().setExecutionState(ExecutionState.ERROR);
            notificationTrigger = JobEvent.JOB_ERROR;
        }
        if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.FINISHED) == 0) {
            this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.FINISHED);
        }
        this.setJobRunningLog(jobDetailsModel.getSettings().getId(), new RunningLogEventsModel());
        for (String datasetId : this.getJobDataSetIds(jobDetailsModel.getSettings())) {
            Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(datasetId);
            if (dataset == null) continue;
            DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
            if (dataRepository != null) {
                JobModel jobModel = jobDetailsModel.getSettings();
                boolean shouldArchive = false;
                switch (jobModel.getExecutionState()) {
                    case FINISHED: {
                        boolean hasWarnings = Boolean.TRUE.equals(jobModel.getHasWarnings());
                        boolean hasSoftErrors = jobModel.getHasSoftErrors() == Boolean.TRUE;
                        boolean hasErrors = jobModel.hasError();
                        if (hasErrors) {
                            shouldArchive = Boolean.TRUE.equals(dataRepository.getDatasetAutoArchiveJobError());
                            break;
                        }
                        if (hasSoftErrors) {
                            shouldArchive = Boolean.TRUE.equals(dataRepository.getDatasetAutoArchiveJobSoftError());
                            break;
                        }
                        if (hasWarnings) {
                            shouldArchive = Boolean.TRUE.equals(dataRepository.getDatasetAutoArchiveJobWarning());
                            break;
                        }
                        shouldArchive = Boolean.TRUE.equals(dataRepository.getDatasetAutoArchive());
                        break;
                    }
                    case ERROR: {
                        shouldArchive = Boolean.TRUE.equals(dataRepository.getDatasetAutoArchiveJobError());
                        break;
                    }
                }
                if (shouldArchive) {
                    dataset.setState(DatasetState.ARCHIVED);
                    long lastModifiedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    dataset.setArchivedDate(Long.valueOf(lastModifiedDate));
                    dataset.setLastModifiedDate(Long.valueOf(lastModifiedDate));
                    this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.DATA_SET_ARCHIVED, this.iu.getFormattedString("DatasetResource.AuditLog.DataSet.Name", (Object)dataset.getName()), remoteAddress));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ARCHIVED, dataset);
                }
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        }
        if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.FINISHED)) {
            notificationTrigger = jobDetailsModel.getSettings().hasError() ? JobEvent.JOB_ERROR : (jobDetailsModel.getSettings().getHasSoftErrors() == Boolean.TRUE ? JobEvent.JOB_FINISHED_WITH_SOFT_ERRORS : (jobDetailsModel.getSettings().getHasWarnings() == Boolean.TRUE ? JobEvent.JOB_FINISHED_WITH_WARNINGS : JobEvent.JOB_FINISHED_SUCCESSFULLY));
        } else if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.STOPPED)) {
            notificationTrigger = JobEvent.JOB_STOPPED;
        } else if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.CANCELLED)) {
            notificationTrigger = JobEvent.JOB_CANCELED;
        } else if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.ERROR)) {
            notificationTrigger = JobEvent.JOB_ERROR;
        }
        this.utilizationUpdateJob(jobDetailsModel, false, false);
        if (jobDetailsModel.getSettings().getScheduleId() != null) {
            this.schedulerApplication.getScheduleResource().updateRunState(jobDetailsModel.getSettings());
        }
        this.archiveFinishedJobs("N/A");
        if (notificationTrigger != null) {
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, notificationTrigger);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, notificationTrigger);
        }
    }

    private void archiveJob(String jobId) {
        JobDetailsModel lastFinishedJobDetails = this.finishedJobsDetails.remove(jobId);
        this.schedulerApplication.getJobsDao().removeJobDetails(jobId);
        if (this.schedulerApplication.getJobsArchiveDao().updateJobDetails(lastFinishedJobDetails, JobState.ARCHIVED) == 0) {
            this.schedulerApplication.getJobsArchiveDao().addJobDetails(lastFinishedJobDetails, JobState.ARCHIVED);
        }
        this.migrateJobExecutionLogToArchive(jobId);
        this.migrateJobOperationMimeStats(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitStagingJobsWithAutoSubmit() {
        JobResource jobResource = this;
        synchronized (jobResource) {
            for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
                OfflineBearerUser user;
                Response mobJobToBacklogResponse;
                OfflineUser offlineUser;
                if (!jobDetailsModel.getSettings().getInStaging()) continue;
                long millis = new DateTime(DateTimeZone.UTC).getMillis();
                if (jobDetailsModel.getSettings().getAutoSubmitOnDate() == null || jobDetailsModel.getSettings().getAutoSubmitOnDate() > millis || jobDetailsModel.getSettings().getWarnings() != null && jobDetailsModel.getSettings().getWarnings().contains(this.iu.getString("JobResource.Warnings.CannotSubmit"))) continue;
                LOGGER.info("Auto-submitting " + String.valueOf(jobDetailsModel));
                String jobStaggedByUserId = jobDetailsModel.getSettings().getStagedUserId();
                if (jobStaggedByUserId == null || (offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(jobStaggedByUserId)) == null || (mobJobToBacklogResponse = this.sendProcessingJobCommand(user = new OfflineBearerUser(offlineUser), null, null, jobDetailsModel.getSettings().getId(), new JobCommand(com.nuix.automate.utils.models.api.job.Command.MOVE_TO_BACKLOG))).getStatus() == 200) continue;
                throw new IllegalStateException(mobJobToBacklogResponse.getStatusInfo().getReasonPhrase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveFinishedJobs(String remoteAddress) {
        ApplicationDao applicationDao = this.schedulerApplication.getJobsArchiveDao();
        synchronized (applicationDao) {
            long maxJobAge;
            ArrayList<JobDetailsModel> finishedList = new ArrayList<JobDetailsModel>();
            finishedList.addAll(this.finishedJobsDetails.values());
            finishedList.sort(Comparator.comparing(o -> -1L * o.getSettings().getLastStateChangedDate()));
            int maxFinishedJobs = this.schedulerApplication.getConfiguration().getArchiveJobsPastCount();
            if (maxFinishedJobs >= 0 && this.finishedJobsDetails.size() > maxFinishedJobs) {
                while (this.finishedJobsDetails.size() > maxFinishedJobs) {
                    JobDetailsModel lastFinishedJobDetails = (JobDetailsModel)finishedList.get(finishedList.size() - 1);
                    DateTime lastChangedDateTime = new DateTime((Object)lastFinishedJobDetails.getSettings().getLastStateChangedDate());
                    LOGGER.info("Archiving #" + finishedList.size() + " " + String.valueOf(lastFinishedJobDetails.getSettings()) + " with last changed on " + String.valueOf(lastChangedDateTime));
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), lastFinishedJobDetails.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_ARCHIVED, "", remoteAddress));
                    this.archiveJob(lastFinishedJobDetails.getSettings().getId());
                    finishedList.remove(finishedList.size() - 1);
                    Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), lastFinishedJobDetails.getSettings());
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_ARCHIVED, eventResult);
                }
            }
            if ((maxJobAge = this.schedulerApplication.getConfiguration().getArchiveJobsPastDuration()) >= 0L) {
                while (this.finishedJobsDetails.size() > 0) {
                    JobDetailsModel lastFinishedJobDetails = (JobDetailsModel)finishedList.get(finishedList.size() - 1);
                    long lastChangeMillis = new DateTime((Object)lastFinishedJobDetails.getSettings().getLastStateChangedDate()).getMillis();
                    long elapsedMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lastChangeMillis;
                    if (elapsedMillis / 1000L < maxJobAge) break;
                    LOGGER.info("Archiving #" + finishedList.size() + " " + String.valueOf(lastFinishedJobDetails.getSettings()) + " with age " + elapsedMillis + " ms");
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), lastFinishedJobDetails.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.JOB_ARCHIVED, "", remoteAddress));
                    this.archiveJob(lastFinishedJobDetails.getSettings().getId());
                    finishedList.remove(finishedList.size() - 1);
                    Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), lastFinishedJobDetails.getSettings());
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_ARCHIVED, eventResult);
                }
            }
        }
    }

    private void sortList(List<JobDetailsModel> list, JobQueueSortSettings sortSettings) {
        if (list == null || sortSettings == null || sortSettings.getSortField() == null) {
            return;
        }
        switch (sortSettings.getSortField()) {
            case SUBMISSION_DATE: {
                list.sort(Comparator.comparing(o -> o.getSettings().getResubmittedDate()));
                break;
            }
            case PRIORITY_SUBMISSION_DATE: {
                list.sort((o1, o2) -> {
                    int priorityComparison = Integer.valueOf(o2.getSettings().getPriority().getInt()).compareTo(o1.getSettings().getPriority().getInt());
                    if (priorityComparison == 0) {
                        return o1.getSettings().getResubmittedDate().compareTo(o2.getSettings().getResubmittedDate());
                    }
                    return priorityComparison;
                });
                break;
            }
            case CHANGED_DATE: {
                list.sort(Comparator.comparing(o -> o.getSettings().getLastStateChangedDate()));
                break;
            }
            case PRIORITY_CHANGED_DATE: {
                list.sort((o1, o2) -> {
                    int priorityComparison = Integer.valueOf(o2.getSettings().getPriority().getInt()).compareTo(o1.getSettings().getPriority().getInt());
                    if (priorityComparison == 0) {
                        return o1.getSettings().getLastStateChangedDate().compareTo(o2.getSettings().getLastStateChangedDate());
                    }
                    return priorityComparison;
                });
            }
        }
        if (JobQueueSortSettings.Order.REVERSED.equals((Object)sortSettings.getSortOrder())) {
            Collections.reverse(list);
        }
    }

    public List<Job> getJobsVisibleBy(BearerUser user) {
        ArrayList<Job> results = new ArrayList<Job>();
        ArrayList<JobDetailsModel> backLogList = new ArrayList<JobDetailsModel>();
        backLogList.addAll(this.backlogJobsDetails.values());
        JobQueueSortSettings sortSettings = this.schedulerApplication.getUserSettingsResource().getUserCategorySetting(user.getName(), JOB_QUEUE_SORT_SETTINGS_CATEGORY_NAME, JobQueueSortSettings.Queue.BACKLOG.name(), JobQueueSortSettings.class);
        this.sortList(backLogList, sortSettings);
        List<JobModel> runningOrInitializedJobs = this.getRunningOrInitializingJobs();
        Set<String> activeLocks = this.getActiveParameterLocks(runningOrInitializedJobs);
        Set<String> activeSynchronizedMatterIds = this.getSynchronizedMatterIds(runningOrInitializedJobs);
        for (JobDetailsModel jobDetailsModel : backLogList) {
            List<JobRequiredProfile> missingRequiredProfiles;
            JobModel jobModel = jobDetailsModel.getSettings();
            this.resolveJobNames(jobModel);
            JobModel jobModel2 = new JobModel(jobDetailsModel.getSettings(), true, false);
            Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel2);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            if (jobDetailsModel.getSettings().getEngineId() == null || jobDetailsModel.getSettings().getEngineId().length() == 0) {
                for (Parameter parameterModel : jobDetailsModel.getSettings().getSessionParameters()) {
                    String lockName;
                    if (!parameterModel.isLock() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0 || !activeLocks.contains(lockName = parameterModel.getName() + ":" + parameterModel.getValue())) continue;
                    result.setParameterLock(true);
                    break;
                }
                String matterId = jobDetailsModel.getSettings().getMatterId();
                com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
                if (matter != null && (matter.getSynchronizeJobs() != null && matter.getSynchronizeJobs().booleanValue() || this.schedulerApplication.getConfiguration().getSynchronizeJobsOnAllMatters()) && activeSynchronizedMatterIds.contains(matter.getId())) {
                    result.setMatterLock(true);
                }
            }
            if (result.getEngineId() != null) {
                EngineModel jobEngine = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(result.getEngineId());
                result.setEngineHasWarnings(jobEngine != null && jobEngine.getError() != null && jobEngine.getError().length() > 0);
            }
            if ((missingRequiredProfiles = this.getMissingRequiredProfiles(jobModel2.getLibraryWorkflowId(), result.getExecutionProfileId())) != null) {
                for (JobRequiredProfile profile : missingRequiredProfiles) {
                    if (!profile.getMissing()) continue;
                    result.setMissingRequiredProfiles(true);
                    break;
                }
            }
            this.resolveJobNames(result);
            results.add(result);
        }
        ArrayList<JobDetailsModel> cacheList = new ArrayList<JobDetailsModel>();
        for (String string : this.runningJobsCachedDetails.keySet()) {
            String engineId;
            boolean isStale;
            JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(string);
            cacheList.add(jobDetailsCacheModel.getJobDetailsModel());
            long remainingMs = jobDetailsCacheModel.getCreationDate() + this.schedulerApplication.getConfiguration().getJobDisconnectedTimeout() - new DateTime(DateTimeZone.UTC).getMillis();
            boolean bl = isStale = remainingMs <= 0L;
            if (isStale) {
                if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState() != ExecutionState.DISCONNECTED) {
                    engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                    LOGGER.error(jobDetailsCacheModel.getJobDetailsModel().getSettings().toString() + " on engine " + engineId + " got disconnected. Last status received at " + jobDetailsCacheModel.getCreationDate() + ". Current time is " + new DateTime(DateTimeZone.UTC).getMillis() + ". ");
                    String jobServerId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getServerId();
                    ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(jobServerId);
                    if (serverWorker != null) {
                        serverWorker.logServerTimingInfo();
                    }
                }
                jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.DISCONNECTED);
                continue;
            }
            if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState() == ExecutionState.DISCONNECTED) {
                engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                LOGGER.warn(jobDetailsCacheModel.getJobDetailsModel().getSettings().toString() + " on engine " + engineId + " reconnected.");
            }
            if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.PAUSING) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.STOPPING) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.PAUSED) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.STOPPED)) continue;
            jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.RUNNING);
        }
        sortSettings = this.schedulerApplication.getUserSettingsResource().getUserCategorySetting(user.getName(), JOB_QUEUE_SORT_SETTINGS_CATEGORY_NAME, JobQueueSortSettings.Queue.RUNNING.name(), JobQueueSortSettings.class);
        this.sortList(cacheList, sortSettings);
        Set<EngineModel> set = this.schedulerApplication.getSchedulerEnginesResource().getEngines();
        for (JobDetailsModel jobDetailsModel : cacheList) {
            boolean userIsOwnerOrIgnoreConfidential;
            boolean bl = userIsOwnerOrIgnoreConfidential = jobDetailsModel.getSettings().getSubmittedBy() != null && jobDetailsModel.getSettings().getSubmittedBy().equals(user.getName());
            if (jobDetailsModel.getSettings().getStagedBy() != null && jobDetailsModel.getSettings().getStagedBy().equals(user.getName())) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            JobModel jobModel = jobDetailsModel.getSettings();
            Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            jobModel = new JobModel(jobDetailsModel.getSettings(), true, !userIsOwnerOrIgnoreConfidential);
            ArrayList<String> workerAgentIds = new ArrayList<String>();
            ArrayList<EngineModel> workerAgents = new ArrayList<EngineModel>();
            for (EngineModel engineModel : set) {
                if (!engineModel.getWorkerAgentOnly() || engineModel.getRunningJobId() == null || !engineModel.getRunningJobId().equals(jobModel.getId())) continue;
                workerAgents.add(engineModel);
            }
            workerAgents.sort(Comparator.comparing(EngineModel::getName));
            for (EngineModel workerAgent : workerAgents) {
                workerAgentIds.add(workerAgent.getId());
            }
            jobModel.setWorkerAgentIds(workerAgentIds);
            result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            this.resolveJobNames(result);
            results.add(result);
        }
        ArrayList<JobDetailsModel> arrayList = new ArrayList<JobDetailsModel>();
        arrayList.addAll(this.finishedJobsDetails.values());
        sortSettings = this.schedulerApplication.getUserSettingsResource().getUserCategorySetting(user.getName(), JOB_QUEUE_SORT_SETTINGS_CATEGORY_NAME, JobQueueSortSettings.Queue.FINISHED.name(), JobQueueSortSettings.class);
        this.sortList(arrayList, sortSettings);
        for (JobDetailsModel jobDetailsModel : arrayList) {
            boolean userIsOwnerOrIgnoreConfidential;
            if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.STOPPING)) {
                jobDetailsModel.getSettings().setExecutionState(ExecutionState.ERROR);
            }
            if (jobDetailsModel.getSettings().getExecutionState().equals((Object)ExecutionState.DISCONNECTED)) {
                jobDetailsModel.getSettings().setExecutionState(ExecutionState.ERROR);
            }
            boolean bl = userIsOwnerOrIgnoreConfidential = jobDetailsModel.getSettings().getSubmittedBy() != null && jobDetailsModel.getSettings().getSubmittedBy().equals(user.getName());
            if (jobDetailsModel.getSettings().getStagedBy() != null && jobDetailsModel.getSettings().getStagedBy().equals(user.getName())) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            JobModel jobModel = jobDetailsModel.getSettings();
            Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            jobModel = new JobModel(jobDetailsModel.getSettings(), true, !userIsOwnerOrIgnoreConfidential);
            result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            this.resolveJobNames(result);
            results.add(result);
        }
        for (Job jobModel : results) {
            if (jobModel.getExecutionProfileId() != null && this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId()) == null) {
                jobModel.setExecutionProfileId(null);
            }
            if (jobModel.getResourcePoolId() != null && this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId()) == null) {
                jobModel.setResourcePoolId(null);
            }
            this.resolveJobUserComments(user, jobModel);
        }
        return results;
    }

    @Operation(tags={"Jobs", "Job Submission"}, operationId="ListJobs", summary="List Jobs", description="List all non-archived jobs", responses={@ApiResponse(description="The list of jobs", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @javax.ws.rs.Path(value="/list")
    @Produces(value={"application/json"})
    public Response listJobs(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The max number of items to return") @QueryParam(value="maxCount") Integer maxCount) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        List response = ResponseUtils.getConciseList(this.getJobsVisibleBy(user), (Integer)maxCount);
        String lastHash = ResponseCache.getInstance().hashObject((Object)response);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
        }
    }

    @Operation(tags={"Jobs"}, operationId="GetJobs", summary="Get Jobs", description="Get full information of all non-archived jobs. This method returns a large amount of data. Instead, use ListJobs to get a list of job IDs and GetJob to get full information for a specific job", responses={@ApiResponse(description="The list of jobs", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Job.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Produces(value={"application/json"})
    public Response getProcessingJobs(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        List<Job> response = this.getJobsVisibleBy(user);
        String lastHash = ResponseCache.getInstance().hashObject(response);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        }
    }

    private void resolveJobUserComments(BearerUser user, Job jobModel) {
        UserComment latestUserComment;
        if (jobModel.getUserPermissions().contains(Permission.VIEW) && !jobModel.getUserPermissions().contains(Permission.VIEW_LIMITED) && (latestUserComment = this.schedulerApplication.getUserCommentResource().getLatestUserCommentForObject(jobModel.getId())) != null) {
            latestUserComment = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, latestUserComment, jobModel.getUserPermissions());
            latestUserComment.setViewedByUserIds(null);
            jobModel.setLastUserComment(latestUserComment);
        }
    }

    private void resolveJobNames(Job jobModel) {
        if (jobModel.getMatterId() != null) {
            com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId());
            Client client = null;
            if (matter != null) {
                jobModel.setMatterName(matter.getName());
                jobModel.setMatterReference(matter.getReference());
                client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            } else {
                jobModel.setMatterName(null);
                jobModel.setMatterReference(null);
            }
            if (client != null) {
                jobModel.setClientName(client.getName());
                jobModel.setClientReference(client.getReference());
            } else {
                jobModel.setClientName(null);
                jobModel.setClientReference(null);
            }
        }
        if (jobModel.getLibraryWorkflowId() != null) {
            Workflow workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
            WorkflowLibrary workflowLibrary = null;
            if (workflowModel != null) {
                jobModel.setLibraryWorkflowName(workflowModel.getName());
                workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(workflowModel.getLibraryId());
            } else {
                jobModel.setLibraryWorkflowName(null);
            }
            if (workflowLibrary != null) {
                jobModel.setLibraryName(workflowLibrary.getName());
            } else {
                jobModel.setLibraryName(null);
            }
        } else {
            jobModel.setLibraryWorkflowName(null);
            jobModel.setLibraryName(null);
        }
        if (jobModel.getResourcePoolId() != null) {
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId());
            if (resourcePool != null) {
                jobModel.setResourcePoolName(resourcePool.getName());
            } else {
                jobModel.setResourcePoolName(null);
            }
        } else {
            jobModel.setResourcePoolName(null);
        }
        if (jobModel.getExecutionProfileId() != null) {
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId());
            if (executionProfile != null) {
                jobModel.setExecutionProfileName(executionProfile.getName());
            } else {
                jobModel.setExecutionProfileName(null);
            }
        } else {
            jobModel.setExecutionProfileName(null);
        }
        if (jobModel.getServerId() != null) {
            Server server = this.schedulerApplication.getServerResource().getServerWithId(jobModel.getServerId());
            if (server != null) {
                jobModel.setServerName(server.getName());
            } else {
                jobModel.setServerName(null);
            }
        } else {
            jobModel.setServerName(null);
        }
        if (jobModel.getEngineId() != null) {
            EngineModel engineModel = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(jobModel.getEngineId());
            if (engineModel != null) {
                jobModel.setEngineName(engineModel.getName());
            } else {
                jobModel.setEngineName(null);
            }
        } else {
            jobModel.setEngineName(null);
        }
        if (jobModel.getScheduleId() != null) {
            Schedule schedule = this.schedulerApplication.getScheduleResource().getSchedule(jobModel.getScheduleId());
            if (schedule != null) {
                jobModel.setScheduleName(schedule.getName());
            } else {
                jobModel.setScheduleName(null);
            }
        } else {
            jobModel.setScheduleName(null);
        }
    }

    public void resetJobNames(Job job) {
        job.setMatterName(null);
        job.setClientName(null);
        job.setLibraryName(null);
        job.setLibraryWorkflowName(null);
        job.setEngineName(null);
        job.setScheduleName(null);
        job.setServerName(null);
        job.setExecutionProfileName(null);
        job.setResourcePoolName(null);
    }

    public void resolveJobNames(JobModel jobModel) {
        if (jobModel.getMatterId() != null) {
            com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId());
            Client client = null;
            if (matter != null) {
                jobModel.setMatterName(matter.getName());
                jobModel.setMatterReference(matter.getReference());
                client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            } else {
                jobModel.setMatterName(null);
                jobModel.setMatterReference(null);
            }
            if (client != null) {
                jobModel.setClientName(client.getName());
                jobModel.setClientReference(client.getReference());
            } else {
                jobModel.setClientName(null);
                jobModel.setClientReference(null);
            }
        } else {
            jobModel.setMatterName(null);
            jobModel.setMatterReference(null);
            jobModel.setClientName(null);
            jobModel.setClientReference(null);
        }
        if (jobModel.getResourcePoolId() != null) {
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId());
            if (resourcePool != null) {
                jobModel.setResourcePoolName(resourcePool.getName());
            } else {
                jobModel.setResourcePoolName(null);
            }
        } else {
            jobModel.setResourcePoolName(null);
        }
        if (jobModel.getExecutionProfileId() != null) {
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId());
            if (executionProfile != null) {
                jobModel.setExecutionProfileName(executionProfile.getName());
            } else {
                jobModel.setExecutionProfileName(null);
            }
        } else {
            jobModel.setExecutionProfileName(null);
        }
        if (jobModel.getServerId() != null) {
            Server server = this.schedulerApplication.getServerResource().getServerWithId(jobModel.getServerId());
            if (server != null) {
                jobModel.setServerName(server.getName());
            }
        } else {
            jobModel.setServerName(null);
        }
        if (jobModel.getEngineId() != null) {
            EngineModel engineModel = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(jobModel.getEngineId());
            if (engineModel != null) {
                jobModel.setEngineName(engineModel.getName());
            }
        } else {
            jobModel.setEngineName(null);
        }
    }

    private void normalizeJobParameters(JobModel jobModel, Workflow workflow) {
        TreeMap<String, Parameter> submittedJobParameters = new TreeMap<String, Parameter>();
        for (Object submittedJobParameter : jobModel.getSessionParameters()) {
            submittedJobParameters.put(submittedJobParameter.getName(), (Parameter)submittedJobParameter);
        }
        HashSet<String> workflowParameterNames = new HashSet<String>();
        for (Parameter workflowParameter : workflow.getSessionParameters()) {
            workflowParameterNames.add(workflowParameter.getName());
            Parameter submittedJobParameter = (Parameter)submittedJobParameters.get(workflowParameter.getName());
            if (submittedJobParameter == null) continue;
            submittedJobParameter.setParameterType(workflowParameter.getParameterType());
        }
        ArrayList<Parameter> workflowParameters = new ArrayList<Parameter>();
        ArrayList<Parameter> additionalParameters = new ArrayList<Parameter>();
        boolean additionalParametersContainSeparator = false;
        for (Parameter submittedParameter : jobModel.getSessionParameters()) {
            if (workflowParameterNames.contains(submittedParameter.getName())) {
                workflowParameters.add(submittedParameter);
                continue;
            }
            if (ParameterType.SEPARATOR.equals((Object)submittedParameter.getParameterType())) {
                additionalParametersContainSeparator = true;
            }
            additionalParameters.add(submittedParameter);
        }
        if (!additionalParametersContainSeparator && additionalParameters.size() > 0) {
            ArrayList<Parameter> normalizedParameters = new ArrayList<Parameter>();
            normalizedParameters.addAll(workflowParameters);
            Parameter separatorParameter = new Parameter("{additional_parameters_separator}", this.iu.getString("JobSubmission.AdditionalParametersSeparator"));
            separatorParameter.setParameterType(ParameterType.SEPARATOR);
            separatorParameter.setFriendlyName(this.iu.getString("JobSubmission.AdditionalParametersSeparator"));
            normalizedParameters.add(separatorParameter);
            additionalParameters.sort(Comparator.comparing(Parameter::getName));
            try {
                ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
                immutableWorkflow.useReadOnlyOperations(operations -> {
                    for (com.nuix.automate.workflow.core.execution.operations.Operation o : operations) {
                        boolean operationDisabled = false;
                        ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
                        String operationAlias = o.getOperationAlias().name().toLowerCase();
                        String operationDisabledParameterName = "{" + operationAlias + "_disabled}";
                        for (Parameter additionalParameter : additionalParameters) {
                            if (additionalParameter.getName().startsWith("{" + operationAlias)) {
                                operationParameters.add(additionalParameter);
                            }
                            if (!additionalParameter.getName().equals(operationDisabledParameterName)) continue;
                            operationDisabled = Boolean.parseBoolean(additionalParameter.getValue());
                        }
                        additionalParameters.removeAll(operationParameters);
                        if (operationDisabled) {
                            Parameter operationDisabledParameter = new Parameter(operationDisabledParameterName, String.valueOf(true));
                            operationDisabledParameter.setParameterType(ParameterType.TEXT);
                            operationDisabledParameter.setFriendlyName(this.iu.getFormattedString("Operation.Disable", (Object)o.getOperationName()));
                            normalizedParameters.add(operationDisabledParameter);
                            continue;
                        }
                        if (operationParameters.size() <= 0) continue;
                        normalizedParameters.addAll(operationParameters);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Cannot parse workflow operations", (Throwable)e);
            }
            normalizedParameters.addAll(additionalParameters);
            jobModel.setSessionParameters(normalizedParameters);
        }
    }

    @Operation(tags={"Jobs", "Job Submission"}, operationId="AddJob", summary="Add Job", description="Add a new job. If an execution profile or resource pool are not specified, default settings will be used.", responses={@ApiResponse(description="The Job that was created", content={@Content(schema=@Schema(implementation=Job.class))}), @ApiResponse(responseCode="400", description="The specified workflow and/or library is not enabled"), @ApiResponse(responseCode="403", description="Priority HIGHEST can only be used by users who can modify the Resource Pool")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addProcessingJob(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, final @io.swagger.v3.oas.annotations.Parameter(description="The job to create", schema=@Schema(implementation=JobSubmission.class)) JobModel jobModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to add " + String.valueOf(jobModel));
        boolean forceStagingJob = true;
        try {
            Response errorResponse;
            ResourcePoolModel resourcePool;
            String jobId = UidUtils.getRandom();
            if (jobModel.getPriority() == null) {
                jobModel.setPriority(com.nuix.automate.utils.models.api.job.Priority.MEDIUM);
            }
            if (jobModel.getResourcePoolId() == null) {
                jobModel.setResourcePoolId(this.schedulerApplication.getResourcePoolResource().getDefaultResourcePoolId(user));
            }
            if (jobModel.getExecutionProfileId() == null) {
                jobModel.setExecutionProfileId(this.schedulerApplication.getExecutionProfileResource().getDefaultExecutionProfileId(user));
            }
            this.schedulerApplication.getUserSettingsResource().getUserCategorySetting(user.getName(), JOB_QUEUE_SORT_SETTINGS_CATEGORY_NAME, JobQueueSortSettings.Queue.BACKLOG.name(), JobQueueSortSettings.class);
            if (jobModel.getResourcePoolId() != null && jobModel.getResourcePoolId().trim().length() == 0) {
                jobModel.setResourcePoolId(null);
            }
            if (jobModel.getResourcePoolId() != null && (resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId())) == null) {
                jobModel.setResourcePoolId(null);
            }
            if (jobModel.getLibraryWorkflowId() != null) {
                Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
                if (workflow == null) {
                    final String workflowId = jobModel.getLibraryWorkflowId();
                    jobModel.setLibraryWorkflowId(null);
                    jobModel.setLibraryId(null);
                    return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                        {
                            this.put("workflowId", workflowId);
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                jobModel.setLibraryId(workflow.getLibraryId());
                this.normalizeJobParameters(jobModel, workflow);
            } else {
                jobModel.setLibraryId(null);
            }
            TreeMap<String, Parameter> submittedJobParameters = new TreeMap<String, Parameter>();
            for (Parameter submittedJobParameter : jobModel.getSessionParameters()) {
                submittedJobParameters.put(submittedJobParameter.getName(), submittedJobParameter);
            }
            if (jobModel.getMatterId() != null) {
                com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId());
                if (matter == null) {
                    jobModel.setClientId(null);
                    jobModel.setMatterId(null);
                    return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                        {
                            this.put("matterId", jobModel.getMatterId());
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                jobModel.setClientId(matter.getClientId());
                Response errorResponse2 = this.schedulerApplication.getClientPoolResource().verifyJobNoClientPoolParameterConflicts(user, jobModel.getClientId());
                if (errorResponse2 != null) {
                    return errorResponse2;
                }
                for (final String datasetId : this.getJobDataSetIds(jobModel)) {
                    Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(datasetId);
                    if (dataset == null) {
                        return ExceptionUtils.toResponse((String)"cannotFindDataset", (Map)new HashMap<String, String>(){
                            {
                                this.put("datasetId", datasetId);
                            }
                        }, (Response.Status)Response.Status.NOT_FOUND);
                    }
                    if (!dataset.getMatterId().equals(jobModel.getMatterId())) {
                        return ExceptionUtils.toResponse((String)"datasetDoesNotBelongToMatter", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (dataset.isFinalized()) continue;
                    return ExceptionUtils.toResponse((String)"datasetIsNotFinalized", (Response.Status)Response.Status.BAD_REQUEST);
                }
                for (final String legalHoldId : this.getJobLegalHoldIds(jobModel)) {
                    LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(legalHoldId);
                    if (legalHold == null) {
                        return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                            {
                                this.put("legalHoldId", legalHoldId);
                            }
                        }, (Response.Status)Response.Status.NOT_FOUND);
                    }
                    if (legalHold.getMatterId().equals(jobModel.getMatterId())) continue;
                    return ExceptionUtils.toResponse((String)"legalHoldDoesNotBelongToMatter", (Response.Status)Response.Status.BAD_REQUEST);
                }
            } else {
                jobModel.setClientId(null);
            }
            if (!jobModel.getInStaging() && (errorResponse = this.getClientMatterLibraryWorkflowError(jobModel)) != null) {
                return errorResponse;
            }
            jobModel.setId(jobId);
            jobModel.setExecutionState(ExecutionState.NOT_STARTED);
            jobModel.setError(null);
            jobModel.setWarnings(new ArrayList());
            jobModel.setSoftErrors(new ArrayList());
            jobModel.setPercentageComplete(0.0);
            jobModel.setLastStateChangedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
            Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            Set jobPermissions = result.getUserPermissions();
            boolean jobHasSubmitJob = jobPermissions.contains(Permission.SUBMIT_JOB);
            boolean jobHasStageJob = jobPermissions.contains(Permission.STAGE_JOB);
            boolean bl = forceStagingJob = !jobHasSubmitJob;
            if (!(user instanceof SystemBearerUser || jobHasSubmitJob || jobHasStageJob)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            if (jobModel.getExecutionProfileId() != null && !jobModel.getExecutionProfileId().equals("")) {
                Set<String> executionProfileRequiredParameters;
                ExecutionProfileModel jobExecutionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId());
                if (jobExecutionProfile == null) {
                    return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("executionProfileId", jobModel.getExecutionProfileId());
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                if (!(user instanceof SystemBearerUser)) {
                    HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
                    resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                    resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
                    resourceIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, jobModel.getExecutionProfileId()));
                    Set<Permission> executionProfilePermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                    forceStagingJob = this.shouldForceStaging("ExecutionProfile", user, jobPermissions, executionProfilePermissions);
                }
                if ((executionProfileRequiredParameters = this.schedulerApplication.getExecutionProfileResource().getExecutionProfileRequiredParameters(jobExecutionProfile.getId())).size() > 0) {
                    final HashSet missingJobExecutionProfileParameters = new HashSet();
                    for (final String parameterName : executionProfileRequiredParameters) {
                        if (!submittedJobParameters.containsKey(parameterName) && !ExecutionContext.jobBuiltInParameters.contains(parameterName)) {
                            missingJobExecutionProfileParameters.add(parameterName);
                            continue;
                        }
                        if (submittedJobParameters.get(parameterName) == null || !((Parameter)submittedJobParameters.get(parameterName)).isProtected()) continue;
                        return ExceptionUtils.toResponse((String)"executionProfileInvalidRequiredParameter", (Map)new HashMap<String, String>(){
                            {
                                this.put("parameterName", parameterName);
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (missingJobExecutionProfileParameters.size() > 0) {
                        return ExceptionUtils.toResponse((String)"executionProfileWorkflowMissingRequiredParameters", (Map)new HashMap<String, String>(){
                            {
                                this.put("missingParameters", String.join((CharSequence)", ", missingJobExecutionProfileParameters));
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                }
                if ((jobExecutionProfile.getSchedulerUrl() == null || jobExecutionProfile.getSchedulerUrl().length() == 0) && request != null && uriInfo != null) {
                    jobExecutionProfile.setSchedulerUrl(ResourceUtils.getSchedulerUrl((HttpServletRequest)request, (UriInfo)uriInfo, (boolean)true));
                    this.schedulerApplication.getExecutionProfileResource().updateExecutionProfileInternal(jobExecutionProfile);
                }
            }
            if (jobModel.getResourcePoolId() != null && !jobModel.getResourcePoolId().equals("")) {
                if (this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId()) == null) {
                    return ExceptionUtils.toResponse((String)"resourcePoolNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("resourcePoolId", jobModel.getResourcePoolId());
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                if (!(user instanceof SystemBearerUser)) {
                    HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
                    resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                    resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
                    resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, jobModel.getResourcePoolId()));
                    Set<Permission> resourcePoolPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                    forceStagingJob = this.shouldForceStaging("ResourcePool", user, jobPermissions, resourcePoolPermissions);
                    if (jobModel.getPriority() == com.nuix.automate.utils.models.api.job.Priority.HIGHEST && !resourcePoolPermissions.contains(Permission.MODIFY)) {
                        return ExceptionUtils.toResponse((String)"priorityHighestPermission", (Response.Status)Response.Status.FORBIDDEN);
                    }
                }
            }
            List<Parameter> defaultSessionParameters = this.schedulerApplication.getLibraryResource().getLibraryWorkflowParameters(jobModel.getLibraryWorkflowId());
            HashMap<String, Parameter> defaultSessionParametersMap = new HashMap<String, Parameter>();
            for (Parameter parameter : defaultSessionParameters) {
                Parameter submittedJobParameter = (Parameter)submittedJobParameters.get(parameter.getName());
                if (submittedJobParameter == null) {
                    submittedJobParameter = new Parameter();
                    submittedJobParameter.setValue(parameter.getValue());
                    submittedJobParameter.setName(parameter.getName());
                    jobModel.getSessionParameters().add(submittedJobParameter);
                }
                defaultSessionParametersMap.put(parameter.getName(), parameter);
            }
            SymmetricKey symmetricKey = null;
            if (jobModel.getSessionParametersKeyId() != null) {
                symmetricKey = this.schedulerApplication.getAesEncryptor().decryptKey(jobModel.getSessionParametersKeyId(), 256);
            }
            for (final Parameter sessionParameter : jobModel.getSessionParameters()) {
                String decryptedValue;
                Parameter defaultSessionParameter = (Parameter)defaultSessionParametersMap.get(sessionParameter.getName());
                if (defaultSessionParameter != null) {
                    sessionParameter.setDescription(defaultSessionParameter.getDescription());
                    sessionParameter.setFriendlyName(defaultSessionParameter.getFriendlyName());
                    sessionParameter.setParameterType(defaultSessionParameter.getParameterType());
                    sessionParameter.setRegex(defaultSessionParameter.getRegex());
                    sessionParameter.setAllowedValuesMatchBy(defaultSessionParameter.getAllowedValuesMatchBy());
                    sessionParameter.setAllowedValues(defaultSessionParameter.getAllowedValues());
                    sessionParameter.setMin(defaultSessionParameter.getMin());
                    sessionParameter.setMax(defaultSessionParameter.getMax());
                    DisplayCondition defaultDisplayCondition = defaultSessionParameter.getDisplayCondition();
                    sessionParameter.setDisplayCondition(defaultDisplayCondition.clone());
                    RelativityCondition defaultRelativityCondition = defaultSessionParameter.getRelativityCondition();
                    sessionParameter.setRelativityCondition(defaultRelativityCondition.clone());
                }
                if (!sessionParameter.isProtected() && !sessionParameter.isMasked()) continue;
                if (sessionParameter.getValue() == null) {
                    if (defaultSessionParameter == null) continue;
                    String parameterValue = defaultSessionParameter.getValue();
                    try {
                        parameterValue = this.schedulerApplication.getEncryptor().decrypt(parameterValue);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot decrypt parameter " + sessionParameter.getName() + " library value", (Throwable)e);
                    }
                    sessionParameter.setValue(parameterValue);
                    continue;
                }
                if (symmetricKey == null || (decryptedValue = this.schedulerApplication.getAesEncryptor().decrypt(sessionParameter.getName(), symmetricKey, sessionParameter.getValue())) != null) continue;
                return ExceptionUtils.toResponse((String)"parameterCryptoError", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameterName", sessionParameter.getName());
                    }
                });
            }
            Map map = DisplayConditionUtils.getInstance().updateDisplayableParameters(jobModel.getSessionParameters(), this.schedulerApplication.getConfiguration().getRegexTimeout());
            ArrayList<Parameter> filteredSessionParameters = new ArrayList<Parameter>();
            for (Parameter sessionParameter : jobModel.getSessionParameters()) {
                DisplayCondition displayConditionUpdate = (DisplayCondition)map.get(sessionParameter.getName());
                if (displayConditionUpdate == null || !displayConditionUpdate.getDisplayable()) continue;
                sessionParameter.setDisplayCondition(displayConditionUpdate);
                filteredSessionParameters.add(sessionParameter);
            }
            jobModel.setSessionParameters(filteredSessionParameters);
            Map<String, Map<String, String>> parameterAllowedValuesToDisplayName = this.buildParametersAllowedValueToDisplayName(user, jobModel.getMatterId(), jobModel.getLibraryWorkflowId(), jobModel.getSessionParameters());
            for (Parameter parameter : jobModel.getSessionParameters()) {
                Map<String, String> allowedValuesToDisplayName = parameterAllowedValuesToDisplayName.get(parameter.getName());
                if (allowedValuesToDisplayName != null) {
                    String displayName = allowedValuesToDisplayName.get(parameter.getValue());
                    parameter.setUserDisplayableValue(displayName);
                } else {
                    parameter.setUserDisplayableValue(null);
                }
                if (parameter.getParameterType().equals((Object)ParameterType.DATA_SET)) {
                    Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(parameter.getValue());
                    if (dataset != null) {
                        parameter.setUserDisplayableValue(dataset.getName());
                        continue;
                    }
                    parameter.setUserDisplayableValue(null);
                    continue;
                }
                if (!parameter.getParameterType().equals((Object)ParameterType.LEGAL_HOLD)) continue;
                LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(parameter.getValue());
                if (legalHold != null) {
                    parameter.setUserDisplayableValue(legalHold.getName());
                    continue;
                }
                parameter.setUserDisplayableValue(null);
            }
            for (Parameter parameter : jobModel.getSessionParameters()) {
                if (!parameter.getDisplayCondition().getDisplayable()) continue;
                switch (parameter.getParameterType()) {
                    case SERVER_FILE: 
                    case SERVER_FOLDER: {
                        final String dataRepositoryId = parameter.getDataRepositoryId();
                        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
                        if (dataRepository == null || DatasetType.IN_PLACE != dataRepository.getType()) {
                            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                                {
                                    this.put("id", dataRepositoryId);
                                }
                            }, (Response.Status)Response.Status.NOT_FOUND);
                        }
                        if (user instanceof SystemBearerUser) break;
                        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
                        forceStagingJob = this.shouldForceStaging("DataRepository", user, jobPermissions, dataRepositoryPermissions);
                        break;
                    }
                    case AZURE_STORAGE_ACCOUNT: {
                        final String dataRepositoryId = parameter.getValue();
                        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
                        if (dataRepository == null) {
                            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                                {
                                    this.put("id", dataRepositoryId);
                                }
                            }, (Response.Status)Response.Status.NOT_FOUND);
                        }
                        if (user instanceof SystemBearerUser) break;
                        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
                        forceStagingJob = this.shouldForceStaging("DataRepository", user, jobPermissions, dataRepositoryPermissions);
                        break;
                    }
                    case PURVIEW_SERVICE: 
                    case VAULT_SERVICE: 
                    case VERITONE_SERVICE: 
                    case SMTP_SERVICE: 
                    case RELATIVITY_SERVICE: 
                    case DISCOVER_SERVICE: 
                    case ECC_SERVICE: 
                    case GEN_AI_SERVICE: 
                    case ELASTICSEARCH_SERVICE: 
                    case SEMANTIC_SERVICE: {
                        String thirdPartyServiceId = parameter.getValue();
                        ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(thirdPartyServiceId);
                        if (user instanceof SystemBearerUser) break;
                        Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
                        forceStagingJob = this.shouldForceStaging(thirdPartyService.getClass().getSimpleName(), user, jobPermissions, thirdPartyServicePermissions);
                        break;
                    }
                }
            }
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"cannotAdd", (Map)new HashMap<String, String>(){
                {
                    this.put("jobModel", String.valueOf(jobModel));
                }
            }, (Exception)e);
        }
        try {
            if (jobModel.getNotes() != null) {
                jobModel.setNotes(jobModel.getNotes().trim());
            }
            if (!(user instanceof SystemBearerUser) && forceStagingJob) {
                jobModel.setInStaging(true);
            }
            if (jobModel.getInStaging()) {
                jobModel.setStagedBy(user.getName());
                if (!(user instanceof SystemBearerUser) || jobModel.getStagedUserId() == null) {
                    jobModel.setStagedUserId(user.getId());
                }
                jobModel.setStagedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
                jobModel.setSubmittedBy(null);
                jobModel.setSubmittedDate(null);
                jobModel.setSubmitterUserId(null);
                jobModel.setOriginalSubmittedDate(null);
            } else {
                jobModel.setStagedBy(null);
                jobModel.setStagedUserId(null);
                jobModel.setStagedDate(null);
                jobModel.setSubmittedBy(user.getName());
                if (!(user instanceof SystemBearerUser) || jobModel.getSubmitterUserId() == null) {
                    jobModel.setSubmitterUserId(user.getId());
                }
                jobModel.setSubmittedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
                jobModel.setOriginalSubmittedDate(jobModel.getSubmittedDate());
            }
            Response response = this.putNotStartedJob(jobModel, user, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
            if (response.getStatus() >= 400) {
                for (Parameter parameter : jobModel.getSessionParameters()) {
                    if (!parameter.getDisplayCondition().getDisplayable()) continue;
                    switch (parameter.getParameterType()) {
                        case DATA_SET: {
                            String datasetId = parameter.getValue();
                            Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(datasetId);
                            DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
                            if (dataRepository == null || !Boolean.TRUE.equals(dataRepository.getDatasetAutoHide())) break;
                            dataset.setState(DatasetState.HIDDEN);
                            dataset.setLastModifiedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                            this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
                            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.DATA_SET_HIDDEN, this.iu.getFormattedString("DatasetResource.AuditLog.DataSet.Name", (Object)dataset.getName()), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_HIDDEN, dataset);
                            ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
                            break;
                        }
                    }
                }
            }
            return response;
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"cannotAdd", (Map)new HashMap<String, String>(){
                {
                    this.put("jobModel", String.valueOf(jobModel));
                }
            }, (Exception)e);
        }
    }

    private boolean shouldForceStaging(String type, BearerUser user, Set<Permission> jobPermissions, Set<Permission> objectPermissions) throws ResponseException {
        boolean matchesStageJob;
        boolean forceStagingJob = false;
        if (!objectPermissions.contains(Permission.VIEW) && !objectPermissions.contains(Permission.VIEW_LIMITED)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), objectPermissions);
            throw new ResponseException(ExceptionUtils.buildForbiddenResponse());
        }
        boolean jobHasSubmitJob = jobPermissions.contains(Permission.SUBMIT_JOB);
        boolean jobHasStageJob = jobPermissions.contains(Permission.STAGE_JOB);
        boolean matchesSubmitJob = jobHasSubmitJob && objectPermissions.contains(Permission.SUBMIT_JOB);
        boolean bl = matchesStageJob = jobHasStageJob && objectPermissions.contains(Permission.STAGE_JOB);
        if (!matchesSubmitJob) {
            forceStagingJob = true;
            if (!matchesStageJob) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), objectPermissions);
                String errorResponseKey = "userDoesNotHave" + (jobHasStageJob ? "AddJob" : "StageJob") + "Permissions" + type;
                throw new ResponseException(ExceptionUtils.toResponse((String)errorResponseKey, (Response.Status)Response.Status.BAD_REQUEST));
            }
        }
        return forceStagingJob;
    }

    public void validateWorkflowSessionParameters(BearerUser user, JobModel jobModel) throws ParameterException {
        Permission allowedValuesScopePermission = jobModel.getInStaging() ? Permission.STAGE_JOB : Permission.SUBMIT_JOB;
        this.validateWorkflowSessionParameters(user, jobModel, allowedValuesScopePermission);
    }

    public void validateWorkflowSessionParameters(BearerUser user, JobModel jobModel, Permission allowedValuesScopePermission) throws ParameterException {
        List sessionParameterModels = jobModel.getSessionParameters();
        this.validateWorkflowSessionParameters(user, jobModel, sessionParameterModels, allowedValuesScopePermission);
        jobModel.setSessionParameters(sessionParameterModels);
    }

    private void validateWorkflowSessionParameters(BearerUser user, JobModel jobModel, List<Parameter> sessionParameterModels, Permission allowedValuesScopePermission) throws ParameterException {
        LinkedHashMap<String, String> parameterNameValueMap = new LinkedHashMap<String, String>();
        for (Parameter parameter : sessionParameterModels) {
            String parameterValue = parameter.isSensitive() ? com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE : parameter.getValue();
            parameterNameValueMap.put(parameter.getName(), parameterValue);
        }
        List configurationParameterModels = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId()).getSessionParameters();
        for (Parameter configurationParameterModel : configurationParameterModels) {
            if (parameterNameValueMap.containsKey(configurationParameterModel.getName())) continue;
            parameterNameValueMap.put(configurationParameterModel.getName(), configurationParameterModel.getValue());
        }
        Map<String, List<AllowedValueItem>> map = AllowedValueUtils.getInstance(this.schedulerApplication).getAllowedSessionParameterValueItems(user, jobModel.getMatterId(), jobModel.getLibraryWorkflowId(), configurationParameterModels, parameterNameValueMap, allowedValuesScopePermission, true);
        HashMap<String, Parameter> sessionParameterModelsMap = new HashMap<String, Parameter>();
        Parameters sessionParameters = new Parameters();
        for (Parameter sessionParameterModel : sessionParameterModels) {
            sessionParameterModelsMap.put(sessionParameterModel.getName(), sessionParameterModel);
            sessionParameters.put((com.nuix.automate.utils.workflow.Parameter)new StaticParameter(sessionParameterModel));
        }
        StringBuilder errorMessages = new StringBuilder();
        for (Parameter configurationParameterModel : configurationParameterModels) {
            Parameter sessionParameterModel = (Parameter)sessionParameterModelsMap.get(configurationParameterModel.getName());
            if (sessionParameterModel == null || sessionParameterModel.getParameterType() == ParameterType.SEPARATOR) continue;
            StaticParameter configurationParameter = new StaticParameter(configurationParameterModel);
            configurationParameter.setDisplayCondition(sessionParameterModel.getDisplayCondition());
            sessionParameterModel.setDescription(configurationParameterModel.getDescription());
            sessionParameterModel.setRegex(configurationParameterModel.getRegex());
            sessionParameterModel.setAllowedValuesMatchBy(configurationParameterModel.getAllowedValuesMatchBy());
            sessionParameterModel.setAllowedValues(configurationParameterModel.getAllowedValues());
            sessionParameterModel.setAllowedDataRepositoryIds(configurationParameter.getAllowedDataRepositoryIds());
            sessionParameterModel.setAllowedFileExtensions(configurationParameter.getAllowedFileExtensions());
            SymmetricKey symmetricKey = null;
            if (jobModel.getSessionParametersKeyId() != null) {
                symmetricKey = this.schedulerApplication.getAesEncryptor().decryptKey(jobModel.getSessionParametersKeyId(), 256);
            }
            if (!sessionParameterModel.getDisplayCondition().getDisplayable()) continue;
            try {
                ThirdPartyServiceSession<?, ?> session;
                String parameterValue = sessionParameterModel.getValue();
                if (sessionParameterModel.isDataSet() && parameterValue.equals("SAME_AS_TRIGGERING_DATASET")) continue;
                if (sessionParameterModel.isServerFile() || sessionParameterModel.isServerFolder()) {
                    String fileExtension;
                    Set allowedFileExtensions;
                    if (parameterValue == null || parameterValue.trim().length() == 0) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.ParameterValueMissing"));
                    }
                    if (sessionParameterModel.isServerFile() && (allowedFileExtensions = sessionParameterModel.getAllowedFileExtensions()) != null && allowedFileExtensions.size() > 0 && !allowedFileExtensions.contains(fileExtension = FileUtils.getFileExtension((String)parameterValue))) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.ParameterValueFileExtensionNotAllowed"));
                    }
                    String dataRepositoryId = sessionParameterModel.getDataRepositoryId();
                    Set allowedDataRepositoryIds = sessionParameterModel.getAllowedDataRepositoryIds();
                    if (allowedDataRepositoryIds != null && allowedDataRepositoryIds.size() > 0 && !allowedDataRepositoryIds.contains(dataRepositoryId)) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.ParameterDataRepositoryNotAllowed"));
                    }
                    DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
                    if (dataRepository == null) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.ParameterDataRepositoryNotFound"));
                    }
                    if (!dataRepository.containsPath(parameterValue)) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.ParameterValueDoesntBelongToDataRepository"));
                    }
                }
                if (sessionParameterModel.isSensitive() && symmetricKey != null) {
                    parameterValue = this.schedulerApplication.getAesEncryptor().decrypt(sessionParameterModel.getName(), symmetricKey, sessionParameterModel.getValue());
                }
                configurationParameter.checkIfValueIsValid(parameterValue, this.schedulerApplication.getConfiguration().getRegexTimeout());
                List<AllowedValueItem> allowedValueItems = map.get(sessionParameterModel.getName());
                if (allowedValueItems == null) continue;
                if (sessionParameterModel.getMultiValue()) {
                    String[] multiValues = null;
                    try {
                        multiValues = (String[])SerializationUtils.fromJson((String)sessionParameterModel.getValue(), String[].class);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to deserialize multi-select value", (Throwable)e);
                    }
                    if (multiValues == null || multiValues.length == 0) {
                        throw new IllegalArgumentException(this.iu.getString("JobResource.InvalidParameterValue"));
                    }
                    for (String multiValue : multiValues) {
                        if (!allowedValueItems.stream().noneMatch(item -> item.getValue().equals(multiValue))) continue;
                        throw new IllegalArgumentException(this.iu.getString("JobResource.InvalidParameterValue"));
                    }
                    continue;
                }
                if (sessionParameterModel.isThirdPartyServiceParameter() && sessionParameterModel.getValue() != null && (session = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSessionOrNull(sessionParameterModel.getValue(), user.getId(), true)) != null && !session.getSignedIn() && session.getService().getAuthenticationMethod() != null && session.getService().getAuthenticationMethod() != ThirdPartyAuthenticationMethod.NONE) {
                    throw new IllegalArgumentException(this.iu.getFormattedString("JobResource.ThirdPartyNotSignedIn", (Object)session.getService().getPrintableServiceType()));
                }
                if (!allowedValueItems.stream().noneMatch(item -> item.getValue().equals(sessionParameterModel.getValue()))) continue;
                throw new IllegalArgumentException(this.iu.getString("JobResource.InvalidParameterValue"));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid parameter " + sessionParameterModel.getFriendlyNameAndName(), (Throwable)e);
                if (errorMessages.length() > 0) {
                    errorMessages.append("\n");
                }
                errorMessages.append(this.iu.getFormattedString("JobResource.IllegalConfigurationParameter", new Object[]{configurationParameterModel.getFriendlyNameAndName(), e.getLocalizedMessage()}));
            }
        }
        if (errorMessages.length() > 0) {
            throw new ParameterException(errorMessages.toString());
        }
    }

    public Response putNotStartedJob(JobModel jobModel, BearerUser user, String remoteAddress) {
        EventType.Type eventType;
        jobModel.setDefaults();
        try {
            if (!jobModel.getInStaging()) {
                this.validateWorkflowSessionParameters(user, jobModel);
            }
            if (jobModel.getName() == null) {
                Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
                jobModel.setName(workflow.getName());
            }
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"invalidParameters", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
        JobDetailsModel jobDetailsModel = new JobDetailsModel();
        jobDetailsModel.setSettings(jobModel);
        try {
            String workflowXml = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId()).getOperationsXml();
            ArrayList operationStatuses = new ArrayList();
            ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflowXml);
            immutableWorkflow.useReadOnlyOperations(operations -> {
                for (com.nuix.automate.workflow.core.execution.operations.Operation o : operations) {
                    OperationStatus status = new OperationStatus();
                    status.setJobId(jobDetailsModel.getSettings().getId());
                    status.setExecutionState(ExecutionState.NOT_STARTED);
                    status.setName(o.getOperationName());
                    status.setOperationAlias(o.getOperationAlias());
                    status.setNotes(o.notes);
                    status.setUsesWorkers(o.getUsesWorkers());
                    status.setExecutionPosition(o.executionPosition);
                    status.setWorkflowPosition(o.workflowPosition);
                    status.setWarnings(new ArrayList());
                    status.setPercentageComplete(0.0);
                    status.setProgressText("");
                    status.setOptions(WorkflowRenderer.getOperationPrintableOptions((com.nuix.automate.workflow.core.execution.operations.Operation)o, (boolean)false, (boolean)true));
                    status.setSkippable(o.skippable);
                    operationStatuses.add(status);
                }
            });
            jobDetailsModel.setOperations(operationStatuses);
        }
        catch (Exception e) {
            LOGGER.error("Unable to generate operation statuses", (Throwable)e);
        }
        StringBuilder submissionDetails = new StringBuilder();
        if (jobModel.getOriginalJobId() != null && jobModel.getOriginalJobId().length() > 0) {
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.OriginalJob", (Object)jobModel.getOriginalJobId()));
        }
        if (jobModel.getScheduleId() != null && jobModel.getScheduleId().length() > 0) {
            Schedule schedule;
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            if ((schedule = this.schedulerApplication.getScheduleResource().getSchedule(jobModel.getScheduleId())) != null) {
                submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Schedule", (Object)schedule.getName()));
            }
        }
        if (jobModel.getLibraryWorkflowId() != null && jobModel.getLibraryWorkflowId().length() > 0) {
            Workflow libraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
            WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(libraryWorkflow.getLibraryId());
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Template", (Object)libraryWorkflow.getName()));
            submissionDetails.append(" (");
            submissionDetails.append(workflowLibrary.getName());
            submissionDetails.append(")");
            jobDetailsModel.getSettings().setRequiredProfiles(this.getMissingRequiredProfiles(jobDetailsModel.getSettings().getLibraryWorkflowId(), jobModel.getExecutionProfileId()));
        }
        if (jobModel.getResourcePoolId() != null && jobModel.getResourcePoolId().length() > 0) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            String resourcePoolName = null;
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(jobModel.getResourcePoolId());
            if (resourcePool != null) {
                resourcePoolName = resourcePool.getName();
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ResourcePool", (Object)resourcePoolName));
        }
        if (jobModel.getExecutionProfileId() != null && jobModel.getExecutionProfileId().length() > 0) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            Object excecutionProfileName = null;
            ExecutionProfileModel executionProfileModel = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId());
            if (executionProfileModel != null) {
                excecutionProfileName = executionProfileModel.getName();
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ExecutionProfile", excecutionProfileName));
        }
        if (jobModel.getPriority() != null && !jobModel.getPriority().equals((Object)com.nuix.automate.utils.models.api.job.Priority.MEDIUM)) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Priority", (Object)jobModel.getPriority()));
        }
        if (jobModel.getNotes() != null && jobModel.getNotes().length() > 0) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Notes", (Object)jobModel.getNotes()));
        }
        if (jobModel.getSessionParameters() != null) {
            for (Parameter parameterModel : jobModel.getSessionParameters()) {
                if (submissionDetails.length() > 0) {
                    submissionDetails.append("\n");
                }
                submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Parameter", (Object)parameterModel.getFriendlyNameAndName()));
                submissionDetails.append(": ");
                if (parameterModel.isProtected() || parameterModel.isMasked()) {
                    submissionDetails.append(com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE);
                    continue;
                }
                if (ParameterType.FILE_CONTENTS.equals((Object)parameterModel.getParameterType())) {
                    long dataSize = 0L;
                    String filename = "unknown";
                    String[] fileDataSplit = parameterModel.getValue().split(":");
                    if (fileDataSplit.length == 2) {
                        filename = fileDataSplit[0];
                        dataSize = fileDataSplit[1].length();
                    } else {
                        LOGGER.error("Unexpected parameter " + parameterModel.getName() + " value format");
                    }
                    submissionDetails.append(filename + " (" + FormattingUtils.sizeToDisplaySize((long)dataSize) + ")");
                    continue;
                }
                if (parameterModel.getUserDisplayableValue() != null) {
                    submissionDetails.append(parameterModel.getUserDisplayableValue()).append(" (").append(parameterModel.getValue()).append(")");
                    continue;
                }
                submissionDetails.append(parameterModel.getValue());
            }
        }
        if (jobModel.getAutoSubmitOnDate() != null) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.AutoSubmitOn", (Object)FormattingUtils.dateTimeToLocalString((DateTime)new DateTime((Object)jobModel.getAutoSubmitOnDate()))));
        }
        if (jobModel.getInStaging()) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            eventType = EventType.Type.JOB_ADDED_TO_STAGING;
            LOGGER.info("Adding " + String.valueOf(jobModel) + " to staging");
        } else {
            eventType = EventType.Type.JOB_SUBMITTED;
            LOGGER.info("Adding " + String.valueOf(jobModel) + " to backlog");
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), eventType, submissionDetails.toString(), remoteAddress));
        this.runningJobsCachedDetails.remove(jobDetailsModel.getSettings().getId());
        this.schedulerApplication.getJobsDao().removeJobDetails(jobModel.getId(), JobState.RUNNING);
        if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.BACKLOG) == 0) {
            this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.BACKLOG);
        }
        this.utilizationUpdateJob(jobDetailsModel, false, true);
        this.backlogJobsDetails.put(jobModel.getId(), jobDetailsModel);
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        this.resolveJobNames(result);
        this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_QUEUED);
        this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_QUEUED);
        Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        this.schedulerApplication.getWebhookWorker().triggerEvent(eventType, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public List<JobDetailsModel> getNonFinishedJobs() {
        ArrayList<JobDetailsModel> nonFinishedJobs = new ArrayList<JobDetailsModel>(this.backlogJobsDetails.values());
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            nonFinishedJobs.add(jobDetailsCacheModel.getJobDetailsModel());
        }
        return nonFinishedJobs;
    }

    public List<JobDetailsModel> getNonFinishedJobsUsingDataSet(String dataSetId) {
        ArrayList<JobDetailsModel> jobs = new ArrayList<JobDetailsModel>();
        block0: for (JobDetailsModel job : this.getNonFinishedJobs()) {
            for (Parameter sessionParameter : job.getSettings().getSessionParameters()) {
                if (!sessionParameter.isDataSet() || !dataSetId.equals(sessionParameter.getValue())) continue;
                jobs.add(job);
                continue block0;
            }
        }
        return jobs;
    }

    public List<JobDetailsModel> getNonFinishedJobsUsingLegalHold(String legalHoldId) {
        ArrayList<JobDetailsModel> jobs = new ArrayList<JobDetailsModel>();
        block0: for (JobDetailsModel job : this.getNonFinishedJobs()) {
            for (Parameter sessionParameter : job.getSettings().getSessionParameters()) {
                if (!sessionParameter.isLegalHold() || !legalHoldId.equals(sessionParameter.getValue())) continue;
                jobs.add(job);
                continue block0;
            }
        }
        return jobs;
    }

    public List<JobDetailsModel> getBacklogJobsUsingWorkflow(String workflowId) {
        ArrayList<JobDetailsModel> jobs = new ArrayList<JobDetailsModel>();
        for (JobDetailsModel jobDetailsModel : this.backlogJobsDetails.values()) {
            JobModel model = jobDetailsModel.getSettings();
            if (model == null || !workflowId.equals(model.getLibraryWorkflowId()) || model.getInStaging()) continue;
            jobs.add(jobDetailsModel);
        }
        return jobs;
    }

    public List<JobDetailsModel> getNonFinishedJobsUsingMatter(String matterId) {
        ArrayList<JobDetailsModel> jobs = new ArrayList<JobDetailsModel>();
        ArrayList<JobDetailsModel> nonFinishedJobs = new ArrayList<JobDetailsModel>(this.backlogJobsDetails.values());
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            nonFinishedJobs.add(jobDetailsCacheModel.getJobDetailsModel());
        }
        for (JobDetailsModel job : nonFinishedJobs) {
            if (!matterId.equals(job.getSettings().getMatterId())) continue;
            jobs.add(job);
        }
        return jobs;
    }

    private <T> boolean matchesFilter(Set<T> filterSet, T value) {
        return filterSet == null || filterSet.size() == 0 || filterSet.contains(value);
    }

    @Operation(tags={"Jobs"}, operationId="SetJobsDisplayFilter", summary="Set Display Filter", description="Sets the filter to use when searching for jobs, for example jobs in a specific state or submitted by a specific user", responses={@ApiResponse(description="The filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=JobFilter.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @javax.ws.rs.Path(value="/filter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setProcessingJobsDisplayFilter(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The filter") JobFilter filter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.sessionsFilter.put(user.getSessionId(), filter);
        ResponseCache.getInstance().resetKeyId(CacheKey.JOBS_LIST_FILTER, user.getSessionId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)filter).build();
    }

    @Operation(tags={"Jobs"}, operationId="GetJobDisplayFilter", summary="Get Display Filter", description="Get the current filter", responses={@ApiResponse(description="The filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=JobFilter.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @javax.ws.rs.Path(value="/filter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProcessingJobDisplayFilter(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.JOBS_LIST_FILTER, user.getSessionId());
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getSessionId());
        }
        catch (CacheException cacheException) {
            JobFilter filter = this.sessionsFilter.get(user.getSessionId());
            if (filter == null) {
                filter = new JobFilter();
                this.sessionsFilter.put(user.getSessionId(), filter);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)filter).build();
        }
    }

    @Operation(tags={"Jobs"}, operationId="PreviewJobsWithFilter", summary="Preview Jobs that match Filter", description="List the jobs that match all of the conditions in the filter, for example jobs in a specific state or submitted by a specific user", responses={@ApiResponse(description="The jobs that match the filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Job.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @javax.ws.rs.Path(value="/filterPreview")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response previewProcessingJobsWithFilter(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The filter") JobFilter filter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to preview jobs with filter");
        }
        List<Job> jobsList = this.getJobsWithFilter(user, filter);
        String lastHash = ResponseCache.getInstance().hashObject(jobsList);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(jobsList).build();
        }
    }

    @Operation(tags={"Jobs"}, operationId="GetJobsWithFilter", summary="Get Jobs with Filter", description="List the jobs that match all of the conditions in the previously set filter, for example jobs in a specific state or submitted by a specific user", responses={@ApiResponse(description="The jobs that match the filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Job.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @javax.ws.rs.Path(value="/filterResults")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProcessingJobsWithFilter(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list jobs with filter");
        }
        List<Job> jobsList = this.getJobsWithFilter(user, this.sessionsFilter.get(user.getSessionId()));
        String lastHash = ResponseCache.getInstance().hashObject(jobsList);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(jobsList).build();
        }
    }

    private List<Job> getJobsWithFilter(BearerUser user, JobFilter filter) {
        ArrayList<Job> jobsList = new ArrayList<Job>();
        int count = 0;
        for (Job jobModel : this.getJobsVisibleBy(user)) {
            boolean matchesFilter = true;
            if (filter != null) {
                if (!this.matchesFilter(filter.getClientIds(), jobModel.getClientId())) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getMatterIds(), jobModel.getMatterId())) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getEngineIds(), jobModel.getEngineId())) {
                    matchesFilter = false;
                }
                if (!(this.matchesFilter(filter.getResourcePoolIds(), jobModel.getResourcePoolId()) || jobModel.getResourcePoolId() == null && this.matchesFilter(filter.getResourcePoolIds(), ""))) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getJobIds(), jobModel.getId())) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getPriorities(), jobModel.getPriority())) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getExecutionStates(), jobModel.getExecutionState())) {
                    matchesFilter = false;
                }
                if (!this.matchesFilter(filter.getSubmitters(), jobModel.getSubmittedBy())) {
                    matchesFilter = false;
                }
                if (filter.getSubmittedDateOnOrAfter() != null) {
                    if (jobModel.getSubmittedDate() == null) {
                        matchesFilter = false;
                    } else if (filter.getSubmittedDateOnOrAfter().getMillis() > jobModel.getSubmittedDate()) {
                        matchesFilter = false;
                    }
                }
                if (filter.getSubmittedDateOnOrBefore() != null) {
                    if (jobModel.getSubmittedDate() == null) {
                        matchesFilter = false;
                    } else if (filter.getSubmittedDateOnOrBefore().getMillis() < jobModel.getSubmittedDate()) {
                        matchesFilter = false;
                    }
                }
                if (filter.getLastStateChangedDateOnOrAfter() != null) {
                    if (jobModel.getLastStateChangedDate() == null) {
                        matchesFilter = false;
                    } else if (filter.getLastStateChangedDateOnOrAfter().getMillis() > jobModel.getLastStateChangedDate()) {
                        matchesFilter = false;
                    }
                }
                if (filter.getLastStateChangedDateOnOrBefore() != null) {
                    if (jobModel.getLastStateChangedDate() == null) {
                        matchesFilter = false;
                    } else if (filter.getLastStateChangedDateOnOrBefore().getMillis() < jobModel.getLastStateChangedDate()) {
                        matchesFilter = false;
                    }
                }
            }
            if (matchesFilter) {
                ++count;
                jobsList.add(jobModel);
            }
            if (filter == null || filter.getMaxCount() == null || count < filter.getMaxCount()) continue;
            break;
        }
        return jobsList;
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @javax.ws.rs.Path(value="/archivedUsers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Set<String> listArchiveUsers(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list archive job users");
        }
        HashSet<String> userNamesSet = new HashSet<String>();
        if (user.getName() != null) {
            userNamesSet.add(user.getName());
        }
        if (this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user) || this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedAllClients(user)) {
            List<String> submittedByUsers = this.schedulerApplication.getJobsArchiveDao().getAllSubmittedBy();
            for (String submittedBy : submittedByUsers) {
                if (submittedBy == null) continue;
                userNamesSet.add(submittedBy);
            }
        }
        return userNamesSet;
    }

    @Operation(tags={"Jobs"}, operationId="ListArchivedJobs", summary="List Archived Jobs with Filter.", description="List the archived jobs that match all of the conditions in the specified filter", responses={@ApiResponse(description="The list of jobs that match the filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @javax.ws.rs.Path(value="/filterArchiveList")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listArchivedProcessingJobs(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The filter") JobArchiveFilter filter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list jobs with filter");
        }
        List<Job> jobsList = this.getArchivedJobList(user, filter);
        Integer maxCount = null;
        if (filter != null) {
            maxCount = filter.getMaxCount();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(jobsList, (Integer)maxCount)).build();
    }

    @Operation(tags={"Jobs"}, operationId="GetArchivedJobs", summary="Get Archived Jobs with Filter.", description="Get the archived jobs that match all of the conditions in the specified filter. Use ListArchivedJobs unless full information is required", responses={@ApiResponse(description="The jobs that match the filter", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Job.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @javax.ws.rs.Path(value="/filterArchive")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getArchivedProcessingJobs(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The filter") JobArchiveFilter filter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list jobs with filter");
        }
        List<Job> jobslist = this.getArchivedJobList(user, filter);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(jobslist).build();
    }

    private List<Job> getArchivedJobList(BearerUser user, JobArchiveFilter filter) {
        if (filter == null) {
            filter = new JobArchiveFilter();
            filter.setMaxCount(50);
        }
        if (filter.getLastStateChangedDateOnOrBefore() == 0L) {
            filter.setLastStateChangedDateOnOrBefore(new DateTime(DateTimeZone.UTC).getMillis());
        }
        ArrayList<Job> jobsList = new ArrayList<Job>();
        HashSet<String> submitters = new HashSet<String>();
        if (filter.getSubmitters() != null) {
            submitters.addAll(filter.getSubmitters());
        }
        if (submitters.size() == 0) {
            submitters.add("__EMPTY_LIST_SENTINEL__");
        }
        HashSet<String> clientIds = new HashSet<String>();
        if (filter.getClientIds() != null) {
            clientIds.addAll(filter.getClientIds());
        }
        if (clientIds.size() == 0) {
            clientIds.add("__EMPTY_LIST_SENTINEL__");
        }
        HashSet<String> matterIds = new HashSet<String>();
        if (filter.getMatterIds() != null) {
            matterIds.addAll(filter.getMatterIds());
        }
        if (matterIds.size() == 0) {
            matterIds.add("__EMPTY_LIST_SENTINEL__");
        }
        List<JobDetailsModel> jobDetailsModels = this.schedulerApplication.getJobsArchiveDao().getJobDetails(JobState.ARCHIVED, filter.getLastStateChangedDateOnOrBefore(), filter.getLastStateChangedDateOnOrAfter(), filter.getMaxCount(), submitters, clientIds, matterIds);
        for (JobDetailsModel jobDetailsModel : jobDetailsModels) {
            JobModel jobModel = jobDetailsModel.getSettings();
            Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            this.resolveJobNames(result);
            this.resolveJobUserComments(user, result);
            jobsList.add(result);
        }
        return jobsList;
    }

    @SecurityRequirement(name="Bearer_Token")
    @POST
    @javax.ws.rs.Path(value="/archiveExists")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean getArchiveExists(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Set<ApplicationFeatures> userFeatures = this.schedulerApplication.getUserResource().getUserFeatures(user);
        if (!userFeatures.contains(ApplicationFeatures.VIEW_JOBS)) {
            return false;
        }
        Integer jobsCount = this.schedulerApplication.getJobsArchiveDao().getJobsCount();
        return jobsCount > 0;
    }

    public JobDetailsModel getJobDetailsModel(String id) {
        return this.getJobDetailsModel(id, 3);
    }

    public JobDetailsModel getRunningJobModel(String id) {
        JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(id);
        if (jobDetailsCacheModel != null) {
            return jobDetailsCacheModel.getJobDetailsModel();
        }
        return null;
    }

    public JobDetailsModel getJobDetailsModel(String id, int retry) {
        if (id == null) {
            return null;
        }
        JobDetailsModel jobDetailsModel = this.backlogJobsDetails.get(id);
        if (jobDetailsModel != null) {
            return jobDetailsModel;
        }
        jobDetailsModel = this.finishedJobsDetails.get(id);
        if (jobDetailsModel != null) {
            return jobDetailsModel;
        }
        JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(id);
        if (jobDetailsCacheModel != null) {
            boolean isStale;
            jobDetailsModel = jobDetailsCacheModel.getJobDetailsModel();
            long remainingMs = jobDetailsCacheModel.getCreationDate() + this.schedulerApplication.getConfiguration().getJobDisconnectedTimeout() - new DateTime(DateTimeZone.UTC).getMillis();
            boolean bl = isStale = remainingMs <= 0L;
            if (isStale) {
                if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState() != ExecutionState.DISCONNECTED) {
                    String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                    LOGGER.error(jobDetailsCacheModel.getJobDetailsModel().getSettings().toString() + " on engine " + engineId + " got disconnected. Last status received at " + jobDetailsCacheModel.getCreationDate() + ". Current time is " + new DateTime(DateTimeZone.UTC).getMillis() + ". ");
                    String jobServerId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getServerId();
                    ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(jobServerId);
                    if (serverWorker != null) {
                        serverWorker.logServerTimingInfo();
                    }
                }
                jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.DISCONNECTED);
            } else {
                if (jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState() == ExecutionState.DISCONNECTED) {
                    String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                    LOGGER.warn(jobDetailsCacheModel.getJobDetailsModel().getSettings().toString() + " on engine " + engineId + " reconnected.");
                }
                if (!(jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.PAUSING) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.STOPPING) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.PAUSED) || jobDetailsCacheModel.getJobDetailsModel().getSettings().getExecutionState().equals((Object)ExecutionState.STOPPED))) {
                    jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.RUNNING);
                }
            }
            return jobDetailsModel;
        }
        jobDetailsModel = this.schedulerApplication.getJobsArchiveDao().getJobDetails(id);
        if (jobDetailsModel == null && retry > 0) {
            LOGGER.warn("Cannot get job with ID " + FormattingUtils.encodeForLog((String)id) + ". Retrying (" + retry + " left)");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Cannot retry");
            }
            return this.getJobDetailsModel(id, retry - 1);
        }
        if (jobDetailsModel == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot get job with ID " + FormattingUtils.encodeForLog((String)id) + ". Giving up.");
            }
            return null;
        }
        return jobDetailsModel;
    }

    @Operation(tags={"Jobs", "Job Submission"}, operationId="GetJobDetails", summary="Get Job Details", description="Get the full details of the job with the specified ID. This method returns a large amount of data. Instead, use GetJob to get the settings of the job", responses={@ApiResponse(description="The job details", content={@Content(schema=@Schema(implementation=JobDetails.class))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/details")
    @GET
    public Response getProcessingJobDetails(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job for which to get the details") @PathParam(value="id") String jobId) {
        Workflow workflow;
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get details for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        this.resolveJobNames(jobModel);
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        JobDetails processingJobDetails = new JobDetails(jobDetails, true);
        processingJobDetails.setSettings(result);
        if (!result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            if (result.getEngineId() != null) {
                EngineModel jobEngine = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(result.getEngineId());
                result.setEngineHasWarnings(jobEngine != null && jobEngine.getError() != null && jobEngine.getError().length() > 0);
            }
            if (result.getExecutionProfileId() != null && this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(result.getExecutionProfileId()) == null) {
                result.setExecutionProfileId(null);
            }
            if (result.getResourcePoolId() != null && this.schedulerApplication.getResourcePoolResource().getResourcePool(result.getResourcePoolId()) == null) {
                result.setResourcePoolId(null);
            }
            List<JobModel> runningOrInitializedJobs = this.getRunningOrInitializingJobs();
            Set<String> activeLocks = this.getActiveParameterLocks(runningOrInitializedJobs);
            Set<String> activeSynchronizedMatterIds = this.getSynchronizedMatterIds(runningOrInitializedJobs);
            if (processingJobDetails.getSettings().getEngineId() == null || processingJobDetails.getSettings().getEngineId().length() == 0) {
                if (processingJobDetails.getSettings().getSessionParameters() != null) {
                    for (Parameter parameterModel : processingJobDetails.getSettings().getSessionParameters()) {
                        String lockName;
                        if (!parameterModel.isLock() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0 || !activeLocks.contains(lockName = parameterModel.getName() + ":" + parameterModel.getValue())) continue;
                        result.setParameterLock(true);
                        break;
                    }
                }
                String matterId = processingJobDetails.getSettings().getMatterId();
                com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
                if (matter != null && (matter.getSynchronizeJobs() != null && matter.getSynchronizeJobs().booleanValue() || this.schedulerApplication.getConfiguration().getSynchronizeJobsOnAllMatters()) && activeSynchronizedMatterIds.contains(matter.getId())) {
                    result.setMatterLock(true);
                }
            }
            if (processingJobDetails.getSettings().getExecutionState().equals((Object)ExecutionState.RUNNING)) {
                Set<EngineModel> engines = this.schedulerApplication.getSchedulerEnginesResource().getEngines();
                ArrayList<String> workerAgentIds = new ArrayList<String>();
                ArrayList<EngineModel> workerAgents = new ArrayList<EngineModel>();
                Iterator iterator = engines.iterator();
                while (iterator.hasNext()) {
                    EngineModel engineModel = (EngineModel)iterator.next();
                    if (!engineModel.getWorkerAgentOnly() || engineModel.getRunningJobId() == null || !engineModel.getRunningJobId().equals(jobModel.getId())) continue;
                    workerAgents.add(engineModel);
                }
                workerAgents.sort(Comparator.comparing(EngineModel::getName));
                for (EngineModel workerAgent : workerAgents) {
                    workerAgentIds.add(workerAgent.getId());
                }
                processingJobDetails.getSettings().setWorkerAgentIds(workerAgentIds);
            }
            processingJobDetails.getAuditLog().clear();
            if (result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
                for (Parameter sessionParameter : jobDetails.getSettings().getSessionParameters()) {
                    if (!sessionParameter.getDisplayCondition().getDisplayable() || !sessionParameter.isDataSet() && !sessionParameter.isThirdPartyServiceParameter() && !sessionParameter.isLegalHold()) continue;
                    processingJobDetails.getAuditLog().addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(sessionParameter.getValue()));
                }
                processingJobDetails.getAuditLog().addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(jobId));
                processingJobDetails.getAuditLog().sort(Comparator.comparing(AuditEvent::getDate));
            }
        }
        if ((workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId())) != null) {
            workflow = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
        }
        if (workflow == null || !workflow.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
            for (OperationStatus status : processingJobDetails.getOperations()) {
                if (result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
                    if (status.getError() != null && status.getError().length() > 0) {
                        status.setError(FormattingUtils.constantToCamelCaseFirstUpper((String)"ERROR") + " Code " + SecurityUtils.computeShortSha256Hex((String)("Status message" + status.getError())));
                    }
                    ArrayList<CallSite> warnings = new ArrayList<CallSite>();
                    if (status.getWarnings() != null) {
                        for (String message : status.getWarnings()) {
                            warnings.add((CallSite)((Object)(FormattingUtils.constantToCamelCaseFirstUpper((String)"WARNING") + " Code " + SecurityUtils.computeShortSha256Hex((String)("Status message" + message)))));
                        }
                        status.setWarnings(warnings);
                    }
                }
                status.setOptions(null);
            }
        } else {
            try {
                HashMap executionPositionPrintableOptionMap = new HashMap();
                ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
                immutableWorkflow.useReadOnlyOperations(operations -> {
                    for (int i = 0; i < operations.size(); ++i) {
                        List operationPrintableOptions = WorkflowRenderer.getOperationPrintableOptions((com.nuix.automate.workflow.core.execution.operations.Operation)((com.nuix.automate.workflow.core.execution.operations.Operation)operations.get(i)), (boolean)false, (boolean)true);
                        executionPositionPrintableOptionMap.put(i, operationPrintableOptions);
                    }
                });
                for (int i = 0; i < processingJobDetails.getOperations().size(); ++i) {
                    OperationStatus status = (OperationStatus)processingJobDetails.getOperations().get(i);
                    status.setOptions((List)executionPositionPrintableOptionMap.get(i));
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot read workflow from XML to generate printable options, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
        this.resolveJobNames(processingJobDetails.getSettings());
        this.resolveJobUserComments(user, processingJobDetails.getSettings());
        String lastHash = ResponseCache.getInstance().hashObject((Object)processingJobDetails);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)processingJobDetails).build();
        }
    }

    @Operation(tags={"Jobs"}, operationId="GetJobSettings", summary="Get Job Settings", description="Get the settings of the job with the specified ID", responses={@ApiResponse(description="The job settings", content={@Content(schema=@Schema(implementation=JobDetails.class))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/settings")
    @GET
    public Response getProcessingJobSettings(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job for which to get the settings") @PathParam(value="id") String jobId) {
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get settings for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        this.resolveJobNames(jobModel);
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            if (result.getEngineId() != null) {
                EngineModel jobEngine = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(result.getEngineId());
                result.setEngineHasWarnings(jobEngine != null && jobEngine.getError() != null && jobEngine.getError().length() > 0);
            }
            if (result.getExecutionProfileId() != null && this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(result.getExecutionProfileId()) == null) {
                result.setExecutionProfileId(null);
            }
            if (result.getResourcePoolId() != null && this.schedulerApplication.getResourcePoolResource().getResourcePool(result.getResourcePoolId()) == null) {
                result.setResourcePoolId(null);
            }
            List<JobModel> runningOrInitializedJobs = this.getRunningOrInitializingJobs();
            Set<String> activeLocks = this.getActiveParameterLocks(runningOrInitializedJobs);
            Set<String> activeSynchronizedMatterIds = this.getSynchronizedMatterIds(runningOrInitializedJobs);
            if (result.getEngineId() == null || result.getEngineId().length() == 0) {
                if (result.getSessionParameters() != null) {
                    for (Parameter parameterModel : result.getSessionParameters()) {
                        String lockName;
                        if (!parameterModel.isLock() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0 || !activeLocks.contains(lockName = parameterModel.getName() + ":" + parameterModel.getValue())) continue;
                        result.setParameterLock(true);
                        break;
                    }
                }
                String matterId = result.getMatterId();
                com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
                if (matter != null && (matter.getSynchronizeJobs() != null && matter.getSynchronizeJobs().booleanValue() || this.schedulerApplication.getConfiguration().getSynchronizeJobsOnAllMatters()) && activeSynchronizedMatterIds.contains(matter.getId())) {
                    result.setMatterLock(true);
                }
            }
            if (result.getExecutionState().equals((Object)ExecutionState.RUNNING)) {
                Set<EngineModel> engines = this.schedulerApplication.getSchedulerEnginesResource().getEngines();
                ArrayList<String> workerAgentIds = new ArrayList<String>();
                ArrayList<EngineModel> workerAgents = new ArrayList<EngineModel>();
                for (EngineModel engineModel : engines) {
                    if (!engineModel.getWorkerAgentOnly() || engineModel.getRunningJobId() == null || !engineModel.getRunningJobId().equals(jobModel.getId())) continue;
                    workerAgents.add(engineModel);
                }
                workerAgents.sort(Comparator.comparing(EngineModel::getName));
                for (EngineModel workerAgent : workerAgents) {
                    workerAgentIds.add(workerAgent.getId());
                }
                result.setWorkerAgentIds(workerAgentIds);
            }
        }
        this.resolveJobNames(result);
        this.resolveJobUserComments(user, result);
        String lastHash = ResponseCache.getInstance().hashObject((Object)result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Jobs", "Job Submission"}, operationId="GetJob", summary="Get Job", description="Get the settings of the job with the specified ID. If the full job details are required, use GetJobDetails", responses={@ApiResponse(description="The job settings", content={@Content(schema=@Schema(implementation=JobDetails.class))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}")
    @GET
    public Response getProcessingJobMinimalSettings(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job for which to get minimal settings") @PathParam(value="id") String jobId) {
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get minimal settings for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.resetJobNames(result);
        String lastHash = ResponseCache.getInstance().hashObject((Object)result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    public boolean jobUsesWorkers(JobDetailsModel jobDetailsModel) {
        if (jobDetailsModel.getSettings().getRemoteWorkersSpec() == null || !jobDetailsModel.getSettings().getRemoteWorkersSpec().getUseRemoteWorkers() || jobDetailsModel.getSettings().getRemoteWorkersSpec().getWorkerBrokerIp() == null) {
            return false;
        }
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            if (!operationStatus.getExecutionState().equals((Object)ExecutionState.RUNNING)) continue;
            return operationStatus.getUsesWorkers();
        }
        return false;
    }

    public boolean jobHasUnfulfilledWorkers(JobDetailsModel jobDetailsModel) {
        if (jobDetailsModel.getSettings().getRemoteWorkersSpec() == null || !jobDetailsModel.getSettings().getRemoteWorkersSpec().getUseRemoteWorkers() || jobDetailsModel.getSettings().getRemoteWorkersSpec().getWorkerBrokerIp() == null) {
            return false;
        }
        return this.getUnfulfilledWorkerSize(jobDetailsModel) > 0;
    }

    public int getUnfulfilledWorkerSize(JobDetailsModel jobDetailsModel) {
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            if (!operationStatus.getExecutionState().equals((Object)ExecutionState.RUNNING) || !operationStatus.getUsesWorkers() || operationStatus.getAddedWorkerCount() == null || operationStatus.getMaximumWorkerCount() == null) continue;
            return operationStatus.getMaximumWorkerCount() - operationStatus.getAddedWorkerCount();
        }
        return 0;
    }

    public int getJobMaxWorkerCount(JobDetailsModel jobDetailsModel) {
        for (OperationStatus operationStatus : jobDetailsModel.getOperations()) {
            if (!operationStatus.getExecutionState().equals((Object)ExecutionState.RUNNING) || !operationStatus.getUsesWorkers() || operationStatus.getAddedWorkerCount() == null || operationStatus.getMaximumWorkerCount() == null) continue;
            return operationStatus.getMaximumWorkerCount();
        }
        return 0;
    }

    @Operation(tags={"Jobs"}, operationId="GetJobRequiredParameters", summary="Get Job Required Parameters", description="Get the parameters which are required by the workflow of the job with the specified ID", responses={@ApiResponse(description="The job parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Parameter.class)))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/requiredSessionParameters")
    @GET
    public Response getProcessingJobRequiredParameters(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job for which to get the required parameters") @PathParam(value="id") String jobId) {
        boolean userIsOwnerOrIgnoreConfidential;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to get required session parameters for job id " + jobId);
        JobDetailsModel jobDetailsModel = this.getJobDetailsModel(jobId);
        if (jobDetailsModel == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetailsModel.getSettings();
        JobModel result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean bl = userIsOwnerOrIgnoreConfidential = jobDetailsModel.getSettings().getSubmittedBy() != null && jobDetailsModel.getSettings().getSubmittedBy().equals(user.getName());
        if (jobDetailsModel.getSettings().getStagedBy() != null && jobDetailsModel.getSettings().getStagedBy().equals(user.getName())) {
            userIsOwnerOrIgnoreConfidential = true;
        }
        if ((result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobModel)).getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
            userIsOwnerOrIgnoreConfidential = true;
        }
        jobDetailsModel = new JobDetailsModel(jobDetailsModel, true, !userIsOwnerOrIgnoreConfidential);
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobDetailsModel.getSettings());
        JobWorkflowModel jobWorkflowModel = new JobWorkflowModel(result.getLibraryWorkflowId(), null);
        return this.getProcessingJobRequiredParameters(user, request, jobWorkflowModel);
    }

    @Operation(tags={"Jobs"}, operationId="UpdateJob", summary="Update Job", description="Update the settings of the job with the specified ID", responses={@ApiResponse(description="The job that was updated", content={@Content(schema=@Schema(implementation=Job.class))}), @ApiResponse(responseCode="400", description="Job with the specified ID does not exist, or is in a state where settings cannot be changed")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/settings")
    @PUT
    public Response updateProcessingJob(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job to update") @PathParam(value="id") String jobId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the job with") JobUpdate processingJobUpdate) {
        ServerWorker serverWorker;
        ResourcePoolModel originalResourcePool;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to update settings for job id " + jobId);
        JobModel currentJobModel = null;
        JobState jobState = null;
        JobDetailsModel jobDetailsModel = this.backlogJobsDetails.get(jobId);
        if (jobDetailsModel != null) {
            currentJobModel = jobDetailsModel.getSettings();
            jobState = JobState.BACKLOG;
        }
        if (this.finishedJobsDetails.get(jobId) != null) {
            jobDetailsModel = this.finishedJobsDetails.get(jobId);
            currentJobModel = jobDetailsModel.getSettings();
            jobState = JobState.FINISHED;
        }
        for (JobDetailsCacheModel jobDetailsCacheModel : this.runningJobsCachedDetails.values()) {
            if (!jobDetailsCacheModel.getJobDetailsModel().getSettings().getId().equals(jobId)) continue;
            jobDetailsModel = jobDetailsCacheModel.getJobDetailsModel();
            currentJobModel = jobDetailsModel.getSettings();
            jobState = JobState.RUNNING;
        }
        if (currentJobModel == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel permissionsTestModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, currentJobModel);
        Set jobPermissions = permissionsTestModel.getUserPermissions();
        boolean jobHasSubmitJob = jobPermissions.contains(Permission.SUBMIT_JOB);
        boolean jobHasStageJob = jobPermissions.contains(Permission.STAGE_JOB);
        if (!jobPermissions.contains(Permission.MODIFY) && !jobPermissions.contains(Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)permissionsTestModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!jobHasSubmitJob && !jobHasStageJob) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)permissionsTestModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (currentJobModel.confidentialitySet()) {
            boolean userIsOwnerOrIgnoreConfidential;
            boolean bl = userIsOwnerOrIgnoreConfidential = jobDetailsModel.getSettings().getSubmittedBy() != null && jobDetailsModel.getSettings().getSubmittedBy().equals(user.getName());
            if (jobDetailsModel.getSettings().getStagedBy() != null && jobDetailsModel.getSettings().getStagedBy().equals(user.getName())) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            if (jobPermissions.contains(Permission.VIEW_SENSITIVE)) {
                userIsOwnerOrIgnoreConfidential = true;
            }
            if (!userIsOwnerOrIgnoreConfidential) {
                return ExceptionUtils.toResponse((String)"cannotManageConfidentialJobPermission", (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        String originalResourcePoolId = currentJobModel.getResourcePoolId();
        String newResourcePoolId = processingJobUpdate.getResourcePoolId();
        if (newResourcePoolId != null && originalResourcePoolId != null && !newResourcePoolId.equals(originalResourcePoolId) && (originalResourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(originalResourcePoolId)) != null && originalResourcePool.isCloud()) {
            return ExceptionUtils.toResponse((String)"cannotReassignJobAssignedToCloudResourcePool", (Response.Status)Response.Status.BAD_REQUEST);
        }
        String originalExecutionProfileId = currentJobModel.getExecutionProfileId();
        HashSet<String> originalExecutionProfileIds = new HashSet<String>();
        if (originalExecutionProfileId != null) {
            originalExecutionProfileIds.add(originalExecutionProfileId);
        }
        LinkedHashMap<String, String> notificationProperties = new LinkedHashMap<String, String>();
        if (jobState == JobState.FINISHED) {
            return ExceptionUtils.toResponse((String)"cannotChangePropertiesFinishedJob", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (jobState == JobState.RUNNING) {
            Map<String, ServerWorker> serverWorkers;
            ServerWorker serverWorker2;
            StringBuilder modificationDetails = new StringBuilder();
            if (processingJobUpdate.getResourcePoolId() != null) {
                if (processingJobUpdate.getResourcePoolId().length() > 0) {
                    String resourcePoolName = null;
                    ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(processingJobUpdate.getResourcePoolId());
                    if (resourcePool != null) {
                        resourcePoolName = resourcePool.getName();
                    }
                    modificationDetails.append(this.iu.getFormattedString("JobResource.ModificationDetails.ResourcePool", (Object)resourcePoolName));
                    notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ResourcePool"), resourcePoolName);
                } else {
                    modificationDetails.append(this.iu.getFormattedString("JobResource.ModificationDetails.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
                    notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ResourcePool"), this.iu.getString("JobResource.ModificationLabel.UnassignedResourcePool"));
                }
            }
            if (processingJobUpdate.getPriority() != null && !processingJobUpdate.getPriority().equals((Object)com.nuix.automate.utils.models.api.job.Priority.MEDIUM)) {
                if (modificationDetails.length() > 0) {
                    modificationDetails.append("\n");
                }
                modificationDetails.append(this.iu.getFormattedString("JobResource.ModificationDetails.Priority", (Object)processingJobUpdate.getPriority()));
                notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.Priority"), new LocalizedEnum("SchedulerText", (Enum)processingJobUpdate.getPriority()).toString());
            }
            if (modificationDetails.length() > 0) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_MODIFIED, modificationDetails.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ModifiedBy"), user.getName());
                this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_MODIFIED, originalExecutionProfileIds, notificationProperties);
                this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_MODIFIED);
                Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_MODIFIED, eventResult, user.getName());
            }
            if ((serverWorker2 = (serverWorkers = this.schedulerApplication.getServerResource().getServerWorkers()).get(currentJobModel.getServerId())) == null) {
                return ExceptionUtils.toResponse((String)"cannotGetServerWorker", (Map)null);
            }
            try {
                JobModel jobModel = serverWorker2.updateEngineJobSettings(currentJobModel.getEngineId(), jobId, processingJobUpdate);
                jobDetailsModel.setSettings(jobModel);
                if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.BACKLOG) == 0) {
                    this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.BACKLOG);
                }
            }
            catch (ServerException e) {
                return ExceptionUtils.toResponse((String)"exception", (Map)new HashMap<String, String>(){
                    {
                        this.put("exception", e.getLocalizedMessage());
                    }
                });
            }
            return this.getProcessingJobDetails(user, request, currentJobModel.getId());
        }
        StringBuilder submissionDetails = new StringBuilder();
        boolean forceStagingJob = !jobHasSubmitJob;
        try {
            HashSet<Identifier> resourceIdentifiers;
            Set<Permission> resourcePoolPermissions;
            HashSet<Identifier> resourceIdentifiers2;
            if (processingJobUpdate.getResourcePoolId() != null && !processingJobUpdate.getResourcePoolId().equals(currentJobModel.getResourcePoolId())) {
                if (processingJobUpdate.getResourcePoolId().trim().isEmpty()) {
                    currentJobModel.setResourcePoolId(null);
                    submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
                    notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ResourcePool"), this.iu.getString("JobResource.ModificationLabel.UnassignedResourcePool"));
                } else {
                    ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(processingJobUpdate.getResourcePoolId());
                    if (resourcePool == null) {
                        processingJobUpdate.setResourcePoolId(null);
                        submissionDetails.append(this.iu.getFormattedString("JobResource.ModificationDetails.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
                        notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ResourcePool"), this.iu.getString("JobResource.ModificationLabel.UnassignedResourcePool"));
                    } else {
                        resourceIdentifiers2 = new HashSet<Identifier>();
                        resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                        resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
                        resourceIdentifiers2.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, processingJobUpdate.getResourcePoolId()));
                        resourcePoolPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers2);
                        forceStagingJob = this.shouldForceStaging("ResourcePool", user, jobPermissions, resourcePoolPermissions);
                        com.nuix.automate.utils.models.api.job.Priority updatedPriority = currentJobModel.getPriority();
                        if (processingJobUpdate.getPriority() != null && !processingJobUpdate.getPriority().equals((Object)currentJobModel.getPriority())) {
                            updatedPriority = processingJobUpdate.getPriority();
                        }
                        if (updatedPriority == com.nuix.automate.utils.models.api.job.Priority.HIGHEST && !resourcePoolPermissions.contains(Permission.MODIFY) && !resourcePoolPermissions.contains(Permission.MODIFY_CHILDREN)) {
                            return ExceptionUtils.toResponse((String)"priorityHighestPermission", (Response.Status)Response.Status.FORBIDDEN);
                        }
                        currentJobModel.setResourcePoolId(processingJobUpdate.getResourcePoolId());
                        String resourcePoolName = resourcePool.getName();
                        submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ResourcePool", (Object)resourcePoolName));
                        notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ResourcePool"), resourcePoolName);
                    }
                }
                if (currentJobModel.getExecutionState() == ExecutionState.PENDING) {
                    currentJobModel.setExecutionState(ExecutionState.NOT_STARTED);
                }
            } else if (permissionsTestModel.getResourcePoolId() != null) {
                resourceIdentifiers = new HashSet<Identifier>();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
                resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, permissionsTestModel.getResourcePoolId()));
                Set<Permission> resourcePoolPermissions2 = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                forceStagingJob = this.shouldForceStaging("ResourcePool", user, jobPermissions, resourcePoolPermissions2);
            }
            if (processingJobUpdate.getExecutionProfileId() != null && !processingJobUpdate.getExecutionProfileId().equals(currentJobModel.getExecutionProfileId())) {
                if (submissionDetails.length() > 0) {
                    submissionDetails.append("\n");
                }
                if (processingJobUpdate.getExecutionProfileId().trim().isEmpty()) {
                    currentJobModel.setExecutionProfileId(null);
                    submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ExecutionProfile", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
                    notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ExecutionProfile"), this.iu.getString("JobResource.ModificationLabel.ExecutionProfileUnassigned"));
                } else {
                    ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(processingJobUpdate.getExecutionProfileId());
                    if (executionProfile == null) {
                        processingJobUpdate.setExecutionProfileId(null);
                        submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ExecutionProfile", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
                        notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ExecutionProfile"), this.iu.getString("JobResource.ModificationLabel.ExecutionProfileUnassigned"));
                    } else {
                        resourceIdentifiers2 = new HashSet();
                        resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                        resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
                        resourceIdentifiers2.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, processingJobUpdate.getExecutionProfileId()));
                        Set<Permission> executionProfilePermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers2);
                        forceStagingJob = this.shouldForceStaging("ExecutionProfile", user, jobPermissions, executionProfilePermissions);
                        HashMap<String, Parameter> jobParameters = new HashMap<String, Parameter>();
                        for (Parameter parameter : currentJobModel.getSessionParameters()) {
                            jobParameters.put(parameter.getName(), parameter);
                        }
                        Set<String> executionProfileRequiredParameters = this.schedulerApplication.getExecutionProfileResource().getExecutionProfileRequiredParameters(executionProfile.getId());
                        if (!executionProfileRequiredParameters.isEmpty()) {
                            final HashSet<String> missingJobExecutionProfileParameters = new HashSet<String>();
                            for (final String parameterName : executionProfileRequiredParameters) {
                                if (!jobParameters.containsKey(parameterName) && !ExecutionContext.jobBuiltInParameters.contains(parameterName)) {
                                    missingJobExecutionProfileParameters.add(parameterName);
                                    continue;
                                }
                                if (jobParameters.get(parameterName) == null || !((Parameter)jobParameters.get(parameterName)).isProtected()) continue;
                                return ExceptionUtils.toResponse((String)"executionProfileInvalidRequiredParameter", (Map)new HashMap<String, String>(){
                                    {
                                        this.put("parameterName", parameterName);
                                    }
                                }, (Response.Status)Response.Status.BAD_REQUEST);
                            }
                            if (!missingJobExecutionProfileParameters.isEmpty()) {
                                return ExceptionUtils.toResponse((String)"executionProfileWorkflowMissingRequiredParameters", (Map)new HashMap<String, String>(){
                                    {
                                        this.put("missingParameters", String.join((CharSequence)", ", missingJobExecutionProfileParameters));
                                    }
                                }, (Response.Status)Response.Status.BAD_REQUEST);
                            }
                        }
                        currentJobModel.setExecutionProfileId(processingJobUpdate.getExecutionProfileId());
                        String executionProfileName = executionProfile.getName();
                        submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.ExecutionProfile", (Object)executionProfileName));
                        notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ExecutionProfile"), executionProfileName);
                    }
                }
            } else if (permissionsTestModel.getExecutionProfileId() != null) {
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
                resourceIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, permissionsTestModel.getExecutionProfileId()));
                Set<Permission> executionProfilePermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                this.shouldForceStaging("ExecutionProfile", user, jobPermissions, executionProfilePermissions);
            }
            permissionsTestModel.setPriority(processingJobUpdate.getPriority());
            permissionsTestModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, permissionsTestModel);
            jobPermissions = permissionsTestModel.getUserPermissions();
            jobHasSubmitJob = jobPermissions.contains(Permission.SUBMIT_JOB);
            jobHasStageJob = jobPermissions.contains(Permission.STAGE_JOB);
            if (!jobHasSubmitJob) {
                forceStagingJob = true;
            }
            if (!jobHasSubmitJob && !jobHasStageJob) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)permissionsTestModel);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            com.nuix.automate.utils.models.api.job.Priority updatedPriority = currentJobModel.getPriority();
            if (processingJobUpdate.getPriority() != null && !processingJobUpdate.getPriority().equals((Object)currentJobModel.getPriority())) {
                updatedPriority = processingJobUpdate.getPriority();
            }
            if (currentJobModel.getResourcePoolId() != null) {
                resourceIdentifiers2 = new HashSet();
                resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers2.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
                resourceIdentifiers2.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, currentJobModel.getResourcePoolId()));
                resourcePoolPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers2);
                this.shouldForceStaging("ResourcePool", user, jobPermissions, resourcePoolPermissions);
                if (updatedPriority == com.nuix.automate.utils.models.api.job.Priority.HIGHEST && !resourcePoolPermissions.contains(Permission.MODIFY) && !resourcePoolPermissions.contains(Permission.MODIFY_CHILDREN)) {
                    return ExceptionUtils.toResponse((String)"priorityHighestPermission", (Response.Status)Response.Status.FORBIDDEN);
                }
            }
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        if (processingJobUpdate.getPriority() != null && !processingJobUpdate.getPriority().equals((Object)currentJobModel.getPriority())) {
            currentJobModel.setPriority(processingJobUpdate.getPriority());
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Priority", (Object)processingJobUpdate.getPriority()));
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.Priority"), new LocalizedEnum("SchedulerText", (Enum)processingJobUpdate.getPriority()).toString());
        }
        if (forceStagingJob && !currentJobModel.getInStaging()) {
            currentJobModel.setInStaging(true);
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.InStaging", (Object)Boolean.TRUE.toString()));
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.InStaging"), Boolean.TRUE.toString());
        }
        if (processingJobUpdate.getNotes() != null) {
            if (submissionDetails.length() > 0) {
                submissionDetails.append("\n");
            }
            if (processingJobUpdate.getNotes().trim().length() == 0) {
                currentJobModel.setNotes(null);
                submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Notes", (Object)this.iu.getString("JobResource.SubmissionDetails.N/A")));
                notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.Notes"), this.iu.getString("JobResource.ModificationLabelNoNotes"));
            } else {
                currentJobModel.setNotes(processingJobUpdate.getNotes().trim());
                submissionDetails.append(this.iu.getFormattedString("JobResource.SubmissionDetails.Notes", (Object)processingJobUpdate.getNotes().trim()));
                notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.Notes"), processingJobUpdate.getNotes().trim());
            }
        }
        Map<String, ServerWorker> serverWorkers = this.schedulerApplication.getServerResource().getServerWorkers();
        EngineModel engineModel = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(currentJobModel.getEngineId());
        if (engineModel != null && (serverWorker = serverWorkers.get(engineModel.getServerId())) != null) {
            try {
                JobModel jobModel = serverWorker.updateEngineJobSettings(currentJobModel.getEngineId(), jobId, currentJobModel);
                jobDetailsModel.setSettings(jobModel);
                if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.BACKLOG) == 0) {
                    this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.BACKLOG);
                }
            }
            catch (ServerException e) {
                LOGGER.warn("Cannot update pending job", (Throwable)e);
            }
        }
        if (submissionDetails.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_MODIFIED, submissionDetails.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.ModifiedBy"), user.getName());
            this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_MODIFIED, originalExecutionProfileIds, notificationProperties);
            this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_MODIFIED);
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_MODIFIED, eventResult, user.getName());
        }
        if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.BACKLOG) == 0) {
            this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.BACKLOG);
        }
        currentJobModel.setModifiedBy(user.getName());
        this.utilizationUpdateJob(jobDetailsModel, false, false);
        return this.getProcessingJobDetails(user, request, currentJobModel.getId());
    }

    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflowOperations")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getJobWorkflowOperations(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The job for which to get the operations") JobModel jobModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        LOGGER.info("Parsing workflow XML");
        ArrayList operations = new ArrayList();
        try {
            Workflow result = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
            if (result != null) {
                result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, result);
            }
            boolean canViewSensitive = result != null && result.getUserPermissions() != null && result.getUserPermissions().contains(Permission.VIEW_SENSITIVE);
            String workflowXml = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId()).getOperationsXml();
            ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflowXml);
            immutableWorkflow.useReadOnlyOperations(_operations -> {
                for (com.nuix.automate.workflow.core.execution.operations.Operation o : _operations) {
                    com.nuix.automate.utils.models.api.job.Operation operation = new com.nuix.automate.utils.models.api.job.Operation();
                    operation.setNotes(o.notes);
                    operation.setOperationAlias(o.getOperationAlias());
                    operation.setName(o.getOperationName());
                    operation.setDisabled(o.disabled);
                    operation.setSoftFail(o.softFail);
                    operation.setSuppressWarnings(o.suppressWarnings);
                    operation.setEnableFieldOverwrite(o.enableFieldOverwrite);
                    operation.setOptions(null);
                    if (canViewSensitive) {
                        operation.setOptions(WorkflowRenderer.getOperationPrintableOptions((com.nuix.automate.workflow.core.execution.operations.Operation)o, (boolean)false, (boolean)true));
                    }
                    operation.setUsesWorkers(o.getUsesWorkers());
                    operation.setSkippable(o.skippable);
                    operations.add(operation);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Cannot read workflow from XML, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            return ExceptionUtils.toResponse((String)"cannotParseXMLDataWorkflow", (Map)null);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(operations).build();
    }

    boolean doesUserHavePermissionOnAnyLibrary(BearerUser user, Permission permission) {
        Set principalIdentifiers = user.getIdentifiers();
        for (SecurityPolicy securityPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                if (scopeIdentifier.getIdentifierType() == IdentifierType.LIBRARY_ID) {
                    identityInScope = true;
                    break;
                }
                if (scopeIdentifier.getIdentifierType() != IdentifierType.BUILTIN || !scopeIdentifier.getIdentifierName().equals(BuiltInScopeIdentifiers.ALL_LIBRARIES.name())) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope || !securityPolicy.getPermissions().contains(permission)) continue;
            return true;
        }
        return false;
    }

    boolean doesUserHavePermissionOnAnyWorkflow(BearerUser user, Permission permission) {
        Set principalIdentifiers = user.getIdentifiers();
        for (SecurityPolicy securityPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
            if (!securityPolicy.getEnabled().booleanValue()) continue;
            boolean identityInScope = false;
            for (Identifier principalIdentity : principalIdentifiers) {
                if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope) continue;
            identityInScope = false;
            for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                if (scopeIdentifier.getIdentifierType() != IdentifierType.WORKFLOW_ID) continue;
                identityInScope = true;
                break;
            }
            if (!identityInScope || !securityPolicy.getPermissions().contains(permission)) continue;
            return true;
        }
        return false;
    }

    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/requiredSessionParameters")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProcessingJobRequiredParameters(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The job for which to get the required parameters") JobWorkflowModel jobWorkflowModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get configuration parameters for " + String.valueOf(jobWorkflowModel));
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobWorkflowModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        LOGGER.info("Parsing workflow XML");
        String workflowXml = jobWorkflowModel.getWorkflowXml();
        try {
            Workflow workflow;
            if (workflowXml == null && (workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobWorkflowModel.getLibraryWorkflowId())) != null) {
                workflowXml = workflow.getOperationsXml();
            }
        }
        catch (Exception e) {
            LOGGER.error(this.iu.getFormattedString("JobResource.CannotReadWorkflowFromXml", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            return ExceptionUtils.toResponse((String)"cannotParseXMLDataWorkflow", (Map)null);
        }
        WorkflowExecution workflowExecution = new WorkflowExecution();
        try {
            workflowExecution.openWorkflow(workflowXml);
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"workflowNotValid", new HashMap(), (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        com.nuix.automate.workflow.core.execution.workflow.Workflow workflow = workflowExecution.getWorkflow();
        try {
            List configurationParameters = workflow.getUserParameters();
            for (Object parameterModel : configurationParameters) {
                if ((parameterModel.isProtected() || parameterModel.isMasked()) && parameterModel.getValue() != null && parameterModel.getValue().length() > 0) {
                    parameterModel.setValue(null);
                }
                if (parameterModel.getParameterType() != ParameterType.SCRIPTED) continue;
                parameterModel.setScriptCode("");
            }
            Map displayConditionUpdates = DisplayConditionUtils.getInstance().updateDisplayableParameters(configurationParameters, this.schedulerApplication.getConfiguration().getRegexTimeout());
            for (Parameter parameter : configurationParameters) {
                DisplayCondition updatedCondition = (DisplayCondition)displayConditionUpdates.get(parameter.getName());
                parameter.setDisplayCondition(updatedCondition);
            }
            String lastHash = ResponseCache.getInstance().hashObject((Object)configurationParameters);
            try {
                return ResponseCache.getInstance().getResponse(lastHash, request);
            }
            catch (CacheException cacheException) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)configurationParameters).build();
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to retrieve session parameters from workflow", (Throwable)e);
            return ExceptionUtils.toResponse((String)"exception", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
    }

    private Map<String, Map<String, String>> buildParametersAllowedValueToDisplayName(BearerUser user, String matterId, String workflowId, List<Parameter> parameters) {
        HashMap<String, Map<String, String>> parameterAllowedValuesToDisplayName = new HashMap<String, Map<String, String>>();
        ParameterUpdateSubmission templateSubmission = new ParameterUpdateSubmission();
        templateSubmission.setMatterId(matterId);
        templateSubmission.setWorkflowTemplateId(workflowId);
        LinkedHashMap<String, String> parameterValues = new LinkedHashMap<String, String>();
        for (Parameter parameter : parameters) {
            if (parameter.isThirdPartyServiceParameter()) {
                templateSubmission.getServiceIds().computeIfAbsent(parameter.getParameterType(), k -> parameter.getValue());
            }
            String parameterValue = parameter.isSensitive() ? com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE : parameter.getValue();
            parameterValues.put(parameter.getName(), parameterValue);
        }
        templateSubmission.setParameterValues(parameterValues);
        for (Parameter parameter : parameters) {
            templateSubmission.setParameter(new Parameter(parameter.getName(), parameter.getValue()));
            Response updateResponse = this.getParameterUpdates(user, templateSubmission);
            if (updateResponse.getStatus() != Response.Status.OK.getStatusCode()) continue;
            Collection parameterUpdates = (Collection)updateResponse.getEntity();
            for (ParameterUpdate update : parameterUpdates) {
                if (update.getAllowedValues() == null) continue;
                HashMap<String, String> allowedValueToName = new HashMap<String, String>();
                parameterAllowedValuesToDisplayName.put(update.getName(), allowedValueToName);
                for (AllowedValueItem allowedValueItem : update.getAllowedValues()) {
                    allowedValueToName.put(allowedValueItem.getValue(), allowedValueItem.getName());
                }
            }
        }
        return parameterAllowedValuesToDisplayName;
    }

    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/parameterUpdate")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getParameterUpdates(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="Parameter update") ParameterUpdateSubmission parameterUpdate) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get configuration parameters for " + String.valueOf(parameterUpdate));
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = user.getIdentifier().getIdentifierType().equals((Object)IdentifierType.SYSTEM_USERNAME) || this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(parameterUpdate.getMatterId());
        if (matter != null) {
            com.nuix.automate.utils.models.api.client.Matter matterResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
            if (!user.getIdentifier().getIdentifierType().equals((Object)IdentifierType.SYSTEM_USERNAME) && !matterResult.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)matter);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        HashMap<String, ParameterUpdate> updateResult = new HashMap<String, ParameterUpdate>();
        try {
            Map<String, List<AllowedValueItem>> allowedValueItems;
            List<Parameter> configurationParameters = this.schedulerApplication.getLibraryResource().getLibraryWorkflowParameters(parameterUpdate.getWorkflowTemplateId());
            Map dependantParametersDisplayable = DisplayConditionUtils.getInstance().evaluateDependantParameters(parameterUpdate.getParameter(), configurationParameters, this.schedulerApplication.getConfiguration().getRegexTimeout());
            for (Map.Entry entry : dependantParametersDisplayable.entrySet()) {
                updateResult.put((String)entry.getKey(), new ParameterUpdate((String)entry.getKey(), (Boolean)entry.getValue()));
            }
            ArrayList<Parameter> parametersRequiringAllowedValues = new ArrayList<Parameter>();
            Parameter originalParameter = null;
            for (Parameter parameter : configurationParameters) {
                if (parameter.getName().equals(parameterUpdate.getParameter().getName())) {
                    originalParameter = parameter;
                }
                if (Boolean.TRUE.equals(dependantParametersDisplayable.get(parameter.getName()))) {
                    parametersRequiringAllowedValues.add(parameter);
                    continue;
                }
                if (parameter.getParameterType() == ParameterType.SCRIPTED && parameter.getDependantParameters() != null && parameter.getDependantParameters().contains(parameterUpdate.getParameter().getName())) {
                    parametersRequiringAllowedValues.add(parameter);
                    continue;
                }
                if (parameterUpdate.getServiceIds().get(ParameterType.RELATIVITY_SERVICE) != null && !((String)parameterUpdate.getServiceIds().get(ParameterType.RELATIVITY_SERVICE)).equals("")) {
                    if (!RelativityUtils.getInstance().isRelativityParameter(parameter.getParameterType()) || !parameter.getRelativityCondition().matches(originalParameter)) continue;
                    parametersRequiringAllowedValues.add(parameter);
                    continue;
                }
                if (parameterUpdate.getServiceIds().get(ParameterType.ECC_SERVICE) == null || ((String)parameterUpdate.getServiceIds().get(ParameterType.ECC_SERVICE)).equals("") || !EccUtils.getInstance().isEccParameter(parameter.getParameterType())) continue;
                parametersRequiringAllowedValues.add(parameter);
            }
            Permission allowedValuesScopePermission = parameterUpdate.getQueueState() == JobQueueState.STAGING ? Permission.STAGE_JOB : Permission.SUBMIT_JOB;
            try {
                allowedValueItems = AllowedValueUtils.getInstance(this.schedulerApplication).getAllowedSessionParameterValueItems(user, parameterUpdate.getMatterId(), parameterUpdate.getWorkflowTemplateId(), parametersRequiringAllowedValues, parameterUpdate.getServiceIds(), parameterUpdate.getParameterValues(), allowedValuesScopePermission, false);
            }
            catch (Exception e) {
                LOGGER.error("Parameters update failed", (Throwable)e);
                return ExceptionUtils.toResponse((String)"errorEvaluatingParameterScriptedAllowedValues", (Exception)e);
            }
            for (String parameterName : allowedValueItems.keySet()) {
                ParameterUpdate update = (ParameterUpdate)updateResult.get(parameterName);
                if (update == null) {
                    update = new ParameterUpdate(parameterName, null);
                    updateResult.put(parameterName, update);
                }
                List<AllowedValueItem> parameterAllowedValueItems = allowedValueItems.get(parameterName);
                if (update.getAllowedValues() == null) {
                    update.setAllowedValues(parameterAllowedValueItems);
                    continue;
                }
                if (parameterAllowedValueItems == null) continue;
                update.getAllowedValues().removeIf(updateAllowedValueItem -> {
                    for (AllowedValueItem parameterAllowedValueItem : parameterAllowedValueItems) {
                        if (updateAllowedValueItem.getValue() == null || parameterAllowedValueItem.getValue() == null) {
                            return true;
                        }
                        if (!parameterAllowedValueItem.getValue().equals(updateAllowedValueItem.getValue())) continue;
                        return false;
                    }
                    return true;
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Parameters update failed", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(updateResult.values()).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/tsvParameters")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response parseTsvParameters(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The multi-line text to parse parameters from, with each line containing the parameter name, followed by tab, followed by the parameter value") String tsvParameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get configuration parameters for " + tsvParameters);
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        tsvParameters = (String)SerializationUtils.fromJson((String)tsvParameters, String.class);
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        List lines = FileUtils.loadVariableColumnTsv((String)tsvParameters);
        for (Object[] line : lines) {
            if (line.length <= 1) continue;
            Parameter parameterModel = new Parameter();
            String name = line[0].toString().trim();
            while (name.length() > 0 && !name.startsWith("{")) {
                name = name.substring(1);
            }
            parameterModel.setName(name);
            String value = "";
            if (line[1] != null) {
                value = line[1].toString().trim();
            }
            parameterModel.setValue(value);
            parameterList.add(parameterModel);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(parameterList).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/csvParameters")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response parseCsvParameters(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The multi-line CSV to parse parameters from, with the columns containing the parameter name and the parameter value") String csvParameters) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get configuration parameters for " + csvParameters);
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        List lines = FileUtils.loadVariableColumnCsv((String)csvParameters);
        for (Object[] line : lines) {
            if (line.length <= 1) continue;
            Parameter parameterModel = new Parameter();
            String name = line[0].toString().trim();
            while (name.length() > 0 && !name.startsWith("{")) {
                name = name.substring(1);
            }
            parameterModel.setName(name);
            String value = "";
            if (line[1] != null) {
                value = line[1].toString().trim();
            }
            parameterModel.setValue(value);
            parameterList.add(parameterModel);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(parameterList).build();
    }

    private void trackJobCommandError(BearerUser user, HttpServletRequest request, JobDetailsModel jobDetailsModel, JobCommand jobCommand, String error) {
        LOGGER.error("Cannot send " + String.valueOf(jobDetailsModel) + " " + String.valueOf(jobCommand) + ": " + error);
        if (jobCommand.getCommand().equals((Object)com.nuix.automate.utils.models.api.job.Command.MOVE_TO_BACKLOG)) {
            if (!jobDetailsModel.getSettings().getWarnings().contains(this.iu.getString("JobResource.Warnings.CannotSubmit"))) {
                jobDetailsModel.getSettings().getWarnings().add(this.iu.getString("JobResource.Warnings.CannotSubmit"));
            }
            this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel);
        }
        String formattedError = this.iu.getFormattedString("JobResource.Command.Error", new Object[]{LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)jobCommand.getCommand()), error});
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), jobDetailsModel.getSettings().getStagedBy(), EventType.Type.JOB_COMMAND_ERROR, formattedError, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_COMMAND_ERROR, eventResult, user.getName());
    }

    @Operation(tags={"Jobs"}, operationId="SendJobCommand", summary="Send Job Command", description="Send a command to the job with the specified ID, for example to stop the execution", responses={@ApiResponse(responseCode="200", description="The command execution status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Job is in a state where it cannot receive execution commands")})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/execution")
    public Response sendProcessingJobCommand(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job on which to execute the command") @PathParam(value="id") String jobId, final @io.swagger.v3.oas.annotations.Parameter(description="The command to execute") JobCommand jobActionModel) {
        boolean canModify;
        JobDetailsCacheModel jobCachedDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to set the execution state for job id " + jobId + " to " + String.valueOf(jobActionModel.getCommand()));
        JobDetailsModel jobDetailsModel = this.backlogJobsDetails.get(jobId);
        JobState jobState = JobState.BACKLOG;
        if (jobDetailsModel == null && (jobCachedDetails = this.runningJobsCachedDetails.get(jobId)) != null) {
            jobDetailsModel = jobCachedDetails.getJobDetailsModel();
            jobState = JobState.RUNNING;
        }
        if (jobDetailsModel == null) {
            jobDetailsModel = this.finishedJobsDetails.get(jobId);
            jobState = JobState.FINISHED;
        }
        if (jobDetailsModel == null) {
            jobDetailsModel = this.schedulerApplication.getJobsArchiveDao().getJobDetails(jobId);
            jobState = JobState.ARCHIVED;
        }
        if (jobDetailsModel == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetailsModel.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        Set jobPermissions = result.getUserPermissions();
        boolean bl = canModify = jobPermissions.contains(Permission.SUBMIT_JOB) && (jobPermissions.contains(Permission.MODIFY) || jobPermissions.contains(Permission.MODIFY_CHILDREN));
        if (!(user instanceof SystemBearerUser || canModify || jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.RESUBMIT_JOB && jobPermissions.contains(Permission.STAGE_JOB))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobId);
            this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!(jobPermissions.contains(Permission.EXCLUDE_METRICS) || jobActionModel.getCommand() != com.nuix.automate.utils.models.api.job.Command.METRICS_EXCLUDE && jobActionModel.getCommand() != com.nuix.automate.utils.models.api.job.Command.METRICS_INCLUDE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobId);
            this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.MOVE_TO_BACKLOG) {
            Response errorResponse;
            Set executionProfilePermissions;
            ExecutionProfileModel jobExecutionProfile;
            String executionProfileId;
            jobDetailsModel = this.backlogJobsDetails.get(jobId);
            if (jobDetailsModel == null || !jobDetailsModel.getSettings().getInStaging()) {
                return ExceptionUtils.toResponse((String)"cannotMoveJobToBacklogNotStaged", (Response.Status)Response.Status.BAD_REQUEST);
            }
            final String resourcePoolId = jobModel.getResourcePoolId();
            if (resourcePoolId != null && resourcePoolId.trim().length() > 0) {
                ResourcePoolModel jobResourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
                if (jobResourcePool == null) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.ResourcePoolNotFound"));
                    return ExceptionUtils.toResponse((String)"resourcePoolNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("resourcePoolId", resourcePoolId);
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                Set resourcePoolPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobResourcePool).getUserPermissions();
                if (!resourcePoolPermissions.contains(Permission.VIEW) || !resourcePoolPermissions.contains(Permission.SUBMIT_JOB)) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
                    return ExceptionUtils.toResponse((String)"userDoesNotHaveAddJobPermissionsResourcePool", (Response.Status)Response.Status.FORBIDDEN);
                }
            }
            if ((executionProfileId = jobModel.getExecutionProfileId()) != null && executionProfileId.trim().length() > 0) {
                jobExecutionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
                if (jobExecutionProfile == null) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.ExecutionProfileNotFound"));
                    return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("executionProfileId", executionProfileId);
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                executionProfilePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobExecutionProfile).getUserPermissions();
                if (!executionProfilePermissions.contains(Permission.VIEW) || !executionProfilePermissions.contains(Permission.SUBMIT_JOB)) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
                    return ExceptionUtils.toResponse((String)"userDoesNotHaveAddJobPermissionsExecutionProfile", (Response.Status)Response.Status.FORBIDDEN);
                }
            }
            if (executionProfileId != null && executionProfileId.trim().length() > 0) {
                jobExecutionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
                if (jobExecutionProfile == null) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.ExecutionProfileNotFound"));
                    return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("executionProfileId", executionProfileId);
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND);
                }
                executionProfilePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobExecutionProfile).getUserPermissions();
                if (!executionProfilePermissions.contains(Permission.VIEW) || !executionProfilePermissions.contains(Permission.SUBMIT_JOB)) {
                    this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
                    return ExceptionUtils.toResponse((String)"userDoesNotHaveAddJobPermissionsExecutionProfile", (Response.Status)Response.Status.FORBIDDEN);
                }
            }
            if ((errorResponse = this.getClientMatterLibraryWorkflowError(jobModel)) != null) {
                return errorResponse;
            }
            String workflowId = jobModel.getLibraryWorkflowId();
            Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
            if (jobModel.getOriginalSubmittedDate() != null && workflow.getLastModified() > jobModel.getOriginalSubmittedDate()) {
                ArrayList sessionParameters = new ArrayList();
                if (jobModel.getSessionParameters() != null) {
                    sessionParameters.addAll(jobModel.getSessionParameters());
                }
                if (workflow.getSessionParameters() != null) {
                    sessionParameters.addAll(workflow.getSessionParameters());
                }
                Iterator iterator = sessionParameters.iterator();
                while (iterator.hasNext()) {
                    Parameter sessionParameter = (Parameter)iterator.next();
                    if (!sessionParameter.isMasked() && !sessionParameter.isProtected()) continue;
                    return ExceptionUtils.toResponse((String)"cannotResubmitJobWorkflowHasProtectedParameters", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            try {
                for (Parameter parameter : jobModel.getSessionParameters()) {
                    if (!parameter.getDisplayCondition().getDisplayable()) continue;
                    switch (parameter.getParameterType()) {
                        case SERVER_FILE: 
                        case SERVER_FOLDER: {
                            final String dataRepositoryId = parameter.getDataRepositoryId();
                            DataRepository jobDataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
                            if (jobDataRepository == null) {
                                this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.DataRepositoryNotFound"));
                                return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                                    {
                                        this.put("id", dataRepositoryId);
                                    }
                                }, (Response.Status)Response.Status.NOT_FOUND);
                            }
                            Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDataRepository).getUserPermissions();
                            if (dataRepositoryPermissions.contains(Permission.VIEW) && dataRepositoryPermissions.contains(Permission.SUBMIT_JOB)) break;
                            this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
                            return ExceptionUtils.toResponse((String)"userDoesNotHaveAddJobPermissionsDataRepository", (Response.Status)Response.Status.FORBIDDEN);
                        }
                        case PURVIEW_SERVICE: 
                        case VAULT_SERVICE: 
                        case VERITONE_SERVICE: 
                        case SMTP_SERVICE: 
                        case RELATIVITY_SERVICE: 
                        case DISCOVER_SERVICE: 
                        case ECC_SERVICE: 
                        case GEN_AI_SERVICE: 
                        case ELASTICSEARCH_SERVICE: 
                        case SEMANTIC_SERVICE: {
                            String thirdPartyServiceId = parameter.getValue();
                            ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(thirdPartyServiceId);
                            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
                            if (thirdPartyServicePermissions.contains(Permission.VIEW) && thirdPartyServicePermissions.contains(Permission.SUBMIT_JOB)) break;
                            this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.UserDoesNotHavePermissions"));
                            return ExceptionUtils.toResponse((String)("userDoesNotHaveAddJobPermissions" + thirdPartyService.getClass().getSimpleName()), (Response.Status)Response.Status.FORBIDDEN);
                        }
                    }
                }
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
            try {
                this.validateWorkflowSessionParameters(user, jobModel, Permission.SUBMIT_JOB);
            }
            catch (Exception e) {
                this.trackJobCommandError(user, request, jobDetailsModel, jobActionModel, this.iu.getString("JobCommand.Error.InvalidParameters"));
                return ExceptionUtils.toResponse((String)"invalidParameters", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
            }
            jobDetailsModel.getSettings().setInStaging(false);
            jobDetailsModel.getSettings().setSubmittedBy(user.getName());
            if (!(user instanceof SystemBearerUser) || jobDetailsModel.getSettings().getSubmitterUserId() == null) {
                jobDetailsModel.getSettings().setSubmitterUserId(user.getId());
            }
            jobModel.setSubmittedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
            jobDetailsModel.getSettings().getWarnings().remove(this.iu.getString("JobResource.Warnings.CannotSubmit"));
            this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_SUBMITTED_FROM_STAGING, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_SUBMITTED_FROM_STAGING, eventResult, user.getName());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("commandSentSuccessfully")).build();
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.MOVE_TO_STAGING) {
            jobDetailsModel = this.backlogJobsDetails.get(jobId);
            if (jobDetailsModel == null) {
                return ExceptionUtils.toResponse((String)"cannotMoveJobToStagingNotBacklog", (Response.Status)Response.Status.BAD_REQUEST);
            }
            jobDetailsModel.getSettings().setInStaging(true);
            jobDetailsModel.getSettings().setSubmittedBy(null);
            jobDetailsModel.getSettings().setSubmitterUserId(null);
            jobDetailsModel.getSettings().setSubmittedDate(null);
            jobDetailsModel.getSettings().setAutoSubmitOnDate(null);
            jobDetailsModel.getSettings().setStagedBy(user.getName());
            if (!(user instanceof SystemBearerUser) || jobDetailsModel.getSettings().getStagedUserId() == null) {
                jobDetailsModel.getSettings().setStagedUserId(user.getId());
            }
            jobModel.setStagedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_MOVED_TO_STAGING, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_MOVED_TO_STAGING, eventResult, user.getName());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("commandSentSuccessfully")).build();
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.RESUBMIT_JOB) {
            Response archiveResponse;
            Object notes;
            boolean archived = false;
            jobDetailsModel = this.finishedJobsDetails.get(jobId);
            if (jobDetailsModel == null) {
                jobDetailsModel = this.schedulerApplication.getJobsArchiveDao().getJobDetails(jobId);
                archived = true;
            }
            if (jobDetailsModel == null) {
                return ExceptionUtils.toResponse((String)"cannotResubmitJobNotFinished", (Response.Status)Response.Status.BAD_REQUEST);
            }
            final String workflowId = jobModel.getLibraryWorkflowId();
            Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
            if (workflow == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", workflowId);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (jobModel.getSubmittedDate() != null && workflow.getLastModified() > jobModel.getSubmittedDate()) {
                ArrayList sessionParameters = new ArrayList();
                if (jobModel.getSessionParameters() != null) {
                    sessionParameters.addAll(jobModel.getSessionParameters());
                }
                if (workflow.getSessionParameters() != null) {
                    sessionParameters.addAll(workflow.getSessionParameters());
                }
                for (Parameter sessionParameter : sessionParameters) {
                    if (!sessionParameter.isMasked() && !sessionParameter.isProtected()) continue;
                    return ExceptionUtils.toResponse((String)"cannotResubmitJobWorkflowHasProtectedParameters", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if ((notes = jobDetailsModel.getSettings().getNotes()) == null) {
                notes = "";
            }
            if (((String)(notes = ((String)notes).trim())).length() > 0) {
                notes = (String)notes + "\n\n";
            }
            JobModel jobResubmission = jobDetailsModel.getSettings().buildResubmission();
            jobResubmission.setNotes((String)notes + this.iu.getFormattedString("JobResource.ResubmittedJob", (Object)FormattingUtils.dateTimeToLocalString((DateTime)new DateTime((Object)jobDetailsModel.getSettings().getSubmittedDate()))));
            Response resubmissionResponse = this.addProcessingJob(user, request, uriInfo, jobResubmission);
            if (resubmissionResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                LOGGER.error("Failed to resubmit Job");
                return resubmissionResponse;
            }
            jobDetailsModel.getSettings().setNotes((String)notes + this.iu.getFormattedString("JobResource.JobWasResubmitted", (Object)FormattingUtils.dateTimeToLocalString((DateTime)DateTime.now())));
            if (archived) {
                this.schedulerApplication.getJobsArchiveDao().updateJobDetails(jobDetailsModel);
            } else {
                this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel);
            }
            Job resubmittedJob = (Job)resubmissionResponse.getEntity();
            String auditLogDetails = this.iu.getFormattedString("JobResource.SubmissionDetails.ResubmittedJob", (Object)resubmittedJob.getId());
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_RESUBMITTED, auditLogDetails, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_RESUBMITTED, eventResult);
            if (jobActionModel.getAutoArchive() != Boolean.FALSE && !archived && canModify && (archiveResponse = this.sendProcessingJobCommand(user, request, uriInfo, jobId, new JobCommand(com.nuix.automate.utils.models.api.job.Command.ARCHIVE))).getStatus() != Response.Status.OK.getStatusCode()) {
                LOGGER.error("Failed to archive Job after resubmission");
                return archiveResponse;
            }
            return resubmissionResponse;
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.CANCEL) {
            try {
                jobDetailsModel = this.backlogJobsDetails.get(jobId);
                if (jobDetailsModel != null) {
                    jobDetailsModel = this.schedulerApplication.getJobResource().takeJobForStopping(jobId);
                    jobDetailsModel.getSettings().setExecutionState(ExecutionState.CANCELLED);
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_CANCEL_REQUESTED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_CANCEL_REQUESTED, new JobId(jobId), user.getName());
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_CANCELED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                    Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_CANCELED, eventResult);
                    jobDetailsModel.getSettings().setLastStateChangedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                    String formattedDate = FormattingUtils.dateTimeToLocalString((DateTime)new DateTime(DateTimeZone.UTC));
                    this.schedulerApplication.getJobsDao().addExecutionLog(jobDetailsModel.getSettings().getId(), LogLevel.EXECUTION.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), "".getBytes(StandardCharsets.UTF_8));
                    this.schedulerApplication.getJobsDao().addExecutionLog(jobDetailsModel.getSettings().getId(), LogLevel.ERROR.name(), DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis(), this.iu.getFormattedString("JobResource.JobCanceled", (Object)formattedDate).getBytes(StandardCharsets.UTF_8));
                    Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobDetailsModel.getSettings().getLibraryWorkflowId());
                    jobDetailsModel.getSettings().clearSensitiveValues();
                    this.finishedJobsDetails.put(jobId, jobDetailsModel);
                    if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.FINISHED) == 0) {
                        this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.FINISHED);
                    }
                    this.utilizationUpdateJob(jobDetailsModel, false, false);
                    if (jobDetailsModel.getSettings().getScheduleId() != null) {
                        this.schedulerApplication.getScheduleResource().updateRunState(jobDetailsModel.getSettings());
                    }
                    this.archiveFinishedJobs(ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
                    LinkedHashMap<String, String> additionalEvents = new LinkedHashMap<String, String>();
                    additionalEvents.put(this.iu.getString("JobResource.ModificationLabel.CancelledBy"), user.getName());
                    this.schedulerApplication.getNotificationsHandler().triggerNotificationEvent(jobDetailsModel, JobEvent.JOB_CANCELED, null, additionalEvents);
                    this.schedulerApplication.getScheduleWorker().triggerJobEvent(jobDetailsModel, JobEvent.JOB_CANCELED);
                    return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("commandSentSuccessfully")).build();
                }
                return ExceptionUtils.toResponse((String)"cannotCancelJobItStarted", (Map)null);
            }
            catch (Exception e) {
                LOGGER.error("Cannot cancel job", (Throwable)e);
                return ExceptionUtils.toResponse((String)"cannotCancelJob", null, (Exception)e);
            }
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.STOP) {
            try {
                JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(jobId);
                if (jobDetailsCacheModel != null) {
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_STOP_REQUESTED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_STOP_REQUESTED, new JobId(jobId), user.getName());
                    String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                    EngineCommand engineCommand = new EngineCommand();
                    engineCommand.setCommand(Command.STOP);
                    engineCommand.setJobId(jobId);
                    jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.STOPPING);
                    return this.schedulerApplication.getSchedulerEnginesResource().schedulerSendEngineCommand(user, engineId, engineCommand);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot stop job", (Throwable)e);
                return ExceptionUtils.toResponse((String)"cannotStopJob", null, (Exception)e);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotStopJobItCurrently", values);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.ABORT) {
            JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(jobId);
            if (jobDetailsCacheModel != null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_ABORT_REQUESTED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_ABORT_REQUESTED, new JobId(jobId), user.getName());
                String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                EngineCommand engineCommand = new EngineCommand();
                engineCommand.setCommand(Command.ABORT);
                engineCommand.setJobId(jobId);
                return this.schedulerApplication.getSchedulerEnginesResource().schedulerSendEngineCommand(user, engineId, engineCommand);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotAbortJobItCurrently", values);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.SKIP) {
            JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(jobId);
            if (jobDetailsCacheModel != null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_OPERATION_SKIP_REQUESTED, "Operation #" + (jobActionModel.getOperationId() + 1), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_OPERATION_SKIP_REQUESTED, new JobOperationId(jobId, jobActionModel.getOperationId() + 1), user.getName());
                String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                EngineCommand engineCommand = new EngineCommand();
                engineCommand.setCommand(Command.SKIP);
                engineCommand.setOperationId(jobActionModel.getOperationId());
                engineCommand.setJobId(jobId);
                return this.schedulerApplication.getSchedulerEnginesResource().schedulerSendEngineCommand(user, engineId, engineCommand);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotSkipOperationCurrently", values);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.ARCHIVE) {
            if (this.finishedJobsDetails.get(jobId) != null) {
                JobModel archivedJob = this.finishedJobsDetails.get(jobId).getSettings();
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_ARCHIVED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.archiveJob(jobId);
                Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), archivedJob);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_ARCHIVED, eventResult, user.getName());
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("commandSentSuccessfully")).build();
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotArchiveJobItCurrently", values);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.PAUSE || jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.HARD_PAUSE) {
            JobDetailsCacheModel jobDetailsCacheModel = this.runningJobsCachedDetails.get(jobId);
            if (jobDetailsCacheModel != null) {
                String comments = "";
                if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.HARD_PAUSE) {
                    comments = this.iu.getString("JobResource.Comments.Type.Hard");
                }
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.JOB_PAUSE_REQUESTED, comments, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.JOB_PAUSE_REQUESTED, new JobId(jobId), user.getName());
                String engineId = jobDetailsCacheModel.getJobDetailsModel().getSettings().getEngineId();
                EngineCommand engineCommand = new EngineCommand();
                if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.PAUSE) {
                    engineCommand.setCommand(Command.PAUSE);
                } else if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.HARD_PAUSE) {
                    engineCommand.setCommand(Command.HARD_PAUSE);
                } else {
                    return ExceptionUtils.toResponse((String)"unexpectedPauseCommand", (Map)new HashMap<String, String>(){
                        {
                            this.put("jobActionModel", String.valueOf(jobActionModel.getCommand()));
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                engineCommand.setJobId(jobId);
                jobDetailsCacheModel.getJobDetailsModel().getSettings().setExecutionState(ExecutionState.PAUSING);
                return this.schedulerApplication.getSchedulerEnginesResource().schedulerSendEngineCommand(user, engineId, engineCommand);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotPauseJobItCurrently", values);
        }
        if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.METRICS_EXCLUDE || jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.METRICS_INCLUDE) {
            Job eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
            if (jobState == JobState.ARCHIVED || jobState == JobState.FINISHED) {
                EventType auditEventType;
                boolean utilizationExclude;
                if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.METRICS_EXCLUDE && !jobDetailsModel.getSettings().getExcludeUtilization()) {
                    utilizationExclude = true;
                    auditEventType = new EventType(EventType.Type.JOB_METRICS_EXCLUDED);
                } else if (jobActionModel.getCommand() == com.nuix.automate.utils.models.api.job.Command.METRICS_INCLUDE && jobDetailsModel.getSettings().getExcludeUtilization()) {
                    utilizationExclude = false;
                    auditEventType = new EventType(EventType.Type.JOB_METRICS_REINCLUDED);
                } else {
                    return ExceptionUtils.toResponse((String)"unexpectedCommand", (Map)new HashMap<String, String>(){
                        {
                            this.put("commandModel", String.valueOf(jobActionModel.getCommand()));
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                jobDetailsModel.getSettings().setExcludeUtilization(utilizationExclude);
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), jobDetailsModel.getSettings().getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), auditEventType, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(auditEventType.getType(), eventResult, user.getName());
                if (jobState == JobState.FINISHED) {
                    if (this.schedulerApplication.getJobsDao().updateJobDetails(jobDetailsModel, JobState.FINISHED) == 0) {
                        this.schedulerApplication.getJobsDao().addJobDetails(jobDetailsModel, JobState.FINISHED);
                    }
                } else if (jobState == JobState.ARCHIVED) {
                    this.schedulerApplication.getJobsArchiveDao().updateJobDetails(jobDetailsModel, JobState.ARCHIVED);
                }
                this.utilizationUpdateJob(jobDetailsModel, false, false);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("commandSentSuccessfully")).build();
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("jobState", new LocalizedEnum((Enum)jobDetailsModel.getSettings().getExecutionState()).toString());
            return ExceptionUtils.toResponse((String)"cannotChangeUtilizationInState", values);
        }
        return ExceptionUtils.toResponse((String)"unexpectedCommand", (Map)new HashMap<String, String>(){
            {
                this.put("commandModel", String.valueOf(jobActionModel.getCommand()));
            }
        }, (Response.Status)Response.Status.BAD_REQUEST);
    }

    public Response getClientMatterLibraryWorkflowError(final JobModel jobModel) {
        if (jobModel.getLibraryWorkflowId() != null) {
            final Workflow libraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(jobModel.getLibraryWorkflowId());
            if (libraryWorkflow == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", jobModel.getLibraryWorkflowId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!libraryWorkflow.getEnabled().booleanValue()) {
                return ExceptionUtils.toResponse((String)"libraryWorkflowNotEnabled", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(libraryWorkflow.getLibraryId());
            if (workflowLibrary == null) {
                return ExceptionUtils.toResponse((String)"cannotFindLibrary", (Map)new HashMap<String, String>(){
                    {
                        this.put("libraryId", libraryWorkflow.getLibraryId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!workflowLibrary.getEnabled().booleanValue()) {
                return ExceptionUtils.toResponse((String)"libraryNotEnabled", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            jobModel.setLibraryId(workflowLibrary.getId());
        }
        if (jobModel.getMatterId() != null) {
            final com.nuix.automate.utils.models.api.client.Matter matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId());
            if (matter == null) {
                return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                    {
                        this.put("matterId", jobModel.getMatterId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!matter.getEnabled().booleanValue()) {
                return ExceptionUtils.toResponse((String)"matterNotEnabled", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            Client client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            if (client == null) {
                return ExceptionUtils.toResponse((String)"clientIdNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("clientId", matter.getClientId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!client.getEnabled().booleanValue()) {
                return ExceptionUtils.toResponse((String)"clientNotEnabled", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        return null;
    }

    @Operation(tags={"Jobs"}, operationId="SendJobsCommand", summary="Send Jobs Command", description="Send a command to the jobs with the specified IDs, for example to stop the execution", responses={@ApiResponse(responseCode="200", description="The commands execution status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/execution")
    public Response sendProcessingJobsCommand(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, @io.swagger.v3.oas.annotations.Parameter(description="The commands to execute on jobs with IDs") JobsCommand processingJobsCommand) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to set the execution state for job id " + String.join((CharSequence)"; ", processingJobsCommand.getJobIds()) + " to " + String.valueOf(processingJobsCommand.getCommand()));
        HashMap<String, Object> responses = new HashMap<String, Object>();
        for (String jobId : processingJobsCommand.getJobIds()) {
            if (responses.containsKey(jobId)) continue;
            Response response = this.sendProcessingJobCommand(user, request, uriInfo, jobId, new JobCommand(processingJobsCommand.getCommand()));
            responses.put(jobId, response.getEntity());
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(responses).build();
    }

    @Operation(tags={"Dummy"}, operationId="DummyJobEvents", summary="Dummy Job Events", description="Dummy endpoints containing job events sample responses", responses={@ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobInfos.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobWarnings.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobSoftErrors.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobErrors.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobId.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=JobOperationId.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/dummy")
    public Response dummy() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/executionLog")
    public Response getExecutionLog(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The job ID") @PathParam(value="id") String jobId, @io.swagger.v3.oas.annotations.Parameter(description="The timestamp of the last update") @QueryParam(value="lastUpdate") long lastUpdate) {
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get details for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new JobExecutionLogUpdate(0L, new ArrayList())).build();
        }
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ApplicationDao jobDao = this.schedulerApplication.getJobsDao();
        List<Object> executionLogs = new ArrayList();
        long lastModifiedJobExecutionLog = jobDao.getLastModifiedJobExecutionLog(jobId);
        if (lastModifiedJobExecutionLog == 0L && this.schedulerApplication.getJobsDao() != this.schedulerApplication.getJobsArchiveDao()) {
            jobDao = this.schedulerApplication.getJobsArchiveDao();
            lastModifiedJobExecutionLog = jobDao.getLastModifiedJobExecutionLog(jobId);
        }
        if (lastUpdate == 0L) {
            executionLogs = jobDao.getJobExecutionLog(jobId);
        } else if (lastModifiedJobExecutionLog > lastUpdate) {
            executionLogs = jobDao.getJobExecutionLog(jobId, lastUpdate);
        }
        JobExecutionLogUpdate executionLogUpdate = new JobExecutionLogUpdate(lastModifiedJobExecutionLog, executionLogs);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)executionLogUpdate).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/operationMimeTypeStats")
    public Response getOperationStats(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The job ID") @PathParam(value="id") String jobId) {
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get details for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(new HashMap()).build();
        }
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        HashMap<Integer, MimeTypeStatsTable> operationMimeTypeStats = new HashMap<Integer, MimeTypeStatsTable>();
        JobOperationMimeTypeStats stats = this.schedulerApplication.getJobsDao().getJobOperationMimeTypeStats(jobId);
        if (stats == null && this.schedulerApplication.getJobsDao() != this.schedulerApplication.getJobsArchiveDao()) {
            stats = this.schedulerApplication.getJobsArchiveDao().getJobOperationMimeTypeStats(jobId);
        }
        if (stats != null && stats.getMimeTypeStats() != null) {
            for (OperationMimeTypeStats stat : stats.getMimeTypeStats()) {
                ArrayList sortedMimeTypeStats = new ArrayList(stat.getOperationMimeTypeStats().values());
                sortedMimeTypeStats.sort(Comparator.comparing(MimeTypeStat::getProcessed).reversed());
                MimeTypeStatsTable table = new MimeTypeStatsTable();
                table.setRows(sortedMimeTypeStats);
                LinkedHashSet columns = new LinkedHashSet();
                HashSet emptySortedColumns = new HashSet();
                emptySortedColumns.addAll(stat.getSortedStageNames());
                columns.addAll(stat.getSortedStageNames());
                for (MimeTypeStat mimeStat : sortedMimeTypeStats) {
                    columns.addAll(mimeStat.getColumnItemCount().keySet());
                    emptySortedColumns.removeAll(mimeStat.getColumnItemCount().keySet());
                }
                columns.removeAll(emptySortedColumns);
                table.setColumns(columns);
                if (jobDetails.getOperations().size() <= stat.getOperationIndex()) continue;
                table.setOperationName(((OperationStatus)jobDetails.getOperations().get(stat.getOperationIndex())).getName());
                operationMimeTypeStats.put(stat.getOperationIndex() + 1, table);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(operationMimeTypeStats).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/runningLog")
    public Response getRunningLog(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The job ID") @PathParam(value="id") String jobId) {
        RunningLogEventsModel processingJobRunningLog;
        JobDetailsModel jobDetails;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get details for job id " + jobId);
        }
        if ((jobDetails = this.getJobDetailsModel(jobId)) == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new RunningLogEventsModel()).build();
        }
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        RunningLogEventsModel runningLog = new RunningLogEventsModel();
        if (result.getUserPermissions().contains(Permission.VIEW_SENSITIVE) && (processingJobRunningLog = this.jobRunningLogs.get(jobId)) != null) {
            runningLog = processingJobRunningLog;
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)runningLog).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/requiredProfiles")
    public Response getProcessingJobRequiredNuixProfiles(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The execution profile ID") JobModel jobModel) {
        String executionProfileId;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        String string = executionProfileId = jobModel.getExecutionProfileId() == null ? "" : jobModel.getExecutionProfileId();
        if (jobModel.getId() != null) {
            jobModel = this.getJobDetailsModel(jobModel.getId()).getSettings();
        }
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        boolean userIsAllowed = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.SUBMIT_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.STAGE_JOB);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY);
        userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyLibrary(user, Permission.MODIFY_CHILDREN);
        boolean bl = userIsAllowed = userIsAllowed || this.doesUserHavePermissionOnAnyWorkflow(user, Permission.MODIFY);
        if (!userIsAllowed) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobModel.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (executionProfileId.length() > 0) {
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            resourceIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, executionProfileId));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB)) {
                return ExceptionUtils.toResponse((String)"userDoesNotHaveSubmitExecutionProfile", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        ArrayList requiredProfiles = jobModel.getRequiredProfiles();
        this.updateRequiredProfiles(requiredProfiles, executionProfileId);
        if (requiredProfiles == null) {
            requiredProfiles = new ArrayList();
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(requiredProfiles).build();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(new HashSet(requiredProfiles)).build();
    }

    private List<JobRequiredProfile> getMissingRequiredProfiles(String workflowId, String executionProfileId) {
        if (workflowId == null || workflowId.trim().isEmpty()) {
            return null;
        }
        ArrayList<JobRequiredProfile> requiredNuixProfiles = new ArrayList<JobRequiredProfile>();
        Workflow libraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
        if (libraryWorkflow != null) {
            try {
                ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(libraryWorkflow.getOperationsXml());
                requiredNuixProfiles.addAll(immutableWorkflow.getRequiredNuixProfiles());
                this.updateRequiredProfiles(requiredNuixProfiles, executionProfileId);
            }
            catch (IOException e) {
                LOGGER.error("Error reading workflow XML", (Throwable)e);
            }
        }
        return requiredNuixProfiles;
    }

    private void updateRequiredProfiles(List<JobRequiredProfile> requiredNuixProfiles, String executionProfileId) {
        if (requiredNuixProfiles == null || requiredNuixProfiles.isEmpty()) {
            return;
        }
        Map<LibraryNuixFileType, Set<String>> nuixProfiles = this.getAllAvailableNuixProfiles(executionProfileId);
        for (JobRequiredProfile requiredProfile : requiredNuixProfiles) {
            Set<String> profileNames = nuixProfiles.get(requiredProfile.getProfileType());
            if (profileNames != null && profileNames.contains(requiredProfile.getName())) continue;
            requiredProfile.setMissing(true);
        }
    }

    private Map<LibraryNuixFileType, Set<String>> getAllAvailableNuixProfiles(String executionProfileId) {
        Map<LibraryNuixFileType, Set<String>> executionProfileNuixProfiles = this.schedulerApplication.getExecutionProfileResource().getExecutionProfileNuixProfiles(executionProfileId);
        Map<LibraryNuixFileType, Set<String>> userDataDirNuixProfiles = this.schedulerApplication.getUserDataDirResource().getNuixProfileNames();
        HashMap<LibraryNuixFileType, Set<String>> nuixProfiles = new HashMap<LibraryNuixFileType, Set<String>>(executionProfileNuixProfiles);
        CollectionUtils.intersectMapValues(nuixProfiles, userDataDirNuixProfiles);
        return nuixProfiles;
    }

    @Operation(tags={"Jobs"}, operationId="GetJobThirdPartyServiceUsers", summary="Get Job Third-Party Service User IDs", description="For each third-party service used in the job, get the user ID of the user is authenticated to the service", responses={@ApiResponse(description="The job details", content={@Content(schema=@Schema(implementation=JobDetails.class))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{id}/thirdPartyServiceUsers")
    @GET
    public Response getJobThirdPartyServiceUserCredentials(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job for which to get the third-party service users") @PathParam(value="id") String jobId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        JobDetailsModel jobDetails = this.getJobDetailsModel(jobId);
        if (jobDetails == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobModel jobModel = jobDetails.getSettings();
        Job result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobModel.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        HashSet<String> thirdPartyServiceIds = new HashSet<String>();
        HashMap<String, String> allowedThirdPartyServiceUsers = new HashMap<String, String>();
        for (Parameter parameter : jobModel.getSessionParameters()) {
            if (!parameter.isThirdPartyServiceParameter() || parameter.getValue() == null) continue;
            String serviceId = parameter.getValue();
            thirdPartyServiceIds.add(serviceId);
            try {
                ThirdPartyServiceSession<?, ?> session = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(serviceId, jobModel.getSubmitterUserId());
                ThirdPartyDetails details = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session);
                if (details.getUserPermissions().contains(Permission.VIEW) && !details.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
                    allowedThirdPartyServiceUsers.put(serviceId, details.getUserCredential().getUsername());
                    continue;
                }
                allowedThirdPartyServiceUsers.put(serviceId, this.iu.getString("Job.Name.Other"));
            }
            catch (IOException iOException) {}
        }
        for (String serviceId : thirdPartyServiceIds) {
            if (allowedThirdPartyServiceUsers.containsKey(serviceId)) continue;
            allowedThirdPartyServiceUsers.put(serviceId, this.iu.getString("ThirdPartyService.Log.UserNotFound"));
        }
        String lastHash = ResponseCache.getInstance().hashObject(allowedThirdPartyServiceUsers);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).header("ETag", (Object)lastHash).entity(allowedThirdPartyServiceUsers).build();
        }
    }

    @Operation(tags={"Jobs"}, operationId="GetJobFile", summary="Get Job File", description="Get a file from the job with the specified ID", responses={@ApiResponse(description="The file as a stream", content={@Content(schema=@Schema(implementation=OutputStream.class))}), @ApiResponse(responseCode="403", description="Forbidden job file download request")})
    @Produces(value={"application/octet-stream"})
    @javax.ws.rs.Path(value="/{id}/file")
    @GET
    public Response getFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the job the file belongs to") @PathParam(value="id") String jobId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        String queryString = request.getQueryString();
        List nameValuePairs = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
        String encodedPayload = ((NameValuePair)nameValuePairs.get(0)).getValue();
        String encodedSignature = ((NameValuePair)nameValuePairs.get(1)).getValue();
        LOGGER.info("Received request to download file from job " + jobId + ", payload: " + encodedPayload);
        JobDetailsModel jobDetails = this.schedulerApplication.getJobResource().getRunningJobModel(jobId);
        if (jobDetails == null) {
            LOGGER.error("Job with ID " + jobId + " not found or is not running");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean valid = this.validateFileDownloadSignature(encodedPayload, encodedSignature);
        if (!valid) {
            LOGGER.error("Job file download payload is invalid");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String payload = new String(Base64.getDecoder().decode(encodedPayload), StandardCharsets.UTF_8);
        JobFilePayload filePayload = (JobFilePayload)SerializationUtils.fromJson((String)payload, JobFilePayload.class);
        long currentDateMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (filePayload.getExpirationDate() == null || filePayload.getExpirationDate() < currentDateMillis) {
            LOGGER.error("Job file download payload is expired");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!filePayload.getJobId().equals(jobId)) {
            LOGGER.error("Job file download payload mismatching job ID");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String serverId = jobDetails.getSettings().getServerId();
        ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkerWithId(serverId);
        if (serverWorker == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cannot find engine server with ID: " + serverId)).build();
        }
        LOGGER.info("Job file download request from " + ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        LOGGER.info("File: " + filePayload.getFileName());
        return serverWorker.getJobFile(jobId, filePayload.getFileName());
    }

    public String getFileDownloadEndpoint(JobFilePayload filePayload) throws NoSuchAlgorithmException, IOException {
        String payload = SerializationUtils.toJson((Object)filePayload);
        byte[] encodedPayloadBytes = Base64.getEncoder().encode(payload.getBytes(StandardCharsets.UTF_8));
        String encodedPayload = new String(encodedPayloadBytes, StandardCharsets.UTF_8);
        String encodedPayloadHash = SecurityUtils.computeSha256Hex((String)encodedPayload);
        String signature = this.schedulerApplication.getEncryptor().encrypt(encodedPayloadHash);
        byte[] encodedSignatureBytes = Base64.getEncoder().encode(signature.getBytes(StandardCharsets.UTF_8));
        String encodedSignature = new String(encodedSignatureBytes, StandardCharsets.UTF_8);
        return "/api/v1/scheduler/jobs/" + filePayload.getJobId() + "/file?payload=" + URLEncoder.encode(encodedPayload, StandardCharsets.UTF_8) + "&sig=" + URLEncoder.encode(encodedSignature, StandardCharsets.UTF_8);
    }

    public boolean validateFileDownloadSignature(String encodedPayload, String encodedSignature) {
        boolean valid = false;
        try {
            byte[] decodedSignature = Base64.getDecoder().decode(encodedSignature.getBytes(StandardCharsets.UTF_8));
            String signature = new String(decodedSignature, StandardCharsets.UTF_8);
            String signedPayloadHash = this.schedulerApplication.getEncryptor().decrypt(signature);
            String expectedPayloadHash = SecurityUtils.computeSha256Hex((String)encodedPayload);
            if (signedPayloadHash != null && signedPayloadHash.equals(expectedPayloadHash)) {
                valid = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error validating job file download payload", (Throwable)e);
        }
        if (!valid) {
            LOGGER.error("Job file download payload is not valid");
        }
        return valid;
    }
}

