/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import au.com.bytecode.opencsv.CSVWriter;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.scheduler.utils.LegalHoldParticipationCache;
import com.nuix.automate.scheduler.utils.NoticeHtmlBuilder;
import com.nuix.automate.scheduler.utils.NoticeUtils;
import com.nuix.automate.scheduler.workers.LegalHoldWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.api.legalhold.Command;
import com.nuix.automate.utils.models.api.legalhold.JobTriggerType;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldCommand;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldExportOptions;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipations;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldSubmission;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldTaskState;
import com.nuix.automate.utils.models.api.legalhold.NoticeDatasetEvent;
import com.nuix.automate.utils.models.api.legalhold.SurveyNoticesTrigger;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfiguration;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfigurationEvent;
import com.nuix.automate.utils.models.api.legalhold.UserImportResult;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeInfo;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import com.nuix.automate.utils.models.api.notice.UserNotice;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.legalhold.LegalHoldEvent;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.CustodianActivity;
import com.nuix.automate.utils.utilization.CustodianNotice;
import com.nuix.automate.utils.utilization.LegalHold;
import com.nuix.automate.utils.utilization.Notice;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/legalHold")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LegalHoldResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegalHoldResource.class);
    private static final String IDENTIFIER_TYPE_ID = "id";
    private static final String IDENTIFIER_TYPE_EMAIL = "email";
    private static final String IDENTIFIER_TYPE_NAME = "name";
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final LegalHoldWorker legalHoldWorker;
    private final Map<String, com.nuix.automate.utils.models.api.legalhold.LegalHold> legalHolds;
    private final Map<String, SecurityPolicy> implicitAdministratorPolicies;
    private final Map<String, SecurityPolicy> implicitCustodianPolicies;
    private Map<String, List<LegalHoldParticipation>> legalHoldParticipations;

    public LegalHoldResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.legalHoldWorker = new LegalHoldWorker(schedulerApplication);
        this.legalHolds = new HashMap<String, com.nuix.automate.utils.models.api.legalhold.LegalHold>();
        this.implicitAdministratorPolicies = new HashMap<String, SecurityPolicy>();
        this.implicitCustodianPolicies = new HashMap<String, SecurityPolicy>();
        this.legalHoldParticipations = new ConcurrentHashMap<String, List<LegalHoldParticipation>>();
    }

    public void initializeLegalHoldsFromStore() {
        LOGGER.info("Initializing Legal Holds from store");
        List<com.nuix.automate.utils.models.api.legalhold.LegalHold> legalHolds = this.schedulerApplication.getSchedulerConfigurationDao().getLegalHolds();
        if (this.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants()) {
            LOGGER.info("Preparing cache for LegalHoldParticipants");
            for (LegalHoldParticipation part : this.schedulerApplication.getSchedulerConfigurationDao().getAllLegalHoldParticipations()) {
                List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(part.getLegalHoldId());
                if (participations == null) {
                    participations = new ArrayList<LegalHoldParticipation>();
                }
                participations.add(part);
                this.legalHoldParticipations.put(part.getLegalHoldId(), participations);
            }
        }
        for (com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold : legalHolds) {
            this.legalHolds.put(legalHold.getId(), legalHold);
            if (legalHold.getTaskState() == null) {
                legalHold.setTaskDone();
            } else if (legalHold.getTaskState() != LegalHoldTaskState.DONE && legalHold.getTaskState() != LegalHoldTaskState.ERROR) {
                legalHold.setTaskError(this.iu.getFormattedString("LegalHoldWorker.TaskInterrupted", (Object)legalHold.getTaskState().getLocalizedString()));
            }
            this.updateLegalHoldImplicitPolicies(legalHold.getId());
        }
    }

    public void addLegalHoldParticipations(List<LegalHoldParticipation> parts) {
        if (this.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants()) {
            for (LegalHoldParticipation part : parts) {
                List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(part.getLegalHoldId());
                if (participations == null) {
                    participations = new ArrayList<LegalHoldParticipation>();
                }
                participations.add(part);
                this.legalHoldParticipations.put(part.getLegalHoldId(), participations);
            }
        }
    }

    public void updateLegalHoldParticipation(LegalHoldParticipation participant) {
        List<LegalHoldParticipation> participations;
        if (this.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants() && (participations = this.legalHoldParticipations.get(participant.getLegalHoldId())) != null) {
            for (LegalHoldParticipation part : participations) {
                if (!part.getUserId().equals(participant.getUserId()) || !part.getRole().equals((Object)participant.getRole())) continue;
                part.copy(participant);
            }
        }
    }

    public void deleteLegalHoldParticipation(String legalHoldId, String userId, LegalHoldRole role) {
        if (this.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants()) {
            List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(legalHoldId);
            LegalHoldParticipation removeParticipant = null;
            if (participations != null) {
                for (LegalHoldParticipation part : participations) {
                    if (!part.getUserId().equals(userId) || !part.getRole().equals((Object)role)) continue;
                    removeParticipant = part;
                }
            }
            if (removeParticipant != null) {
                participations.remove(removeParticipant);
            }
        }
    }

    public void deleteLegalHoldParticipations(String legalHoldId) {
        if (this.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants()) {
            this.legalHoldParticipations.remove(legalHoldId);
        }
    }

    public LegalHoldParticipation getUserLegalHoldParticipation(String legalHoldId, String userId, LegalHoldRole role) {
        List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(legalHoldId);
        if (participations != null) {
            for (LegalHoldParticipation part : participations) {
                if (!part.getUserId().equals(userId) || !part.getRole().equals((Object)role)) continue;
                return part;
            }
        }
        return null;
    }

    public List<LegalHoldParticipation> getUserLegalHoldParticipations(String legalHoldId, String userId) {
        List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(legalHoldId);
        ArrayList<LegalHoldParticipation> userParticipations = new ArrayList<LegalHoldParticipation>();
        if (participations != null) {
            for (LegalHoldParticipation part : participations) {
                if (!part.getUserId().equals(userId)) continue;
                userParticipations.add(part);
            }
        }
        return userParticipations;
    }

    public List<LegalHoldParticipation> getUserLegalHoldParticipations(String userId, LegalHoldRole role) {
        ArrayList<LegalHoldParticipation> userParticipations = new ArrayList<LegalHoldParticipation>();
        for (Map.Entry<String, List<LegalHoldParticipation>> legalHold : this.legalHoldParticipations.entrySet()) {
            for (LegalHoldParticipation part : legalHold.getValue()) {
                if (!part.getUserId().equals(userId) || !part.getRole().equals((Object)role)) continue;
                userParticipations.add(part);
            }
        }
        return userParticipations;
    }

    public List<LegalHoldParticipation> getLegalHoldParticipations(String legalHoldId, LegalHoldRole role) {
        List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(legalHoldId);
        ArrayList<LegalHoldParticipation> userParticipations = new ArrayList<LegalHoldParticipation>();
        if (participations != null) {
            for (LegalHoldParticipation part : participations) {
                if (!part.getRole().equals((Object)role)) continue;
                userParticipations.add(part);
            }
        }
        return userParticipations;
    }

    public List<LegalHoldParticipation> getLegalHoldParticipations(String legalHoldId) {
        List<LegalHoldParticipation> parts = this.legalHoldParticipations.get(legalHoldId);
        if (parts == null) {
            parts = new ArrayList<LegalHoldParticipation>();
        }
        return parts;
    }

    public Set<String> getLegalHoldParticipationUserIds(String legalHoldId, LegalHoldRole role) {
        List<LegalHoldParticipation> participations = this.legalHoldParticipations.get(legalHoldId);
        HashSet<String> userIds = new HashSet<String>();
        if (participations != null) {
            for (LegalHoldParticipation part : participations) {
                if (!part.getRole().equals((Object)role)) continue;
                userIds.add(part.getUserId());
            }
        }
        return userIds;
    }

    public void updateLegalHoldImplicitPolicies(String legalHoldId) {
        this.updateLegalHoldImplicitPolicies(legalHoldId, null);
    }

    public void updateLegalHoldImplicitPolicies(String legalHoldId, List<LegalHoldParticipation> legalHoldParticipations) {
        this.implicitAdministratorPolicies.remove(legalHoldId);
        this.implicitCustodianPolicies.remove(legalHoldId);
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.legalHolds.get(legalHoldId);
        if (legalHold != null && com.nuix.automate.utils.models.api.legalhold.LegalHold.manageStates.contains(legalHold.getState())) {
            ArrayList<LegalHoldParticipation> administrators = new ArrayList<LegalHoldParticipation>();
            ArrayList<LegalHoldParticipation> custodians = new ArrayList<LegalHoldParticipation>();
            if (legalHoldParticipations == null) {
                legalHoldParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId());
            }
            for (LegalHoldParticipation participation : legalHoldParticipations) {
                if (participation.getRole() == LegalHoldRole.ADMINISTRATOR) {
                    administrators.add(participation);
                    continue;
                }
                if (participation.getRole() != LegalHoldRole.CUSTODIAN) continue;
                custodians.add(participation);
            }
            if (administrators.size() > 0) {
                SecurityPolicy administratorPolicy = this.schedulerApplication.getLegalHoldUtils().buildAdministratorImplicitPolicy(legalHold, administrators);
                this.implicitAdministratorPolicies.put(legalHold.getId(), administratorPolicy);
            }
            if (custodians.size() > 0 && com.nuix.automate.utils.models.api.legalhold.LegalHold.replyStates.contains(legalHold.getState())) {
                SecurityPolicy custodianPolicy = this.schedulerApplication.getLegalHoldUtils().buildCustodianImplicitPolicy(legalHold);
                this.implicitCustodianPolicies.put(legalHold.getId(), custodianPolicy);
            }
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.SECURITY_POLICIES, "");
    }

    public com.nuix.automate.utils.models.api.legalhold.LegalHold getLegalHold(String id) {
        return this.legalHolds.get(id);
    }

    public Collection<com.nuix.automate.utils.models.api.legalhold.LegalHold> getLegalHolds() {
        return this.legalHolds.values();
    }

    public List<SecurityPolicy> getLegalHoldImplicitPolicies() {
        ArrayList<SecurityPolicy> implicitPolicies = new ArrayList<SecurityPolicy>(this.implicitAdministratorPolicies.values());
        implicitPolicies.addAll(this.implicitCustodianPolicies.values());
        return implicitPolicies;
    }

    private boolean isLegalHoldCommandInProgress(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        return legalHold.getCommandInProgress() || this.legalHoldWorker.containsWorkForLegalHold(legalHold.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Legal Hold"}, operationId="SendLegalHoldCommand", summary="Send Legal Hold Command", description="Process legal hold commands", responses={@ApiResponse(description="The legal hold updated after the command", content={@Content(schema=@Schema(implementation=com.nuix.automate.utils.models.api.legalhold.LegalHold.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/command")
    @POST
    public Response sendLegalHoldCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId, @Parameter(description="The legal hold command") LegalHoldCommand legalHoldCommand) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.getLegalHold(legalHoldId);
        if (legalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        HashSet<Command> modifyOnlyCommands = new HashSet<Command>(Arrays.asList(Command.ARCHIVE));
        Command command = legalHoldCommand.getCommand();
        com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        if (!(result.getUserPermissions().contains(Permission.MODIFY) || !modifyOnlyCommands.contains(command) && result.getUserPermissions().contains(Permission.MANAGE))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (this.isLegalHoldCommandInProgress(legalHold)) {
            return ExceptionUtils.toResponse((String)"legalHoldCommandInProgress", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            legalHold.setCommandInProgress(true);
            long lastChangedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            String remoteAddress = ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request);
            LegalHoldEvent scheduleTriggerEvent = null;
            List<LegalHoldParticipation> affectedCustodianParticipations = null;
            EventType.Type eventType = null;
            String eventDetails = null;
            EmailType emailType = null;
            String emailDescription = null;
            boolean silentLegalHold = legalHold.getSilent() == Boolean.TRUE;
            switch (command) {
                case ACTIVATE: {
                    UserAccount disabledUser;
                    Response noticeTemplate;
                    Response noticeConfigurations;
                    if (!LegalHoldState.DRAFT.equals((Object)legalHold.getState())) {
                        Response response = ExceptionUtils.toResponse((String)"legalHoldIsNotDraft", (Response.Status)Response.Status.BAD_REQUEST);
                        return response;
                    }
                    String dataRepositoryId = legalHold.getDataRepositoryId();
                    boolean hasDataRepository = dataRepositoryId != null && this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId) != null;
                    boolean requiresDataRepository = false;
                    LinkedHashMap surveyNoticeConfigurations = legalHold.getSurveyNoticeConfigurations();
                    if (!hasDataRepository && !silentLegalHold) {
                        noticeConfigurations = new ArrayList();
                        noticeConfigurations.add(legalHold.getHoldNoticeConfiguration());
                        noticeConfigurations.add(legalHold.getReleaseNoticeConfiguration());
                        if (surveyNoticeConfigurations != null) {
                            noticeConfigurations.addAll(surveyNoticeConfigurations.values());
                        }
                        for (NoticeConfiguration noticeConfiguration : noticeConfigurations) {
                            if (!Boolean.TRUE.equals(noticeConfiguration.getEnabled()) || !(noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(noticeConfiguration.getNoticeTemplateId())).requiresDataRepository()) continue;
                            requiresDataRepository = true;
                            break;
                        }
                    }
                    if (!hasDataRepository && requiresDataRepository) {
                        noticeConfigurations = ExceptionUtils.toResponse((String)"activeLegalHoldRequiresDataRepository", (Response.Status)Response.Status.BAD_REQUEST);
                        return noticeConfigurations;
                    }
                    List<LegalHoldParticipation> administratorParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId, LegalHoldRole.ADMINISTRATOR);
                    List<LegalHoldParticipation> custodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId, LegalHoldRole.CUSTODIAN);
                    final ArrayList<String> disabledUserNames = new ArrayList<String>();
                    for (LegalHoldParticipation legalHoldParticipation : administratorParticipations) {
                        if (this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(legalHoldParticipation.getUserId())) continue;
                        disabledUser = this.schedulerApplication.getUserServiceResource().getUser(legalHoldParticipation.getUserId());
                        if (disabledUser == null) {
                            disabledUserNames.add(legalHoldParticipation.getUserId());
                            continue;
                        }
                        disabledUserNames.add(disabledUser.getName());
                    }
                    if (disabledUserNames.size() > 0) {
                        noticeTemplate = ExceptionUtils.toResponse((String)"cannotActivateWithDisabledAdministrators", (Map)new HashMap<String, String>(){
                            {
                                this.put("names", String.join((CharSequence)"\n", disabledUserNames));
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                        return noticeTemplate;
                    }
                    for (LegalHoldParticipation legalHoldParticipation : custodianParticipations) {
                        if (this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabledOrInactive(legalHoldParticipation.getUserId())) continue;
                        disabledUser = this.schedulerApplication.getUserServiceResource().getUser(legalHoldParticipation.getUserId());
                        if (disabledUser == null) {
                            disabledUserNames.add(legalHoldParticipation.getUserId());
                            continue;
                        }
                        disabledUserNames.add(disabledUser.getName());
                    }
                    if (disabledUserNames.size() > 0) {
                        noticeTemplate = ExceptionUtils.toResponse((String)"cannotActivateWithDisabledCustodians", (Map)new HashMap<String, String>(){
                            {
                                this.put("names", String.join((CharSequence)"\n", disabledUserNames));
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                        return noticeTemplate;
                    }
                    if (!silentLegalHold) {
                        if (administratorParticipations.size() == 0) {
                            noticeTemplate = ExceptionUtils.toResponse((String)"activeLegalHoldRequiresAdmin", (Response.Status)Response.Status.BAD_REQUEST);
                            return noticeTemplate;
                        }
                        String smtpServerId = legalHold.getSmtpServerId();
                        if (smtpServerId == null || this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(smtpServerId) == null) {
                            LegalHoldParticipation legalHoldParticipation;
                            legalHoldParticipation = ExceptionUtils.toResponse((String)"activeLegalHoldRequiresSmtp", (Response.Status)Response.Status.BAD_REQUEST);
                            return legalHoldParticipation;
                        }
                        String schedulerUrl = legalHold.getSchedulerUrl();
                        if (schedulerUrl == null || schedulerUrl.trim().length() == 0) {
                            Response response = ExceptionUtils.toResponse((String)"activeLegalHoldRequiresSchedulerUrl", (Response.Status)Response.Status.BAD_REQUEST);
                            return response;
                        }
                        this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(legalHoldId, legalHold.getHoldNoticeConfiguration());
                        if (surveyNoticeConfigurations != null) {
                            for (NoticeConfiguration surveyNoticeConfiguration : surveyNoticeConfigurations.values()) {
                                if (surveyNoticeConfiguration.getEnabled() != Boolean.TRUE) continue;
                                this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(legalHoldId, surveyNoticeConfiguration);
                            }
                        }
                        this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(legalHoldId, legalHold.getRecurringNoticeConfiguration());
                        this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(legalHoldId, legalHold.getReleaseNoticeConfiguration());
                    }
                    this.schedulerApplication.getLegalHoldUtils().handleMatterTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_ACTIVATE);
                    legalHold.setState(LegalHoldState.ACTIVE);
                    legalHold.setStartDate(Long.valueOf(lastChangedDate));
                    this.legalHoldWorker.submitIssueHoldsTask(user, remoteAddress, legalHold, custodianParticipations);
                    scheduleTriggerEvent = LegalHoldEvent.LEGAL_HOLD_ACTIVATED;
                    affectedCustodianParticipations = custodianParticipations;
                    eventType = EventType.Type.LEGAL_HOLD_ACTIVATED;
                    eventDetails = "";
                    emailType = EmailType.LEGAL_HOLD_ACTIVATED;
                    emailDescription = this.iu.getFormattedString("LegalHoldResource.LegalHoldActivatedEmailDescription", (Object)legalHold.getName());
                    com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_ACTIVATED, eventResult, user.getName());
                    this.trackLegalHoldUtilization(legalHold);
                    this.trackLegalHoldNoticesUtilization(legalHold);
                    break;
                }
                case RELEASE: {
                    if (!LegalHoldState.ACTIVE.equals((Object)legalHold.getState())) {
                        Response dataRepositoryId = ExceptionUtils.toResponse((String)"legalHoldIsNotActive", (Response.Status)Response.Status.BAD_REQUEST);
                        return dataRepositoryId;
                    }
                    List<LegalHoldParticipation> custodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId, LegalHoldRole.CUSTODIAN);
                    this.legalHoldWorker.submitReleaseHoldsTask(user, remoteAddress, legalHold, custodianParticipations);
                    legalHold.setState(LegalHoldState.RELEASED);
                    legalHold.setEndDate(Long.valueOf(lastChangedDate));
                    scheduleTriggerEvent = LegalHoldEvent.LEGAL_HOLD_RELEASED;
                    affectedCustodianParticipations = custodianParticipations;
                    eventType = EventType.Type.LEGAL_HOLD_RELEASED;
                    eventDetails = "";
                    emailType = EmailType.LEGAL_HOLD_RELEASED;
                    emailDescription = this.iu.getFormattedString("LegalHoldResource.LegalHoldReleasedEmailDescription", (Object)legalHold.getName());
                    com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_RELEASED, eventResult, user.getName());
                    this.trackLegalHoldUtilization(legalHold);
                    break;
                }
                case ARCHIVE: {
                    if (!LegalHoldState.RELEASED.equals((Object)legalHold.getState())) {
                        Response custodianParticipations = ExceptionUtils.toResponse((String)"legalHoldIsNotReleased", (Response.Status)Response.Status.BAD_REQUEST);
                        return custodianParticipations;
                    }
                    Response errorResponse = this.schedulerApplication.getLegalHoldUtils().verifyNotUsedInJobs(user, legalHoldId);
                    if (errorResponse != null) {
                        Response eventResult = errorResponse;
                        return eventResult;
                    }
                    legalHold.setState(LegalHoldState.ARCHIVED);
                    this.legalHoldWorker.submitDisableReleaseNoticeTask(legalHold);
                    eventType = EventType.Type.LEGAL_HOLD_ARCHIVED;
                    eventDetails = "";
                    emailType = EmailType.LEGAL_HOLD_ARCHIVED;
                    emailDescription = this.iu.getFormattedString("LegalHoldResource.LegalHoldArchivedEmailDescription", (Object)legalHold.getName());
                    com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_ARCHIVED, eventResult, user.getName());
                    this.schedulerApplication.getLegalHoldUtils().handleMatterTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_ARCHIVED);
                    this.trackLegalHoldUtilization(legalHold);
                    this.updateLegalHoldImplicitPolicies(legalHoldId);
                    break;
                }
                case ISSUE_HOLD: {
                    if (!LegalHoldState.ACTIVE.equals((Object)legalHold.getState())) {
                        Response errorResponse = ExceptionUtils.toResponse((String)"legalHoldIsNotActive", (Response.Status)Response.Status.BAD_REQUEST);
                        return errorResponse;
                    }
                    List<LegalHoldParticipation> custodianParticipations = this.addAndGetCustodianParticipationsForUserIds(legalHold, legalHoldCommand.getUserIds());
                    this.legalHoldWorker.submitIssueHoldsTask(user, remoteAddress, legalHold, custodianParticipations);
                    break;
                }
                case RELEASE_HOLD: {
                    if (!LegalHoldState.ACTIVE.equals((Object)legalHold.getState())) {
                        Response custodianParticipations = ExceptionUtils.toResponse((String)"legalHoldIsNotActive", (Response.Status)Response.Status.BAD_REQUEST);
                        return custodianParticipations;
                    }
                    List<LegalHoldParticipation> custodianParticipations = this.addAndGetCustodianParticipationsForUserIds(legalHold, legalHoldCommand.getUserIds());
                    this.legalHoldWorker.submitReleaseHoldsTask(user, remoteAddress, legalHold, custodianParticipations);
                    break;
                }
                default: {
                    Response custodianParticipations = ExceptionUtils.toResponse((String)"noSuchCommand");
                    return custodianParticipations;
                }
            }
            if (command != Command.ACTIVATE && command != Command.RELEASE) {
                legalHold.setLastChangedDate(Long.valueOf(lastChangedDate));
                legalHold.setLastChangedBy(user.getName());
                legalHold.setLastChangedByUserId(user.getId());
            }
            this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
            if (eventType != null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHold.getId(), Long.valueOf(lastChangedDate), user.getName(), eventType, eventDetails, remoteAddress));
            }
            ThirdPartyService smtpService = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(legalHold.getSmtpServerId());
            if (emailType != null && smtpService != null) {
                this.schedulerApplication.getLegalHoldUtils().sendEmailToAdmins(user, legalHold, emailType, emailDescription);
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHoldId);
            ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, legalHoldId);
            ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
            if (scheduleTriggerEvent != null) {
                this.schedulerApplication.getScheduleWorker().triggerLegalHoldEvent(scheduleTriggerEvent, legalHold, affectedCustodianParticipations);
            }
            result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
            Response response = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
            return response;
        }
        finally {
            legalHold.setCommandInProgress(false);
        }
    }

    private List<LegalHoldParticipation> addAndGetCustodianParticipationsForUserIds(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold, Set<String> userIds) {
        HashSet<String> newUserIds = new HashSet<String>(userIds);
        List<LegalHoldParticipation> custodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.CUSTODIAN).stream().filter(participation -> newUserIds.remove(participation.getUserId())).collect(Collectors.toList());
        ArrayList<LegalHoldParticipation> newCustodianParticipations = new ArrayList<LegalHoldParticipation>();
        for (String userId : newUserIds) {
            UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(userId);
            if (userAccount == null) {
                LOGGER.info("Skipping user " + userId + ", not found");
                continue;
            }
            if (!this.isUserEligibleForLegalHoldRole(LegalHoldRole.CUSTODIAN, userAccount)) {
                LOGGER.info("Skipping user " + userAccount.getName() + ", not eligible for Legal Hold custodian");
                continue;
            }
            if (!this.isUserCompatibleWithLegalHold(userAccount, legalHold)) {
                LOGGER.info("Skipping user " + userAccount.getName() + " (" + String.valueOf(userAccount.getPlatform()) + "), not compatible with Legal Hold");
                continue;
            }
            LegalHoldParticipation custodianParticipation = new LegalHoldParticipation(legalHold.getId(), userAccount.getId(), LegalHoldRole.CUSTODIAN);
            newCustodianParticipations.add(custodianParticipation);
        }
        this.addLegalHoldParticipations(newCustodianParticipations);
        this.schedulerApplication.getSchedulerConfigurationDao().addLegalHoldParticipations(newCustodianParticipations);
        custodianParticipations.addAll(newCustodianParticipations);
        return custodianParticipations;
    }

    private List<Notice> getLegalHoldNoticesUtilization(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        ArrayList<Notice> notices = new ArrayList<Notice>();
        if (legalHold.getSilent() != null && legalHold.getSilent().booleanValue()) {
            notices.add(this.getSilentNotice(legalHold));
        } else {
            HashMap noticeConfigurations = new HashMap();
            ArrayList<NoticeConfiguration> holdConfigurations = new ArrayList<NoticeConfiguration>();
            holdConfigurations.add(legalHold.getHoldNoticeConfiguration());
            noticeConfigurations.put(NoticeType.HOLD.name(), holdConfigurations);
            ArrayList<NoticeConfiguration> releaseConfigurations = new ArrayList<NoticeConfiguration>();
            releaseConfigurations.add(legalHold.getReleaseNoticeConfiguration());
            noticeConfigurations.put(NoticeType.RELEASE.name(), releaseConfigurations);
            ArrayList<NoticeConfiguration> recurringConfigurations = new ArrayList<NoticeConfiguration>();
            if (legalHold.getRecurringNoticeConfiguration() != null) {
                recurringConfigurations.add(legalHold.getRecurringNoticeConfiguration());
            }
            noticeConfigurations.put(NoticeType.RECURRING.name(), recurringConfigurations);
            ArrayList surveyConfigurations = new ArrayList();
            surveyConfigurations.addAll(legalHold.getSurveyNoticeConfigurations().values());
            noticeConfigurations.put(NoticeType.SURVEY.name(), surveyConfigurations);
            ArrayList<NoticeConfiguration> reminderConfigurations = new ArrayList<NoticeConfiguration>();
            ArrayList<NoticeConfiguration> escalationConfigurations = new ArrayList<NoticeConfiguration>();
            for (String noticeType : noticeConfigurations.keySet()) {
                for (NoticeConfiguration noticeConfiguration : (List)noticeConfigurations.get(noticeType)) {
                    if (noticeConfiguration.getReminderNoticeId() != null) {
                        com.nuix.automate.utils.models.api.notice.Notice reminderNoticeModel = this.schedulerApplication.getNoticeResource().getNotice(noticeConfiguration.getReminderNoticeId());
                        reminderConfigurations.add(reminderNoticeModel.getConfiguration());
                    }
                    if (noticeConfiguration.getEscalateNoticeId() == null) continue;
                    com.nuix.automate.utils.models.api.notice.Notice escalateNoticeModel = this.schedulerApplication.getNoticeResource().getNotice(noticeConfiguration.getEscalateNoticeId());
                    escalationConfigurations.add(escalateNoticeModel.getConfiguration());
                }
            }
            noticeConfigurations.put(NoticeType.REMINDER.name(), reminderConfigurations);
            noticeConfigurations.put(NoticeType.ESCALATION.name(), escalationConfigurations);
            for (String noticeType : noticeConfigurations.keySet()) {
                for (NoticeConfiguration noticeConfiguration : (List)noticeConfigurations.get(noticeType)) {
                    if (noticeConfiguration.getNoticeId() == null) continue;
                    Notice utilizationNotice = new Notice();
                    utilizationNotice.setNoticeId(noticeConfiguration.getNoticeId());
                    utilizationNotice.setLegalHoldId(legalHold.getId());
                    utilizationNotice.setNoticeType(noticeType);
                    utilizationNotice.setNoticeTemplateId(noticeConfiguration.getNoticeTemplateId());
                    notices.add(utilizationNotice);
                }
            }
        }
        return notices;
    }

    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/export")
    @Produces(value={"application/zip"})
    @GET
    public Response getLegalHoldResponsesAsCsvForm(@Auth BearerUser user, @PathParam(value="legalHoldId") String legalHoldId, @QueryParam(value="formData") String formDataJson) {
        LegalHoldExportOptions noticeExportOptions = (LegalHoldExportOptions)SerializationUtils.fromJson((String)formDataJson, LegalHoldExportOptions.class);
        return this.getLegalHoldResponsesAsCsvInternal(user, legalHoldId, noticeExportOptions);
    }

    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/export")
    @Produces(value={"application/zip"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response getLegalHoldResponsesAsCsvForm(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token, @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId, @Parameter(description="The notice export options", schema=@Schema(implementation=LegalHoldExportOptions.class)) @FormParam(value="formData") String formDataJson) throws AuthenticationException {
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isEmpty()) {
            return ExceptionUtils.buildForbiddenResponse((String)"Unauthenticated", (Object)legalHoldId);
        }
        LegalHoldExportOptions noticeExportOptions = (LegalHoldExportOptions)SerializationUtils.fromJson((String)formDataJson, LegalHoldExportOptions.class);
        return this.getLegalHoldResponsesAsCsvInternal(user.get(), legalHoldId, noticeExportOptions);
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldResponses", summary="Get Legal Hold Responses", description="Download custodian responses as a zipped csv file", responses={@ApiResponse(description="Custodian responses as a CSV string", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/export")
    @Produces(value={"application/zip"})
    @Consumes(value={"application/json"})
    @POST
    public Response getLegalHoldResponsesAsCsv(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId, @Parameter(description="The notice export options") LegalHoldExportOptions noticeExportOptions) {
        return this.getLegalHoldResponsesAsCsvInternal(user, legalHoldId, noticeExportOptions);
    }

    private Response getLegalHoldResponsesAsCsvInternal(final BearerUser user, final String legalHoldId, final LegalHoldExportOptions noticeExportOptions) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        final com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.getLegalHold(legalHoldId);
        if (legalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        if (!result.getUserPermissions().contains(Permission.VIEW_SENSITIVE) && !result.getUserPermissions().contains(Permission.MANAGE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        StreamingOutput streamingOutput = new StreamingOutput(){
            Set<String> noticeIds;
            Map<String, List<NoticeEvent>> noticeIdToEvents;
            Map<String, List<NoticeDatasetEvent>> userToNoticeDatasetEvents;
            Map<String, List<TriggerConfigurationEvent>> userToTriggerConfigurationEvents;
            List<LegalHoldParticipation> custodianParticipations;

            public void write(OutputStream outputStream) throws WebApplicationException {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                    if (noticeExportOptions.getExportCustodiansOverview() || noticeExportOptions.getExportDatasetsOverview()) {
                        this.custodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId, LegalHoldRole.CUSTODIAN);
                        this.userToNoticeDatasetEvents = LegalHoldResource.this.schedulerApplication.getLegalHoldUtils().getLegalHoldNoticeDatasetEvents(legalHoldId);
                        this.userToTriggerConfigurationEvents = new HashMap<String, List<TriggerConfigurationEvent>>();
                        for (TriggerConfigurationEvent triggerConfigurationEvent : LegalHoldResource.this.schedulerApplication.getSchedulerConfigurationDao().getTriggerConfigurationEvents(legalHoldId)) {
                            for (String userId : triggerConfigurationEvent.getUserIds()) {
                                this.userToTriggerConfigurationEvents.computeIfAbsent(userId, k -> new ArrayList()).add(triggerConfigurationEvent);
                            }
                        }
                    }
                    if (noticeExportOptions.getExportNoticesOverview() || noticeExportOptions.getExportNoticeResponses() || noticeExportOptions.getExportUserNoticeHtml()) {
                        this.noticeIds = noticeExportOptions.getNoticeIds().stream().filter(id -> LegalHoldResource.this.schedulerApplication.getNoticeResource().getNotice((String)id) != null).collect(Collectors.toSet());
                        this.noticeIdToEvents = this.noticeIds.stream().collect(Collectors.toMap(noticeId -> noticeId, noticeId -> LegalHoldResource.this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents((String)noticeId)));
                    }
                    if (noticeExportOptions.getExportCustodiansOverview()) {
                        this.writeCustodiansOverview(zipOutputStream);
                    }
                    if (noticeExportOptions.getExportDatasetsOverview()) {
                        this.writeDatasetsOverview(zipOutputStream);
                    }
                    if (legalHold.getSilent() != Boolean.TRUE) {
                        if (noticeExportOptions.getExportNoticesOverview()) {
                            this.writeNoticesOverview(zipOutputStream);
                        }
                        if (noticeExportOptions.getExportNoticeResponses()) {
                            this.writeNoticeResponses(zipOutputStream);
                        }
                        if (noticeExportOptions.getExportUserNoticeHtml()) {
                            this.writeUserNoticeHtmls(zipOutputStream);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error during legal hold export: " + legalHoldId, (Throwable)e);
                }
            }

            private void writeCustodiansOverview(ZipOutputStream zipOutputStream) {
                try (StringWriter writer = new StringWriter();
                     CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                    String[] overviewHeaders = new String[]{"Status", LegalHoldResource.IDENTIFIER_TYPE_NAME, LegalHoldResource.IDENTIFIER_TYPE_EMAIL, "Has Uploaded Data", "Has Collected Data", "Has Collections"};
                    csvWriter.writeNext(overviewHeaders);
                    for (LegalHoldParticipation custodianParticipation : this.custodianParticipations) {
                        String[] values = new String[6];
                        values[0] = LegalHoldResource.this.iu.getString("CustodianState." + String.valueOf(custodianParticipation.getCustodianState()));
                        String userId = custodianParticipation.getUserId();
                        UserAccount userAccount = LegalHoldResource.this.schedulerApplication.getUserServiceResource().getUser(userId);
                        if (userAccount != null) {
                            values[1] = userAccount.getName();
                            values[2] = userAccount.getEmail();
                        } else {
                            values[1] = custodianParticipation.getUserId();
                            values[2] = "";
                        }
                        boolean hasUploadedData = this.userToNoticeDatasetEvents.containsKey(userId);
                        values[3] = LegalHoldResource.this.iu.getString("LegalHoldResource.Boolean." + hasUploadedData);
                        boolean hasJobs = false;
                        List<TriggerConfigurationEvent> triggerConfigurationEvents = this.userToTriggerConfigurationEvents.get(userId);
                        if (triggerConfigurationEvents != null && triggerConfigurationEvents.size() > 0) {
                            hasJobs = true;
                        }
                        values[4] = LegalHoldResource.this.iu.getString("LegalHoldResource.Boolean." + hasJobs);
                        csvWriter.writeNext(values);
                    }
                    String custodiansOverviewCsvName = "Custodians Overview.csv";
                    zipOutputStream.putNextEntry(new ZipEntry(custodiansOverviewCsvName));
                    zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOGGER.error("Error writing custodians overview info CSV", (Throwable)e);
                }
            }

            private void writeDatasetsOverview(ZipOutputStream zipOutputStream) {
                try (StringWriter writer = new StringWriter();
                     CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                    String[] overviewHeaders = new String[]{LegalHoldResource.IDENTIFIER_TYPE_NAME, LegalHoldResource.IDENTIFIER_TYPE_EMAIL, "Dataset ID", "Dataset Type", "Dataset Name", "Collection ID", "Collection Name"};
                    csvWriter.writeNext(overviewHeaders);
                    for (LegalHoldParticipation custodianParticipation : this.custodianParticipations) {
                        String userId = custodianParticipation.getUserId();
                        UserAccount userAccount = LegalHoldResource.this.schedulerApplication.getUserServiceResource().getUser(userId);
                        List<NoticeDatasetEvent> noticeDatasetEvents = this.userToNoticeDatasetEvents.get(custodianParticipation.getUserId());
                        if (noticeDatasetEvents == null) continue;
                        for (NoticeDatasetEvent noticeDatasetEvent : noticeDatasetEvents) {
                            String[] values = this.buildDatasetEvent(userAccount, userId, noticeDatasetEvent.getDatasetId(), null);
                            csvWriter.writeNext(values);
                        }
                    }
                    String datasetsOverviewCsvName = "Datasets Overview.csv";
                    zipOutputStream.putNextEntry(new ZipEntry(datasetsOverviewCsvName));
                    zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOGGER.error("Error writing datasets overview info CSV", (Throwable)e);
                }
            }

            private String[] buildDatasetEvent(UserAccount userAccount, String userId, String datasetId, String collectionId) {
                String[] values = new String[7];
                if (userAccount != null) {
                    values[0] = userAccount.getName();
                    values[1] = userAccount.getEmail();
                } else {
                    values[0] = userId;
                    values[1] = "";
                }
                values[2] = datasetId;
                Dataset dataset = LegalHoldResource.this.schedulerApplication.getDatasetResource().getDataset(datasetId);
                if (dataset != null) {
                    values[3] = LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)dataset.getType());
                    values[4] = dataset.getName();
                }
                values[5] = "";
                values[6] = "";
                return values;
            }

            private void writeNoticesOverview(ZipOutputStream zipOutputStream) {
                try (StringWriter writer = new StringWriter();
                     CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                    String[] overviewHeaders = new String[]{"Type", "Subject", "Sent", "Viewed", "Responded", "Escalated"};
                    csvWriter.writeNext(overviewHeaders);
                    for (String noticeId : this.noticeIds) {
                        com.nuix.automate.utils.models.api.notice.Notice noticeModel = LegalHoldResource.this.schedulerApplication.getNoticeResource().getNotice(noticeId);
                        Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeParameters = LegalHoldResource.this.schedulerApplication.getNoticeUtils().getNoticeBuiltInParameters(noticeModel, null);
                        NoticeInfo noticeInfo = new NoticeInfo(noticeModel, this.noticeIdToEvents.get(noticeId));
                        noticeInfo.evaluateParameters(noticeParameters);
                        String[] values = new String[]{LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)noticeInfo.getType()), noticeInfo.getSubject(), String.valueOf(noticeInfo.getEventsCount()), String.valueOf(noticeInfo.getViewedCount()), String.valueOf(noticeInfo.getRespondedCount()), String.valueOf(noticeInfo.getEscalatedCount())};
                        csvWriter.writeNext(values);
                    }
                    String noticesOverviewCsvName = "Notices Overview.csv";
                    zipOutputStream.putNextEntry(new ZipEntry(noticesOverviewCsvName));
                    zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOGGER.error("Error writing notices overview info CSV", (Throwable)e);
                }
            }

            private void writeNoticeResponses(ZipOutputStream zipOutputStream) {
                DateTimeFormatter excelDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.of("UTC"));
                for (String noticeId : this.noticeIds) {
                    com.nuix.automate.utils.models.api.notice.Notice noticeModel = LegalHoldResource.this.schedulerApplication.getNoticeResource().getNotice(noticeId);
                    if (!noticeModel.hasSurveyFormOptions()) continue;
                    Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeParameters = LegalHoldResource.this.schedulerApplication.getNoticeUtils().getNoticeBuiltInParameters(noticeModel, null);
                    try (StringWriter writer = new StringWriter();
                         CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                        List<String> responseHeaders = Arrays.asList("Custodian", "Response Date", "Escalated Date");
                        ArrayList<String> headers = new ArrayList<String>(responseHeaders);
                        ArrayList<FormOption> formOptions = new ArrayList<FormOption>(noticeModel.getSurveyFormOptions());
                        formOptions.removeIf(formOption -> formOption.getType() == FormElementType.HEADER);
                        for (FormOption formOption2 : formOptions) {
                            String description;
                            switch (formOption2.getType()) {
                                case DATA_UPLOAD: 
                                case CHECKBOX: {
                                    description = formOption2.getLabel();
                                    break;
                                }
                                default: {
                                    description = formOption2.getDescription();
                                }
                            }
                            description = LegalHoldResource.this.schedulerApplication.getNoticeUtils().evaluateParameters(noticeParameters, description);
                            headers.add(description);
                        }
                        csvWriter.writeNext(headers.toArray(new String[0]));
                        for (NoticeEvent noticeEventModel : this.noticeIdToEvents.get(noticeId)) {
                            String[] values = new String[headers.size()];
                            UserAccount noticeEventUser = LegalHoldResource.this.schedulerApplication.getUserServiceResource().getUser(noticeEventModel.getUserId());
                            Long respondedDate = noticeEventModel.getLastRespondedDate();
                            Long escalatedDate = noticeEventModel.getEscalatedDate();
                            values[0] = noticeEventUser != null ? noticeEventUser.getName() : "N/A";
                            values[1] = respondedDate != null ? excelDateTimeFormatter.format(Instant.ofEpochMilli(respondedDate)) : "N/A";
                            values[2] = escalatedDate != null ? excelDateTimeFormatter.format(Instant.ofEpochMilli(escalatedDate)) : "";
                            Map surveyFormValues = noticeEventModel.getSurveyFormValues();
                            for (int i = 0; i < formOptions.size(); ++i) {
                                FormOption formOption3 = (FormOption)formOptions.get(i);
                                if (respondedDate != null && surveyFormValues != null && surveyFormValues.get(formOption3.getKey()) != null) {
                                    String value = (String)surveyFormValues.get(formOption3.getKey());
                                    if (formOption3.getType() == FormElementType.CHECKBOX) {
                                        value = Boolean.parseBoolean(value) ? LegalHoldResource.this.iu.getString("LegalHoldResource.SurveyValue.Checked") : LegalHoldResource.this.iu.getString("LegalHoldResource.SurveyValue.Unchecked");
                                    }
                                    if (formOption3.getType() == FormElementType.DATA_UPLOAD) {
                                        value = FileInfoCache.getInstance().getDatasetRootFileInfos(value).stream().map(fileInfo -> {
                                            String relativePath = fileInfo.getRelativePath();
                                            if (relativePath == null) {
                                                relativePath = "N/A";
                                            }
                                            return relativePath + " / " + FormattingUtils.sizeToDisplaySize((long)fileInfo.getSize());
                                        }).collect(Collectors.joining("\n"));
                                    }
                                    values[i + responseHeaders.size()] = value;
                                    continue;
                                }
                                values[i + responseHeaders.size()] = "";
                            }
                            csvWriter.writeNext(values);
                        }
                        String noticeModelCsvName = this.getNoticeFolderName(noticeModel, noticeParameters) + "/Responses.csv";
                        zipOutputStream.putNextEntry(new ZipEntry(noticeModelCsvName));
                        zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error writing notice CSV for " + noticeId, (Throwable)e);
                    }
                }
            }

            private void writeUserNoticeHtmls(ZipOutputStream zipOutputStream) throws IOException {
                NoticeHtmlBuilder noticeHtmlBuilder;
                block25: {
                    noticeHtmlBuilder = new NoticeHtmlBuilder(LegalHoldResource.this.schedulerApplication, user, noticeExportOptions);
                    try (InputStream stylesInputStream = this.getClass().getResourceAsStream("/templates/userNoticeStyles.css");){
                        if (LegalHoldResource.this.schedulerApplication.getConfiguration().getInlineUserNoticeCss()) {
                            String cssText = IOUtils.toString((InputStream)stylesInputStream, (Charset)StandardCharsets.UTF_8);
                            noticeHtmlBuilder.addStyleElement(cssText);
                            break block25;
                        }
                        zipOutputStream.putNextEntry(new ZipEntry("styles.css"));
                        try (ReadableByteChannel stylesReadableChannel = Channels.newChannel(stylesInputStream);
                             WritableByteChannel zipWriteableChannel = Channels.newChannel(zipOutputStream);){
                            ByteBuffer buffer = ByteBuffer.allocate(8192);
                            while (stylesReadableChannel.read(buffer) != -1) {
                                buffer.flip();
                                while (buffer.hasRemaining()) {
                                    zipWriteableChannel.write(buffer);
                                }
                                buffer.compact();
                            }
                            noticeHtmlBuilder.linkStyleSheet("../../styles.css");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot add HTML notice CSS", (Throwable)e);
                    }
                }
                for (String noticeId : this.noticeIds) {
                    com.nuix.automate.utils.models.api.notice.Notice notice = LegalHoldResource.this.schedulerApplication.getNoticeResource().getNotice(noticeId);
                    noticeHtmlBuilder.imprintNotice(notice);
                    for (NoticeEvent noticeEvent : this.noticeIdToEvents.get(noticeId)) {
                        String htmlResult = noticeHtmlBuilder.printNoticeEvent(noticeEvent);
                        Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeEventParameters = LegalHoldResource.this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
                        String html = LegalHoldResource.this.schedulerApplication.getNoticeUtils().evaluateParameters(noticeEventParameters, htmlResult);
                        UserAccount noticeEventUser = LegalHoldResource.this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
                        String username = noticeEventUser != null ? noticeEventUser.getName() : noticeEvent.getId();
                        String sanitizedUserName = FormattingUtils.sanitizeFilename((String)username);
                        String userNoticeHtmlName = this.getNoticeFolderName(notice, noticeEventParameters) + "/HTML/" + sanitizedUserName + " (" + noticeEvent.getId().substring(0, 5) + ").html";
                        zipOutputStream.putNextEntry(new ZipEntry(userNoticeHtmlName));
                        zipOutputStream.write(html.getBytes(StandardCharsets.UTF_8));
                    }
                }
            }

            private String getNoticeFolderName(com.nuix.automate.utils.models.api.notice.Notice noticeModel, Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeParameters) {
                String folderName = noticeModel.getSubject() + " (" + UidUtils.getShortId((String)noticeModel.getId()) + ")";
                String evaluatedFolderName = LegalHoldResource.this.schedulerApplication.getNoticeUtils().evaluateParameters(noticeParameters, folderName);
                return FormattingUtils.sanitizeFilename((String)evaluatedFolderName);
            }
        };
        DateTimeFormatter fileDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC"));
        String fileName = FormattingUtils.sanitizeFilename((String)(fileDateTimeFormatter.format(Instant.ofEpochMilli(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis())) + " " + legalHold.getName() + " (" + UidUtils.getShortId((String)legalHold.getId()) + ")"));
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)streamingOutput, (String)(fileName + ".zip"));
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHolds", summary="Get Legal Holds", description="Get legal holds", responses={@ApiResponse(description="The list of legal holds", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.legalhold.LegalHold.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getLegalHolds(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LEGAL_HOLDS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<com.nuix.automate.utils.models.api.legalhold.LegalHold> viewableLegalHolds = new ArrayList<com.nuix.automate.utils.models.api.legalhold.LegalHold>();
            for (com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold : this.legalHolds.values()) {
                com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                if (!result.canView()) continue;
                result.normalize();
                viewableLegalHolds.add(result);
            }
            SortingUtils.sortList(viewableLegalHolds, com.nuix.automate.utils.models.api.legalhold.LegalHold::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(viewableLegalHolds).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldAuditLog", description="Get Legal Hold Audit Log", summary="Get legal holds audit log", responses={@ApiResponse(description="The audit log", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AuditEvent.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/auditLog")
    @GET
    public Response getAuditLogs(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LEGAL_HOLD, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>();
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            Set permissions = legalHold.getUserPermissions();
            if (permissions.contains(Permission.VIEW) && permissions.contains(Permission.VIEW_SENSITIVE)) {
                auditEvents.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(legalHoldId));
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(auditEvents).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="AddLegalHoldParticipations", summary="Add Legal Hold Participations", description="Add legal hold participations", responses={@ApiResponse(description="The custodian import result", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserImportResult.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/participations")
    @POST
    public Response addLegalHoldParticipations(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId, @Parameter(description="The identifier type") @QueryParam(value="identifier") String identifierType, @Parameter(description="The identifier type") @QueryParam(value="role") LegalHoldRole legalHoldRole, @Parameter(description="The list of user identifiers") List<String> userIdentifiers) throws IOException {
        String normalizedIdentifierType;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.getLegalHold(legalHoldId);
        if (legalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        if (!result.getUserPermissions().contains(Permission.MODIFY) && !result.getUserPermissions().contains(Permission.MANAGE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        Set<String> userSyncEnabledUserServiceIds = this.schedulerApplication.getUserServiceResource().getUserSyncEnabledUserServiceIds();
        HashMap<String, Set> identifierToUsers = new HashMap<String, Set>();
        switch (identifierType) {
            case "id": {
                Iterator<UserAccount> users = this.schedulerApplication.getUserServiceResource().getImmutableUsers();
                for (Map.Entry<String, UserAccount> userEntry : users.entrySet()) {
                    if (userEntry.getValue().getUserServiceId() == null || !userSyncEnabledUserServiceIds.contains(userEntry.getValue().getUserServiceId())) continue;
                    Set existingMapping = identifierToUsers.computeIfAbsent(userEntry.getKey().trim().toLowerCase(), k -> new HashSet());
                    existingMapping.add(userEntry.getValue());
                }
                normalizedIdentifierType = IDENTIFIER_TYPE_ID;
                break;
            }
            case "name": {
                Set existingMapping;
                for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getImmutableUsers().values()) {
                    if (userAccount.getUserServiceId() == null || !userSyncEnabledUserServiceIds.contains(userAccount.getUserServiceId())) continue;
                    existingMapping = identifierToUsers.computeIfAbsent(userAccount.getName().trim().toLowerCase(), k -> new HashSet());
                    existingMapping.add(userAccount);
                }
                normalizedIdentifierType = IDENTIFIER_TYPE_NAME;
                break;
            }
            case "email": {
                Set existingMapping;
                for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getImmutableUsers().values()) {
                    if (userAccount.getUserServiceId() == null || !userSyncEnabledUserServiceIds.contains(userAccount.getUserServiceId()) || !userAccount.hasEmail()) continue;
                    existingMapping = identifierToUsers.computeIfAbsent(userAccount.getEmail().trim().toLowerCase(), k -> new HashSet());
                    existingMapping.add(userAccount);
                }
                normalizedIdentifierType = IDENTIFIER_TYPE_EMAIL;
                break;
            }
            default: {
                return ExceptionUtils.toResponse((String)"unknownIdentifierType");
            }
        }
        String currentDate = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC")).format(Instant.ofEpochMilli(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        String fileName = FormattingUtils.sanitizeFilename((String)(currentDate + " " + legalHold.getName() + " (" + legalHold.getId().substring(0, 5) + ") - Custodian Import.csv"));
        UserImportResult importResult = new UserImportResult(fileName, userIdentifiers.size());
        ArrayList<LegalHoldParticipation> newLegalHoldParticipations = new ArrayList<LegalHoldParticipation>();
        try (StringWriter writer = new StringWriter();
             CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            csvWriter.writeNext(new String[]{StringUtils.capitalize((String)normalizedIdentifierType), "Status", "Details"});
            String[] values = new String[3];
            HashSet<String> addedUserIds = new HashSet<String>();
            Iterator<String> iterator = userIdentifiers.iterator();
            while (iterator.hasNext()) {
                String identifier;
                values[0] = identifier = iterator.next();
                boolean userAdded = false;
                Set userAccounts = null;
                if (identifier != null) {
                    userAccounts = (Set)identifierToUsers.get(identifier.trim().toLowerCase());
                }
                if (userAccounts != null) {
                    for (UserAccount userAccount : userAccounts) {
                        values[2] = null;
                        if (userAccount == null) {
                            values[2] = this.iu.getString("LegalHoldResource.UserImport.CustodianNotFound");
                        } else if (userAccount.getId() == null) {
                            values[2] = this.iu.getString("LegalHoldResource.UserImport.UserMissingId");
                        } else if (userAccount.getUserAccountState() == UserAccountState.DELETED) {
                            values[2] = this.iu.getString("LegalHoldResource.UserImport.UserDeleted");
                        } else if (!this.isUserCompatibleWithLegalHold(userAccount, legalHold)) {
                            switch (legalHoldRole) {
                                case ADMINISTRATOR: {
                                    if (this.isUserCompatibleWithLegalHold(userAccount, legalHold)) break;
                                    values[2] = this.iu.getString("LegalHoldResource.UserImport.ManagedUserAdminRequiresSsoLinks");
                                    break;
                                }
                                case CUSTODIAN: {
                                    if (this.isUserCompatibleWithLegalHold(userAccount, legalHold)) break;
                                    values[2] = this.iu.getString("LegalHoldResource.UserImport.ManagedUserCustodianRequiresSsoLinks");
                                }
                            }
                        } else {
                            UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId());
                            if (userService == null) {
                                values[2] = this.iu.getString("LegalHoldResource.UserImport.UserServiceNotFound");
                            } else {
                                switch (legalHoldRole) {
                                    case ADMINISTRATOR: {
                                        if (userService.getUsersEligibleLegalHoldAdministrator() == Boolean.TRUE) break;
                                        values[2] = this.iu.getString("LegalHoldResource.UserImport.UserNotEligibleAdmin");
                                        break;
                                    }
                                    case CUSTODIAN: {
                                        if (userService.getUsersEligibleLegalHoldCustodian() == Boolean.TRUE) break;
                                        values[2] = this.iu.getString("LegalHoldResource.UserImport.UserNotEligibleCustodian");
                                    }
                                }
                            }
                        }
                        if (values[2] == null) {
                            if (addedUserIds.contains(userAccount.getId())) {
                                values[2] = this.iu.getString("LegalHoldResource.UserImport.SkippedDuplicateUser");
                            } else {
                                LegalHoldParticipation participation = LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipation(legalHoldId, userAccount.getId(), legalHoldRole);
                                if (participation != null) {
                                    values[2] = this.iu.getString("LegalHoldResource.UserImport.CustodianAlreadyPresent");
                                } else {
                                    participation = new LegalHoldParticipation(legalHoldId, userAccount.getId(), legalHoldRole);
                                    newLegalHoldParticipations.add(participation);
                                    userAdded = true;
                                    values[1] = this.iu.getString("LegalHoldResource.UserImport.Added");
                                    values[2] = "";
                                }
                            }
                        }
                        if (userAdded) {
                            addedUserIds.add(userAccount.getId());
                            break;
                        }
                        values[1] = this.iu.getString("LegalHoldResource.UserImport.NotAdded");
                    }
                } else {
                    values[1] = this.iu.getString("LegalHoldResource.UserImport.NotAdded");
                    values[2] = this.iu.getString("LegalHoldResource.UserImport.CustodianNotFound");
                }
                csvWriter.writeNext(values);
            }
            this.addLegalHoldParticipations(newLegalHoldParticipations);
            this.schedulerApplication.getSchedulerConfigurationDao().addLegalHoldParticipations(newLegalHoldParticipations);
            importResult.setAddedUserIds(addedUserIds);
            importResult.setFailedCount(importResult.getTotalCount() - addedUserIds.size());
            importResult.setCsv(((Object)writer).toString());
            if (legalHoldRole == LegalHoldRole.ADMINISTRATOR) {
                legalHold.getAdministratorIds().addAll(addedUserIds);
                this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
            }
        }
        if (legalHoldRole == LegalHoldRole.CUSTODIAN) {
            if (!newLegalHoldParticipations.isEmpty()) {
                SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_ADDED, new LegalHoldParticipations(newLegalHoldParticipations), user.getName());
            }
        } else {
            com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_MODIFIED, eventResult, user.getName());
            this.trackLegalHoldUtilization(legalHold);
        }
        this.updateLegalHoldImplicitPolicies(legalHoldId);
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHoldId);
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)importResult).build();
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldParticipations", summary="Get Legal Hold Participations", description="Get participations for a legal hold", responses={@ApiResponse(description="The participations for a legal hold", content={@Content(schema=@Schema(implementation=LegalHoldParticipations.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/participations")
    @GET
    public Response getParticipations(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LEGAL_HOLD, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            if (!legalHold.canViewSensitive()) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new LegalHoldParticipations(new ArrayList())).build();
            }
            List<LegalHoldParticipation> viewableParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId);
            Map<String, UserAccount> users = this.schedulerApplication.getUserServiceResource().getImmutableUsers();
            TreeMap<CallSite, LegalHoldParticipation> sortedParticipations = new TreeMap<CallSite, LegalHoldParticipation>();
            for (LegalHoldParticipation legalHoldParticipation : viewableParticipations) {
                UserAccount participationUser = users.get(legalHoldParticipation.getUserId());
                if (participationUser != null) {
                    sortedParticipations.put((CallSite)((Object)(String.valueOf(legalHoldParticipation.getRole()) + "_" + participationUser.getEmail() + "_" + legalHoldParticipation.getUserId())), legalHoldParticipation);
                    continue;
                }
                sortedParticipations.put((CallSite)((Object)(String.valueOf(legalHoldParticipation.getRole()) + "_N/A_" + legalHoldParticipation.getUserId())), legalHoldParticipation);
            }
            ArrayList sortedViewableParticipations = new ArrayList(sortedParticipations.values());
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new LegalHoldParticipations(sortedViewableParticipations)).build();
        }
    }

    public List<LegalHoldParticipation> getParticipations(String legalHoldId) {
        List<LegalHoldParticipation> participations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId);
        return participations;
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldTriggerConfigurationEvents", summary="Get Legal Hold Trigger Configuration Events", description="Get trigger configuration events for a legal hold", responses={@ApiResponse(description="The job events for a legal hold", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TriggerConfigurationEvent.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/triggerConfigurationEvents")
    @GET
    public Response getTriggerConfigurationEvents(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LEGAL_HOLD_TRIGGER_CONFIGURATION_EVENTS, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            if (!legalHold.canViewSensitive()) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
            }
            ArrayList<TriggerConfigurationEvent> viewableTriggerConfigurationsEvents = new ArrayList<TriggerConfigurationEvent>(this.schedulerApplication.getSchedulerConfigurationDao().getTriggerConfigurationEvents(legalHoldId));
            viewableTriggerConfigurationsEvents.sort(Comparator.comparing(TriggerConfigurationEvent::getTriggeredDate));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(viewableTriggerConfigurationsEvents).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldNoticeDatasetEvents", summary="Get Legal Hold Notice Dataset Events", description="Get notice dataset events for a legal hold", responses={@ApiResponse(description="The notice dataset events for a legal hold", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NoticeDatasetEvent.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/noticeDatasetEvents")
    @GET
    public Response getNoticeDatasetEvents(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICES, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            if (!legalHold.canViewSensitive()) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(new HashMap()).build();
            }
            Map<String, List<NoticeDatasetEvent>> viewableNoticeDatasetEvents = this.schedulerApplication.getLegalHoldUtils().getLegalHoldNoticeDatasetEvents(legalHoldId);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(viewableNoticeDatasetEvents).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldNoticeInfos", summary="Get Legal Hold Notice Infos", description="Get notice infos for a legal hold", responses={@ApiResponse(description="The notice infos for a legal hold", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NoticeInfo.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/noticeInfos")
    @GET
    public Response getLegalHoldNoticeInfos(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICES, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            if (!legalHold.canViewSensitive()) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
            }
            List<com.nuix.automate.utils.models.api.notice.Notice> noticeModels = this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldNotices(legalHoldId);
            ArrayList<NoticeInfo> noticeInfos = new ArrayList<NoticeInfo>();
            for (com.nuix.automate.utils.models.api.notice.Notice noticeModel : noticeModels) {
                try {
                    List<NoticeEvent> noticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents(noticeModel.getId());
                    Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeParameters = this.schedulerApplication.getNoticeUtils().getNoticeBuiltInParameters(noticeModel, null);
                    NoticeInfo noticeInfo = new NoticeInfo(noticeModel, noticeEvents);
                    noticeInfo.evaluateParameters(noticeParameters);
                    noticeInfos.add(noticeInfo);
                }
                catch (Exception e) {
                    LOGGER.error("Failed creating noticeInfo for: " + noticeModel.getId(), (Throwable)e);
                }
            }
            noticeInfos.sort(Comparator.comparing(NoticeInfo::getCreatedDate));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(noticeInfos).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="GetLegalHoldUserNotices", summary="Get Legal Hold User Notices", description="Get legal hold notices for user", responses={@ApiResponse(description="The user notices", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserNotice.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}/userNotices")
    @GET
    public Response getLegalHoldUserNoticeModels(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICES, legalHoldId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(user.getId());
            if (user.getId() == null || userAccount == null || !legalHold.canView()) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
            }
            List<com.nuix.automate.utils.models.api.notice.Notice> noticeModels = this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldNotices(legalHoldId);
            ArrayList<UserNotice> userNotices = new ArrayList<UserNotice>();
            for (com.nuix.automate.utils.models.api.notice.Notice noticeModel : noticeModels) {
                for (NoticeEvent noticeEvent : this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(noticeModel.getId(), user.getId())) {
                    UserNotice userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
                    if (!userNotice.canView()) continue;
                    userNotices.add(userNotice);
                }
            }
            userNotices.sort(Comparator.comparing(UserNotice::getSentDate));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(userNotices).build();
        }
    }

    @Operation(tags={"Legal Hold"}, operationId="AddLegalHold", summary="Add Legal Hold", description="Add a new legal hold", responses={@ApiResponse(description="The legal hold that was added", content={@Content(schema=@Schema(implementation=com.nuix.automate.utils.models.api.legalhold.LegalHold.class))}), @ApiResponse(responseCode="400", description="A legal hold with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    public Response addLegalHold(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The legal hold to add", schema=@Schema(implementation=LegalHoldSubmission.class)) LegalHoldSubmission legalHoldSubmission) {
        LegalHoldParticipation legalHoldParticipation;
        String name;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.LEGAL_HOLDS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.CREATE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final String matterId = legalHoldSubmission.getMatterId();
        Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
        if (matter == null) {
            return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", matterId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Set matterPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions();
        if (!matterPermissions.contains(Permission.MODIFY) && !matterPermissions.contains(Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!matter.getEnabled().booleanValue()) {
            return ExceptionUtils.toResponse((String)"matterNotEnabled", (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)legalHoldSubmission);
        legalHoldSubmission.setClientId(matter.getClientId());
        if (legalHoldSubmission.getDataRepositoryId() != null) {
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
            resourceIdentifiers.add(new Identifier(IdentifierType.DATA_REPOSITORY_ID, legalHoldSubmission.getDataRepositoryId()));
            if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        if (legalHoldSubmission.getSmtpServerId() != null) {
            try {
                Object thirdPartyServicePermissions;
                ThirdPartyService smtpService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(legalHoldSubmission.getSmtpServerId());
                if (!(user instanceof SystemBearerUser) && !(thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, smtpService).getUserPermissions()).contains(Permission.VIEW)) {
                    return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)legalHoldSubmission);
                }
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
        }
        if ((name = legalHoldSubmission.getName()) == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"legalHoldNameMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        name = name.trim();
        for (com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold : this.legalHolds.values()) {
            if (!name.equalsIgnoreCase(legalHold.getName())) continue;
            return ExceptionUtils.toResponse((String)"legalHoldNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        legalHoldSubmission.setName(name);
        if (!Boolean.TRUE.equals(legalHoldSubmission.getSilent())) {
            Map<String, com.nuix.automate.utils.models.api.job.Parameter> parameters;
            LinkedHashMap surveyNoticeConfigurations;
            NoticeConfiguration releaseNoticeConfiguration;
            final NoticeConfiguration holdNoticeConfiguration = legalHoldSubmission.getHoldNoticeConfiguration();
            if (holdNoticeConfiguration == null) {
                return ExceptionUtils.toResponse((String)"missingHoldNoticeConfiguration", (Response.Status)Response.Status.BAD_REQUEST);
            }
            holdNoticeConfiguration.setEnabled(Boolean.valueOf(true));
            holdNoticeConfiguration.setNoticeType(NoticeType.HOLD);
            if (!this.validatePermissionForNoticeTemplate(user, holdNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (!holdNoticeConfiguration.isValid()) {
                return ExceptionUtils.toResponse((String)"holdNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
            }
            NoticeTemplate holdNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(holdNoticeConfiguration.getNoticeTemplateId());
            if (holdNoticeTemplate == null) {
                return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                    {
                        this.put("noticeTemplateId", holdNoticeConfiguration.getNoticeTemplateId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (legalHoldSubmission.getSurveyNoticesTrigger() == null || !holdNoticeTemplate.hasSurveyFormOptions()) {
                legalHoldSubmission.setSurveyNoticesTrigger(SurveyNoticesTrigger.ON_HOLD);
            }
            if ((releaseNoticeConfiguration = legalHoldSubmission.getReleaseNoticeConfiguration()) == null) {
                return ExceptionUtils.toResponse((String)"missingReleaseNoticeConfiguration", (Response.Status)Response.Status.BAD_REQUEST);
            }
            releaseNoticeConfiguration.setEnabled(Boolean.valueOf(true));
            releaseNoticeConfiguration.setNoticeType(NoticeType.RELEASE);
            if (!this.validatePermissionForNoticeTemplate(user, releaseNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (!releaseNoticeConfiguration.isValid()) {
                return ExceptionUtils.toResponse((String)"releaseNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
            }
            NoticeTemplate releaseNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(releaseNoticeConfiguration.getNoticeTemplateId());
            if (releaseNoticeTemplate == null) {
                return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                    {
                        this.put("noticeTemplateId", releaseNoticeConfiguration.getNoticeTemplateId());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            final NoticeConfiguration recurringNoticeConfiguration = legalHoldSubmission.getRecurringNoticeConfiguration();
            if (recurringNoticeConfiguration != null && Boolean.TRUE.equals(recurringNoticeConfiguration.getEnabled())) {
                recurringNoticeConfiguration.setNoticeType(NoticeType.RECURRING);
                if (!this.validatePermissionForNoticeTemplate(user, recurringNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                if (!recurringNoticeConfiguration.isValid()) {
                    return ExceptionUtils.toResponse((String)"recurringNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (recurringNoticeConfiguration.getEnabled() == Boolean.TRUE && this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(recurringNoticeConfiguration.getNoticeTemplateId()) == null) {
                    return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                        {
                            this.put("noticeTemplateId", recurringNoticeConfiguration.getNoticeTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if ((surveyNoticeConfigurations = legalHoldSubmission.getSurveyNoticeConfigurations()) != null) {
                for (Object surveyNoticeConfiguration : surveyNoticeConfigurations.values()) {
                    surveyNoticeConfiguration.setNoticeType(NoticeType.SURVEY);
                    if (!this.validatePermissionForNoticeTemplate(user, surveyNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                    if (!surveyNoticeConfiguration.isValid()) {
                        return ExceptionUtils.toResponse((String)"surveyNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (surveyNoticeConfiguration.getEnabled() != Boolean.TRUE || this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(surveyNoticeConfiguration.getNoticeTemplateId()) != null) continue;
                    return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>((NoticeConfiguration)surveyNoticeConfiguration){
                        final /* synthetic */ NoticeConfiguration val$surveyNoticeConfiguration;
                        {
                            this.val$surveyNoticeConfiguration = noticeConfiguration;
                            this.put("noticeTemplateId", this.val$surveyNoticeConfiguration.getNoticeTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if ((parameters = legalHoldSubmission.getParameters()) != null) {
                for (com.nuix.automate.utils.models.api.job.Parameter parameterModel : parameters.values()) {
                    if (parameterModel.getName() != null && parameterModel.getName().trim().length() != 0 && parameterModel.getValue() != null) continue;
                    return ExceptionUtils.toResponse((String)"legalHoldMissingParameters", (Response.Status)Response.Status.BAD_REQUEST);
                }
                parameters = this.schedulerApplication.getNoticeUtils().normalizeParameters(parameters);
                for (final String parameterName : parameters.keySet()) {
                    if (!NoticeUtils.builtInParameterNames.contains(parameterName)) continue;
                    return ExceptionUtils.toResponse((String)"cannotUseBuiltInParameter", (Map)new HashMap<String, String>(){
                        {
                            this.put("parameter", parameterName);
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                legalHoldSubmission.setParameters(parameters);
            }
        }
        if (Boolean.TRUE.equals(legalHoldSubmission.getTriggerJobs())) {
            try {
                this.validatePermissionsForExecutionProfileAndResourcePool(user, legalHoldSubmission);
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
            LinkedHashMap triggerConfigurations = legalHoldSubmission.getTriggerConfigurations();
            if (triggerConfigurations != null) {
                for (final TriggerConfiguration triggerConfiguration : triggerConfigurations.values()) {
                    triggerConfiguration.setTriggered(false);
                    JobModel job = new JobModel();
                    job.setClientId(legalHoldSubmission.getClientId());
                    job.setMatterId(legalHoldSubmission.getMatterId());
                    job.setExecutionProfileId(legalHoldSubmission.getExecutionProfileId());
                    job.setResourcePoolId(legalHoldSubmission.getResourcePoolId());
                    job.setPriority(legalHoldSubmission.getPriority());
                    job.setLibraryId(triggerConfiguration.getWorkflowLibraryId());
                    job.setLibraryWorkflowId(triggerConfiguration.getWorkflowTemplateId());
                    if (!this.validatePermissionsForJobWorkflow(user, job)) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                    if (!triggerConfiguration.isValid()) {
                        return ExceptionUtils.toResponse((String)"triggerConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (triggerConfiguration.getEnabled() != Boolean.TRUE) continue;
                    WorkflowLibrary triggerConfigurationWorkflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(triggerConfiguration.getWorkflowLibraryId());
                    if (triggerConfigurationWorkflowLibrary == null) {
                        return ExceptionUtils.toResponse((String)"cannotFindWorkflowLibrary", (Map)new HashMap<String, String>(){
                            {
                                this.put(LegalHoldResource.IDENTIFIER_TYPE_ID, triggerConfiguration.getWorkflowLibraryId());
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    Workflow triggerConfigurationLibraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(triggerConfiguration.getWorkflowTemplateId());
                    if (triggerConfigurationLibraryWorkflow != null) continue;
                    return ExceptionUtils.toResponse((String)"cannotFindLibraryWorkflow", (Map)new HashMap<String, String>(){
                        {
                            this.put(LegalHoldResource.IDENTIFIER_TYPE_ID, triggerConfiguration.getWorkflowTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
        }
        if (!this.areUsersCompatibleWthLegalHold(legalHoldSubmission.getSilent(), legalHoldSubmission.getEnableLoginLinks(), legalHoldSubmission.getAdministratorIds())) {
            return ExceptionUtils.toResponse((String)"invalidAdministratorsNoSsoLinkWithManagedUserService", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!this.areUsersCompatibleWthLegalHold(legalHoldSubmission.getSilent(), legalHoldSubmission.getEnableLoginLinks(), legalHoldSubmission.getCustodianIds())) {
            return ExceptionUtils.toResponse((String)"invalidCustodianNoSsoLinkWithManagedUserService", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Response errorResponse = this.validateAdministratorAndCustodianUsers(legalHoldSubmission.getAdministratorIds(), legalHoldSubmission.getCustodianIds());
        if (errorResponse != null) {
            return errorResponse;
        }
        String legalHoldId = UidUtils.getRandom();
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = new com.nuix.automate.utils.models.api.legalhold.LegalHold(legalHoldSubmission);
        legalHold.setId(legalHoldId);
        legalHold.setDefaults();
        legalHold.setState(LegalHoldState.DRAFT);
        legalHold.setTaskDone();
        long createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        legalHold.setCreatedDate(Long.valueOf(createdDate));
        legalHold.setCreatedBy(user.getName());
        legalHold.setCreatedByUserId(user.getId());
        this.schedulerApplication.getSchedulerConfigurationDao().addLegalHold(legalHold);
        this.legalHolds.put(legalHoldId, legalHold);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHoldId, Long.valueOf(createdDate), user.getName(), EventType.Type.LEGAL_HOLD_ADDED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.trackLegalHoldUtilization(legalHold);
        ArrayList<LegalHoldParticipation> legalHoldParticipations = new ArrayList<LegalHoldParticipation>();
        ArrayList<LegalHoldParticipation> custodiansAdded = new ArrayList<LegalHoldParticipation>();
        for (String administratorId : legalHoldSubmission.getAdministratorIds()) {
            legalHoldParticipation = new LegalHoldParticipation(legalHoldId, administratorId, LegalHoldRole.ADMINISTRATOR);
            legalHoldParticipations.add(legalHoldParticipation);
        }
        for (String custodianId : legalHoldSubmission.getCustodianIds()) {
            legalHoldParticipation = new LegalHoldParticipation(legalHoldId, custodianId, LegalHoldRole.CUSTODIAN);
            legalHoldParticipations.add(legalHoldParticipation);
            custodiansAdded.add(legalHoldParticipation);
        }
        this.addLegalHoldParticipations(legalHoldParticipations);
        this.schedulerApplication.getSchedulerConfigurationDao().addLegalHoldParticipations(legalHoldParticipations);
        this.updateLegalHoldImplicitPolicies(legalHoldId, legalHoldParticipations);
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHoldId);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, legalHoldId);
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
        com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_ADDED, eventResult, user.getName());
        if (custodiansAdded.size() > 0) {
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_CUSTODIANS_ADDED, new LegalHoldParticipations(custodiansAdded), user.getName());
        }
        this.schedulerApplication.getScheduleWorker().triggerLegalHoldEvent(LegalHoldEvent.LEGAL_HOLD_CREATED, legalHold, custodiansAdded);
        com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Legal Hold"}, operationId="UpdateLegalHold", summary="Update Legal Hold", description="Update the legal hold with the specified ID", responses={@ApiResponse(description="The updated legal hold", content={@Content(schema=@Schema(implementation=com.nuix.automate.utils.models.api.legalhold.LegalHold.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}")
    @PUT
    public Response updateLegalHold(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="legalHoldId") String legalHoldId, @Parameter(description="The information to update the legal hold with", schema=@Schema(implementation=LegalHoldSubmission.class)) LegalHoldSubmission legalHoldSubmission) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold = this.getLegalHold(legalHoldId);
        if (originalLegalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        com.nuix.automate.utils.models.api.legalhold.LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
        Response errorResponse = this.validateLegalHoldUpdate(user, originalLegalHold, legalHoldSubmission, result.getUserPermissions());
        if (errorResponse != null) {
            return errorResponse;
        }
        if (this.isLegalHoldCommandInProgress(originalLegalHold)) {
            return ExceptionUtils.toResponse((String)"legalHoldCommandInProgress", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            FormattingUtils.trimAllStrings((Object)legalHoldSubmission);
            this.performLegalHoldUpdate(user, originalLegalHold, legalHoldSubmission, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
            com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_MODIFIED, eventResult, user.getName());
            this.trackLegalHoldUtilization(originalLegalHold);
            if (originalLegalHold.getState().equals((Object)LegalHoldState.ACTIVE)) {
                this.trackLegalHoldNoticesUtilization(originalLegalHold);
            }
            result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLegalHold);
            this.updateLegalHoldImplicitPolicies(legalHoldId);
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHoldId);
            ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, legalHoldId);
            result.normalize();
            Response response = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
            return response;
        }
        finally {
            originalLegalHold.setCommandInProgress(false);
        }
    }

    private Response validateLegalHoldUpdate(BearerUser user, final com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold, LegalHoldSubmission legalHoldSubmission, Set<Permission> permissions) {
        Boolean triggerJobs;
        boolean isActive;
        boolean canModify = permissions.contains(Permission.MODIFY);
        boolean canManage = permissions.contains(Permission.MANAGE);
        if (!canModify && !canManage) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean isDraft = originalLegalHold.getState() == LegalHoldState.DRAFT;
        boolean bl = isActive = originalLegalHold.getState() == LegalHoldState.ACTIVE;
        if (!isDraft && !isActive) {
            return ExceptionUtils.toResponse((String)"cannotModifyLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("state", originalLegalHold.getState().toString());
                }
            }, (Response.Status)Response.Status.FORBIDDEN);
        }
        String name = legalHoldSubmission.getName();
        String matterId = legalHoldSubmission.getMatterId();
        String dataRepositoryId = legalHoldSubmission.getDataRepositoryId();
        String smtpServerId = legalHoldSubmission.getSmtpServerId();
        if (matterId != null && !matterId.equals(originalLegalHold.getMatterId())) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (name != null && name.trim().length() > 0 && !name.equals(originalLegalHold.getName())) {
            if (!canModify) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            for (com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold : this.legalHolds.values()) {
                if (legalHold.getId().equals(originalLegalHold.getId()) || !name.equalsIgnoreCase(legalHold.getName())) continue;
                return ExceptionUtils.toResponse((String)"legalHoldNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if (dataRepositoryId != null && !dataRepositoryId.equals(originalLegalHold.getDataRepositoryId())) {
            if (!canModify) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
            resourceIdentifiers.add(new Identifier(IdentifierType.DATA_REPOSITORY_ID, dataRepositoryId));
            if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)originalLegalHold);
            }
        }
        if (smtpServerId != null && !smtpServerId.equals(originalLegalHold.getSmtpServerId())) {
            if (!canModify) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)originalLegalHold);
            }
            try {
                Set thirdPartyServicePermissions;
                ThirdPartyService smtpService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(smtpServerId);
                if (!(user instanceof SystemBearerUser) && !(thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, smtpService).getUserPermissions()).contains(Permission.VIEW)) {
                    return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)originalLegalHold);
                }
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
        }
        final NoticeConfiguration holdNoticeConfiguration = legalHoldSubmission.getHoldNoticeConfiguration();
        NoticeConfiguration originalHoldNoticeConfiguration = originalLegalHold.getHoldNoticeConfiguration();
        final NoticeConfiguration releaseNoticeConfiguration = legalHoldSubmission.getReleaseNoticeConfiguration();
        NoticeConfiguration originalReleaseNoticeConfiguration = originalLegalHold.getReleaseNoticeConfiguration();
        LinkedHashMap surveyNoticeConfigurations = legalHoldSubmission.getSurveyNoticeConfigurations();
        LinkedHashMap originalSurveyNoticeConfigurations = originalLegalHold.getSurveyNoticeConfigurations();
        Boolean silent = legalHoldSubmission.getSilent();
        if (silent != null && !silent.equals(originalLegalHold.getSilent())) {
            if (!canModify) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (!isDraft) {
                return ExceptionUtils.toResponse((String)"cannotChangeActiveLegalHoldSilentState", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if (silent == null) {
            silent = originalLegalHold.getSilent();
        }
        if (!Boolean.TRUE.equals(silent)) {
            SurveyNoticesTrigger surveyNoticesTrigger = legalHoldSubmission.getSurveyNoticesTrigger();
            if (surveyNoticesTrigger != null && surveyNoticesTrigger != originalLegalHold.getSurveyNoticesTrigger()) {
                NoticeTemplate holdNoticeTemplate;
                if (!canModify) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                if (!isDraft) {
                    return ExceptionUtils.toResponse((String)"cannotChangeActiveLegalHoldSurveyNoticesTrigger", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (surveyNoticesTrigger == SurveyNoticesTrigger.ON_HOLD_RESPONSE && !(holdNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(originalHoldNoticeConfiguration.getNoticeTemplateId())).hasSurveyFormOptions()) {
                    return ExceptionUtils.toResponse((String)"holdNoticeHasNoSurveyFormOptionsForSurveyTrigger", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if (holdNoticeConfiguration != null) {
                boolean changedNoticeTemplateId;
                holdNoticeConfiguration.setEnabled(Boolean.valueOf(true));
                holdNoticeConfiguration.setNoticeType(NoticeType.HOLD);
                if (!canModify && holdNoticeConfiguration.different(originalHoldNoticeConfiguration)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                boolean bl2 = changedNoticeTemplateId = originalHoldNoticeConfiguration == null || holdNoticeConfiguration.getNoticeTemplateId() != null && !holdNoticeConfiguration.getNoticeTemplateId().equals(originalHoldNoticeConfiguration.getNoticeTemplateId());
                if (changedNoticeTemplateId && !this.validatePermissionForNoticeTemplate(user, holdNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                NoticeTemplate holdNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(holdNoticeConfiguration.getNoticeTemplateId());
                if (holdNoticeTemplate == null) {
                    return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                        {
                            this.put("noticeTemplateId", holdNoticeConfiguration.getNoticeTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (!holdNoticeConfiguration.isValid() || originalHoldNoticeConfiguration != null && !originalHoldNoticeConfiguration.isChangeValid(holdNoticeConfiguration)) {
                    return ExceptionUtils.toResponse((String)"holdNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if (releaseNoticeConfiguration != null) {
                boolean changedNoticeTemplateId;
                releaseNoticeConfiguration.setEnabled(Boolean.valueOf(true));
                releaseNoticeConfiguration.setNoticeType(NoticeType.RELEASE);
                if (!canModify && releaseNoticeConfiguration.different(originalReleaseNoticeConfiguration)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                boolean bl3 = changedNoticeTemplateId = originalReleaseNoticeConfiguration == null || releaseNoticeConfiguration.getNoticeTemplateId() != null && !releaseNoticeConfiguration.getNoticeTemplateId().equals(originalReleaseNoticeConfiguration.getNoticeTemplateId());
                if (changedNoticeTemplateId && !this.validatePermissionForNoticeTemplate(user, releaseNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
                NoticeTemplate releaseNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(releaseNoticeConfiguration.getNoticeTemplateId());
                if (releaseNoticeTemplate == null) {
                    return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                        {
                            this.put("noticeTemplateId", releaseNoticeConfiguration.getNoticeTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (!releaseNoticeConfiguration.isValid() || originalReleaseNoticeConfiguration != null && !originalReleaseNoticeConfiguration.isChangeValid(releaseNoticeConfiguration)) {
                    return ExceptionUtils.toResponse((String)"releaseNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if (surveyNoticeConfigurations != null) {
                if (!canModify) {
                    boolean surveyNoticeConfigurationsChanged;
                    boolean bl4 = surveyNoticeConfigurationsChanged = originalSurveyNoticeConfigurations == null || originalSurveyNoticeConfigurations.size() != surveyNoticeConfigurations.size();
                    if (!surveyNoticeConfigurationsChanged) {
                        for (String key : surveyNoticeConfigurations.keySet()) {
                            NoticeConfiguration surveyNoticeConfiguration = (NoticeConfiguration)surveyNoticeConfigurations.get(key);
                            NoticeConfiguration originalSurveyNoticeConfiguration = (NoticeConfiguration)originalSurveyNoticeConfigurations.get(key);
                            if (originalSurveyNoticeConfiguration != null && !originalSurveyNoticeConfiguration.different(surveyNoticeConfiguration)) continue;
                            surveyNoticeConfigurationsChanged = true;
                            break;
                        }
                    }
                    if (surveyNoticeConfigurationsChanged) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                }
                for (final NoticeConfiguration surveyNoticeConfiguration : surveyNoticeConfigurations.values()) {
                    NoticeTemplate noticeTemplate;
                    surveyNoticeConfiguration.setNoticeType(NoticeType.SURVEY);
                    boolean changedNoticeTemplateId = true;
                    if (originalSurveyNoticeConfigurations != null) {
                        NoticeConfiguration originalSurveyNoticeConfiguration = (NoticeConfiguration)originalSurveyNoticeConfigurations.get(surveyNoticeConfiguration.getId());
                        boolean bl5 = changedNoticeTemplateId = originalSurveyNoticeConfiguration == null || surveyNoticeConfiguration.getNoticeTemplateId() != null && !surveyNoticeConfiguration.getNoticeTemplateId().equals(originalSurveyNoticeConfiguration.getNoticeTemplateId());
                    }
                    if (changedNoticeTemplateId && !this.validatePermissionForNoticeTemplate(user, surveyNoticeConfiguration.getNoticeTemplateId(), Permission.VIEW)) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                    if (surveyNoticeConfiguration.getEnabled() == Boolean.TRUE && (noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(surveyNoticeConfiguration.getNoticeTemplateId())) == null) {
                        return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                            {
                                this.put("noticeTemplateId", surveyNoticeConfiguration.getNoticeTemplateId());
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (surveyNoticeConfiguration.isValid()) continue;
                    return ExceptionUtils.toResponse((String)"surveyNoticeConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (originalSurveyNoticeConfigurations != null) {
                    for (NoticeConfiguration originalSurveyNoticeConfiguration : originalSurveyNoticeConfigurations.values()) {
                        NoticeConfiguration surveyNoticeConfiguration;
                        if (originalSurveyNoticeConfiguration.isChangeValid(surveyNoticeConfiguration = (NoticeConfiguration)surveyNoticeConfigurations.get(originalSurveyNoticeConfiguration.getId()))) continue;
                        return ExceptionUtils.toResponse((String)"cannotChangeTriggeredNoticeConfiguration", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                }
            }
        }
        Map<String, com.nuix.automate.utils.models.api.job.Parameter> parameters = legalHoldSubmission.getParameters();
        Map originalParameters = originalLegalHold.getParameters();
        if (parameters != null) {
            if (!canModify) {
                boolean parametersChanged;
                boolean bl6 = parametersChanged = originalParameters == null || originalParameters.size() != parameters.size();
                if (!parametersChanged) {
                    for (String key : parameters.keySet()) {
                        com.nuix.automate.utils.models.api.job.Parameter parameter = parameters.get(key);
                        com.nuix.automate.utils.models.api.job.Parameter originalParameter = (com.nuix.automate.utils.models.api.job.Parameter)originalParameters.get(key);
                        if (originalParameter != null && originalParameter.getValue().equals(parameter.getValue())) continue;
                        parametersChanged = true;
                        break;
                    }
                }
                if (parametersChanged) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                    return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                }
            }
            for (com.nuix.automate.utils.models.api.job.Parameter parameter : parameters.values()) {
                if (parameter.getName() != null && parameter.getName().trim().length() != 0 && parameter.getValue() != null) continue;
                return ExceptionUtils.toResponse((String)"legalHoldMissingParameters", (Response.Status)Response.Status.BAD_REQUEST);
            }
            parameters = this.schedulerApplication.getNoticeUtils().normalizeParameters(parameters);
            for (final String parameterName : parameters.keySet()) {
                if (!NoticeUtils.builtInParameterNames.contains(parameterName)) continue;
                return ExceptionUtils.toResponse((String)"cannotUseBuiltInParameter", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameter", parameterName);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((triggerJobs = legalHoldSubmission.getTriggerJobs()) != null && !triggerJobs.equals(originalLegalHold.getTriggerJobs()) && !canModify) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)originalLegalHold);
        }
        if (triggerJobs == null) {
            triggerJobs = originalLegalHold.getTriggerJobs();
        }
        if (Boolean.TRUE.equals(triggerJobs)) {
            try {
                this.validatePermissionsForExecutionProfileAndResourcePool(user, legalHoldSubmission);
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
            LinkedHashMap triggerConfigurations = legalHoldSubmission.getTriggerConfigurations();
            LinkedHashMap originalTriggerConfigurations = originalLegalHold.getTriggerConfigurations();
            if (triggerConfigurations != null) {
                TriggerConfiguration originalTriggerConfiguration;
                if (!canModify) {
                    boolean triggerConfigurationsChanged;
                    boolean bl7 = triggerConfigurationsChanged = originalTriggerConfigurations == null || originalTriggerConfigurations.size() != triggerConfigurations.size();
                    if (!triggerConfigurationsChanged) {
                        for (String key : triggerConfigurations.keySet()) {
                            TriggerConfiguration triggerConfiguration = (TriggerConfiguration)triggerConfigurations.get(key);
                            originalTriggerConfiguration = (TriggerConfiguration)originalTriggerConfigurations.get(key);
                            if (originalTriggerConfiguration != null && !originalTriggerConfiguration.different(triggerConfiguration)) continue;
                            triggerConfigurationsChanged = true;
                            break;
                        }
                    }
                    if (triggerConfigurationsChanged) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                }
                for (final TriggerConfiguration triggerConfiguration : triggerConfigurations.values()) {
                    boolean changedWorkflowTemplateOrLibraryId = true;
                    boolean triggerConfigurationTriggerChanged = true;
                    if (originalTriggerConfigurations != null) {
                        originalTriggerConfiguration = (TriggerConfiguration)originalTriggerConfigurations.get(triggerConfiguration.getId());
                        changedWorkflowTemplateOrLibraryId = originalTriggerConfiguration == null || triggerConfiguration.getWorkflowLibraryId() != null && !triggerConfiguration.getWorkflowLibraryId().equals(originalTriggerConfiguration.getWorkflowLibraryId()) || triggerConfiguration.getWorkflowTemplateId() != null && !triggerConfiguration.getWorkflowTemplateId().equals(originalTriggerConfiguration.getWorkflowTemplateId());
                        boolean bl8 = triggerConfigurationTriggerChanged = originalTriggerConfiguration == null || triggerConfiguration.getTrigger() != null && triggerConfiguration.getTrigger() != originalTriggerConfiguration.getTrigger();
                        if (isActive && triggerConfigurationTriggerChanged && triggerConfiguration.getTrigger() == JobTriggerType.ON_MATTER_ACTIVATE) {
                            return ExceptionUtils.toResponse((String)"cannotModifyMatterActivateTriggerAfterActivated", (Response.Status)Response.Status.BAD_REQUEST);
                        }
                    }
                    if (isActive && triggerConfigurationTriggerChanged && triggerConfiguration.getTrigger() == JobTriggerType.ON_MATTER_ACTIVATE) {
                        return ExceptionUtils.toResponse((String)"cannotAddMatterActivateTriggerAfterActivated", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    JobModel job = new JobModel();
                    job.setClientId(legalHoldSubmission.getClientId());
                    job.setMatterId(legalHoldSubmission.getMatterId());
                    job.setExecutionProfileId(legalHoldSubmission.getExecutionProfileId());
                    job.setResourcePoolId(legalHoldSubmission.getResourcePoolId());
                    job.setPriority(legalHoldSubmission.getPriority());
                    job.setLibraryId(triggerConfiguration.getWorkflowLibraryId());
                    job.setLibraryWorkflowId(triggerConfiguration.getWorkflowTemplateId());
                    if (changedWorkflowTemplateOrLibraryId && !this.validatePermissionsForJobWorkflow(user, job)) {
                        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                        return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
                    }
                    if (!triggerConfiguration.isValid()) {
                        return ExceptionUtils.toResponse((String)"triggerConfigurationInvalid", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    if (triggerConfiguration.getEnabled() != Boolean.TRUE) continue;
                    WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(triggerConfiguration.getWorkflowLibraryId());
                    if (workflowLibrary == null) {
                        return ExceptionUtils.toResponse((String)"cannotFindWorkflowLibrary", (Map)new HashMap<String, String>(){
                            {
                                this.put(LegalHoldResource.IDENTIFIER_TYPE_ID, triggerConfiguration.getWorkflowLibraryId());
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    Workflow triggerConfigurationLibraryWorkflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(triggerConfiguration.getWorkflowTemplateId());
                    if (triggerConfigurationLibraryWorkflow != null) continue;
                    return ExceptionUtils.toResponse((String)"cannotFindLibraryWorkflow", (Map)new HashMap<String, String>(){
                        {
                            this.put(LegalHoldResource.IDENTIFIER_TYPE_ID, triggerConfiguration.getWorkflowTemplateId());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (originalLegalHold.getTriggerConfigurations() != null) {
                    for (TriggerConfiguration originalTriggerConfiguration2 : originalLegalHold.getTriggerConfigurations().values()) {
                        TriggerConfiguration triggerConfiguration;
                        if (originalTriggerConfiguration2.isChangeValid(triggerConfiguration = (TriggerConfiguration)triggerConfigurations.get(originalTriggerConfiguration2.getId()))) continue;
                        return ExceptionUtils.toResponse((String)"cannotChangeTriggeredConfiguration", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                }
            }
        }
        Set administratorIds = legalHoldSubmission.getAdministratorIds();
        Set originalAdministratorIds = originalLegalHold.getAdministratorIds();
        if (!canModify && administratorIds != null) {
            boolean administratorsChanged;
            boolean bl9 = administratorsChanged = originalAdministratorIds == null || originalAdministratorIds.size() != administratorIds.size() || !originalAdministratorIds.containsAll(administratorIds);
            if (administratorsChanged) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        String schedulerUrl = legalHoldSubmission.getSchedulerUrl();
        if (!canModify && schedulerUrl != null && !schedulerUrl.equals(originalLegalHold.getSchedulerUrl())) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalLegalHold);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (isActive) {
            boolean hasDataRepository;
            if (originalLegalHold.getSilent() != Boolean.TRUE) {
                if (administratorIds != null && administratorIds.size() == 0) {
                    return ExceptionUtils.toResponse((String)"activeLegalHoldRequiresAdmin", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (smtpServerId != null && this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(smtpServerId) == null) {
                    return ExceptionUtils.toResponse((String)"activeLegalHoldRequiresSmtp", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (schedulerUrl != null && schedulerUrl.trim().length() == 0) {
                    return ExceptionUtils.toResponse((String)"activeLegalHoldRequiresSchedulerUrl", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            boolean bl10 = hasDataRepository = dataRepositoryId != null && this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId) != null || originalLegalHold.getDataRepositoryId() != null && this.schedulerApplication.getDataRepositoryResource().getDataRepository(originalLegalHold.getDataRepositoryId()) != null;
            if (!hasDataRepository) {
                boolean requiresDataRepository = false;
                if (originalLegalHold.getSilent() != Boolean.TRUE) {
                    ArrayList<Object> noticeConfigurations = new ArrayList<Object>();
                    noticeConfigurations.add(holdNoticeConfiguration != null ? holdNoticeConfiguration : originalHoldNoticeConfiguration);
                    noticeConfigurations.add(releaseNoticeConfiguration != null ? releaseNoticeConfiguration : originalReleaseNoticeConfiguration);
                    noticeConfigurations.addAll(surveyNoticeConfigurations != null ? surveyNoticeConfigurations.values() : originalSurveyNoticeConfigurations.values());
                    for (NoticeConfiguration noticeConfiguration : noticeConfigurations) {
                        NoticeTemplate noticeTemplate;
                        if (noticeConfiguration == null || noticeConfiguration.getEnabled() != Boolean.TRUE || !(noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(noticeConfiguration.getNoticeTemplateId())).requiresDataRepository()) continue;
                        requiresDataRepository = true;
                        break;
                    }
                }
                if (requiresDataRepository) {
                    return ExceptionUtils.toResponse((String)"activeLegalHoldRequiresDataRepository", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
        }
        Set adminIds = administratorIds != null ? administratorIds : originalAdministratorIds;
        Set<String> custodianIds = legalHoldSubmission.getCustodianIds() != null ? legalHoldSubmission.getCustodianIds() : LegalHoldParticipationCache.getInstance().getLegalHoldParticipationUserIds(originalLegalHold.getId(), LegalHoldRole.CUSTODIAN);
        Boolean enableLoginLinks = legalHoldSubmission.getEnableLoginLinks() != null ? legalHoldSubmission.getEnableLoginLinks() : originalLegalHold.getEnableLoginLinks();
        if (!this.areUsersCompatibleWthLegalHold(silent, enableLoginLinks, adminIds)) {
            return ExceptionUtils.toResponse((String)"invalidAdministratorsNoSsoLinkWithManagedUserService", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!this.areUsersCompatibleWthLegalHold(silent, enableLoginLinks, custodianIds)) {
            return ExceptionUtils.toResponse((String)"invalidCustodianNoSsoLinkWithManagedUserService", (Response.Status)Response.Status.BAD_REQUEST);
        }
        return this.validateAdministratorAndCustodianUsers(adminIds, custodianIds);
    }

    private boolean isUserCompatibleWithLegalHold(UserAccount userAccount, com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        if (userAccount == null || userAccount.getPlatform() == null) {
            return false;
        }
        switch (userAccount.getPlatform()) {
            case MANAGED: {
                if (legalHold.getSilent() == Boolean.TRUE || legalHold.getEnableLoginLinks() == Boolean.TRUE) break;
                return false;
            }
        }
        return true;
    }

    private boolean areUsersCompatibleWthLegalHold(Boolean silent, Boolean enableLoginLinks, Collection<String> userIds) {
        if (silent != Boolean.TRUE && enableLoginLinks != Boolean.TRUE) {
            for (String userId : userIds) {
                UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(userId);
                if (userAccount != null && userAccount.getPlatform() != UserAccountPlatform.MANAGED) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUserEligibleForLegalHoldRole(LegalHoldRole role, UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        if (role.equals((Object)LegalHoldRole.ADMINISTRATOR) && userAccount.getUserAccountState().equals((Object)UserAccountState.INACTIVE)) {
            return false;
        }
        if (!(userAccount.getUserAccountState().equals((Object)UserAccountState.ACTIVE) || userAccount.getUserAccountState().equals((Object)UserAccountState.INACTIVE) || userAccount.getUserAccountState().equals((Object)UserAccountState.DELETED))) {
            return false;
        }
        UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId());
        if (userService.isUserSynchronizeActive()) {
            switch (role) {
                case ADMINISTRATOR: {
                    return userService.getUsersEligibleLegalHoldAdministrator() == Boolean.TRUE;
                }
                case CUSTODIAN: {
                    return userService.getUsersEligibleLegalHoldCustodian() == Boolean.TRUE;
                }
            }
        }
        return false;
    }

    private Response validateAdministratorAndCustodianUsers(Collection<String> administratorIds, Collection<String> custodianIds) {
        HashMap<String, String> values;
        UserAccount userAccount;
        ArrayList<String> invalidUsers = new ArrayList<String>();
        for (String administratorId : administratorIds) {
            userAccount = this.schedulerApplication.getUserServiceResource().getUser(administratorId);
            if (this.isUserEligibleForLegalHoldRole(LegalHoldRole.ADMINISTRATOR, userAccount)) continue;
            if (userAccount != null) {
                invalidUsers.add(userAccount.getEmail());
                continue;
            }
            invalidUsers.add(administratorId);
        }
        if (invalidUsers.size() > 0) {
            values = new HashMap();
            values.put("users", String.join((CharSequence)"\n", invalidUsers));
            return ExceptionUtils.toResponse((String)"invalidLegalHoldAdministratorUsers", values, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (String custodianId : custodianIds) {
            userAccount = this.schedulerApplication.getUserServiceResource().getUser(custodianId);
            if (this.isUserEligibleForLegalHoldRole(LegalHoldRole.CUSTODIAN, userAccount)) continue;
            if (userAccount != null) {
                invalidUsers.add(userAccount.getEmail());
                continue;
            }
            invalidUsers.add(custodianId);
        }
        if (invalidUsers.size() > 0) {
            values = new HashMap<String, String>();
            values.put("users", String.join((CharSequence)"\n", invalidUsers));
            return ExceptionUtils.toResponse((String)"invalidLegalHoldCustodianUsers", values, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return null;
    }

    private boolean validatePermissionForNoticeTemplate(BearerUser user, String noticeTemplateId, Permission permission) {
        if (user instanceof SystemBearerUser) {
            return true;
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTICE_TEMPLATES));
        resourceIdentifiers.add(new Identifier(IdentifierType.NOTICE_TEMPLATE_ID, noticeTemplateId));
        return this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, permission);
    }

    private void validatePermissionsForExecutionProfileAndResourcePool(BearerUser user, LegalHoldSubmission legalHoldSubmission) throws ResponseException {
        if (!(user instanceof SystemBearerUser)) {
            HashSet<Identifier> resourceIdentifiers;
            if (legalHoldSubmission.getExecutionProfileId() != null) {
                resourceIdentifiers = new HashSet<Identifier>();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
                resourceIdentifiers.add(new Identifier(IdentifierType.EXECUTION_PROFILE_ID, legalHoldSubmission.getExecutionProfileId()));
                if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), resourceIdentifiers, Permission.SUBMIT_JOB, Permission.STAGE_JOB)) {
                    throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)legalHoldSubmission));
                }
            }
            if (legalHoldSubmission.getResourcePoolId() != null) {
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
                resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, legalHoldSubmission.getResourcePoolId()));
                Set<Permission> resourcePoolPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                if (!resourcePoolPermissions.contains(Permission.SUBMIT_JOB) && !resourcePoolPermissions.contains(Permission.STAGE_JOB)) {
                    throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)legalHoldSubmission));
                }
                if (legalHoldSubmission.getPriority() == Priority.HIGHEST && !resourcePoolPermissions.contains(Permission.MODIFY)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHoldSubmission);
                    throw new ResponseException(ExceptionUtils.toResponse((String)"priorityHighestPermission", (Response.Status)Response.Status.FORBIDDEN));
                }
            }
        }
    }

    private boolean validatePermissionsForJobWorkflow(BearerUser user, JobModel jobModel) {
        if (user instanceof SystemBearerUser) {
            return true;
        }
        JobModel jobModelPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobModel);
        return jobModelPermissions.getUserPermissions().contains(Permission.SUBMIT_JOB) || jobModelPermissions.getUserPermissions().contains(Permission.STAGE_JOB);
    }

    private void performLegalHoldUpdate(BearerUser user, com.nuix.automate.utils.models.api.legalhold.LegalHold originalLegalHold, LegalHoldSubmission legalHoldSubmission, String remoteAddress) {
        boolean triggerConfigurationsChanged;
        boolean notSilentLegalHold;
        Boolean enableLoginLinks;
        String schedulerUrl;
        String smtpServerId;
        String dataRepositoryId;
        Priority priority;
        String executionProfileId;
        String resourcePoolId;
        boolean isDraft = originalLegalHold.getState() == LegalHoldState.DRAFT;
        boolean isActive = originalLegalHold.getState() == LegalHoldState.ACTIVE;
        boolean sendNotices = isActive && !Boolean.TRUE.equals(originalLegalHold.getSilent());
        ArrayList<String> changedDetails = new ArrayList<String>();
        Boolean triggerJobs = legalHoldSubmission.getTriggerJobs();
        if (triggerJobs != null && !triggerJobs.equals(originalLegalHold.getTriggerJobs())) {
            originalLegalHold.setTriggerJobs(triggerJobs);
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.TriggerJobs", (Object)triggerJobs));
        }
        if ((resourcePoolId = legalHoldSubmission.getResourcePoolId()) != null && !resourcePoolId.equals(originalLegalHold.getResourcePoolId())) {
            originalLegalHold.setResourcePoolId(resourcePoolId);
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
            if (resourcePool != null) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.ResourcePool", (Object)resourcePool.getName()));
            } else {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if ((executionProfileId = legalHoldSubmission.getExecutionProfileId()) != null && !executionProfileId.equals(originalLegalHold.getExecutionProfileId())) {
            originalLegalHold.setExecutionProfileId(executionProfileId);
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
            if (executionProfile != null) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.ExecutionProfile", (Object)executionProfile.getName()));
            } else {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.ExecutionProfile", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if ((priority = legalHoldSubmission.getPriority()) != null && !priority.equals((Object)originalLegalHold.getPriority())) {
            originalLegalHold.setPriority(priority);
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Priority", (Object)priority));
        }
        if ((dataRepositoryId = legalHoldSubmission.getDataRepositoryId()) != null && !dataRepositoryId.equals(originalLegalHold.getDataRepositoryId())) {
            originalLegalHold.setDataRepositoryId(dataRepositoryId);
            DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
            if (dataRepository != null) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.DataRepository", (Object)dataRepository.getName()));
            } else {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.DataRepositoryId", (Object)dataRepositoryId));
            }
        }
        if ((smtpServerId = legalHoldSubmission.getSmtpServerId()) != null && !smtpServerId.equals(originalLegalHold.getSmtpServerId())) {
            originalLegalHold.setSmtpServerId(smtpServerId);
            ThirdPartyService smtpService = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(smtpServerId);
            if (smtpService != null) {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.SmtpService", (Object)smtpService.getName()));
            } else {
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.SmtpServiceId", (Object)smtpServerId));
            }
        }
        if ((schedulerUrl = legalHoldSubmission.getSchedulerUrl()) != null && schedulerUrl.trim().length() > 0 && !schedulerUrl.equals(originalLegalHold.getSchedulerUrl())) {
            originalLegalHold.setSchedulerUrl(schedulerUrl.trim());
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.SchedulerUrl", (Object)schedulerUrl.trim()));
        }
        if ((enableLoginLinks = legalHoldSubmission.getEnableLoginLinks()) != null && !enableLoginLinks.equals(originalLegalHold.getEnableLoginLinks())) {
            originalLegalHold.setEnableLoginLinks(enableLoginLinks);
            changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.EnableLoginLinks", (Object)enableLoginLinks));
        }
        Map parameters = legalHoldSubmission.getParameters();
        Boolean silent = legalHoldSubmission.getSilent();
        boolean bl = notSilentLegalHold = (isDraft && silent != null ? silent : originalLegalHold.getSilent()) != Boolean.TRUE;
        if (notSilentLegalHold && (isDraft || isActive) && parameters != null) {
            Map originalParameters = originalLegalHold.getParameters();
            if (isDraft) {
                originalLegalHold.setParameters(parameters);
            } else {
                for (Map.Entry entry : parameters.entrySet()) {
                    if (originalParameters.containsKey(entry.getKey())) continue;
                    originalParameters.put((String)entry.getKey(), (com.nuix.automate.utils.models.api.job.Parameter)entry.getValue());
                    changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Parameter", (Object[])new String[]{((com.nuix.automate.utils.models.api.job.Parameter)entry.getValue()).getName(), ((com.nuix.automate.utils.models.api.job.Parameter)entry.getValue()).getValue()}));
                }
            }
            for (String key2 : parameters.keySet()) {
                com.nuix.automate.utils.models.api.job.Parameter parameter = (com.nuix.automate.utils.models.api.job.Parameter)parameters.get(key2);
                com.nuix.automate.utils.models.api.job.Parameter originalParameter = (com.nuix.automate.utils.models.api.job.Parameter)originalParameters.get(key2);
                if (originalParameter != null && originalParameter.getValue().equals(parameter.getValue())) continue;
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Parameter", (Object[])new String[]{parameter.getName(), parameter.getValue()}));
            }
        }
        NoticeConfiguration holdNoticeConfiguration = legalHoldSubmission.getHoldNoticeConfiguration();
        NoticeConfiguration releaseNoticeConfiguration = legalHoldSubmission.getReleaseNoticeConfiguration();
        NoticeConfiguration recurringNoticeConfiguration = legalHoldSubmission.getRecurringNoticeConfiguration();
        LinkedHashMap surveyNoticeConfigurations = legalHoldSubmission.getSurveyNoticeConfigurations();
        LinkedHashMap triggerConfigurations = legalHoldSubmission.getTriggerConfigurations();
        boolean holdNoticeConfigurationChanged = holdNoticeConfiguration != null && (originalLegalHold.getHoldNoticeConfiguration() == null || originalLegalHold.getHoldNoticeConfiguration().different(holdNoticeConfiguration));
        boolean releaseNoticeConfigurationChanged = releaseNoticeConfiguration != null && (originalLegalHold.getReleaseNoticeConfiguration() == null || originalLegalHold.getReleaseNoticeConfiguration().different(releaseNoticeConfiguration));
        boolean recurringNoticeConfigurationChanged = recurringNoticeConfiguration != null && (originalLegalHold.getRecurringNoticeConfiguration() == null || originalLegalHold.getRecurringNoticeConfiguration().different(recurringNoticeConfiguration));
        boolean surveyNoticeConfigurationsChanged = surveyNoticeConfigurations != null && (originalLegalHold.getSurveyNoticeConfigurations() == null || surveyNoticeConfigurations.size() != originalLegalHold.getSurveyNoticeConfigurations().size() || surveyNoticeConfigurations.keySet().stream().anyMatch(key -> {
            NoticeConfiguration oldSurveyNoticeConfiguration = (NoticeConfiguration)originalLegalHold.getSurveyNoticeConfigurations().get(key);
            NoticeConfiguration surveyNoticeConfiguration = (NoticeConfiguration)surveyNoticeConfigurations.get(key);
            return oldSurveyNoticeConfiguration == null || oldSurveyNoticeConfiguration.different(surveyNoticeConfiguration);
        }));
        boolean bl2 = triggerConfigurationsChanged = triggerConfigurations != null && (originalLegalHold.getTriggerConfigurations() == null || triggerConfigurations.size() != originalLegalHold.getTriggerConfigurations().size() || triggerConfigurations.keySet().stream().anyMatch(key -> {
            TriggerConfiguration originalTriggerConfiguration = (TriggerConfiguration)originalLegalHold.getTriggerConfigurations().get(key);
            TriggerConfiguration triggerConfiguration = (TriggerConfiguration)triggerConfigurations.get(key);
            return originalTriggerConfiguration == null || originalTriggerConfiguration.different(triggerConfiguration);
        }));
        if (isDraft) {
            SurveyNoticesTrigger surveyNoticesTrigger;
            String description;
            String name;
            String matterId = legalHoldSubmission.getMatterId();
            if (matterId != null && !matterId.equals(originalLegalHold.getMatterId())) {
                originalLegalHold.setMatterId(matterId);
                Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Matter", (Object)matter.getName()));
                String clientId = matter.getClientId();
                originalLegalHold.setClientId(clientId);
                Client client = this.schedulerApplication.getClientResource().getClient(clientId);
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Client", (Object)client.getName()));
            }
            if ((name = legalHoldSubmission.getName()) != null && name.trim().length() > 0 && !name.equals(originalLegalHold.getName())) {
                originalLegalHold.setName(name.trim());
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Name", (Object)name.trim()));
            }
            if ((description = legalHoldSubmission.getDescription()) != null && !description.equals(originalLegalHold.getDescription())) {
                originalLegalHold.setDescription(description.trim());
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Description", (Object)description.trim()));
            }
            if ((surveyNoticesTrigger = legalHoldSubmission.getSurveyNoticesTrigger()) != null && surveyNoticesTrigger != originalLegalHold.getSurveyNoticesTrigger()) {
                originalLegalHold.setSurveyNoticesTrigger(surveyNoticesTrigger);
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.SurveyNoticesTrigger", (Object)LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)surveyNoticesTrigger)));
            }
            if (silent != null && !silent.equals(originalLegalHold.getSilent())) {
                originalLegalHold.setSilent(silent);
                changedDetails.add(this.iu.getFormattedString("LegalHoldResource.Details.Silent", (Object)silent));
            }
            if (holdNoticeConfigurationChanged) {
                originalLegalHold.setHoldNoticeConfiguration(holdNoticeConfiguration);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.HoldNoticeConfiguration"));
            }
            if (recurringNoticeConfigurationChanged) {
                originalLegalHold.setRecurringNoticeConfiguration(recurringNoticeConfiguration);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.RecurringNoticeConfiguration"));
            }
            if (releaseNoticeConfigurationChanged) {
                originalLegalHold.setReleaseNoticeConfiguration(releaseNoticeConfiguration);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.ReleaseNoticeConfiguration"));
            }
            if (surveyNoticeConfigurationsChanged) {
                originalLegalHold.setSurveyNoticeConfigurations(surveyNoticeConfigurations);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.SurveyNoticeConfigurations"));
            }
            if (triggerConfigurationsChanged) {
                originalLegalHold.setTriggerConfigurations(triggerConfigurations);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.TriggerConfigurations"));
            }
        }
        if (isActive) {
            if (holdNoticeConfigurationChanged && originalLegalHold.getHoldNoticeConfiguration() != null) {
                originalLegalHold.getHoldNoticeConfiguration().update(holdNoticeConfiguration, false);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.HoldNoticeConfiguration"));
                if (sendNotices) {
                    this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(originalLegalHold.getId(), originalLegalHold.getHoldNoticeConfiguration());
                }
            }
            if (recurringNoticeConfigurationChanged && originalLegalHold.getRecurringNoticeConfiguration() != null) {
                originalLegalHold.getRecurringNoticeConfiguration().update(recurringNoticeConfiguration, false);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.RecurringNoticeConfiguration"));
                if (sendNotices) {
                    this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(originalLegalHold.getId(), originalLegalHold.getRecurringNoticeConfiguration());
                }
            }
            if (releaseNoticeConfigurationChanged && originalLegalHold.getReleaseNoticeConfiguration() != null) {
                originalLegalHold.getReleaseNoticeConfiguration().update(releaseNoticeConfiguration, false);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.ReleaseNoticeConfiguration"));
                if (sendNotices) {
                    this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(originalLegalHold.getId(), originalLegalHold.getReleaseNoticeConfiguration());
                }
            }
            if (surveyNoticeConfigurationsChanged) {
                if (originalLegalHold.getSurveyNoticeConfigurations() == null) {
                    originalLegalHold.setSurveyNoticeConfigurations(new LinkedHashMap());
                }
                for (String id : surveyNoticeConfigurations.keySet()) {
                    NoticeConfiguration surveyConfiguration = (NoticeConfiguration)surveyNoticeConfigurations.get(id);
                    NoticeConfiguration originalSurveyConfiguration = (NoticeConfiguration)originalLegalHold.getSurveyNoticeConfigurations().get(id);
                    if (originalSurveyConfiguration != null) {
                        originalSurveyConfiguration.update(surveyConfiguration, true);
                    } else {
                        originalLegalHold.getSurveyNoticeConfigurations().put(id, surveyConfiguration);
                    }
                    if (!sendNotices) continue;
                    this.schedulerApplication.getNoticeUtils().buildOrUpdateNotices(originalLegalHold.getId(), (NoticeConfiguration)originalLegalHold.getSurveyNoticeConfigurations().get(id));
                }
                this.trackLegalHoldNoticesUtilization(originalLegalHold);
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.SurveyNoticeConfigurations"));
            }
            if (triggerConfigurationsChanged) {
                if (originalLegalHold.getTriggerConfigurations() == null) {
                    originalLegalHold.setTriggerConfigurations(new LinkedHashMap());
                }
                for (String id : triggerConfigurations.keySet()) {
                    TriggerConfiguration triggerConfiguration = (TriggerConfiguration)triggerConfigurations.get(id);
                    TriggerConfiguration originalTriggerConfiguration = (TriggerConfiguration)originalLegalHold.getTriggerConfigurations().get(id);
                    if (originalTriggerConfiguration != null) {
                        originalTriggerConfiguration.update(triggerConfiguration);
                        continue;
                    }
                    originalLegalHold.getTriggerConfigurations().put(id, triggerConfiguration);
                }
                changedDetails.add(this.iu.getString("LegalHoldResource.Details.TriggerConfigurations"));
            }
        }
        this.legalHoldWorker.submitUpdateLegalHoldParticipationsAndEventsTask(remoteAddress, user, originalLegalHold, legalHoldSubmission.getAdministratorIds(), legalHoldSubmission.getCustodianIds(), changedDetails);
        this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(originalLegalHold);
        this.trackLegalHoldUtilization(originalLegalHold);
    }

    @Operation(tags={"Legal Hold"}, operationId="DeleteLegalHold", summary="Delete Legal Hold", description="Delete the legal hold with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find legal hold with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{legalHoldId}")
    @DELETE
    public Response deleteLegalHold(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The legal hold ID") @PathParam(value="legalHoldId") String legalHoldId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold = this.getLegalHold(legalHoldId);
        if (legalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", legalHoldId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold).getUserPermissions();
        if (!permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)legalHold);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (LegalHoldState.ACTIVE.equals((Object)legalHold.getState())) {
            return ExceptionUtils.toResponse((String)"cannotDeleteActiveLegalHold", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (this.isLegalHoldCommandInProgress(legalHold)) {
            return ExceptionUtils.toResponse((String)"legalHoldCommandInProgress", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Response errorResponse = this.schedulerApplication.getLegalHoldUtils().verifyNotUsedInJobs(user, legalHoldId);
        if (errorResponse != null) {
            return errorResponse;
        }
        this.schedulerApplication.getLegalHoldUtils().handleMatterTriggerConfiguration(legalHold, JobTriggerType.ON_MATTER_DELETE);
        this.legalHoldWorker.submitDeleteLegalHoldTask(request, legalHold);
        this.legalHolds.remove(legalHoldId);
        this.updateLegalHoldImplicitPolicies(legalHoldId);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), legalHoldId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LEGAL_HOLD_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.trackLegalHoldUtilization(legalHold);
        com.nuix.automate.utils.models.api.legalhold.LegalHold eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
        SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_DELETED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHoldId);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, legalHoldId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void trackLegalHoldUtilization(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        LegalHold utilizationLegalHold = new LegalHold();
        utilizationLegalHold.setLegalHoldId(legalHold.getId());
        utilizationLegalHold.setLegalHoldCreatedBy(User.getIdFromName((String)legalHold.getCreatedBy(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        utilizationLegalHold.setLegalHoldName(legalHold.getName());
        utilizationLegalHold.setLegalHoldState(legalHold.getState().name());
        utilizationLegalHold.setLegalHoldCreatedEpoch(legalHold.getCreatedDate());
        utilizationLegalHold.setMatterId(legalHold.getMatterId());
        this.schedulerApplication.getUtilizationDaoV2().replaceLegalHold(utilizationLegalHold);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<LegalHold> legalHolds = new HashSet<LegalHold>();
        legalHolds.add(utilizationLegalHold);
        utilizationRecords.setLegalHolds(legalHolds);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public Notice getSilentNotice(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        Notice utilizationNotice = new Notice();
        utilizationNotice.setNoticeId(legalHold.getId());
        utilizationNotice.setLegalHoldId(legalHold.getId());
        utilizationNotice.setNoticeType(NoticeType.SILENT.name());
        utilizationNotice.setNoticeTemplateId(UidUtils.fromString((String)"_Undefined", (String)"notice").toString());
        return utilizationNotice;
    }

    private void trackLegalHoldNoticesUtilization(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold) {
        List<Notice> notices = this.getLegalHoldNoticesUtilization(legalHold);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<Notice> noticesSet = new HashSet<Notice>();
        utilizationRecords.setNotices(noticesSet);
        for (Notice notice : notices) {
            noticesSet.add(notice);
            try {
                this.schedulerApplication.getUtilizationDaoV2().addNotice(notice);
            }
            catch (StatementException statementException) {}
        }
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public List<com.nuix.automate.utils.models.api.legalhold.LegalHold> getLegalHoldsUsingWorkflow(String workflowId) {
        ArrayList<com.nuix.automate.utils.models.api.legalhold.LegalHold> legalHolds = new ArrayList<com.nuix.automate.utils.models.api.legalhold.LegalHold>();
        for (com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold : this.legalHolds.values()) {
            if (legalHold.getTriggerConfigurations() == null) continue;
            for (TriggerConfiguration configuration : legalHold.getTriggerConfigurations().values()) {
                if (configuration == null || configuration.getWorkflowTemplateId() == null || !configuration.getWorkflowTemplateId().equals(workflowId)) continue;
                legalHolds.add(legalHold);
            }
        }
        return legalHolds;
    }

    public User getUtilizationUserFromLegalHoldUserId(String legalHoldUserId) {
        UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(legalHoldUserId);
        if (userAccount != null) {
            User user = new User();
            user.setUserName(userAccount.getName());
            user.setUserTimeZone(null);
            user.setUserId(User.getIdFromName((String)user.getUserName(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
            return user;
        }
        return null;
    }

    public void trackSilentLegalHoldCustodiansUtilization(com.nuix.automate.utils.models.api.legalhold.LegalHold legalHold, LegalHoldParticipations participations, String performedByUserName) {
        if (legalHold.getSilent() == null || !legalHold.getSilent().booleanValue()) {
            return;
        }
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<User> users = new HashSet<User>();
        HashSet<CustodianNotice> custodianNotices = new HashSet<CustodianNotice>();
        HashSet<CustodianActivity> custodianActivities = new HashSet<CustodianActivity>();
        utilizationRecords.setUsers(users);
        utilizationRecords.setCustodianNotices(custodianNotices);
        utilizationRecords.setCustodianActivities(custodianActivities);
        HashSet<ActivityDetails> activityDetailsSet = new HashSet<ActivityDetails>();
        utilizationRecords.setActivityDetails(activityDetailsSet);
        Notice silentNotice = this.getSilentNotice(legalHold);
        for (LegalHoldParticipation legalHoldParticipation : participations.getParticipations()) {
            String userId = legalHoldParticipation.getUserId();
            User user = this.getUtilizationUserFromLegalHoldUserId(legalHoldParticipation.getUserId());
            if (user != null) {
                userId = user.getUserId();
                this.schedulerApplication.getUtilizationDaoV2().replaceUser(user);
                users.add(user);
            }
            CustodianNotice custodianNotice = new CustodianNotice();
            custodianNotice.setCustodianNoticeId(UidUtils.fromString((String)silentNotice.getNoticeId(), (String)legalHoldParticipation.getUserId()).toString());
            custodianNotice.setNoticeId(silentNotice.getNoticeId());
            custodianNotice.setLegalHoldId(legalHold.getId());
            custodianNotice.setUserId(userId);
            custodianNotice.setNoticeIssuedEpoch(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getUtilizationDaoV2().replaceCustodianNotice(custodianNotice);
            custodianNotices.add(custodianNotice);
            CustodianActivity custodianSetupActivity = new CustodianActivity();
            custodianSetupActivity.setCustodianActivityId(UidUtils.getRandom());
            custodianSetupActivity.setCustodianNoticeId(custodianNotice.getCustodianNoticeId());
            custodianSetupActivity.setActivityKey(custodianSetupActivity.getCustodianActivityId());
            custodianSetupActivity.setLegalHoldId(legalHold.getId());
            try {
                this.schedulerApplication.getUtilizationDaoV2().addCustodianActivity(custodianSetupActivity);
            }
            catch (StatementException statementException) {
                // empty catch block
            }
            custodianActivities.add(custodianSetupActivity);
            ActivityDetails custodianSetupActivityDetails = new ActivityDetails();
            custodianSetupActivityDetails.setStartEpoch(custodianNotice.getNoticeIssuedEpoch().longValue());
            custodianSetupActivityDetails.setLastEpoch(custodianNotice.getNoticeIssuedEpoch() + 1L);
            custodianSetupActivityDetails.setMatterId(legalHold.getMatterId());
            custodianSetupActivityDetails.setActivityType(ActivityType.LEGAL_HOLD_SETUP);
            custodianSetupActivityDetails.setUserId(User.getIdFromName((String)performedByUserName, (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
            custodianSetupActivityDetails.setActivityKey(custodianSetupActivity.getActivityKey());
            this.schedulerApplication.getUserResource().trackFinishedActivity(custodianSetupActivityDetails);
            activityDetailsSet.add(custodianSetupActivityDetails);
            CustodianActivity custodianIssueHoldActivity = new CustodianActivity();
            custodianIssueHoldActivity.setCustodianActivityId(UidUtils.getRandom());
            custodianIssueHoldActivity.setCustodianNoticeId(custodianNotice.getCustodianNoticeId());
            custodianIssueHoldActivity.setActivityKey(custodianIssueHoldActivity.getCustodianActivityId());
            custodianIssueHoldActivity.setLegalHoldId(legalHold.getId());
            try {
                this.schedulerApplication.getUtilizationDaoV2().addCustodianActivity(custodianIssueHoldActivity);
            }
            catch (StatementException statementException) {
                // empty catch block
            }
            custodianActivities.add(custodianIssueHoldActivity);
            ActivityDetails custodianIssuedHoldActivityDetails = new ActivityDetails();
            custodianIssuedHoldActivityDetails.setStartEpoch(custodianNotice.getNoticeIssuedEpoch().longValue());
            custodianIssuedHoldActivityDetails.setLastEpoch(custodianNotice.getNoticeIssuedEpoch() + 1L);
            custodianIssuedHoldActivityDetails.setMatterId(legalHold.getMatterId());
            custodianIssuedHoldActivityDetails.setActivityType(ActivityType.LEGAL_HOLD_ISSUED);
            custodianIssuedHoldActivityDetails.setUserId(userId);
            custodianIssuedHoldActivityDetails.setActivityKey(custodianIssueHoldActivity.getActivityKey());
            this.schedulerApplication.getUserResource().trackFinishedActivity(custodianIssuedHoldActivityDetails);
            activityDetailsSet.add(custodianIssuedHoldActivityDetails);
        }
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }
}

